/*
 * Device tables.  See the Configure file for a complete description.
 */

#if (defined SPARC || defined SPARC_ODD)
#undef _POSIX_SOURCE
#endif


#include <stdio.h>
/*#define __USE_BSD*/		/* even linux isn't perfect */
#include <sys/types.h>
#include <string.h>
#include <memory.h>
#include <ctype.h>
#include <limits.h>
#include "msdos.h"
#include <stdlib.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/param.h>
#include <sys/ioctl.h>

#ifdef LOADDEVS
#define devices const_devices
#endif /* LOADDEVS */


#define INIT_NOOP ((int (*) ()) 0)
#define INIT_DEFAULT INIT_NOOP

#ifdef DELL
#define predefined_devices
struct device devices[] = {
	{'B', "/dev/rdsk/f1q15dt", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 15},
	{'B', "/dev/rdsk/f1d9dt", 0L, 12, O_RDONLY, INIT_NOOP, 40, 2, 9},
	{'B', "/dev/rdsk/f1d8dt", 0L, 12, O_RDONLY, INIT_NOOP, 40, 2, 8},
	{'A', "/dev/rdsk/f03ht", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 18},
	{'A', "/dev/rdsk/f03dt", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 9},
	{'C', "/dev/rdsk/dos", 0L, 16, O_RDONLY, INIT_NOOP, 0, 0, 0},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};
#endif /* DELL */

#ifdef ISC
#define predefined_devices
struct device devices[] = {
	{'A', "/dev/rdsk/f0d9dt", 0L, 12, O_RDONLY, INIT_NOOP, 40, 2, 9},
	{'A', "/dev/rdsk/f0q15dt", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 15},
	{'A', "/dev/rdsk/f0d8dt", 0L, 12, O_RDONLY, INIT_NOOP, 40, 2, 8},
	{'B', "/dev/rdsk/f13ht", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 18},
	{'B', "/dev/rdsk/f13dt", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 9},
	{'C', "/dev/rdsk/0p1", 0L, 16, O_RDONLY, INIT_NOOP, 0, 0, 0},
	{'D', "/usr/vpix/defaults/C:", 8704L, 12, O_RDONLY, INIT_NOOP, 0, 0, 0},
	{'E', "$HOME/vpix/C:", 8704L, 12, O_RDONLY, INIT_NOOP, 0, 0, 0},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};
#endif /* ISC */

#ifdef RT_ACIS
#define predefined_devices
struct device devices[] = {
	{'A', "/dev/rfd0", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 15},
	{'A', "/dev/rfd0", 0L, 12, O_RDONLY, INIT_NOOP, 40, 2, 9},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};
#endif /* RT_ACIS */

#ifdef SPARC
#define predefined_devices
struct device devices[] = {
	{'A', "/dev/rfd0c", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 18},
	{'A', "/dev/rfd0c", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 9},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};
#endif /* SPARC */

#ifdef SUN386
#define predefined_devices
struct device devices[] = {
	{'A', "/dev/rfdl0c", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 9},
	{'A', "/dev/rfd0c", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 18},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};
#endif /* SUN386 */

#ifdef XENIX
#define predefined_devices
struct device devices[] = {
	{'A', "/dev/fd096ds15", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 15},
	{'A', "/dev/fd048ds9", 0L, 12, O_RDONLY, INIT_NOOP, 40, 2, 9},
	{'B', "/dev/fd1135ds18", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 18},
	{'B', "/dev/fd1135ds9", 0L, 12, O_RDONLY, INIT_NOOP, 80, 2, 9},
	{'C', "/dev/hd0d", 0L, 16, O_RDONLY, INIT_NOOP, 0, 0, 0},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};
#endif /* XENIX */


#ifdef UNIXPC
#include <sys/gdioctl.h>

int init_unixpc();

#undef INIT_DEFAULT
#define INIT_DEFAULT init_unixpc

#define predefined_devices
struct device devices[] = {
	{'A', "/dev/rfp020", 0L, 12, O_NDELAY, init_unixpc, 40, 2, 9},
	{'C', "/usr/bin/DOS/dvd000", 0L, 12, O_RDONLY, INIT_NOOP, 0, 0, 0},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};

int
init_unixpc(fd, ntracks, nheads, nsect)
int fd, ntracks, nheads, nsect;
{
	struct gdctl gdbuf;

	if (ioctl(fd, GDGETA, &gdbuf) == -1) {
		ioctl(fd, GDDISMNT, &gdbuf);
		return(1);
	}

	gdbuf.params.cyls = ntracks;
	gdbuf.params.heads = nheads;
	gdbuf.params.psectrk = nsect;

	gdbuf.params.pseccyl = gdbuf.params.psectrk * gdbuf.params.heads;
	gdbuf.params.flags = 1;		/* disk type flag */
	gdbuf.params.step = 0;		/* step rate for controller */
	gdbuf.params.sectorsz = msector_size;	/* sector size */

	if (ioctl(fd, GDSETA, &gdbuf) < 0) {
		ioctl(fd, GDDISMNT, &gdbuf);
		return(1);
	}
	return(0);
}
#endif /* UNIXPC */

#ifdef SPARC_ODD

#include <sys/stat.h>
#include <sys/types.h>
#include <sun/dkio.h>
#include <fcntl.h>
#include <sys/ioctl.h>

int init_generic();
#undef INIT_DEFAULT
#define INIT_DEFAULT init_generic

#define predefined_devices
struct device devices[] = {
	{'A', "/dev/rfd0c", 0L, 12, 0, init_generic, 0, 2, 18},
	{'\0', (char *) NULL, 0L, 0, O_RDONLY, INIT_NOOP, 0, 0, 0}
};

/*
 * Stuffing back the floppy parameters into the driver allows for gems
 * like 10 sector or single sided floppies from Atari ST systems.
 * 
 * Martin Schulz, Universite de Moncton, N.B., Canada, March 11, 1991.
 */

#define GENERIC_INIT

struct generic_floppy_struct
{
  struct fdk_char dkbuf;
  struct dk_map dkmap;
};

#define BLOCK_MAJOR 16
#define CHAR_MAJOR 54

int
get_parameters( fd, floppy)
     int fd;
     struct generic_floppy_struct *floppy;
{
  if (ioctl(fd, DKIOCGPART, &(floppy->dkmap)) != 0) {
    perror("DKIOCGPART");
    ioctl(fd, FDKEJECT, NULL);
    return(1);
  }
  
  if (ioctl(fd, FDKIOGCHAR, &( floppy->dkbuf)) != 0) {
    perror("");
    ioctl(fd, FDKEJECT, NULL);
    return(1);
  }
  return 0;
}

#define TRACKS(floppy) floppy.dkbuf.ncyl
#define HEADS(floppy) floppy.dkbuf.nhead
#define SECTORS(floppy) floppy.dkbuf.secptrack
#define SECTORS_PER_DISK(floppy) floppy.dkmap.dkl_nblk
#define FD_SECTSIZE(floppy) floppy.dkbuf.sec_size
#define FD_SET_SECTSIZE(floppy,v) { floppy.dkbuf.sec_size = v; }
#define MAJOR major
int 
set_parameters( fd, floppy, buf)
     int fd;
     struct generic_floppy_struct *floppy;
     struct stat buf;
{
  if (ioctl(fd, FDKIOSCHAR, &(floppy->dkbuf)) != 0) {
    ioctl(fd, FDKEJECT, NULL);
    perror("");
    return(1);
  }
  
  if (ioctl(fd, ( unsigned int) DKIOCSPART, &(floppy->dkmap)) != 0) {
    ioctl(fd, FDKEJECT, NULL);
    perror("");
    return(1);
  }
  return 0;
}

#endif /* SPARC_ODD */


#ifdef DPX1000
#define predefined_devices
struct device devices[] = {
	/* [block device]: DPX1000 has /dev/flbm60, DPX2 has /dev/easyfb */
	{'A', "/dev/flbm60", 0L, 12, 0, (int (*) ()) 0, 80, 2, 15}, /* 5.25" 1.2m */
	{'B', "/dev/flbm60", 0L, 12, 0, (int (*) ()) 0, 40, 2, 9},  /* 5.25" 360k */
	{'C', "/dev/flbm60", 0L, 12, 0, (int (*) ()) 0, 40, 2, 8},	/* 5.25" 320k */
	{'D', "/dev/flbm60", 0L, 12, 0, (int (*) ()) 0, 40, 1, 9},	/* 5.25" 180k */
	{'E', "/dev/flbm60", 0L, 12, 0, (int (*) ()) 0, 40, 1, 8},	/* 5.25" 160k */
	{'\0', (char *) NULL, 0L, 0, 0, (int (*) ()) 0, 0, 0, 0}
};
#endif

#ifdef BOS
#define predefined_devices
struct device devices[] = {
	/* [block device]: DPX1000 has /dev/flbm60, DPX2 has /dev/easyfb */
	{'A', "/dev/easyfb", 0L, 12, 0, (int (*) ()) 0, 80, 2, 15}, /* 5.25" 1.2m */
	{'B', "/dev/easyfb", 0L, 12, 0, (int (*) ()) 0, 40, 2, 9},  /* 5.25" 360k */
	{'C', "/dev/easyfb", 0L, 12, 0, (int (*) ()) 0, 40, 2, 8},	/* 5.25" 320k */
	{'D', "/dev/easyfb", 0L, 12, 0, (int (*) ()) 0, 40, 1, 9},	/* 5.25" 180k */
	{'E', "/dev/easyfb", 0L, 12, 0, (int (*) ()) 0, 40, 1, 8},	/* 5.25" 160k */
	{'\0', (char *) NULL, 0L, 0, 0, (int (*) ()) 0, 0, 0, 0}
};
#endif


#ifdef linux

#include <linux/fd.h>
#include <linux/fs.h>
#if 0
#define MINOR(x) ((x) & 0xff)
#define MAJOR(x) (((x) >> 8 ) & 0xff )
#endif
#include <sys/stat.h>

int init_generic();
#undef INIT_DEFAULT
#define INIT_DEFAULT init_generic

#define predefined_devices
struct device devices[] = {
	{'A', "/dev/fd0", 0L, 0, 0, init_generic, 0, 0, 0},
	{'B', "/dev/fd1", 0L, 0, 0, init_generic, 0, 0, 0},
	{'\0', (char *) NULL, 0L, 0, 0, INIT_NOOP, 0, 0, 0}
};

/*
 * Stuffing back the floppy parameters into the driver allows for gems
 * like 21 sector or single sided floppies from Atari ST systems.
 * 
 * Alain Knaff, Universite Joseph Fourier, France, November 12, 1993.
 */


#define GENERIC_INIT
#define generic_floppy_struct floppy_struct
#define BLOCK_MAJOR 2
#define SECTORS(floppy) floppy.sect
#define TRACKS(floppy) floppy.track
#define HEADS(floppy) floppy.head
#define SECTORS_PER_DISK(floppy) floppy.size
#define STRETCH(floppy) floppy.stretch

int
set_parameters(fd, floppy, buf)
	int fd;
	struct floppy_struct *floppy;
	struct stat *buf;
{
	if ( ( MINOR(buf->st_rdev ) & 0x7f ) > 3 )
		return 1;
	
	return ioctl(fd, FDSETPRM, floppy);
}

int
get_parameters(fd, floppy, buf)
	int fd;
	struct floppy_struct *floppy;
	struct stat *buf;
{
	return ioctl(fd, FDGETPRM, floppy);
}

#endif /* linux */


#ifdef GENERIC_INIT
int
init_generic(fd, ntracks, nheads, nsect 
#ifdef MULTISIZE
,ssize
#endif
#ifdef USE_2M
,use_2m
#endif
)
int fd, ntracks, nheads, nsect;
#ifdef MULTISIZE
int *ssize;
#endif
#ifdef USE_2M
int *use_2m;
#endif
{
	struct stat buf;
	struct generic_floppy_struct floppy;
	
	if ( ntracks == 0 )
		return 0;
	
#ifdef LOADDEVS
	if ( fstat(fd, & buf) < 0 )
		return 1;	
	/* 
	 * succeed if we don't have a floppy
	 * this is the case for dosemu floppy image files for instance
	 */
	if ( ! (( S_ISBLK(buf.st_mode) && MAJOR(buf.st_rdev) == BLOCK_MAJOR )
#ifdef CHAR_MAJOR
		|| ( S_ISCHR(buf.st_mode) && MAJOR(buf.st_rdev) == CHAR_MAJOR ) 
#endif
		))
		return 0;
#endif /* LOADDEVS */
	
	/*
	 * We first try to get the current floppy parameters from the kernel.
	 * This allows us to
	 * 1. get the rate
	 * 2. skip the parameter setting if the parameters are already o.k.
	 */
	
	if ( get_parameters( fd, & floppy ) )
		/* 
		 * autodetection failure.
		 * This mostly occurs because of an absent or unformatted disks.
		 *
		 * It might also occur because of bizarre formats (for example 
		 * rate 1 on a 3 1/2 disk).

		 * If this is the case, the user should do an explicit 
		 * setfdprm before calling mtools
		 *
		 * Another cause might be pre-existing wrong parameters. The 
		 * user should do an setfdprm -c to repair this situation.
		 *
		 * ...fail immediately... ( Theoretically, we could try to save
		 * the situation by trying out all rates, but it would be slow 
		 * and awkward)
		 */
		return 1;

	
	/* 
	 * if we have already have the correct parameters, keep them.
	 * the number of tracks doesn't need to match exactly, it may be bigger.
	 * the number of heads and sectors must match exactly, to avoid 
	 * miscalculation of the location of a block on the disk
	 */
	if( SECTORS(floppy) == nsect &&
	   HEADS(floppy) == nheads &&
#ifdef MULTISIZE
	   ( *ssize == 0x80 || 
	    *ssize == (((floppy.rate & 0x3c ) >> 3) + 2) % 8  )&& 
#endif
#ifdef USE_2M
	   ( !*use_2m || (*use_2m & FD_2M) == (floppy.rate & FD_2M)) &&
#endif
	   TRACKS(floppy) >= ntracks ){
#ifdef MULTISIZE
		/* exists only for linux currently */
		*ssize = (((floppy.rate & 0x38) >> 3 ) + 2) % 8;
#endif
		
#ifdef USE_2M
		*use_2m = floppy.rate & FD_2M;
#endif		
		return 0;
	   }
	   
	/* set sectors, heads and tracks and other parameters */
	SECTORS(floppy) = nsect;
	HEADS(floppy) = nheads;
	TRACKS(floppy) = ntracks;
	
#ifdef MULTISIZE
	/* exists only for linux currently */
	if (*ssize == 0x80 )
		*ssize = ( ((floppy.rate & 0x38) >> 3 ) + 2 ) % 8;
	else
		floppy.rate = (floppy.rate & ~0xb8) | ((((*ssize)+6)%8) << 3);
#endif

#ifdef USE_2M
	/* exists only for linux currently */
	if (*use_2m)
		floppy.rate = (floppy.rate & ~FD_2M) | (*use_2m & FD_2M);
	else
		*use_2m = (floppy.rate & FD_2M)|1;
#endif

#ifdef SECTORS_PER_TRACK
	SECTORS_PER_TRACK(floppy) = nsect * nheads;
#endif

#ifdef SECTORS_PER_DISK
	SECTORS_PER_DISK(floppy) = nsect * nheads * ntracks;
#endif
	
#ifdef STRETCH
	/* ... and the stretch */
	if ( ntracks > 41 ) 
		STRETCH(floppy) = 0;
	else
		STRETCH(floppy) = 1;
#endif
	
	return set_parameters( fd, &floppy, &buf) ;
}
#endif /* GENERIC_INIT */
  

#ifdef LOADDEVS
#include <sys/fcntl.h>
#undef devices

#define CFG_FILE1    "/.mtoolsrc"
#define CFG_FILE2    "/etc/mtools"

#define MAX_LINE    MAXPATHLEN+40
#define MAX_DEVICES 100

#ifdef __STDC__
# define AUX(x) #x
# define STR(x) AUX(x)
#else
# define STR(x) "x"
#endif

#define SET(f,t,h,s) \
  { devices[dev].fat_bits = (f); devices[dev].tracks = (t); \
  devices[dev].heads = (h); devices[dev].sectors = (s); }

struct device devices[MAX_DEVICES+1];

void load_devices(void)
{
    FILE *cfg;
    char buffer[MAX_LINE+1],name[MAXPATHLEN+1];
    char *here,*start;
    int items,dev,fat_bits;
    char *homedir;
    char conf_file[MAXPATHLEN+sizeof(CFG_FILE1)];

    homedir = get_homedir();

    if ( homedir ){
      strncpy(conf_file, homedir, MAXPATHLEN );
      conf_file[MAXPATHLEN]='\0';
      strcat( conf_file, CFG_FILE1 );
      cfg = fopen(conf_file,"r");
    } else 
      cfg = NULL;

    if ( !cfg )
      cfg = fopen(CFG_FILE2, "r" );

    if (cfg == NULL) {
#ifdef predefined_devices
      if ( sizeof(devices) >= sizeof(const_devices) ){
	bcopy( const_devices, devices, sizeof(const_devices));
	return;
      }
#endif
      perror(CFG_FILE2);
      exit(1);
    }

    dev = 0;
    while (fgets(buffer,MAX_LINE,cfg)) {
	if ((here = strchr(buffer,'#'))) *here = 0;
	else if ((here = strchr(buffer,'\n'))) *here = 0;
	for (start = buffer; *start == ' ' || *start == '\t'; start++);
	if (!*start) continue;
	items = sscanf(start,"%c %s %d %d %d %d %ld",
	  &devices[dev].drive,name,&devices[dev].fat_bits,&devices[dev].tracks,
	  &devices[dev].heads,&devices[dev].sectors, &devices[dev].offset);
	if (dev >= MAX_DEVICES) {
	    fprintf(stderr,"Too many devices\n");
	    exit(1);
	}
	if ( items <= 6 ) devices[dev].offset = 0;
	if (items >= 6) devices[dev].fat_bits = fat_bits;
	else {
	    if (items == 2 || items == 3) {
#ifdef oldLINUX
		     if (!strncmp("/dev/at",name,7)) { SET(12,80,2,15) }
		else if (!strncmp("/dev/PS",name,7)) { SET(12,80,2,18) }
		else if (!strncmp("/dev/ps",name,7)) { SET(12,80,2,9) }
		else if (!strncmp("/dev/hd",name,7)) { SET(16,0,0,0) }
		else
#endif
		{
		    fprintf(stderr,"Unknown device %s, please specify all "
		      "parameters\n",name);
		    exit(1);
		}
		if (items == 3) devices[dev].fat_bits = fat_bits;
	    }
	    else {
		fprintf(stderr,"Config file syntax: drive device [ fat [ "
		  "tracks heads sectors ] ]\n");
		exit(1);
	    }
	}
	if (islower(devices[dev].drive))
	    devices[dev].drive = toupper(devices[dev].drive);
	devices[dev].mode = 0;
	devices[dev].gioctl = INIT_DEFAULT;
	if ((devices[dev].name = (char *) malloc(strlen(name)+1)) == NULL) {
	    fprintf(stderr,"Out of memory\n");
	    exit(1);
	}
	strcpy(devices[dev++].name,name);
    }
    memset(&devices[dev],0,sizeof(struct device));
    fclose(cfg);
}



#endif /* LOADDEVS */
