#include <linux/config.h>
#include <linux/blkdev.h>
/* to bring in FLOPPY_MAJOR */
#undef FLOPPY_MAJOR
#undef ALLOWED_DRIVE_MASK
#undef CONFIG_BLK_DEV_FD
#undef CONFIG_FLOPPY_SANITY
#undef CONFIG_FLOPPY_2_FDC

#ifdef VINTAGE
static void floppy_on(unsigned int drive);
#include <asm/dma.h>
#include <linux/fd.h>
#undef FD_RAW_USER_SUPPLIED
#define FD_RAW_USER_SUPPLIED 0
#define _request_dma(x,y) request_dma(x,y)
#define request_dma(x) _request_dma(x,"floppy")
#endif

#ifdef PRE_AK
/* let's hope this doesn't cross a 64k boundary ... */
char tmp_floppy_area[1024];
#endif

#include <linux/module.h>
/*
 * NB. we must include the kernel idenfication string in to install the module.
 */
#include <linux/version.h>
char kernel_version[] = UTS_RELEASE;

static int FLOPPY_MAJOR=2;

/* the following three variables will be overwritten if the floppy driver 
 * doesn't support it */
int FLOPPY_IRQ=6;
int FLOPPY_DMA=2;
int ALLOWED_DRIVE_MASK = 0x33;

/* the following two variables will be ignored if the floppy driver 
 * doesn't support it */
int FDC1=0x3f0;
int FDC2=-1;
static int REPLACE=0;

#define CONFIG_BLK_DEV_FD
#define CONFIG_FLOPPY_SANITY
#define CONFIG_FLOPPY_2_FDC
#define FD_MODULE

#define irqaction(x,y) request_irq((x),(y)->sa_handler,(y)->sa_flags,"floppy")

#include "floppy.c"

#ifdef FLOPPY_SETUP
char *get_options(char *str, int *ints)
{
	char *cur = str;
	int i=1;

	while (cur && *cur >= '0' && *cur <= '9' && i <= 10) {
		ints[i++] = simple_strtoul(cur,NULL,0);
		if ((cur = strchr(cur,',')) != NULL)
			cur++;
	}
	ints[0] = i-1;
	return(cur);
}

void
f_setup( void) {
	char **environ,*env,*ptr,c,i;
	char *name="floppy=";
	char line[100];
	int ints[11];

	/* assuming that insmod is compiled as a.out binary using a shared
	   C library ... */
	environ = (char **) get_fs_long( 0x60090b34 );
	
	while((env = (char *)get_fs_long(environ))){
		for(i=0; i<strlen(name); i++)
			if ( (char) get_fs_byte(env++) != name[i] )
				break;
		if(i == strlen(name)){
			ptr=line;
			while(ptr < line+99){
			        c = (char)get_fs_byte(env++);
				if ( c== ' ' || !c ){
					*ptr='\0';
					if(ptr!=line)
						floppy_setup(get_options(line,
									 ints),
							     ints);
					ptr=line;
					if (!c)
						break;
				} else
					*ptr++ = c;
			}
		}
		environ++;
	}
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
static int module_initialising=1;
static int ra=0;
int init_module(void)
{
	int ret;
	if(REPLACE){
		if ( FLOPPY_MAJOR != 2){
			printk("Use replace only with FLOPPY_MAJOR=2\n");
			return -EINVAL;
		}

		/* the following is needed if the stock driver is not
		 * module aware. We don't want to snarf its major
		 * number from under it, if there are still some open
		 * file descriptors...*/

		if (request_irq(FLOPPY_IRQ, floppy_interrupt, SA_INTERRUPT, 
				"floppy")) {
			printk("Unable to grab IRQ%d for the floppy driver\n",
				FLOPPY_IRQ);
			return -EBUSY;
		}
		disable_irq(FLOPPY_IRQ);
		free_irq(FLOPPY_IRQ);
		
		if ((ret=unregister_blkdev(MAJOR_NR, "fd")) != 0){
			printk("unregistering old driver failed\n");
			return ret;
		}
	}
	printk("inserting floppy driver for %s\n", kernel_version);
	printk("FLOPPY_MAJOR=%d\n", MAJOR_NR);
	printk("MAX_BUFFER_SECTORS=%d\n", MAX_BUFFER_SECTORS);



#ifdef FLOPPY_SETUP
	f_setup();
#endif

#ifdef MODULE_AWARE_DRIVER
	/* in module aware drivers, we can chose irq, dma, and io base 
	 * address */
	printk("FLOPPY_IRQ=%d\n", FLOPPY_IRQ);
	printk("FLOPPY_DMA=%d\n", FLOPPY_DMA);
	printk("FDC1=%x\n", FDC1);
	if ( FDC2 != -1 )
		printk("FDC2=%x\n", FDC2);
	printk("allowed drive mask=%x\n", ALLOWED_DRIVE_MASK);
	ret = new_floppy_init();
#else
	floppy_init();
	ret = 0;
#endif
	if ( ra )
		read_ahead[FLOPPY_MAJOR] = ra;
	module_initialising=0;
	return 0;
}

#ifndef MODULE_AWARE_DRIVER
static int new_floppy_init(void)
{
	printk("this should never be called\n");
	new_floppy_init();
	return -1;
}
#endif



void cleanup_module(void)
{
#ifndef PRE_AK
#ifndef MODULE_AWARE_DRIVER
	int drive;
	/* wait until everything is dead */
	while(1){
		if ( (fdc_state[0].dor & 0xf0)
#if N_FDC > 1
		    || (fdc_state[1].dor & 0xf0)
#endif
		    || module_initialising ||
		    (timer_active & (1 << FLOPPY_TIMER)) ||
		    fd_timer.next ||
		    floppy_tq.sync||
		    usage_count){
			printk("waiting...\n");
			schedule(); continue;
		}

		for (drive=0; drive < N_DRIVE; drive++){
			if(motor_off_timer[drive].next){
				printk("motor %d still on\n", drive);
				break;
			}
			if(UDRS->fd_ref)
				break;
		}
		if ( drive == N_DRIVE)
			break;
		schedule();
	}
#endif
#else
	int drive;
	while(1){
		if(current_DOR & 0xf0){
			schedule(); continue;
		}
		for (drive=0; drive < 4; drive++)
			if(fd_ref[drive])
				break;
		if(drive == 4)
			break;
		schedule();
	}
#endif

	unregister_blkdev(MAJOR_NR, "fd");
	blk_dev[MAJOR_NR].request_fn = 0;
}

#ifdef __cplusplus
}
#endif
