/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: fopen.c,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Specialized fopen()-like functions
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"



/*
 * xfopen() --- open file, check for error
 */

FILE *xfopen(name, mode)
char *name, *mode;
{
    FILE *fp;

    if((fp = fopen(name, mode)) == NULL) {
	log("$Can't open file '%s'", name);
	exit(EX_OSFILE);
    }
    return(fp);
}



/*
 * libfopen() --- open file in LIBDIR, check for error
 */

FILE *libfopen(name, mode)
char *name, *mode;
{
    char filename[MAXPATH];

    strncpy0(filename, cf_libdir(), sizeof(filename));
    strncat0(filename, "/",         sizeof(filename));
    strncat0(filename, name,        sizeof(filename));

    return xfopen(filename, mode);
}



/*
 * spoolfopen() --- open file in SPOOLDIR, check for error
 */

FILE *spoolfopen(name, mode)
char *name, *mode;
{
    char filename[MAXPATH];

    strncpy0(filename, cf_spooldir(), sizeof(filename));
    strncat0(filename, "/",           sizeof(filename));
    strncat0(filename, name,          sizeof(filename));

    return xfopen(filename, mode);
}
