/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: declare.h,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Declaration header for not-so-ANSI systems
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/


/*
 * errno might not be declared extern in errno.h
 */
extern int errno;



#ifdef sun /******************************************************************/
/*
 * SUNOS 4.1.x, GNU gcc 2.x
 */

/*
 * Non-standard functions
 */
/* sys/time.h */
int    gettimeofday P((/*struct timeval *, struct timezone * */));

/* unistd.h */
int    lockf	P((int, int, long));


/*
 * Standard-C functions undeclared in header files
 */

/* stdio.h */
int    _filbuf	P(());			/* Internal, no standard */
int    _flsbuf	P(());			/* Internal, no standard */

int    fclose	P((FILE *));
int    fflush	P((FILE *));
int    fprintf	P((FILE *, const char *, ...));
int    fputs	P((const char *, FILE *));
size_t fread	P((void *, size_t, size_t, FILE *));
int    fseek	P((FILE *, long, int));
size_t fwrite	P((const void *, size_t, size_t, FILE *));
void   perror	P((const char *));
int    printf	P((const char *, ...));
int    puts	P((const char *));
int    rename	P((const char *, const char *));
void   rewind	P((FILE *));
int    sscanf	P((char *, const char *, ...));
int    ungetc	P((int, FILE *));
int    vfprintf	P((FILE *, const char *, va_list));
int    vsprintf	P((char *, const char *, va_list));
/* Not ANSI-C or POSIX but missing anyway ... */
int    pclose	P((FILE *));

/* string.h */
/* Not ANSI-C or POSIX */
int	strcasecmp	P((char *, char *));
int	strncasecmp	P((char *, char *, int));

/* stdlib.h */
int    system	P((const char *));

/* time.h */
time_t time	P((time_t *));
size_t strftime P((char *, size_t, const char *, const struct tm*));
/* Looks like SUN's timelocal() is the same as Standard-C mktime() */
#define mktime  timelocal

#endif /**sun*****************************************************************/
