#!/usr/bin/perl

$title="FEddi 0.9 Makefile maker";

sub input {
	local($line);
	print $_[0];
	$line=<STDIN>;
	chop($line);
	$line;
}

print("Figuring out group and user...\n");

@fidouser=getpwnam("fido");
@fidogroup=getgrnam("fido");

if (!defined(@fidogroup)) {
	$freegid=0;
	setgrent;
	while (@grent=getgrent) {
		if ($grent[2]>$freegid && $grent[2]<32000) {
			$freegid=$grent[2];
		}
	}
	endgrent;
	$freegid++;
	die "Can't open /etc/group!\n" unless open(group,">>/etc/group");
	print group "fido::$freegid:fido,root,uucp\n";
	close(group);
	@fidogroup=getgrnam("fido");
	if (!defined(@fidogroup)) { die "Can't create group entry!\n"; }
	print "Created fido group GID $fidogroup[2]\n";
} else {
	print "Found fido group GID $fidogroup[2]\n";
}

if (!defined(@fidouser)) {
	$freeuid=0;
	setpwent;
	while (@pwent=getpwent) {
		if ($pwent[2]>$freeuid && $pwent[2]<32000) {
			$freeuid=$pwent[2];
		}
	}
	endpwent;
	$freeuid++;
	die "Can't open /etc/passwd!\n" unless open(passwd,">>/etc/passwd");
	print passwd "fido::$freeuid:$fidogroup[2]:FidoNet::\n";
	close(passwd);
	@fidouser=getpwnam("fido");
	if (!defined(@fidouser)) { die "Can't create passwd entry!\n"; }
	print "Created fido user UID $fidouser[2]\n";
} else {
	print "Found fido user UID $fidouser[2]\n";
}

if ($fidogroup[3] !~ /\bfido\b/) {
	die "Can't open /etc/group!\n" unless open(group,"</etc/group");
	die "Can't open /etc/tmpgroup!\n" unless open(tmpgr,">/etc/tmpgroup");
	while ($entry = <group>) {
		chop($entry);
		print tmpgr $entry;
		if ($entry =~ /^fido:/) {
			if ($entry =~ /:$/) {
				print tmpgr "fido";
			} else {
				print tmpgr ",fido";
			}
		}
		print tmpgr "\n";
	}
	close(group);
	close(tmpgr);
	system("cp /etc/group /etc/group~ ; mv /etc/tmpgroup /etc/group");
	@fidogroup=getgrnam("fido");
	if (!defined(@fidogroup)) { die "Can't modify group entry!\n"; }
	if ($fidogroup[3] !~ /\bfido\b/) { die "Can't modify group entry!\n"; }
	print "Adding fido user entry in fido group memberlist\n";
} else {
	print "Found fido user entry in fido group memberlist\n";
}

@tmppath=stat("/tmp");
if (!defined(@tmppath)) {
	print "\nCan't find TEMPPATH\n";
	while (!defined(@tmppath)) {
		$temppath=&input("Please enter your TEMPPATH [/tmp]: ");
		@tmppath=stat($temppath);
	}
	$last=chop($temppath);
	$temppath.=$last;
	if ($last!~/\//) { $temppath.="/"; }
} else {
	$temppath="/tmp/";
}
print "Found TEMPPATH $temppath\n";

print "\nCreating config.h\n";

system("cp config.h config.h.old");
die "Can't create config.h!\n" unless open(conf,">config.h");
print conf <<EOF;
/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#ifndef _CONFIG_H
#define _CONFIG_H

/* TEMPDIR */
#define TEMPPATH "$temppath"
#define TEMPMSG  TEMPPATH"msg.feddi"

/* charset */
#define DEFAULTCHRS 1

/* MsgBase mode */
#define FIDO_MOD 0664
#define FIDO_UID $fidouser[2]
#define FIDO_GID $fidogroup[2]

#endif
EOF
close(conf);

print "\nMakefile\n";

while (!defined(@st)) {
	$bindir=&input("Enter the binary-path [/usr/bin]: ");
	if ($bindir eq "") { $bindir="/usr/bin"; }
	@st=stat($bindir);
}
$last=chop($bindir);
if ($last!~/\//) { $bindir.=$last; }

undef(@st);
while (!defined(@st)) {
	$mandir=&input("Enter the man-path [/usr/man]: ");
	if ($mandir eq "") { $mandir="/usr/man"; }
	@st=stat($mandir);
}
$last=chop($mandir);
if ($last!~/\//) { $mandir.=$last; }

print "\nCreating Makefile\n";

system("cp Makefile Makefile.old");
die "Can't create Makefile!\n" unless open(mkf,">Makefile");
die "Can't open config/Makefile.orig!\n" unless open(omkf,"<config/Makefile.orig");
print mkf <<EOF;
# Edit these Path to match your configuration
SRCDIR    = $ENV{'PWD'}
SRCMANDIR = \$(SRCDIR)/man
BINDIR    = $bindir
MANDIR    = $mandir/man1

EOF
while (<omkf>) {
	print mkf;
}
close(mkf);
close(omkf);

print "\Modifing config.user\n";
system("cp config/config.user config/config.user.old");
die "Can't create config/config.user!\n" unless open(ncf,">config/config.user");
die "Can't open config/config.user.old!\n" unless open(ocf,"<config/config.user.old");
print ncf <<EOF;
#!/usr/bin/perl

\$FEDDISRC="$ENV{'PWD'}";
EOF
$_=<ocf>;
$_=<ocf>;
$_=<ocf>;
while (<ocf>) { print ncf; }
close(ncf);
close(ocf);

print "\nDone.\n";
