/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#define _CHARSET
#include "charset.h"

const char CHRSETS[MAXCHRS][5][10]=
{
	{"LATIN-1 2","LATIN-1","LATIN1",""},
	{"IBMPC 2","IBMPC",""},
};

static const unsigned char SETS[MAXCHRS][256]=
{
	{ /* Linux latin1 -- NO CONVERSION */
		  0,   1,   2,   3,   4,   5,   6,   7,
		  8,   9,  10,  11,  12,  13,  14,  15,
		 16,  17,  18,  19,  20,  21,  22,  23,
		 24,  25,  26,  27,  28,  29,  30,  31,
		 32,  33,  34,  35,  36,  37,  38,  39,
		 40,  41,  42,  43,  44,  45,  46,  47,
		 48,  49,  50,  51,  52,  53,  54,  55,
		 56,  57,  58,  59,  60,  61,  62,  63,
		 64,  65,  66,  67,  68,  69,  70,  71,
		 72,  73,  74,  75,  76,  77,  78,  79,
		 80,  81,  82,  83,  84,  85,  86,  87,
		 88,  89,  90,  91,  92,  93,  94,  95,
		 96,  97,  98,  99, 100, 101, 102, 103,
		104, 105, 106, 107, 108, 109, 110, 111,
		112, 113, 114, 115, 116, 117, 118, 119,
		120, 121, 122, 123, 124, 125, 126, 127,
		128, 129, 130, 131, 132, 133, 134, 135,
		136, 137, 138, 139, 140, 141, 142, 143,
		144, 145, 146, 147, 148, 149, 150, 151,
		152, 153, 154, 155, 156, 157, 158, 159,
		160, 161, 162, 163, 164, 165, 166, 167,
		168, 169, 170, 171, 172, 173, 174, 175,
		176, 177, 178, 179, 180, 181, 182, 183,
		184, 185, 186, 187, 188, 189, 190, 191,
		192, 193, 194, 195, 196, 197, 198, 199,
		200, 201, 202, 203, 204, 205, 206, 207,
		208, 209, 210, 211, 212, 213, 214, 215,
		216, 217, 218, 219, 220, 221, 222, 223,
		224, 225, 226, 227, 228, 229, 230, 231,
		232, 233, 234, 235, 236, 237, 238, 239,
		240, 241, 242, 243, 244, 245, 246, 247,
		248, 249, 250, 251, 252, 253, 254, 255,
	},
	{ /* Conversion table from `ibmpc' charset to `latin1' charset. */
		/* Generated by GNU recode version 3.3. */
      0,   1,   2,   3,   4,   5,   6,   7,     /*   0 -   7 */
      8,   9,  10,  11,  12,  13,  14,  15,     /*   8 -  15 */
     16,  17,  18,  19, 182, 167,  22,  23,     /*  16 -  23 */
     24,  25,  26,  27,  28,  29,  30,  31,     /*  24 -  31 */
     32,  33,  34,  35,  36,  37,  38,  39,     /*  32 -  39 */
     40,  41,  42,  43,  44,  45,  46,  47,     /*  40 -  47 */
     48,  49,  50,  51,  52,  53,  54,  55,     /*  48 -  55 */
     56,  57,  58,  59,  60,  61,  62,  63,     /*  56 -  63 */
     64,  65,  66,  67,  68,  69,  70,  71,     /*  64 -  71 */
     72,  73,  74,  75,  76,  77,  78,  79,     /*  72 -  79 */
     80,  81,  82,  83,  84,  85,  86,  87,     /*  80 -  87 */
     88,  89,  90,  91,  92,  93,  94,  95,     /*  88 -  95 */
     96,  97,  98,  99, 100, 101, 102, 103,     /*  96 - 103 */
    104, 105, 106, 107, 108, 109, 110, 111,     /* 104 - 111 */
    112, 113, 114, 115, 116, 117, 118, 119,     /* 112 - 119 */
    120, 121, 122, 123, 124, 125, 126, 127,     /* 120 - 127 */
    199, 252, 233, 226, 228, 224, 229, 231,     /* 128 - 135 */
    234, 235, 232, 239, 238, 236, 196, 197,     /* 136 - 143 */
    201, 230, 198, 244, 246, 242, 251, 249,     /* 144 - 151 */
    255, 214, 220, 162, 163, 165, 158, 159,     /* 152 - 159 */
    225, 237, 243, 250, 241, 209, 170, 186,     /* 160 - 167 */
    191, 169, 172, 189, 188, 161, 171, 187,     /* 168 - 175 */
	/* This section is WITHOUT linedrawing-conversion (-g) */
/*
    248, 164, 253, 179, 180, 145,  20, 156,
    184, 185,  21, 175, 166, 174, 190, 168,
    192, 193, 194, 195, 142, 143, 146, 128,
    200, 144, 202, 203, 204, 205, 206, 207,
    208, 157, 210, 211, 212, 213, 153, 215,
    216, 217, 218, 219, 154, 221, 222, 152,
*/
	/* This section is WITH linedrawing-conversion (-g) */
		 35,  35,  35, 124,  43, 124,  43,  46,
		 46, 124, 124,  46,  39,  39,  39,  46,
		 96,  43,  43,  43,  45,  43, 124,  43,
		 96,  46,  61,  61, 124,  61,  61,  61,
		 43,  61,  43,  96,  96,  46,  46,  43,
		 61,  39,  46,  35,  35,  35,  35,  35,

    133, 223, 131, 227, 132, 134, 181, 135,     /* 224 - 231 */
    138, 130, 136, 137, 141, 173, 140, 139,     /* 232 - 239 */
    240, 177, 149, 155, 147, 245, 247, 148,     /* 240 - 247 */
    176, 151, 183, 150, 129, 178, 254, 160,     /* 248 - 255 */
	}
};

static const unsigned char BACK[MAXCHRS][256]=
{
	{ /* Linux latin1 -- NO CONVERSION */
		  0,   1,   2,   3,   4,   5,   6,   7,
		  8,   9,  10,  11,  12,  13,  14,  15,
		 16,  17,  18,  19,  20,  21,  22,  23,
		 24,  25,  26,  27,  28,  29,  30,  31,
		 32,  33,  34,  35,  36,  37,  38,  39,
		 40,  41,  42,  43,  44,  45,  46,  47,
		 48,  49,  50,  51,  52,  53,  54,  55,
		 56,  57,  58,  59,  60,  61,  62,  63,
		 64,  65,  66,  67,  68,  69,  70,  71,
		 72,  73,  74,  75,  76,  77,  78,  79,
		 80,  81,  82,  83,  84,  85,  86,  87,
		 88,  89,  90,  91,  92,  93,  94,  95,
		 96,  97,  98,  99, 100, 101, 102, 103,
		104, 105, 106, 107, 108, 109, 110, 111,
		112, 113, 114, 115, 116, 117, 118, 119,
		120, 121, 122, 123, 124, 125, 126, 127,
		128, 129, 130, 131, 132, 133, 134, 135,
		136, 137, 138, 139, 140, 141, 142, 143,
		144, 145, 146, 147, 148, 149, 150, 151,
		152, 153, 154, 155, 156, 157, 158, 159,
		160, 161, 162, 163, 164, 165, 166, 167,
		168, 169, 170, 171, 172, 173, 174, 175,
		176, 177, 178, 179, 180, 181, 182, 183,
		184, 185, 186, 187, 188, 189, 190, 191,
		192, 193, 194, 195, 196, 197, 198, 199,
		200, 201, 202, 203, 204, 205, 206, 207,
		208, 209, 210, 211, 212, 213, 214, 215,
		216, 217, 218, 219, 220, 221, 222, 223,
		224, 225, 226, 227, 228, 229, 230, 231,
		232, 233, 234, 235, 236, 237, 238, 239,
		240, 241, 242, 243, 244, 245, 246, 247,
		248, 249, 250, 251, 252, 253, 254, 255,
  },
	{ /* Conversion table from `latin1' charset to `ibmpc' charset. */
		/* Generated by GNU recode version 3.3. */
		/* Each input char transforms into an output string. */
      0,   1,   2,   3,   4,   5,   6,   7,     /*   0 -   7 */
      8,   9,  10,  11,  12,  13,  14,  15,     /*   8 -  15 */
     16,  17,  18,  19, 182, 186,  22,  23,     /*  16 -  23 */
     24,  25,  26,  27,  28,  29,  30,  31,     /*  24 -  31 */
     32,  33,  34,  35,  36,  37,  38,  39,     /*  32 -  39 */
     40,  41,  42,  43,  44,  45,  46,  47,     /*  40 -  47 */
     48,  49,  50,  51,  52,  53,  54,  55,     /*  48 -  55 */
     56,  57,  58,  59,  60,  61,  62,  63,     /*  56 -  63 */
     64,  65,  66,  67,  68,  69,  70,  71,     /*  64 -  71 */
     72,  73,  74,  75,  76,  77,  78,  79,     /*  72 -  79 */
     80,  81,  82,  83,  84,  85,  86,  87,     /*  80 -  87 */
     88,  89,  90,  91,  92,  93,  94,  95,     /*  88 -  95 */
     96,  97,  98,  99, 100, 101, 102, 103,     /*  96 - 103 */
    104, 105, 106, 107, 108, 109, 110, 111,     /* 104 - 111 */
    112, 113, 114, 115, 116, 117, 118, 119,     /* 112 - 119 */
    120, 121, 122, 123, 124, 125, 126, 127,     /* 120 - 127 */
    199, 252, 233, 226, 228, 224, 229, 231,     /* 128 - 135 */
    234, 235, 232, 239, 238, 236, 196, 197,     /* 136 - 143 */
    201, 181, 198, 244, 247, 242, 251, 249,     /* 144 - 151 */
    223, 214, 220, 243, 183, 209, 158, 159,     /* 152 - 159 */
    255, 173, 155, 156, 177, 157, 188,  21,     /* 160 - 167 */
    191, 169, 166, 174, 170, 237, 189, 187,     /* 168 - 175 */
    248, 241, 253, 179, 180, 230,  20, 250,     /* 176 - 183 */
    184, 185, 167, 175, 172, 171, 190, 168,     /* 184 - 191 */
    192, 193, 194, 195, 142, 143, 146, 128,     /* 192 - 199 */
    200, 144, 202, 203, 204, 205, 206, 207,     /* 200 - 207 */
    208, 165, 210, 211, 212, 213, 153, 215,     /* 208 - 215 */
    216, 217, 218, 219, 154, 221, 222, 225,     /* 216 - 223 */
    133, 160, 131, 227, 132, 134, 145, 135,     /* 224 - 231 */
    138, 130, 136, 137, 141, 161, 140, 139,     /* 232 - 239 */
    240, 164, 149, 162, 147, 245, 148, 246,     /* 240 - 247 */
    176, 151, 163, 150, 129, 178, 254, 152,     /* 248 - 255 */
	}
};

const char PRINTABLECHAR[256]=
{
/* 0==!printable 1==printable 2==printable&convertible
 * -1==pipethrough
 * 0  1  2  3  4  5  6  7  8  9  a  b  c  d  e  f
 */
	-1,-1, 0, 0, 0, 0, 0, 0, 0,-1,-1, 0, 0,-1, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	 0,-1,-1,-1, 0,-1,-1,-1, 0, 0,-1,-1,-1,-1, 0, 0,
	-1,-1,-1, 0, 0,-1,-1,-1, 0, 0,-1,-1,-1,-1, 0,-1,
	 0, 0, 0, 0, 2,-1,-1,-1, 0,-1, 0, 0, 0, 0, 0, 0,
	 0,-1, 0, 0, 0, 0, 2, 0,-1, 0, 0, 0, 2, 0, 0, 2,
	-1,-1,-1, 0, 2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
	 0,-1,-1,-1,-1, 0, 2,-1,-1,-1,-1,-1, 2, 0, 0,-1,
};

const maxCONVERTCHAR=7;

const ConversionType CONVERTCHAR[8]=
{
	{0xe4,"ae"},
	{0xf6,"oe"},
	{0xfc,"ue"},
	{0xc4,"Ae"},
	{0xd6,"Oe"},
	{0xdc,"Ue"},
	{0xdf,"ss"},
};

void transstr(char *s, int Set)
{
	for (; *s; s++)
	{
		*s=(char)SETS[Set][((int)*s)&255];
		if (!PRINTABLECHAR[((int)*s)&255]) *s='#';
	}
}

void transback(char *s, int Set)
{
	for (; *s; s++)
		*s=(char)BACK[Set][((int)*s)&255];
}
