.\"
.\" $Header: /vol/dwb/src/mumail-2.4b/RCS/mumail.man,v 1.4 1994/03/31 20:13:07 dwb Exp $
.\".\"
.\" $Log: mumail.man,v $
.\\" Revision 1.4  1994/03/31  20:13:07  dwb
.\\" Fixed problems with new 2.4 beta words
.\\"
.\\" Revision 1.3  1994/03/31  20:08:16  dwb
.\\" Added addtional 2.4 Beta words
.\\"
.\\" Revision 1.2  1994/03/31  17:59:21  dwb
.\\"  MuMail 2.4 Beta
.\\"
.\\" Revision 1.1  1993/11/15  19:02:32  dwb
.\\" Initial revision
.\\"
.\"
.TH Mumail 1X "June 1993" "Revision 2.4Beta "X11 Super Clients" \" -*- nroff -*-
\".TH Mumail 1X "June 1993" "MMS Programs" "X11 Super Clients" \" -*- nroff -*-

\"                             -*- Mode: Nroff -*- 
\" mumail.man --- Manual page
\" Author          : Muhammad M. Saggaf
\" Created On      : April 1993
\" Last Modified By: system admin
\" Last Modified On: Tue Jul  6 23:29:02 1993
\" Update Count    : 39
\" Status          : Mostly OK
\" 

.SH NAME

Mumail \- X11 Mail Reader.

.SH PRONUNCIATION

Mumail is pronounced \fImo mail\fP, as in \fImore mail\fP.

.SH SYNOPSIS

\fBMumail\fP [\-option ...] [\-toolkit_option ...]

.SH DESCRIPTION

.P 
\fIMumail\fP is a complete full-featured mail reader for the \fIX
Window System\fP. \" Some of its features are:


.SH OPTIONS

.PP
Toolkit options given at the command line (e.g. \-geometry, \-iconic, ..etc.)
all refer to the first Mumail screen (screen 0).

\"Besides the toolkit options, Mumail recognizes the following
\"command-line switches:

.SH RESOURCES

Toolkit resources (e.g. geometry, iconic, ..etc.) for Mumail's first
screen (screen 0) are specified as usual. Toolkit resources for other
screens have to be qualified by the screen number. Examples follow.

.PD 0
.IP
For screen 0:
.IP
Mumail.<resource>: <value>
.PD

.PD 0
.IP
For screen 1:
.IP
Mumail.screen1.<resource>: <value>
.PD

.PD 0
.IP
For all screens:
.IP
Mumail*<resource>: <value>
.PD

.PD 0
.IP
Invalid:
.IP
Mumail.screen0.<resource>: <value>
.PD

.PP
Besides the toolkit resources, Mumail defines some proprietry
resources. All proprietry resources are global and cannot be specified
on a per-screen basis. These resources are as follows:

.TP
.BI checkTime " (int)"
This resource sets the time in seconds between checks of the 
users mailbox for mail.
.I Default value: 300

.TP
.BI mailIcon " (string)"
This is the path name of the xpm file to use as an icon 
when there is new mail in the mailbox. If not set Mumail 
defaults to internal icons.
.I Default value: NULL

.TP
.BI nomailIcon " (string)"
This is the path name of the xpm file to use as an icon when 
there is no new mail in the mailbox. If not sets Mumail 
defaults to internal icons.
.I Default value: NULL

.TP
.BI cite.fillColumn " (int)"
This is the column beyond which automatic line-wrapping for formatted
citation should happen. The program will break the line at the nearest
word boundary if the line goes beyond this column.
.I Default value: 70

.TP
.BI cite.indentString " (string)"
Left-hand padding for formatted citation. This string will be
prepended to the normal citation string. The default is a tab, to
left-indent quoted text a bit for a more aesthetic look.
.I Default value: \\\\t

.TP
.BI cite.nestedAttribFmt " (string)"
The attribution format string used for nested (rn-style) citation.
The content of the original letter's From: header will be substituted
for the conversion specifier (%s) in this format string.
.I Default value: \\\\n>>>>> %s wrote:\\\\n>\\\\n

.TP
.BI cite.nonNestedAttribFmt " (string)"
The attribution format string used for non-nested (sc-style)
citation. The program will prompt for a string (usually the initials
of the person to whom the cited text is attributed) to substitute for
the first conversion specifier (%s) in this format string. The content
of the original letter's From: header will be substituted for the
second conversion specifier.
.I Default value: \\\\n>>>>> %s == %s wrote:\\\\n\\\\n

.TP
.BI contentInToc " (boolean)"
Whether to display the first part of the message body in the table of
contents if the subject line is shorter than its field (like mhmail
does). If disabled, only the subject is shown, even if it doesn't fill
its field. The main advantage to that is that it makes the table of
contents look less busy and easier to browse.
.I Default value: off

.TP
.BI externalEditor " (string)"
You favorite external editor. Keep in mind though that Mumail has its
own quite capable editor.
.I Default value: emacs

.TP
.BI mailAgent.passAddress " (boolean)"
Wheather to leave the task of extracting the To:, Cc:, and Bcc:
headers from the message to the mail delivery agent, or wheather
Mumail itself should perform that task and pass the addresses in those
headers to the mail delivery agent on the command line. Refer to the
section titled \fIMail Delivery Agents\fP below for more details.
.I Default value: off

.TP
.BI mailAgent.program " (string)"
The mail delivery agent on your system. This progarm is responsible
for delivering mail to local and remote hosts, and will be invoked by
Mumail when sending letters. Refer to the section titled \fIMail
Delivery Agents\fP below for more details.
.I Default value: /usr/lib/sendmail

.TP
.BI mailAgent.arguments " (string)"
Command-line switches to pass to the mail delivery agent. Refer to the
section titled \fIMail Delivery Agents\fP below for more details.
.I Default value:  \-bm \-oi \-oem \-t


.TP
.BI mime.addHeaders " (boolean)"
Whether Mumail should add the MIME headers to outgoing messages. These
headers make the letter MIME-compiant so that it will be handled
properly if read by a MIME-aware mail reader at the other end. There
is no harm in enabling this feature other than cluttering the
headers. These headers will be available for editing by the user while
composing the draft, and are constructed according to the default
letter properties given by other resources (see below).
.I Default value: on

.TP
.BI mime.agentCommand " (string)"
The full command (including switches) of the mime agent on the
system. Mumail will pass MIME-compliant messages that are not plain
text (e.g. jpeg pictures, audio sounds, ..etc), to this agent for
viewing, subject to the resource \fImime.invokeAgent\fP.
.I Default value: metamail -d -r -x -m Mumail

.TP
.BI mime.multipartBoundary " (string)"
This is the bounadry Mumail should use to separate the MIME subparts
included in a multipart MIME letter contrcuted via the
\fImime-include\fP command. Refer to the section titled \fIMIME
Support\fP below for more details.
.I Default value: ####

.TP
.BI mime.defaultContentType " (string)"
The default content type of outgoing letters. The Content-Type header
in the draft will be set according to this resource if
\fImime.addHeaders\fP is enabled.
.I Default value: text/plain

.TP
.BI mime.defaultCharSet " (string)"
The default character set of outgoing letters. The Content-Type header
in the draft will be set according to this resource if
\fImime.addHeaders\fP is enabled.
.I Default value: US-ASCII

.TP
.BI mime.defaultTransferEncoding " (string)"
The default transfer encoding of outgoing letters. The
Content-Transfer-Encoding header in the draft will be set according to
this resource if \fImime.addHeaders\fP is enabled.
.I Default value: 7BIT

.TP
.BI mime.invokeAgent " (enumeration)"
Specifies the action taken by Mumail when the user elects to view a
MIME-compliant letter that is not plain text. This resources can be
either \fInever\fP (never invoke the MIME agent), \fIalways\fP
(automatically invoke it, without confirmation), or \fIask\fP (prompt
the user before invoking). Case is irrelevant, so Ask and ask mean the
same thing.
.I Default value: ask

.TP
.BI printCommand " (string)"
The external command (program) used on your system to send documents
to the printer for printing. This is used by Mumail for printing
letters and folders from withen the program.
.I Default value: lpr

.TP
.BI quickKey?
Refer to the section entitled \fIQuick Keys\fP below.

.TP
.BI signatureFile " (string)"
The base name of the user's signature file. The program will look for
this file in the user's home directory.
.I Default value: .signature

.TP
.BI sort.descending " (boolean)"
Whether folder sorting should be in a descending (decreasing) order
rather than the default ascending order. The value of this resource
can also be changed dynamically on a per-screen basis via the menus.
.I Default value: off

.TP
.BI sort.majorKey " (enumeration)"
The primary key used in sorting folders. Folders are sorted according
to this key unless two letters have equal value of this key, in which
case the seconady key will be used. Accepted values are \fIdate\fP
(letter date), \fIsubject\fP (letter subject), and \fIname\fP (the
sender's name or address). Key names are case-insensitive.  The value
of this resource can also be changed dynamically on a per-screen basis
via the menus. Mumail is smart enough to ignore \fIRe:\fP in subject
lines when sorting by subject.
.I Default value: date

.TP
.BI sort.minorKey " (enumeration)"
The secondary key used in sorting folders. See the resource
\fIsort.majorKey\fP for more details. The value of this resource can
also be changed dynamically on a per-screen basis via the menus.
.I Default value: subject

.TP
.BI sort.when " (enumeration list)"
Specifies a list of instances at which Mumail should auto-sort the
folder. The program sorts the current folder at each instance in the
list. Instance names are case-insensitive. Valid instance names are:

.IP "" 15n

.IP
.I burst:
Each time a digest is exploded into its constituent letters. This
means the folder will be sorted each time this function is invoked
either via the menus or accelerator keys.

.IP 
.I commit:
Each time Folder*Commit is invoked.

.IP 
.I inc:
This is currenly not supported.

.IP 
.I none:
Never sort the folder. This is meaningful only if no other instance
name is in the resource.

.IP 
.I open:
Each time a folder is opened. This also includes each time new mail is
incorporated. 

.IP 
.I save:
Each time the folder is saved.

.PP
The default is to sort the folder when it is opened and after
exploding digests.
.I Default value: burst open


.SH MAIL DELIVERY AGENTS

Mumail does not rely on any external programs for incorporaitng and
reading mail. However, like other mail readers of its ilk (e.g. elm,
pine, ..etc.), Mumail relies on mail delivery agents for sending mail.
It is important that Mumail is told enough information about the mail
delivery agent on your system, or outgoing letters may not be
delivered successfully due to miscommunication bewteen Mumail and the
mail delivery agent.

Mumail needs to know three things about the mail delivery agent, all
of which are set via the resources: the program's name, command
switches to pass to, and whether to pass the receipients' addresses to
it on the command line. The first two are self-explanatory, the third
means whether Mumail should extract the To:, Cc:, and Bcc: headers
from the message and pass those on the command line to the mail
delivery agent, or leave this task to be performed by the mail agent
itself. Care should be taken not to give the mail delivery agnet
conflicting options; for example, specifying \-t as a command-line
switch to smail and telling Mumail to pass the addresses to it would
result in smail not delivering the message to anybody. Suggested
settings for some of the more popular mail delivery agents are
discussed below.

By far the most popular mail delivery agents are \fIsendmail\fP,
\fIsmail\fP and \fImailx\fP (old Berkeley mail). The first two (with a
suitable switch) do not need the addresses to be passed to them. Note
that although these two progarms can be run in a mode where they need
the addresses to be passed to them, it is recommended that you do not
use that mode, but instead take advantage of their intelligence.  This
is purely a case of me having more trust of the ability of those
programs to extract the headers properly than I have in my own
program! Don't let that fool you though, Mumail is very good at what
it does, and you have to rely on it anyway if you're using mailx.

Note that regardless of what program extracts the headers, Mumail
alsways performas alias expanstion and Fcc: refiling for the message
before invoking the mail delivery agent. Suggested values for Mumail
resources describing the mail delivery agents mentioned above are as
follows:


.PD 0
.TP 
.I sendmail
.IP
Mumail.mailAgent.program: /usr/lib/sendmail
.IP
(or sendmail, if in the path)
.IP
Mumail.mailAgent.argumentss: \-bm \-oi \-oem \-t
.IP
Mumail.mailAgent.passAddress: off
.PD

.PD 0
.TP 
.I smail
.IP
Mumail.mailAgent.program: smail
.IP
(also /bin/rmail, send-mail)
.IP
Mumail.mailAgent.argumentss: \-bm \-oi \-oem \-t
.IP
Mumail.mailAgent.passAddress: off
.PD

.PP
If you want Mumail to take care of extracting the headers and to pass
them on the command line to the mail agent, then change the latter
resources in the above two examples to:

.PD 0
.IP
Mumail.mailAgent.argumentss: \-bm \-oi \-oem
.IP
Mumail.mailAgent.passAddress: on
.PD

.PD 0
.TP 
.I mailx (old Berkeley mail)
.IP
Mumail.mailAgent.program: /bin/mail
.IP
(also /usr/ucb/mail)
.IP
Mumail.mailAgent.argumentss:
.IP
Mumail.mailAgent.passAddress: on
.PD


.SH ALIASES

Mumail has full support for mail aliases. When sending a draft, the
program expands each alias to the corresponding addresses listed in
the alises file (~/.mumail/aliases by default). The aliases file can
be edited from withen Mumail and is reread automatically whenever it
changes, even if the change is made by an external program. Multiple
aliases can be specified on the same line. Headers for which aliases
are expanded are \fITo:\fP, \fICc:\fP, and \fIBcc:\fP.

The format of the aliases file is very flexible. Each alias line has
the follwoing format.

.nf
.IP
.I
alias : [comment] { address [, addrsss...] }
.fi

.PP
Blank lines are allowed between alias lines. The comment field can
have any characters (including spaces and newlines, so it can span
multiple lines) except curley braces. Spaces between the different
fields in an alias line are optional, but are encouraged for clarity.
Spaces, tabs, and newlines can appear anywhere in an alias line,
subject to two RFC restrictions: newlines are not allowed between
addresses, and continuation address lines have to start with a space
or a tab. Mumail will accept aliases violating these two restrictions,
but they will not be handled properly by the mail agent. An example
aliases file follows:

.PD 0
.nf
Friend1 : This is a comment { someone@somewhere.com }

Friend2 : Anything after the colon and before the curley
          brace is a comment. As you can see, it can span
          multiple lines.  
          { someone@somewhere.com }

Friend3 : Blank lines are fine, { someone@somewhere.com }
Friend4 : but not reuired. { someone@somewhere.com }

friend4 : Case is significant. This is not the same as
          the one above.
          { someone@somewhere.com }

Friend5:No spaces are necessary anywhere, 
        but they're good for clarity.{someone@somewhere.com}

Friends1 : This has multiple addresses .
           { someone1@somewhere.com, someone2@somewhere.com }

Friends2 : Even more addresses (with real names this time).
           Note though, that you cannot have blank lines in
           addresses between the braces. Also, continuation
           lines in addresses have to start with a space or
           a tab. 
        { someone1@somewhere.com (Friend1), 
          someone2@somewhere.com (Friend2),
          someone3@somewhere.com, someone4@somewhere.com (Friend4) }

Friends3 : 

           Let's stretch it a bit. This is also ok.

        { 
          
          someone1@somewhere.com (Friend1), 
          someone2@somewhere.com (Friend2),
          someone3@somewhere.com, someone4@somewhere.com (Friend4) 

        }

dummy: The following is a typical entry {}

Mumail-list: 
    
     This comment space it useful to for a general
     explanation of what this alias is for and such. You
     can also put reminders here (e.g. note that the
     address someone102@somewhere.com will expire on July
     12, so please remove it then). You can put anything
     here as long as it doesn't contain a curley brace. 

     {
        someone1@somewhere.com (Friend1), 
        someone2@somewhere.com (Friend2),
        someone3@somewhere.com (Friend3), 
        someone4!uucp!somewhere (Friend4) 
     }
.fi
.PD

.PP 
End of example. The following are examples of invalid alias lines:

.PD 0
.nf
Friend1 : Invalid since {comment} has a curley brace.
        { someone@somewhere.com }

Friends1 : Invalid since a blank line appears between 
           addresses.
          { someone1@somewhere.com,

            someone2@somewhere.com }

Friends2 : Invalid since an address continuation line does
           not start with a space or a tab.
          { someone1@somewhere.com,
someone2@somewhere.com }
.fi
.PD

.PP
Aliases can be previewed before sending the letter (useful if, for
example, the user is not sure of what alias corresponds to what
address and wants to check) via the \fIExpand Aliases\fP option of the
draft menu. This is meant for previewing only and is not required,
since all aliases and MIME inclusions are expaneded automatically when
the letter is sent.

.SH MIME SUPPORT

Mumail suppoerts the Multipurpose Internet Mail Extensions,
\fIMIME\fP. For incoming letters, Mumail identifies MIME-compliant
letters that are not plain text and passes them to the system's MIME
agent for display, subject to the resource \fImime.invokeAgent\fP. The
program also adds MIME-compliant headers to all outgoing letters,
unless the user elects not to do so. Those headers are available for
editing during letter composition and can be changed there. They are
constructed according to the MIME resources mentioned elsewhere in
this manual.

MIME subparts can be included in any outgoing letter in a straight
forward manner. To insert a MIME subpart in an outgoing letter, put a
line like the following at the place in the draft where you want the
subpart to be included:

.nf
.I @mime-include <entity> <content-type/subtype> [encoding]@
.fi

.PP
Mumail will then insert the subpart and add the appropriate boundaries
and letter headers to the document. The command will be ignored unless
it starts on a new line. The command itself can span multiple lines,
however, and does not have to fit a single line. The third argument is
optional, and text beyond it till the end of the command (as delimited
by @) is ignored. Arguments that contain spaces have to be quoted. The
resource \fImime.addHeaders\fP has to be enabled in this case, or you
may get an inconsistent (MIME-incompliant) document.

The first argument is either a file name or a shell command whose
output is be placed in the document. If this argument starts with the
dollar sign, it will considered a shell command, otherwise it is
considered file name. The second argument is the content type and
subtype of the subpart, and third is the content transfer encoding
used to encode the subpart. Examples follow.

The following commands insert a plain text subpart whose content is in
the file ~/foo.bar:

.PD 0
.nf
.IP
@mime-include ~/foo.bar text/plain 7bit@
.IP
@mime-include ~/foo.bar text/plain@
.IP
@mime-include ~/foo.bar "text/plain; charset=us-ascii" 7bit@
.fi
.PD

.PP
The following command inserts a gif image whose content has been
encoded in base64 and placed in a file called pic.b64:

.PD 0
.nf
.IP
@mime-include pic.b64 image/gif base64@
.fi
.PD

.PP
The following command encodes a jpeg image whose content is in the
file pic.jpg into base64 and then inserts the encoded result in the
document. This is the easiest and most typical use of the command.

.PD 0
.nf
.IP
@mime-include "$mmencode pic.jpg" image/jpeg base64@
.fi
.PD

.PP
A similar command, but sends an audio file instead: 

.PD 0
.IP
.nf
@mime-include "$mmencode sound.au" audio/basic base64@
.fi
.PD

.PP
Refer to RFC-1341 for details on the valid MIME content types and
transfer encodings.

Multiple subparts can be included in the letter with or without plain
text between them. Here is an example:

.PD 0
.IP
\&...
.IP
Hey Joe, here is the latest output I got from the simulation:
.nf
.IP
@mime-include "$mmencode semu-4.jpg" image/jpeg base64@
.fi
.IP
As you can see, it differes quite a bit from last week's results:
.nf
.IP
@mime-include "$mmencode semu-1.jpg" image/jpeg base64@
.IP
@mime-include "$mmencode semu-2.jpg" image/jpeg base64@
.fi
.IP
What do you think?
.IP
\&...
.PD

.PP
Included subaprts can be expanded in the draft for previewing before
the letter is sent. This can be done via the \fIExpand MIME
Inclusions\fP menu option under the draft menu. This is meant for
previewing only and is not required, since all aliases and MIME
inclusions are expaneded automatically when the letter is sent. Also
note that unlike expanding aliases, using the Expand MIME Inclusions
menu choice more than once in the same draft (do not confuse this with
expanding numerous, possibly repeated, inclusions with a single
invocation of the menu choice) will likely result in a malformed
(i.e. MIME-incompliant) document.

.SH MENUS

.TP
.B Window Menu:

.IP "" 15n

.IP 
.I New
opens a new window with the current folder. Folders are not shared
between windows, and changes in a folder in one window does not
affect the same folder if also opened in another window.

.IP
.I Close
closes the current window. Closing the last window exits the program
(the user is always prompted before exiting in this case).

.IP
.I Iconify <C-z>
iconifies the current window. 

.IP
.I Exit Program <q>
exits the program. The user is prompted if the folder is not saved.

.IP
.I Quick Exit <Q>
exits the program unconditionally. No prompt is issued, even if the
folder is not saved.

.TP
.B Folder Menu:

.IP
.I Check Mailbox
reports if the the user's mailbox has any mail.

.IP
.I Read New Mail
incorporates new mail into the inbox folder \fIMUINBOX\fP and makes it
the current folder. 

.IP
.I Open <C-o>
opens a folder.

.IP 
.I ReOpen     
reopens the current folder.

.IP
.I Open in Next Window
opens a folder in the next window. If no next window exits, a new one
is created.

\" New...                    

.IP
.I Save (+Commit) <C-s>
saves the current folder. The folder is saved in the same fomrat it
was opened in. For example, a compressed folder is saved as
compressed. 

.IP
.I Save As  
saves the current folder under a new name. The folder will
automatically be saved as compressed if the new name ends with .Z, and
as gzipped if it ends with .z or .gz.

.IP
.I Save Compressed
saves the current folder in compressed format. There is no need to
choose this if the folder is already compressed.

.IP
.I Save GZipped            
saves the current folder in gzipped format. There is no need to
choose this if the folder is already gzipped.

.IP
.I Save Unpacked (Normal)
if the folder is compressed/gzipped, this will save it as a normal
file (non-compressed/gzipped). Otherwise, it's equivalent to
\fIOpen\fP.

.IP
.I Edit
allows the user to edit the current folder. This should be used only
by people who know what they're doing.

.IP
.I Delete
deletes the current folder.

.IP
.I Commit Changes <C-c>
commits all changes to the folder without saving it. This is
convenient to reduce the clutter in the table of content by removing
all deleted letters.

.IP
.I Sort (Do it!)
sorts the current folder accroding to the default keys and sort
order.

.IP
.I Sort Major Key
Prompts for and sets the default major key for soritng folders, then
sorts the current folder. The menu label shows the current sort key.

.IP
.I Sort Minor Key
prompts for and sets the default minor key for soritng folders, then
sorts the current folder. The menu label shows the current sort key.

.IP
.I Sort Major Key
reverses the default sort direction, then sorts the current
folder. The menu label shows the current sort direction.

.IP
.I Search Headers
searches the headers of all letters in the folder for a given string
starting from the current letter. The first letter containing the
string in its headers will be highlighted and displayed. The search is
case-insensitive.

.IP
.I Search Whole Letters
is similar to the above, but searches the whole letter (including the
headers), instead of just the headers.

.IP
.I Next Find
finds the next search match starting from the letter following the
current one. The search type (i.e. headers only vs. whole letter) is
the same as the last search perfomed. This option is not available
until a search is first executed by one of the menu functions
mentioned above.

.IP
.I Reconstruct TOC
reconstrcuts the table of contents from the folder.

.IP
.I Redraw TOC <C-l>
redraws (redisplays) the table of contents.

.IP
.I Info
displays information about the current folder.

.TP
.B Letter Menus:

.IP
.I View <./space> 
displays the current letter. (Space actually does more than just
displaying the letter, see the section titled \fIMouse and Key
Bindings\fP below).

.IP
.I View Whole <v>
displays the current letter with all its headers.

.IP
.I View in Next Window 
displays the current letter in the next window. If no next window
exits, a new one is created.

.IP
.I MIME View
passes the current letter to the MIME agent for display. Refer to the
section titled \fIMIME Support\fP for more details.

.IP
.I Compose <c>
allows the user to compose and send a new letter.

.IP
.I Reply <r>
replies to the current letter.

.IP
.I Forward <f>
forwards the current letter.

.IP
.I Follow-up                     
follows-up on the current letter.

.IP
.I Quote/Reply (SC Fmt.) <M-1>
quotes the current letter in formatted non-nested (SuperCite-like)
style and replies to it. Lines are adjusted withen paragraphs to fit
the width of the fill-column. Refere to the resource
\fIcite.fillColumn\fP for more details.

.IP
.I Quote/Reply (SC Unfmt.) <M-2>
quotes the current letter in unformatted non-nested (SuperCite-like)
style and replies to it. Lines are \fInot\fP adjusted withen
paragraphs to fit the width of the fill-column.

.IP
.I Quot/Reply (RN) <M-3>
quotes the current letter in unformatted nested (rn-like) style and
replies to it. Simplest type of citation.

.IP
.I External Compose
composes a new letter using the extrnal editor. Refer to the resource
\fIexternalEditor\fP for more details. 

\"External Reply                

.IP
.I Info <i>
displays information about the current letter.

.IP
.I Tag/Untag <t>
tags or untags the current letter.

.IP
.I Tag All
tags all letters in the folder.

.IP
.I Tag Range
tags a range of letters. The user is prompted for the range.

.IP
.I Untag All
untags all letters in the folder.

.IP
.I Retag <T>
retags the letters that were tagged before the last oparation. For
example, to copy a range of letters to a file then delete them, use
Tag Range * Copy * Retag * Delete.

.IP
.I Delete <d>
deletes the current letter or tagged letters.

.IP
.I Undelete <u>
undeletes the current letter or tagged letters.

.IP
.I Copy/Write <C/w>
copies the current letter or tagged letters to a folder or writes
it/them to a file.

.IP
.I Refile <F>
refiles the current letter or tagged letters to a folder.

.IP
.I Pipe to Command
pipes the current letter or tagged letters (one at a time) to a shell
command. For example, piping a letter to the command \fIlpr\fP prints
it.
        
.IP
.I Print
prints the current letter or tagged letters. Refer to the resource
\fIprintCommand\fP for more details.

.IP
.I Explode Digest
explodes a digest into its constituent letters.

.IP
.I Explode Grotty Digest
explodes a digest not conforming to the de facto standard Digest
Message Format (RFC-1153) into its constituent letters. Use this if
the digest fails to explode properly using \fIExplode Digest\fP.

.IP
.I Search <C-s>
searches the current letter for a given string. The accelerator key is
valiad only in the body box (letter) area.

.TP
.B Draft Menu:

I'm tired. Figure this one out for yourself.

.TP
.B Edit Menu:

ditto.

.TP
.B Help Menu:

ditto.

.SH MOUSE AND KEY BINDINGS

All Mumail mouse and key bindings can be set via the resource
translation table, so they can easily be modified by the user if the
default ones do not suit his/her taste.

The default mouse bindings for the table of contents display are as
follows.

.IP "" 15n

.IP
.I Left Button
selects the letter (makes it the current one) but does not display
it.
.IP
.I Middle Button
selects the letter and displays it.
.IP
.I Right Button
tags/untags the letter.

.PP
There are also some key shortcuts, but they do not cover all menu
choices. Those are listed above under the section titled \fIMenus\fP.
Additional ones for the table of contents are as follows. Note that
C- and M- refer to the Control and Meta keys, respectively.

.IP "" 15n

.IP 
.I PgUp
scrolls up.
.IP
.I PgDown
scrolls down.
.IP
.I M-<
moves to first page.
.IP
.I M->
moves to last page.

.IP
.I Down
selects the next letter but does not display it.
.IP
.I Up
selects the previous letter but does not display it.
.IP
.I n
selects the next letter and displays it.
.IP
.I p
selects the previous letter and display it.

.IP
.I Space
does `the right thing'. It displays the current letter or scrolls
current letter down by one page or displays the next letter (as
appropriate).
.IP
.I BackSpace, b
move backward one page in the letter.
.IP
.I Return
moves to the next line in the letter.

.PP
In the letter view area, besides the usual mouse functions (scrolling
and such), the editor/viewer has a large number of mouse and key
bindings. I'm not going to list those here, but they generally follow
Emacs' key bindings (e.g. Ctrl-s for search, Ctrl-w for kill region,
\&..etc).

.SH QUICK KEYS

Mumail allows the user to have custom buttons, called \fIQuickKeys\fP
(quickies), to which actions can be attached. QuickKeys provide a
convenient way via which the user can invoke frequently-used
operations by a singe mouse click. QuickKeys are specified through the
resources quickKey?, where ? is an integer corresponding to the order
at which that QuickKey is to appear on the window.  Relevant subparts
of that resource are \fIaction\fP and \fIlabel\fP. Here is an example:

.PD 0
.nf
.IP
Mumail*quickKey3.action: ReplyToLetter() QuoteScStyleFmt()
.IP
Mumail*quickKey3.label: Reply+Q
.fi
.PD

.PP
The first line specifies the action bound to the third QuickKey (in
this case, a compound action), and being a non-empty resource, that
the third QuickKey should be visible. The second line specifies the
label for that QuickKey. Other subparts can also be specified in a
similar fashion (e.g. background, foreground, ..etc.). 

Actions can be either simple or compound. A compound action consists
of a stack of simple actions. If the action is empty, the
corresponding QuickKey is not displayed. If no QuickKey is to be
displayed, the QuickKey box itself is not displayed. QuickKeys do not
have to specified in any partiular order (i.e. it is acceptable to
make the first and third QuickKeys visible but not the second).

Mumail supports a large number of actions, and unavailable but desired
actions can be added easily. I'm not going to list them here, the user
is referred to the app-defaults file for examples. In general,
anything that you can invoke via an accelerator key has an action, and
any menu option can have an action (send me an email me request if you
want a new action added). Because actions can be stacked, it is
possible to have a QuickKey that can singly perform the task of
several menu options.

One action worth mentioning here is \fIOpenFolder\fP. You can use this
action to open frequntly-visited folder by a single key click, which
is equivalent to the FreqFolder feature that is no longer supported.
Examples follow.

.IP "" 15n

.IP
.I OpenFolder()
Pops up the file chooser for selecting and opening a folder.
Equivalent to the corresponding menu option.

.IP
.I OpenFolder(sent)
Opens the folder sent in the user's mail directory. Prompts for saving
the current folder if it has changed since the last time it was
opened/saved.

.IP
.nf
.I OpenFolder(/usr/mail/sent)
.fi
Opens the specified folder.


.IP
.I SaveFolder() OpenFolder(sent)
Saves the current folder then opens the folder sent in the user's mail
directory.

.SH FILES

Mumail expects all mail folders to be in the directory ~/Mail.
Program configuration files should reside in the directory ~/.mumail.

.TP
.BI ~/Mail/MUINBOX
This is the inbox folder all new incoming mail is deposited into.

.TP
.BI ~/.mumail/headers
The headers in this file is added to the headers of all outgoing
letters. These headers are visible to the user during letter
composition and can be edited before sending the letter. This file
typically contains the user's custom header.

.TP
.BI ~/.mumail/aliases
The aliases file. See the section titled \fIAliases\fP above for more
details.

.TP
.BI ~/.signature
The user's signature file. The content of this file will be inserted
in the draft when the InsertSignature function is called. An alternate
signature file can be specified via the resource \fIsignatureFile\fP

.SH SEE ALSO

mail(1), sendmail(8)

.SH BUGS

None that I know of so far, but there must be some.

.SH COPYRIGHT


     Copyright (c) 1992-1993 of Muhammad M. Saggaf
                   1994 of David. W. Boyd
                   All Rights Reserved

Mumail is not public domain. Permission is granted to use 
and distribute Mumail freely for any use and to sell it at any price 
provided that in all above cases Mumail is intact and this entire 
copyright notice must appear in all copies of this software. 

Permission is also granted to modify the source as long as the modified 
source is not distributed without prior consent of the author.

IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF
THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED
OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT LIMITED
TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE
AUTHOR HAS NO OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES,
ENHANCEMENTS, OR MODIFICATIONS.

If you would like to do something with this software that this copyright
prohibits please contact the author (email prefered) and arrangements 
may be worked out.

.SH AUTHOR

Muhammad M. Saggaf, alsaggaf@mit.edu. Snail Mail: Muhammad Saggaf, Box
9863, Dhahran 31311, SAUDI ARABIA. I apologize that I may not be able
to respond to all correspondence I receive.

.SH MAINTAINER
David W. Boyd, dave_boyd@sterling.com. Snail Mail: David Boyd,
Sterling Software, 1404 Fort Crook Rd, Bellevue, NE 68005

.SH ACKNOWLEDGEMENT

Joseph Urban (jurban@norden1.com) supplied me with the RFC-1153
document and examples of digests that were not correcly handled by
older versions of the program. KidMun.Yap@mel.dit.csiro.au sent me
patches and ideas that I based some new features on. David Hobley
(davidh@cyclone.bt.co.uk) sent bug reports and fixes. Edward M.
Williams <WILLIAMSEM@space.laafb.af.mil> modified the file chooser to
use regex and globbing. And my sincere thanks to everybody to sent me
comments, suggestions, bug fixes, or yes, even bug reports :-).


