#!/bin/sh
#
# $Header: /vol/dwb/src/mumail-2.4b/RCS/makever.sh,v 1.2 1994/03/31 17:59:18 dwb Exp $
#
#
# $Log: makever.sh,v $
# Revision 1.2  1994/03/31  17:59:18  dwb
#  MuMail 2.4 Beta
#
# Revision 1.1  1993/11/15  19:02:31  dwb
# Initial revision
#
#


# Sometimes hostname is broken and exit with nonzero even if it
# succeeds, so this approach is not used.

#host=`hostname || uname -n || echo host` 
#if [ "$USER" != "" ]; then user=$USER
#elif [ "$LOGNAME" != "" ]; then user=$LOGNAME
#elif [ "$LOGNAME" != "" ]; then user=$LOGNAME
#else user="user"
#fi

VERSION="2"
REVISION="4Beta"

host=`hostname`
if [ "$host" = "" ]; then host=`uname -n`; fi
if [ "$host" = "" ]; then host=$HOST; fi
if [ "$host" = "" ]; then host="unknown"; fi

user=$USER
if [ "$user" = "" ]; then user=$LOGNAME; fi
if [ "$user" = "" ]; then user=`logname`; fi
if [ "$user" = "" ]; then user="unknown"; fi

system=`uname -s`
if [ "$system" = "" ]; then system="unknown"; fi

machine=`uname -m`
if [ "$machine" = "" ]; then machine=$MACHINE; fi
if [ "$machine" = "" ]; then machine=$HOSTTYPE; fi
if [ "$machine" = "" ]; then machine=$hosttype; fi
if [ "$machine" = "" ]; then machine="unknown"; fi

# This requires bash (ksh and zsh would probably work too), but is not
# supported by the standard sh.

#host=`hostname`; host=${host:-${`uname -n`:-"host"}}
#user=${USER:-${LOGNAME:-${`logname`:-"user"}}}

echo "#define COMPILE_BY \"$user\"" > version.h
echo "#define COMPILE_HOST \"$host\"" >> version.h
echo "#define COMPILE_OSNAME \"$system\"" >> version.h
echo "#define COMPILE_HOSTTYPE \"$machine\"" >> version.h
echo "#define COMPILE_DATE \"`date +%D`\"" >> version.h
echo "#define COMPILE_TIME \"`date +%T`\"" >> version.h

echo "#define VERSION \"$VERSION\"" >> version.h
echo "#define REVISION \"$REVISION\"" >> version.h

echo "#ifdef IS_MAIN" >> version.h
echo "static char version[] = \"\$Revision: 1.2 $VERSION.$REVISION \$\";"\
     >> version.h
echo "#endif" >> version.h

echo "Machine type is $machine, OS name is $system"
