#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmScreen.c,v 1.2 1994/03/31 17:57:40 dwb Exp $";
#endif


/*
 * $Log: MmScreen.c,v $
 * Revision 1.2  1994/03/31  17:57:40  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:53:02  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmScreen.c --- Screen Handling routines
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Wed Jun 30 07:31:11 1993
 * Update Count    : 57
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Paned.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif

#include "MmDecl.h"
#include "MuWin.h"
#include "MuGeneric.h"
#include "version.h"

extern Widget
                SetupTocW(),
                SetupQuickKeys(),
                SetupBodyW();

extern void
                SetupMainMenu(),
                SetupDialogW();

SCREEN          *scnList[MAX_SCREENS];
int             numScreens;

static void IconEventHandler(w, client_data, event)
Widget w;
XtPointer client_data;
XEvent *event;

{
Bool state;
SCREEN *scn = (SCREEN *)client_data;

   if (event->type == PropertyNotify)
      {
      XtVaGetValues(w, XtNiconic, &state, NULL);

      if (state)
          SetIconState(scn);
      }
}
SCREEN*
AddScreen(topLevelW, folderName)
	 Widget          topLevelW;
	 String          folderName;
{
  SCREEN               *scn;
  static Atom          WM_DELETE_WINDOW;
  Widget               frameW;
  String               folder, dummyS;
  int                  i;

  unsigned long                 valuemask;
  XSetWindowAttributes          attributes;

  if (numScreens >= MAX_SCREENS - 1) {
	MuError("Maximum number of screens reached");
	MuNotice("Recompile with a larger MAX_SCREENS number");
	return (SCREEN*)NULL;
  }

  /** Due to the potential heavy use of FmtString between here and the 
   ** actual use of folderName, we must guarantee the validy of the
   ** variable by replicating it in our own memory here.
   */
  folder = XtNewString(folderName);

  /** Find the lowest available screen slot.
   */
  for (i = 0; i < numScreens; i++)
	if (scnList[i] == NULL) break;

  /** Allocate the space and initialize it to zero.
   */
  scn = scnList[i] = (SCREEN*)XtCalloc(1, (unsigned)sizeof(SCREEN));
  scn->number = i;
  numScreens++;

  /**
   */
/*  scn->parentW = scn->number == 0 ? topLevelW :
	XtVaCreatePopupShell(FmtString("screen%d", scn->number), 
					 topLevelShellWidgetClass, topLevelW, 
					NULL);
*/
    scn->parentW = XtVaCreatePopupShell(FmtString("screen%d", scn->number), 
                                         topLevelShellWidgetClass, topLevelW,
					 NULL);

  XtOverrideTranslations(scn->parentW,
	     XtParseTranslationTable("<Message>WM_PROTOCOLS: CloseWindow()"));
  SetIcon(scn->parentW,False);

  /**
   */
  scn->topLevelW = topLevelW;

  XtAddEventHandler(scn->parentW, PropertyChangeMask, False, IconEventHandler,
                    (XtPointer)scn);
#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("mainFrame", xfwfFrameWidgetClass,
					scn->parentW, NULL); 
#else
  frameW = scn->parentW;
#endif
  scn->panedW = AddPaned("mainPaned", frameW);

  SetupMainMenu(scn, scn->panedW);
  scn->toc.tocW = SetupTocW(scn->panedW);
  SetupQuickKeys(scn);
  SetupDialogW(scn, scn->panedW);
  scn->bodyW = SetupBodyW(scn->panedW);

#if USE_3D_FRAME
  frameW = 	XtVaCreateManagedWidget("labelFrame", xfwfFrameWidgetClass,
					scn->panedW, NULL); 
#else
  frameW = scn->panedW;
/*  XtVaSetValues(scn->panedW, XtNinternalBorderWidth, 1, NULL);*/
#endif
  scn->labelW = AddLabel("labelW", frameW);

  /* Initialize the buffer list */
  scn->folder.buffers = NULL;
  scn->folder.buffs_used = 0;

  /** We have to set this here so that they are defined even if we fail 
   ** to open the initial folder.
   */
  scn->folder.numLetters = 0;
  scn->folder.curLetterN = -1;
  scn->folder.changed = False;

  scn->letterList[0] = NULL;
  scn->draft.name = XtNewString(FmtString("%s.%d", DRAFT_NAME, 
										   scn->number));
  scn->draft.tmpName = XtNewString(FmtString("%s.tmp.%d", DRAFT_NAME, 
										   scn->number));
  scn->draft.active = False;
  scn->toc.tocS = NULL;

  /**
   */
  DisplayLogo(scn);

  /**
   */
  /* if (scn->number) XtPopup(scn->parentW, XtGrabNone);
  else XtRealizeWidget(scn->parentW); */
  XtPopup(scn->parentW, XtGrabNone);

  WM_DELETE_WINDOW = XInternAtom(XtDisplay(scn->parentW), 
					 "WM_DELETE_WINDOW", False);
  XSetWMProtocols(XtDisplay(scn->parentW), XtWindow(scn->parentW), 
				  &WM_DELETE_WINDOW,  1);

  /** Ignore device events while the busy cursor is displayed. 
   */
  valuemask = CWDontPropagate;
  attributes.do_not_propagate_mask = (KeyPressMask | KeyReleaseMask |
				  ButtonPressMask | ButtonReleaseMask | 
				  PointerMotionMask);

  /** The window will be as big as the display screen, and clipped by
   ** its own parent window, so we never have to worry about resizing.
   */
  scn->cursorW = 
	XCreateWindow(XtDisplay(scn->parentW), XtWindow(scn->parentW), 0, 0,
				  65535, 65535, (unsigned int) 0, 0, InputOnly,
				  CopyFromParent, valuemask, &attributes);

  /**
   */
  if (!FileReadable(folder)) 
	folderName = SetupTempFolder(folder);

  if (OpenFolder(scn, folder) >= 0)
	Message(scn, FmtString("Welcome to Mumail version %s.%s%s", VERSION, 
							REVISION, QueryMailBox(scn, &dummyS) == 
							QM_MAILBOX_HAS_MAIL ? " (BTW, mailbox has mail)" 
							: ""), MSG_CLEAR_NEVER);
  
  XtFree(folder);
  return scn;
}

SCREEN*
FirstScreen(scn)
	 SCREEN          *scn;
{
  int          i;

  /* Most common case */
/*  if (numScreens == 1) return scn; */

  for (i = 0; i < MAX_SCREENS; i++)
	if (scnList[i]) return scnList[i];

  return (SCREEN*)NULL;
}

SCREEN*
NextScreen(scn)
	 SCREEN          *scn;
{
  int          i;

  /* Most common case */
  if (numScreens == 1) return (SCREEN*)NULL;

  for (i = scn->number+1; i < MAX_SCREENS; i++)
	if (scnList[i]) return scnList[i];

  return (SCREEN*)NULL;
}

/* ARGSUSED */
int
NumberOfScreens(scn)
	 SCREEN          *scn;
{
  return numScreens;
}

SCREEN*
WidgetToScn(widget)
	 Widget widget;
{
  int          i;

  widget = GetShell(widget);
  for (i = 0; i < MAX_SCREENS; i++)
	if (scnList[i] && scnList[i]->parentW == widget) return scnList[i];

  MuError("(SERIOUS ERROR): Could not find screen from widget");
  return NULL;
}

SCREEN*
NewWindowProc(scn, folder)
	 SCREEN          *scn;
	 String          folder;
{
  AnimStart(scn);
  SimpleMessage(scn, "New window will appear soon...");
  return AddScreen(scn->topLevelW, folder);
}

/* ARGSUSED */
void
NewWindowCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  NewWindowProc(scn, FolderFullName(scn));
}

/*---------------------------------------------------------------------------+
| Close window routines.
+---------------------------------------------------------------------------*/

void
CloseWindow(scn)
	 SCREEN          *scn;
{
  RestoreKeyboardFocus(scn);
  if (NumberOfScreens(scn) == 1) {QuickExit(scn); return;}

  XtUnmapWidget(scn->parentW);
  /* This is to insure that the message timer is not triggered after the 
	 screen is destroyed */
  Message(scn, "", MSG_REMOVE_TIMER);

  if (scn->number) XtDestroyWidget(scn->parentW);
  else {
	XtDestroyWidget(scn->panedW);
	XtUnrealizeWidget(scn->parentW);
  }

  numScreens--;
  scnList[scn->number] = NULL;
  XtFree(scn->folder.name);
  XtFree(scn->draft.name);
  XtFree(scn->draft.tmpName);
  XtFree((String)scn);
}

void
CloseWindowProc(scn, prompForExit)
	 SCREEN           *scn;
	 Boolean          prompForExit;
{  
  int             action;

  PromptIffolderChanged(scn,action);

  if (NumberOfScreens(scn) == 1 && prompForExit)
	if (AlertYesNo(TOCW, "Last window. Exit program?") == 2) return;

  CloseWindow(scn);
}

/* ARGSUSED */
void 
CloseWindowCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  CloseWindowProc((SCREEN*)clientData, True);
}

/* ARGSUSED */
void
IconifyWindowCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  IconifyShell(scn->parentW);
}

/*---------------------------------------------------------------------------+
| Exit program routines.
+---------------------------------------------------------------------------*/

void
QuickExit(scn)
	 SCREEN          *scn;
{
  SCREEN           *curScn;

  for (curScn = FirstScreen(scn); curScn; curScn = NextScreen(curScn))
	XtUnmapWidget(curScn->parentW);
  
  XtDestroyApplicationContext(XtWidgetToApplicationContext(scn->parentW));
  exit(0);
}

/* ARGSUSED */
void 
QuickExitCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  QuickExit((SCREEN*)clientData);
}

/* ARGSUSED */
void 
ExitCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN           *scn = (SCREEN*)clientData, 
                   *curScn, *nextScn;

  for (curScn = FirstScreen(scn); 
	   curScn && ((nextScn = NextScreen(curScn)) || 1);
	   curScn = nextScn)
	CloseWindowProc(curScn, False);
}
