#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmQuickKeys.c,v 1.2 1994/03/31 17:57:37 dwb Exp $";
#endif


/*
 * $Log: MmQuickKeys.c,v $
 * Revision 1.2  1994/03/31  17:57:37  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:53:01  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmQuickKeys.c --- QuickKeys routines
 * Author          : Muhammad M. Saggaf
 * Created On      : Wed Jun 30 01:21:17 1993
 * Last Modified By: system admin
 * Last Modified On: Thu Jul  1 12:16:55 1993
 * Update Count    : 12
 * Status          : Mostly OK, needs some cleaning up
 */

#include "config.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#if USE_3D_FRAME
#include "Xfwf/Frame.h"
#endif

#include "MmDecl.h"
#include "MuWin.h"
#include "MuGeneric.h"

#define MAX_SEQUICKKEYS 30

struct QuickKeyResRec {
  Boolean          visible;
  String           action;
};

void
GetQuickKeyResources(topLevelW, quickKeyName, quickKeyRes)
	 Widget               topLevelW;
	 String               quickKeyName;
	 struct QuickKeyResRec      *quickKeyRes;
{
#define offset(field) XtOffsetOf(struct QuickKeyResRec, field)
  static XtResource resources[] = {
    {"visible", "Visible", XtRBoolean, sizeof(Boolean),
	   offset(visible), XtRImmediate, (XtPointer)False},
    {"action", "Action", XtRString, sizeof(String),
	   offset(action), XtRString, (XtPointer)""},
  };
#undef offset
  
  XtGetSubresources(topLevelW, (XtPointer)quickKeyRes, quickKeyName, 
					"Command", resources, XtNumber(resources), NULL, 0);
}

Widget
SetupQuickKeys(scn)
	 SCREEN          *scn;
{
  struct QuickKeyResRec quickKeyRes;
  Widget                frameW, quickKeysBoxW, quickKeyW;
  String                qKName, action, qKTrans;
  int                   i, n;

#if 0 /*USE_3D_FRAME*/
  frameW = 	XtVaCreateManagedWidget("quickKeysBoxFrame", xfwfFrameWidgetClass,
									scn->panedW, NULL); 
#else
  frameW = scn->panedW;
#endif

  quickKeysBoxW = AddBox("quickKeysBox", frameW);

  for (i = 0, n = 0; i < MAX_SEQUICKKEYS; i++) {
	qKName = FmtString("quickKey%d", i+1);
	GetQuickKeyResources(scn->topLevelW, qKName, &quickKeyRes);

	if (*(action = StripStringA(quickKeyRes.action))) {
      n++;
	  
#if USE_3D_FRAME
	  frameW = XtVaCreateManagedWidget("quickKeyFrame", xfwfFrameWidgetClass,
									   quickKeysBoxW, NULL);
#else
	  frameW = quickKeysBoxW;
#endif

	  quickKeyW = AddButton(qKName, frameW, NULL, NULL);
      qKTrans = FmtString("<Btn1Up>: %s unset()", action);
      XtOverrideTranslations(quickKeyW, XtParseTranslationTable(qKTrans));
	}
  }

  if (n == 0) {
	XtDestroyWidget(quickKeysBoxW);
#if 0 /*USE_3D_FRAME*/
	XtDestroyWidget(frameW);
#endif
  }

  return quickKeysBoxW;
}
