#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmFolder.c,v 1.2 1994/03/31 17:57:14 dwb Exp $";
#endif


/*
 * $Log: MmFolder.c,v $
 * Revision 1.2  1994/03/31  17:57:14  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:52  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

/*                               -*- Mode: C -*- 
 * MmFolder.c --- Folder handling
 * Author          : Muhammad M. Saggaf
 * Created On      : April 1993
 * Last Modified By: system admin
 * Last Modified On: Wed Jul  7 00:15:11 1993
 * Update Count    : 149
 * Status          : Mostly OK, needs some cleaning up
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/AsciiText.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include <sys/stat.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

#define PATHSEP_CHAR ('/')

void
ParseFolderName(fullName, name, path)
	 String          fullName;
	 String          *name,
                     *path;
{
  String          sepPtr;

  fullName = ExpandTilda(fullName);
  if ((sepPtr = strrchr(fullName, PATHSEP_CHAR))) {
	*sepPtr = CNULL;
	*name = ++sepPtr;
	*path = fullName;
  }
  
  else {
	*path = FileInMailDir("");
	*(strend(*path)-1) = CNULL;
	*name = fullName;
  }
}

String
FileFullName(name, path)
	 String          name,
	                 path;
{
  return FmtString("%s%c%s", path, PATHSEP_CHAR, name);
}

String
FolderFullName(scn)
	 SCREEN          *scn;
{
  return FileFullName(scn->folder.name, scn->folder.path);
}

String
FileBaseName(fullName)
	 String          fullName;
{
  String          tmpPtr = FmtString("%s", fullName);
  String          name, path;

  ParseFolderName(tmpPtr, &name, &path);
  return name;
}

void
SetFolderName(scn, fullName)
	 SCREEN          *scn;
	 String          fullName;
{
  String          postTitle, name, path;

  ParseFolderName(fullName, &name, &path);

  if (scn->folder.name) XtFree(scn->folder.name);
  scn->folder.name = XtNewString(name);
  if (scn->folder.path) XtFree(scn->folder.path);
  scn->folder.path = XtNewString(path);

  postTitle = FmtString("%s%s", scn->folder.name, scn->number ? 
						 FmtString("(%d)", scn->number) : "");
  XtVaSetValues(scn->parentW, XtNtitle, FmtString("Mumail: %s", postTitle),
				XtNiconName, postTitle, NULL);
}
  
int
OpenFolder(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{
  static String          fullName;
  String                 name, path;

  /* This is here so that is the file chooser is not used, the folder
	 base name indicates it's in the mail directory */
  ParseFolderName(folderName, &name, &path);

  /* We want to make sure the name is still valid after the heavy use
	 of FmtString in GetLettersFromFolder() */
  if (fullName) XtFree(fullName);
  fullName = XtNewString(FileFullName(name, path));

  if (GetLettersFromFolder(scn, fullName) < 0) 
	{AnimStop(scn); return -1;}

  scn->folder.changed = False;
  SetFolderName(scn, fullName);

  if (res.sortWhen & SORT_ON_OPEN) SortFolderByDefaultKeys(scn);
  SimpleMessage(scn, "Building table of contents...");
  ReMakeToc(scn);
  SetIconState(scn);
 
  return 0;
}

/*---------------------------------------------------------------------------+
| Incorporate new mail routines.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
int
QueryMailBox(scn, mailBoxName)
	 SCREEN          *scn;
	 String          *mailBoxName;
{
  static String          mailBox;
  struct stat            statInfo;
  
  if (mailBox == NULL) mailBox = getenv("MAIL");
  if (mailBox == NULL) return QM_NO_MAILBOX_NAME;
  if (stat(mailBox, &statInfo) < 0) return QM_STAT_ERROR;

  *mailBoxName = mailBox;
  return (statInfo.st_size ? QM_MAILBOX_HAS_MAIL : QM_MAILBOX_EMPTY);
}

int
CheckMailBoxProc(scn, mailBox)
	 SCREEN          *scn;
	 String          *mailBox;
{
  int                    retStatus;

  switch (retStatus = QueryMailBox(scn, mailBox)) {
  case QM_NO_MAILBOX_NAME:
	SimpleMessage(scn, "Could not get mailbox name, aborting");
	return -1;
  case QM_STAT_ERROR:
	if (errno == ENOENT) SimpleMessage(scn, "No mailbox");
	else MessagePError(scn, "Mailbox error");
	return -1;
  case QM_MAILBOX_EMPTY:
	SimpleMessage(scn, "Mailbox is empty");
	return -1;
  case QM_MAILBOX_HAS_MAIL:
  default:
	break;
  }

  return retStatus;
}

/* ARGSUSED */
void
CheckMailBoxCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          dummyS;

  if (CheckMailBoxProc(scn, &dummyS) == QM_MAILBOX_HAS_MAIL)
	SimpleMessage(scn, "Mailbox has mail");
}

int
IncorporateNewMailProc(scn)
	 SCREEN          *scn;
{
  String                 mailBox;
  FILE                   *mailBoxFP;
  String                 mailBoxBuf;
  int                    retStatus;

  if (CheckMailBoxProc(scn, &mailBox) != QM_MAILBOX_HAS_MAIL)
	return -1;

  if ((mailBoxFP = fopen(mailBox, "r")) == NULL) {
	MessagePError(scn, "Could not open Mailbox");
	return -1;
  }

  if ((mailBoxBuf = SimpleCopyStreamToBuffer(mailBoxFP)) == NULL) {
	MessagePError(scn, "Could not read Mailbox");
	fclose(mailBoxFP);
	return -1;
  }

  retStatus = AppendBufferToFile(FileInMailDir(INFOLDER_NAME), mailBoxBuf);

  fclose(mailBoxFP);
  XtFree(mailBoxBuf);

  if (retStatus < 0) return retStatus;

  if (truncate(mailBox, 0) < 0) {
	MessagePError(scn, "Could not empty mailbox");
	MuPError(FmtString("Could not truncate file %s", mailBox));
  }

  return True;
}

int
AppendNewMailProc(scn)
	 SCREEN          *scn;
{
  String                 mailBox;
  FILE                   *mailBoxFP;
  String                 mailBoxBuf;
  int                    retStatus;

  if (CheckMailBoxProc(scn, &mailBox) != QM_MAILBOX_HAS_MAIL)
	return -1;

  if ((mailBoxFP = fopen(mailBox, "r")) == NULL) {
	MessagePError(scn, "Could not open Mailbox");
	return -1;
  }

  if ((mailBoxBuf = CopyStreamToBuffer(mailBoxFP,"\n\n")) == NULL) {
	MessagePError(scn, "Could not read Mailbox");
	fclose(mailBoxFP);
	return -1;
  }

  retStatus = AppendLettersFromBuffer(scn, mailBoxBuf);

  fclose(mailBoxFP);

  if (retStatus < 0) return retStatus;

  if (truncate(mailBox, 0) < 0) {
	MessagePError(scn, "Could not empty mailbox");
	MuPError(FmtString("Could not truncate file %s", mailBox));
  }

  return True;
}

/* ARGSUSED */
void
IncorporateNewMailCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             action;

  PromptIffolderChanged(scn,action);

  if ((IncorporateNewMailProc(scn) >= 0) &&
      (OpenFolder(scn, FileInMailDir(INFOLDER_NAME)) >= 0))
	SimpleMessage(scn, 
      FmtString("New mail incorporated to folder %s, now the current folder", 
				 scn->folder.name));
}

/*---------------------------------------------------------------------------+
| Open folder routines.
+---------------------------------------------------------------------------*/

void
OpenFolderProc2(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{
  if (OpenFolder(scn, folderName) >= 0)
	SimpleMessage(scn, FmtString("Folder %s loaded, has %d letters", 
			  scn->folder.name, scn->folder.numLetters));
}

void
OpenFolderProc(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{
  int             action;

  PromptIffolderChanged(scn,action);
  OpenFolderProc2(scn, folderName);
}

/* ARGSUSED */
void 
OpenFolderCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          fileName;
  int             action;

  PromptIffolderChanged(scn,action);
  if ((fileName = SelectFile(scn)) == NULL) return;
  OpenFolderProc2(scn, fileName);
}

/*---------------------------------------------------------------------------+
| Re-open folder routine.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
void 
ReOpenFolderCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  OpenFolderProc(scn, FolderFullName(scn));
}

/*---------------------------------------------------------------------------+
| Open folder in new screen routines.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
void 
OpenFolderInNextScreenCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData, *nextScn;
  String          fileName;

  if ((fileName = SelectFile(scn)) == NULL) return;
  if ((nextScn = NextScreen(scn)) == NULL)
	if (!FileReadable(fileName)) {
	  SimpleMessage(scn, "Unable to read folder");
	  return;
	}
	else nextScn = NewWindowProc(scn, fileName);
  else OpenFolderProc(nextScn, fileName);
}

#if 0
void
UnlinkAndOpenFolderCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  _clientDataRec *clientDataRec = (_clientDataRec*)clientData;
  SCREEN *scn = (SCREEN*)clientDataRec->field[0];

  XtFree(scn->folder.name);
  scn->folder.name = XtNewString((String)clientDataRec->field[1]);

  if (unlink((String)clientDataRec->field[1]) < 0)
	Message(scn, 
	 FmtString("Error in opening folder %s, folder may not have been opened", 
			   scn->folder.name, "", ""), MSG_CLEAR_DEFAULT);
  else
	Message(scn, FmtString("Folder %s loaded", scn->folder.name, "", ""), 
			MSG_CLEAR_DEFAULT);
}

/* ARGSUSED */
void
DoNewFolderCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  static _clientDataRec clientDataRec;

  clientDataRec.field[0] = (XtPointer)scn;
  clientDataRec.field[1] = callData;

  if (access((String)callData, F_OK) < 0)
	{ExecOpenFolderCallback(widget, (XtPointer)&clientDataRec, callData);
	 return;}

  Message(scn, FmtString("Folder %s already exists. Overwrite it?", 
						 (String)callData, "", ""), MSG_CLEAR_DEFAULT);
  BooleanInputAndDispatch(scn, ExecNewFolderCallback, 
						  (XtPointer)&clientDataRec);
}
#endif

/* ARGSUSED */
void 
NewFolderCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
/*  SCREEN *scn = (SCREEN*)clientData;
  return;
  Message(scn, "Enter new folder name above", MSG_CLEAR_DEFAULT);
  DialogInputAndDispatch(scn, DoNewFolderCallback, (XtPointer)scn);*/
}

#define ERR_BACKUP       -1
#define ERR_SAVE_FOLDER  -2

int
SaveFolder(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{

  static String           fullName;
  String                  name, path;
  int                     ret;

  /* This is here so that is the file chooser is not used, the folder
	 base name indicates it's in the mail directory */
  ParseFolderName(folderName, &name, &path);

  /* We want to make sure the name is still valid after the heavy use
	 of FmtString in WritefolderToDisk() */
  if (fullName) XtFree(fullName);
  fullName = XtNewString(FileFullName(name, path));
  
  ret = BackupFile(fullName);

  if (WritefolderToDisk(scn, fullName) < 0) return ERR_SAVE_FOLDER;
  SetFolderName(scn, fullName);

  return ret < 0 ? ERR_BACKUP : 0;
}


/* ARGSUSED */
void 
SaveFolderCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  int             ret;
  
  ret = SaveFolder(scn, FolderFullName(scn));

  if (ret == ERR_SAVE_FOLDER) {
	SimpleMessage(scn, "Error in saving folder, folder not saved");
	return;
  }

  SimpleMessage(scn, FmtString("Folder saved%s", ret == ERR_BACKUP ? 
								"" : ", old copy backed up"));
}

void
SaveFolderAs(scn, folderName)
	 SCREEN          *scn;
	 String          folderName;
{
  String          msg;
  int             ret;

  ret = SaveFolder(scn, folderName);

  if (ret == ERR_SAVE_FOLDER) {
	SimpleMessage(scn, "Error in saving folder, folder not saved");
	return;
  }

  msg = FmtString("Folder saved as %s, now the current folder", 
				   scn->folder.name);
  strcat(msg,  ret == ERR_BACKUP ? "" : ", old copy backed up");
  SimpleMessage(scn, msg); 
}


/* ARGSUSED */
void 
SaveFolderAsCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          fileName;

  if ((fileName = SelectFile(scn)) == NULL) return;
  SaveFolderAs(scn, fileName);
}

/* ARGSUSED */
void
SaveFolderAsCompressedCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          newName = FmtString("%s", FolderFullName(scn));

  if (FileIsPacked(newName)) PureFromPackedName(newName);
  SaveFolderAs(scn, FmtString("%s.Z", newName));
}

/* ARGSUSED */
void
SaveFolderAsGZippedCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          newName = FmtString("%s", FolderFullName(scn));

  if (FileIsPacked(newName)) PureFromPackedName(newName);
  SaveFolderAs(scn, FmtString("%s.gz", newName));
}

/* ARGSUSED */
void
SaveFolderAsUnpackedCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          newName = FmtString("%s", FolderFullName(scn));

  if (FileIsPacked(newName))
	*(strend(newName) - 2) = CNULL;

  SaveFolderAs(scn, newName);
}

/* ARGSUSED */
void 
EditFolderCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;

  ErrorIfEditOrDialogMode(scn,);
  
  if (FileIsPacked(scn->folder.name)) {
	Message(scn, "Cannot edit a compressed folder", MSG_CLEAR_DEFAULT);
	return;
  }

  EditFileInBodyBox(scn, FolderFullName(scn));
  /* SUPPRESS 622 */
  EditMode(scn, True);

  Message(scn, "For experts only, use caution", MSG_CLEAR_DEFAULT);
}

/* ARGSUSED */
void 
DeleteFolderCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  int    retStatus;

  SimpleMessage(scn, "Delete current folder? Are you really sure?");
  if (BooleanPrompt(scn) == BP_NO) return;

  retStatus = BackupFile(FolderFullName(scn));
  if (unlink(FolderFullName(scn)) < 0)
	MessagePError(scn, "Error in deleting folder, folder not deleted");
  else if (retStatus < 0)
	SimpleMessage(scn, "Folder deleted (but backup error)");
  else 
	SimpleMessage(scn, FmtString("Folder deleted, backup saved as %s~", 
								  scn->folder.name));
}

int
CommitChanges(scn)
	 SCREEN *scn;
{
  int ret;

  /* We don't want to do anything if the folder doesn't have any letters
	 to begin with */
  if (scn->folder.numLetters == 0) return -1;

  CompactFolder(scn);
  if (res.sortWhen & SORT_ON_COMMIT) SortFolderByDefaultKeys(scn);
  ret = SaveFolder(scn, FolderFullName(scn));
  ReMakeToc(scn);
  return 0;
}

/* ARGSUSED */
void 
CommitChangesCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  if (CommitChanges(scn) < 0)
	Message(scn, "No letters in folder, changes not commited", 
			MSG_CLEAR_DEFAULT);
  else Message(scn, "Changes to folder commited", MSG_CLEAR_DEFAULT);
}

/*---------------------------------------------------------------------------+
| Sort folder routine.
+---------------------------------------------------------------------------*/

int
CompareLettersByDateProc(letter1, letter2)
	 Letter          **letter1,
	                 **letter2;
{
  if ((*letter1)->date.timeU < (*letter2)->date.timeU) 
	return (res.sortDescending ? 1 : -1);
  else if ((*letter1)->date.timeU > (*letter2)->date.timeU) 
	return (res.sortDescending ? -1 : 1);
  else if (res.minorSortProc != CompareLettersByDateProc)
	return (*res.minorSortProc)(letter1, letter2);
  else return 0;
}

int
CompareLettersBySubjectProc(letter1, letter2)
	 Letter          **letter1,
	                 **letter2;
{
  String          subject1, subject2;
  int             cmpRes;
  
  subject1 = (*letter1)->subject;
  if (CaseNStrSame(subject1, "Re:", 3)) subject1 = StripStringB(subject1 += 3);
  subject2 = (*letter2)->subject;
  if (CaseNStrSame(subject2, "Re:", 3)) subject2 = StripStringB(subject2 += 3);

  cmpRes = strcasecmp(subject1, subject2);
  
  if (cmpRes == 0 && res.minorSortProc != CompareLettersBySubjectProc)
	return (*res.minorSortProc)(letter1, letter2);
  else return (res.sortDescending ? -cmpRes : cmpRes);
}

int
CompareLettersByNameProc(letter1, letter2)
	 Letter          **letter1,
	                 **letter2;
{
  int          cmpRes = strcasecmp((*letter1)->from, (*letter2)->from);

  if (cmpRes == 0 && res.minorSortProc != CompareLettersByNameProc)
	return (*res.minorSortProc)(letter1, letter2);
  else return (res.sortDescending ? -cmpRes : cmpRes);
}

void
SortFolderByDefaultKeys(scn)
	 SCREEN          *scn;
{
  Letter          **letter = scn->letterList;

  SimpleMessage(scn, "Sorting folder...");
  qsort(letter, scn->folder.numLetters, sizeof(Letter*), res.majorSortProc);
}

/* ARGSUSED */
void 
SortFolderCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
/*  Letter          **letter = scn->letterList,
                  *tmpLetter = NULL;
  int             i, j;*/

  SortFolderByDefaultKeys(scn);

/*  for (i = 0; i < scn->folder.numLetters; i++)
	for (j = i+1; j < scn->folder.numLetters; j++)
	  if (letter[i]->date.timeU > letter[j]->date.timeU) {
		tmpLetter = letter[i];
		letter[i] = letter[j];
		letter[j] = tmpLetter;
	  }

  qsort(letter, scn->folder.numLetters, sizeof(Letter*), res.majorSortProc);

  ReMakeToc(scn);
  if (tmpLetter) scn->folder.changed = True;*/
  ReMakeToc(scn);
  SimpleMessage(scn, "Folder sorted");
}

void
SetSortKey(widget, var, name, clientData)
	 Widget             widget;
	 SortProcT          *var;
	 String             name;
	 XtPointer          clientData;
{
  SCREEN                    *scn = (SCREEN*)clientData;
  static String             keyS[] = {"Date", "Subject", "Name", NULL};
  String                    cName;
  static SortProcT          proc[] = {CompareLettersByDateProc,
										 CompareLettersBySubjectProc,
										 CompareLettersByNameProc,
										 NULL};
  int                       keyN, i;

  if (scn) {
	keyN = Alert(0, scn->toc.tocW, FmtString("Select sort %s key", name), 
				 "Date | Subject | Name | Cancel");

	if (keyN > 3) return;
	*var = proc[keyN-1];
  }

  for (i = 0; proc[i] && proc[i] != *var; i++);
  if (proc[i] == NULL) return;

  cName = FmtString("%s", name);
  cName[0] = (char)toupper(cName[0]);

  XtVaSetValues(widget, XtNlabel, FmtString("Sort %s Key: %s", cName, 
											 keyS[i]), NULL);

  if (scn) {
	SortFolderByDefaultKeys(scn);
	ReMakeToc(scn);
	SimpleMessage(scn, FmtString("New sort %s key: %s", name, keyS[i]));
  }
}

/* ARGSUSED */
void
SetSortMajorKeyCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SetSortKey(widget, &res.majorSortProc, "major", clientData);
}

/* ARGSUSED */
void
SetSortMinorKeyCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SetSortKey(widget, &res.minorSortProc, "minor", clientData);
}

/* ARGSUSED */
void
ToggleSortDirectionCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn;
  String          directionS;

  if (clientData) res.sortDescending = !res.sortDescending;

  directionS = res.sortDescending ? "Descending" : "Ascending";
  XtVaSetValues(widget, XtNlabel, FmtString("Sort Direction: %s", 
											 directionS), NULL);

  if (clientData) {
	scn = (SCREEN*)clientData;
	SortFolderByDefaultKeys(scn);
	ReMakeToc(scn);
	SimpleMessage(scn, FmtString("New sort direction: %s", directionS));
  }
}

/*---------------------------------------------------------------------------+
| Search folder routine.
+---------------------------------------------------------------------------*/

int
FindStringInLetterHeaders(letter, searchKey)
	 Letter          *letter;
	 String          searchKey;
{
  String          letterBuffer, heasdersEnd;
  int             ret;

  letterBuffer = ConstructLetter(letter, LETTER_MAKE_WHOLE);
  if ((heasdersEnd = Strstr(letterBuffer, "\n\n"))) *heasdersEnd = CNULL;
  ret = (CaseStrstr(letterBuffer, searchKey) != NULL);

  XtFree(letterBuffer);
  return ret;
}

int
FindStringInWholeLetter(letter, searchKey)
	 Letter          *letter;
	 String          searchKey;
{
  String          letterBuffer;
  int             ret;

  letterBuffer = ConstructLetter(letter, LETTER_MAKE_WHOLE);
  ret = (CaseStrstr(letterBuffer, searchKey) != NULL);

  XtFree(letterBuffer);
  return ret;
}

int
SearchFolderProc(scn, searchProc, searchKey)
	 SCREEN               *scn;
	 SearchProcT          searchProc;
	 String               searchKey;
{
  Letter          *letter;
  Widget          searchNextW;
  Boolean         found;
  int             i;

  scn->folder.searchProc = searchProc;
  CloneString(&scn->folder.searchKey, searchKey);
  if ((searchNextW = XtNameToWidget(scn->panedW, "*searchNext")))
	XtSetSensitive(searchNextW, True);

  SimpleMessage(scn, "Searching folder...");

  AnimStart(scn);
  for (i = scn->folder.curLetN, found = False;
	   (letter = scn->letterList[i]) && !found; i++) {

	Anim(scn);
	if ((*searchProc)(letter, scn->folder.searchKey)) found = True;
  }

  AnimStop(scn);

  if (!found) {
	SimpleMessage(scn, "Search string not found");
	return -1;
  }

  scn->folder.curLetN = --i;
  RedisplayToc(scn);
  DisplayCurLetterPartialCallback(scn->parentW, (XtPointer)scn, 
								  (XtPointer)NULL);
  SimpleMessage(scn, 
	    FmtString("Found search string in letter #%d, now the current letter",
				  scn->folder.curLetN+1));
  return 0;
}

void
SearchFolder(scn, searchProc)
	 SCREEN               *scn;
	 SearchProcT          searchProc;
{
  String          searchKey;

  SimpleMessage(scn, "Enter string to search letters for above");
  if ((searchKey = DialogPrompt(scn)) == NULL) return;
  SearchFolderProc(scn, searchProc, searchKey);
}

/* ARGSUSED */
void
SearchFolderByHeadersCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  SearchFolder(scn, FindStringInLetterHeaders);
}

/* ARGSUSED */
void
SearchFolderByWholeLetterCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  SearchFolder(scn, FindStringInWholeLetter);
}

/* ARGSUSED */
void
SearchFolderNextCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;

  if (scn->folder.searchKey == NULL) {
	SimpleMessage(scn, "No prior search");
	return;
  }

  if (scn->folder.curLetN + 1 >= scn->folder.numLetters) {
	SimpleMessage(scn, "Already on last letter");
	return;
  }

/*  MoveToNextLine(TOCW);
  HighlightCurrentLine(TOCW);
  SetCurLetterNumber(scn);*/

  scn->folder.curLetN++;
  if (SearchFolderProc(scn, scn->folder.searchProc, 
					   scn->folder.searchKey) < 0)
	scn->folder.curLetN--;
}

/*---------------------------------------------------------------------------+
| Folder info routine.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
void 
FolderInfoCallback(widget, clientData, callData)
	 Widget             widget;
	 XtPointer          clientData;
	 XtPointer          callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  String          curLetterMsg;
  char            message[4096];

  curLetterMsg = scn->folder.curLetterN < 0 ? "" :
	FmtString(" (current is #%d)", scn->folder.curLetterN + 1);

  sprintf(message, "Current folder is %s, has %d letters%s%s", 
		  scn->folder.name, scn->folder.numLetters,
		  curLetterMsg, 
		  scn->folder.changed ? ", not saved" : "");
  SimpleMessage(scn, message);

  sprintf(message, "\n\t%s\n\n\t%s\n\t%s\n\n\t%s\n\t%s\n\t%s\n\n\t%s\n",
		  "---------- Folder Information ----------",
		  FmtString("Base name:         %s", scn->folder.name),
		  FmtString("Full name:         %s", FolderFullName(scn)),
		  FmtString("# of letters:      %d", scn->folder.numLetters),
		  FmtString("# tagged:          %d", scn->folder.numTagged),
 		  FmtString("Current letter:    %s", 
					 scn->folder.curLetN < 0 ? "N/A" :
					 FmtString("%d", scn->folder.curLetN + 1)),
		  FmtString("Changed:           %s", scn->folder.changed ? 
					 "Yes" : "No"));
  DisplayBufferInBodyBox(scn, message);
}

/* ARGSUSED */
void 
RedisplayTocCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  ReMakeToc(scn);
  Message(scn, "Table of contents reconstructed", MSG_CLEAR_DEFAULT);
}

/*---------------------------------------------------------------------------+
| Misc. folder routines.
+---------------------------------------------------------------------------*/

String
SelectFile(scn)
	 SCREEN                  *scn;
{
#if USE_FILE_CHOOSER
  String                  FileChooser();
  String                  dir;
  static Boolean          firstTime = True;

  if (firstTime) {
	firstTime = False;
	dir = FileInMailDir("");
  }
  else dir = NULL;

  return FileChooser(scn->parentW, dir);

#else
  SimpleMessage(scn, "Enter name above (file chooser not compiled)");
  return DialogPrompt(scn);
#endif
}

String
SetupTempFolder(name)
	 String          name;
{
  String          userName, folder;
  char            letter[BUFPAGE];

  userName = UserName();
  folder = FmtString("/tmp/%s.%s", FileBaseName(name), userName);

  sprintf(letter, "\
From mailer-mumail %s\n\
From: Mumail (your best mailer yet)\n\
To: Careless S. User III\n\
Subject: Temporary folder\n\
Date: %s\n\n\
Hi there!\n\n\
Folder requested:  %s\n\
Temporary folder:  %s\n\n\
The above folder you requested could not be read. The most likely\n\
cause for this is that is does not exist. I have therefore created\n\
the above temporary folder for you.\n\n\
If the requested folder is the inbox folder (~/Mail/MUINBOX),\n\
please do not incorp[orate any new mail, as this can only be done\n\
with the real, not temporary, inbox folder. Instead, do the\n\
following:\n\n\
o Make sure the directory ~/Mail exists.\n\
o Make sure the inbox file ~/Mail/MUINBOX exists. If it doesn't, just\n\
  copy this temporary folder to be that file.\n\
o After doing that, open the inbox folder.\n\n\
That's it. Have a good day\n\n\
P.S. You can delete this temporary folder by clicking Folder*Delete.\n\n\
-- Mumail (your friendly neighborhood mailer)\n\n",
		  CurrentLocalTimeString(), CurrentArpaDate(), name, folder);

  AppendBufferToFile(folder, letter);
  return folder;
}

/* Put this here for lack of a better place */
String GetNewBuffer(scn,data)
SCREEN *scn;
String data;
   {
   /* See if a buffer pointer is available */
   if ((scn->folder.buffs_used % BUFFER_INC) == 0)
      {
      int i;

      /* Allocate more buffer pointers */
      String *old_buffs = scn->folder.buffers;
      scn->folder.buffers = 
           (String *)XtCalloc(scn->folder.buffs_used+BUFFER_INC,
                              sizeof(String));

      /* Copy the existing pointers */
      for (i=0; i<scn->folder.buffs_used; i++)
	  scn->folder.buffers[i] = old_buffs[i];

      for (i=scn->folder.buffs_used;i<scn->folder.buffs_used+BUFFER_INC;i++)
          scn->folder.buffers[i] = NULL;

      /* Free the old */
      if (old_buffs) XtFree((XtPointer)old_buffs);

      }
    
   /* Put the data in the buffer */ 
   scn->folder.buffers[scn->folder.buffs_used] = data;      
   scn->folder.buffs_used++;


   return(scn->folder.buffers[scn->folder.buffs_used-1]);
  } 

void FreeBuffers(scn)
  SCREEN *scn;

  {

  if (scn->folder.buffers)
     {
     FreeList((void **)scn->folder.buffers);
     XtFree((XtPointer)scn->folder.buffers);
     }
  scn->folder.buffs_used = 0;

  }

