#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmEdit.c,v 1.2 1994/03/31 17:57:11 dwb Exp $";
#endif


/*
 * $Log: MmEdit.c,v $
 * Revision 1.2  1994/03/31  17:57:11  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:50  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include "MmDecl.h"

/* ARGSUSED */
void
GotoEditCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  EditFileInBodyBox(scn, scn->edit.fileName);
  SimpleMessage(scn, "Back to file being edited (changes not saved are lost)");
}

/* ARGSUSED */
void
EditSaveCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  if (XawAsciiSaveAsFile(XawTextGetSource(scn->bodyW), scn->edit.fileName))
	SimpleMessage(scn, "File saved successfully");
  else
	SimpleMessage(scn, "Could not save file, file not saved");
}

/* ARGSUSED */
void
EditCancelCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;

  Message(scn, "Editing ended", MSG_CLEAR_DEFAULT);
  /* SUPPRESS 622 */
  EditMode(scn, False);
  DisplayLetterProc(scn, scn->folder.curDispLetN, LETTER_MAKE_PARTIAL);
}

/* ARGSUSED */
void
EditCutCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "kill-selection");
}

/* ARGSUSED */
void
EditCutEolCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "kill-to-end-of-line");
}

/* ARGSUSED */
void
EditPasteCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  static String   arg[] = {"CUT_BUFFER1"};
  CallAction(scn->bodyW, "insert-selection", arg, 1);
}

/* ARGSUSED */
void
EditSearchCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN          *scn = (SCREEN*)clientData;
  static String arg[] = {"forward"};
  CallAction(scn->bodyW, "search", arg, 1);
}

/* ARGSUSED */
void
EditInsertFileCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "insert-file");
}

/* ARGSUSED */
void
EditFormatCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "form-paragraph");
}

/* ARGSUSED */
void
EditRedrawCallback(widget, clientData, callData)
	 Widget    widget;
	 XtPointer clientData;
	 XtPointer callData;
{
  SCREEN *scn = (SCREEN*)clientData;
  CallSimpleAction(scn->bodyW, "redraw-display");
}

