#if !defined(lint) && !defined(CODECENTER)
static char *rcsid = "$Header: /vol/dwb/src/mumail-2.4b/RCS/MmActions.c,v 1.2 1994/03/31 17:56:49 dwb Exp $";
#endif


/*
 * $Log: MmActions.c,v $
 * Revision 1.2  1994/03/31  17:56:49  dwb
 *  MuMail 2.4 Beta
 *
 * Revision 1.1  1993/11/15  18:52:46  dwb
 * Initial revision
 *
 *
 */

/*---------------------------------------------------------------------------+
| This file is part of Mumail, 
| Copyright (c) 1992-1993 by Muhammad M. Saggaf.
| Copyright (c) 1994 by David W. Boyd. All rights reserved
|
| See the file COPYING (1-COPYING) or the manual page mumail(1)
| for a full statement of rights and permissions.
+---------------------------------------------------------------------------*/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/MenuButton.h>
#include <string.h>
#include "MuWin.h"
#include "MuGeneric.h"
#include "MmDecl.h"

#define TOCW_ACTION_NAME "toc"

void
                DisplayCurLetterPartialCallback(),
                DisplayCurLetterWholeCallback();

/* ARGSUSED */
void
ClearCutBufferAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  XStoreBytes(XtDisplay(widget), "", 1);
}

/* ARGSUSED */
void
CloseWindowAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  CloseWindowCallback(widget, (XtPointer)WidgetToScn(widget), 
					  (XtPointer)NULL);
}

/* ARGSUSED */
void
IconifyWindowAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  IconifyWindowCallback(widget, (XtPointer)WidgetToScn(widget), 
						(XtPointer)NULL);
}

/* ARGSUSED */
void
ExitAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  ExitCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

/* ARGSUSED */
void
QuickExitAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  QuickExit(WidgetToScn(widget));
}

/* ARGSUSED */
void
HighlightCurrentLineAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  Widget          paramW;

  if (*numParam == 0) HighlightCurrentLine(widget);
  else if ((paramW = XtNameToWidget(scn->parentW, FmtString("*%s", *param))))
	HighlightCurrentLine(paramW);
  else MuError(FmtString("Unrecognized widget name: %s", *param));
}

/* ARGSUSED */
void
SetCurLetterNumberAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SetCurLetterNumber(WidgetToScn(widget));
}

/* ARGSUSED */
void
HighlightToEndOFLineAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  HighlightToEndOFLine(scn->toc.tocW);
}

/* ARGSUSED */
void
PrevLineAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);
  Widget          paramW;

  if (*numParam == 0) MoveToPrevLine(widget);
  else if ((paramW = XtNameToWidget(scn->parentW, FmtString("*%s", *param))))
	MoveToPrevLine(paramW);
  else MuError(FmtString("Unrecognized widget name: %s", *param));
}

/* ARGSUSED */
void
NextLineAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);
  Widget          paramW;

  if (*numParam == 0) MoveToNextLine(widget);
  else if ((paramW = XtNameToWidget(scn->parentW, FmtString("*%s", *param))))
	MoveToNextLine(paramW);
  else MuError(FmtString("Unrecognized widget name: %s", *param));
}

/* ARGSUSED */
void
BeginningOfBufferAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);
  Widget          paramW;

  if (*numParam == 0) MoveToStartOfBuffer(widget);
  else if ((paramW = XtNameToWidget(scn->parentW, FmtString("*%s", *param))))
	MoveToStartOfBuffer(paramW);
  else MuError(FmtString("Unrecognized widget name: %s", *param));
}

/* ARGSUSED */
void
EndOfBufferAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);
  Widget          paramW;

  if (*numParam == 0) MoveToEndOfBuffer(widget);
  else if ((paramW = XtNameToWidget(scn->parentW, FmtString("*%s", *param))))
	MoveToEndOfBuffer(paramW);
  else MuError(FmtString("Unrecognized widget name: %s", *param));
}

/* ARGSUSED */
void
IncCurLetterNumberAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  
  if (scn->folder.curLetterN + 1 > scn->folder.numLetters - 1) return;
  ++(scn->folder.curLetterN);
}

/* ARGSUSED */
void
DecrCurLetterNumberAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SCREEN *scn = WidgetToScn(widget);
  
  if (scn->folder.curLetterN - 1 < 0) return;
  --(scn->folder.curLetterN);
}

/*---------------------------------------------------------------------------+
| Body box actions.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
void
BodyBoxNextPageAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CallSimpleAction(WidgetToScn(widget)->bodyW, "next-page");
}

/* ARGSUSED */
void
BodyBoxPrevPageAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CallSimpleAction(WidgetToScn(widget)->bodyW, "previous-page");
}

/* ARGSUSED */
void
BodyBoxNextLineAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CallSimpleAction(WidgetToScn(widget)->bodyW, "next-line");
}

/* ARGSUSED */
void
BodyBoxEndOfPageAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  MoveToEndOfPage(WidgetToScn(widget)->bodyW);
}

/*---------------------------------------------------------------------------+
| Letter actions.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
void
RedisplayCurLetterPartialAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  DisplayCurLetterPartialCallback(widget, WidgetToScn(widget), 
								  (XtPointer)NULL);
}

/* ARGSUSED */
void
DisplayLetterGeneralAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);

  BodyBoxEndOfPageAction(widget, event, param, numParam);

  if (scn->folder.curDispLetN != scn->folder.curLetN)
	RedisplayCurLetterPartialAction(widget, event, param, numParam);

  else if (FindEndOfCurrentLine(scn->bodyW) == FindEndOfBuffer(scn->bodyW)) {
	CallSimpleAction(scn->toc.tocW, "next-line");
	HighlightCurrentLine(scn->toc.tocW);
	SetCurLetterNumber(scn);
	RedisplayCurLetterPartialAction(widget, event, param, numParam);
  }
  
  else
	BodyBoxNextPageAction(widget, event, param, numParam);
}

/* ARGSUSED */
void
RedisplayCurLetterWholeAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  DisplayCurLetterWholeCallback(widget, WidgetToScn(widget), (XtPointer)NULL);
}

/* ARGSUSED */
void
DisplayInsertionPointPosAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  printf("pos = %d\n", 
		 XawTextGetInsertionPoint(WidgetToScn(widget)->toc.tocW));
}

/* ARGSUSED */
void
OpenFolderAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SCREEN          *scn = WidgetToScn(widget);

  if (*numParam == 0)
	OpenFolderCallback(widget, (XtPointer)scn, (XtPointer)NULL);
  else OpenFolderProc(scn, *param);
}

/* ARGSUSED */
void
SaveFolderAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  SaveFolderCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}


/* ARGSUSED */
void
CommitChangesAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CommitChangesCallback(widget, (XtPointer)WidgetToScn(widget), 
						(XtPointer)NULL);
}

/* ARGSUSED */
void
FolderInfoAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  FolderInfoCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

/* ARGSUSED */
void
TagUntagLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  TagUntagLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
						 (XtPointer)NULL);
}

/* ARGSUSED */
void
RetagLettersAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  RetagLettersCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

/* ARGSUSED */
void
DeleteLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  DeleteLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

/* ARGSUSED */
void
UndeleteLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  UndeleteLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
						 (XtPointer)NULL);
}

/* ARGSUSED */
void
ComposeLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ComposeLetter(WidgetToScn(widget));
}

/* ARGSUSED */
void
ReplyToLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ReplyToLetter(WidgetToScn(widget));
}

/* ARGSUSED */
void
ForwardLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ForwardLetter(WidgetToScn(widget));
}

/* ARGSUSED */
void
ExternalComposeLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  ExternalComposeLetter(WidgetToScn(widget));
}

/* ARGSUSED */
void
CopyLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  CopyLetterCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

/* ARGSUSED */
void
RefileLetterAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  RefileLetterCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

/* ARGSUSED */
void
LetterInfoAction(widget, event, param, numParam)
	 Widget          widget;
	 XEvent*         event;
	 String*         param;
	 Cardinal*       numParam;
{
  LetterInfo(WidgetToScn(widget));
}

/* ARGSUSED */
void
SendDraftAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  SendDraftCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

/* ARGSUSED */
void
CancelDraftAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  CancelDraftCallback(widget, (XtPointer)WidgetToScn(widget), (XtPointer)NULL);
}

/* ARGSUSED */
void
QuoteRnStyleAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  QuoteRnStyleCallback(widget, (XtPointer)WidgetToScn(widget), 
					   (XtPointer)NULL);
}

/* ARGSUSED */
void
QuoteScStyleFmtAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  NonNestedCitation(WidgetToScn(widget), CITE_FMT);
}

/* ARGSUSED */
void
QuoteScStyleUnfmtAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  NonNestedCitation(WidgetToScn(widget), CITE_UNFMT);
}

/* ARGSUSED */
void
InsertSignatureAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  InsertSignatureCallback(widget, (XtPointer)WidgetToScn(widget), 
						  (XtPointer)NULL);
}

/*---------------------------------------------------------------------------+
| Menu actions.
+---------------------------------------------------------------------------*/

/* ARGSUSED */
void
MenuButtonPopdownMenuAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  String          menuName;
  Widget          menuW;

  XtVaGetValues(widget, XtNmenuName, &menuName, NULL);
  if ((menuW = XtNameToWidget(widget, menuName)))
	XtPopdown(menuW);
  else printf("null\n");
}

/* ARGSUSED */
void
PopupMenuIfMenuButtonAction(widget, event, param, numParam)
	 Widget            widget;
	 XEvent            *event;
	 String            *param;
	 Cardinal          *numParam;
{
  Widget          entry = XawSimpleMenuGetActiveEntry(widget);

  if (entry == NULL) return;

  if (XtClass(entry) == menuButtonWidgetClass)
	XtCallActionProc(entry, "PopupMenu", event, param, *numParam);
}
