/*
 * Copyright (c) 1985, 1989 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char sccsid[] = "@(#)cmdtab.c	5.9 (Berkeley) 3/21/89";
#endif /* not lint */

#include "ftp_var.h"

/*
 * User FTP -- Command Tables.
 */
int	setascii(), setbell(), setbinary(), setdebug(), setform();
int	setglob(), sethash(), setmode(), setpeer(), setport();
int	setprompt(), setstruct();
int	settenex(), settrace(), settype(), setverbose();
int	disconnect(), restart(), reget(), syst();
int	cd(), lcd(), delete(), mdelete(), user();
int	ls(), mls(), get(), mget(), help(), append(), put(), mput();
int	quit(), renamefile(), status();
int	quote(), rmthelp(), shell(), site();
int	pwd(), makedir(), removedir(), setcr();
int	account(), doproxy(), reset(), setcase(), setntrans(), setnmap();
int	setsunique(), setrunique(), cdup(), macdef(), domacro();
int	sizecmd(), modtime(), newer(), rmtstatus();
int	do_chmod(), do_umask(), idle();
#ifdef REMOTE_TERMINAL
int     upload(), download(), list(), morehelp();
#endif /* REMOTE_TERMINAL */

char	accounthelp[] =	"send account command to remote server";
char	appendhelp[] =	"append to a file";
char	asciihelp[] =	"set ascii transfer type";
char	beephelp[] =	"beep when command completed";
char	binaryhelp[] =	"set binary transfer type";
char	casehelp[] =	"toggle mget upper/lower case id mapping";
char	cdhelp[] =	"change remote working directory";
char	cduphelp[] = 	"change remote working directory to parent directory";
char	chmodhelp[] =	"change file permissions of remote file";
char	connecthelp[] =	"connect to remote tftp";
char	crhelp[] =	"toggle carriage return stripping on ascii gets";
char	deletehelp[] =	"delete remote file";
char	debughelp[] =	"toggle/set debugging mode";
char	dirhelp[] =	"list contents of remote directory";
char	disconhelp[] =	"terminate ftp session";
char	domachelp[] = 	"execute macro";
#ifdef REMOTE_TERMINAL
char    downloadhelp[] = "download file to your local terminal";
#endif /* REMOTE_TERMINAL */
char	formhelp[] =	"set file transfer format";
char	globhelp[] =	"toggle metacharacter expansion of local file names";
char	hashhelp[] =	"toggle printing `#' for each buffer transferred";
#ifdef REMOTE_TERMINAL
char    helphelp[] =    "print essential local help information";
#else
char    helphelp[] =    "print local help information";
#endif /* REMOTE_TERMINAL */
char	idlehelp[] =	"get (set) idle timer on remote side";
char	lcdhelp[] =	"change local working directory";
#ifdef REMOTE_TERMINAL
char    listhelp[] =   "list contents of PWD, uses for keep files for/from FTP";
#endif /* REMOTE_TERMINAL */
char	lshelp[] =	"list contents of remote directory";
char	macdefhelp[] =  "define a macro";
char	mdeletehelp[] =	"delete multiple files";
char	mdirhelp[] =	"list contents of multiple remote directories";
char	mgethelp[] =	"get multiple files";
char	mkdirhelp[] =	"make directory on the remote machine";
char	mlshelp[] =	"list contents of multiple remote directories";
char	modtimehelp[] = "show last modification time of remote file";
char	modehelp[] =	"set file transfer mode";
#ifdef REMOTE_TERMINAL
char    morehelphelp[] ="print all available local help information";
#endif /* REMOTE_TERMINAL */
char	mputhelp[] =	"send multiple files";
char	newerhelp[] =	"get file if remote file is newer than local file ";
char	nlisthelp[] =	"nlist contents of remote directory";
char	nmaphelp[] =	"set templates for default file name mapping";
char	ntranshelp[] =	"set translation table for default file name mapping";
char	porthelp[] =	"toggle use of PORT cmd for each data connection";
char	prompthelp[] =	"force interactive prompting on multiple commands";
char	proxyhelp[] =	"issue command on alternate connection";
char	pwdhelp[] =	"print working directory on remote machine";
char	quithelp[] =	"terminate ftp session and exit";
char	quotehelp[] =	"send arbitrary ftp command";
char	receivehelp[] =	"receive file";
char	regethelp[] =	"get file restarting at end of local file";
char	remotehelp[] =	"get help from remote server";
char	renamehelp[] =	"rename file";
char	restarthelp[]=	"restart file transfer at bytecount";
char	rmdirhelp[] =	"remove directory on the remote machine";
char	rmtstatushelp[]="show status of remote machine";
char	runiquehelp[] = "toggle store unique for local files";
char	resethelp[] =	"clear queued command replies";
char	sendhelp[] =	"send one file";
char	sitehelp[] =	"send site specific command to remote server\n\t\tTry \"rhelp site\" or \"site help\" for more information";
char	shellhelp[] =	"escape to the shell";
char	sizecmdhelp[] = "show size of remote file";
char	statushelp[] =	"show current status";
char	structhelp[] =	"set file transfer structure";
char	suniquehelp[] = "toggle store unique on remote machine";
char	systemhelp[] =  "show remote system type";
char	tenexhelp[] =	"set tenex file transfer type";
char	tracehelp[] =	"toggle packet tracing";
char	typehelp[] =	"set file transfer type";
char	umaskhelp[] =	"get (set) umask on remote side";
#ifdef REMOTE_TERMINAL
char    uploadhelp[] =  "upload file from your local terminal";
#endif /* REMOTE_TERMINAL */
char	userhelp[] =	"send new user information";
char	verbosehelp[] =	"toggle verbose mode";

#ifdef REMOTE_TERMINAL
struct cmd cmdtab[] = {
        { "!",          shellhelp,      0,      0,      0,      3, shell },
        { "$",          domachelp,      1,      0,      0,      3, domacro },
        { "account",    accounthelp,    0,      1,      1,      2, account},
        { "append",     appendhelp,     1,      1,      1,      2, put },
        { "ascii",      asciihelp,      0,      1,      1,      0, setascii },
        { "bell",       beephelp,       0,      0,      0,      2, setbell },
        { "binary",     binaryhelp,     0,      1,      1,      0, setbinary },
        { "bye",        quithelp,       0,      0,      0,      1, quit },
        { "case",       casehelp,       0,      0,      1,      3, setcase },
        { "cd",         cdhelp,         0,      1,      1,      0, cd },
        { "cdup",       cduphelp,       0,      1,      1,      1, cdup },
        { "chmod",      chmodhelp,      0,      1,      1,      3, do_chmod },
        { "close",      disconhelp,     0,      1,      1,      0, disconnect },
        { "cr",         crhelp,         0,      0,      0,      3, setcr },
        { "delete",     deletehelp,     0,      1,      1,      1, delete },
        { "debug",      debughelp,      0,      0,      0,      3, setdebug },
        { "dir",        dirhelp,        1,      1,      1,      0, ls },
        { "disconnect", disconhelp,     0,      1,      1,      3, disconnect },
        { "download",   downloadhelp,   1,      0,      1,      0, download },
        { "form",       formhelp,       0,      1,      1,      3, setform },
        { "get",        receivehelp,    1,      1,      1,      0, get },
        { "glob",       globhelp,       0,      0,      0,      3, setglob },
        { "hash",       hashhelp,       0,      0,      0,      1, sethash },
        { "help",       helphelp,       0,      0,      1,      0, help },
        { "idle",       idlehelp,       0,      1,      1,      3, idle },
        { "image",      binaryhelp,     0,      1,      1,      3, setbinary },
        { "lcd",        lcdhelp,        0,      0,      0,      3, lcd },
        { "list",       listhelp,       0,      0,      1,      0, list },
        { "ls",         lshelp,         1,      1,      1,      1, ls },
        { "macdef",     macdefhelp,     0,      0,      0,      3, macdef },
        { "mdelete",    mdeletehelp,    1,      1,      1,      2, mdelete },
        { "mdir",       mdirhelp,       1,      1,      1,      2, mls },
        { "mget",       mgethelp,       1,      1,      1,      2, mget },
        { "mkdir",      mkdirhelp,      0,      1,      1,      1, makedir },
        { "mls",        mlshelp,        1,      1,      1,      2, mls },
        { "mode",       modehelp,       0,      1,      1,      3, setmode },
        { "modtime",    modtimehelp,    0,      1,      1,      3, modtime },
        { "morehelp",   morehelphelp,   0,      0,      1,      0, morehelp },
        { "mput",       mputhelp,       1,      1,      1,      2, mput },
        { "newer",      newerhelp,      1,      1,      1,      3, newer },
        { "nmap",       nmaphelp,       0,      0,      1,      3, setnmap },
        { "nlist",      nlisthelp,      1,      1,      1,      3, ls },
        { "ntrans",     ntranshelp,     0,      0,      1,      3, setntrans },
        { "open",       connecthelp,    0,      0,      1,      0, setpeer },
        { "prompt",     prompthelp,     0,      0,      0,      3, setprompt },
        { "proxy",      proxyhelp,      0,      0,      1,      3, doproxy },
        { "sendport",   porthelp,       0,      0,      0,      3, setport },
        { "put",        sendhelp,       1,      1,      1,      0, put },
        { "pwd",        pwdhelp,        0,      1,      1,      1, pwd },
        { "quit",       quithelp,       0,      0,      0,      0, quit },
        { "quote",      quotehelp,      1,      1,      1,      3, quote },
        { "recv",       receivehelp,    1,      1,      1,      3, get },
        { "reget",      regethelp,      1,      1,      1,      3, reget },
        { "rstatus",    rmtstatushelp,  0,      1,      1,      3, rmtstatus },
        { "rhelp",      remotehelp,     0,      1,      1,      3, rmthelp },
        { "rename",     renamehelp,     0,      1,      1,      1, renamefile },
        { "reset",      resethelp,      0,      1,      1,      3, reset },
        { "restart",    restarthelp,    1,      1,      1,      3, restart },
        { "rmdir",      rmdirhelp,      0,      1,      1,      2, removedir },
        { "runique",    runiquehelp,    0,      0,      1,      3, setrunique },
        { "send",       sendhelp,       1,      1,      1,      3, put },
        { "site",       sitehelp,       0,      1,      1,      3, site },
        { "size",       sizecmdhelp,    1,      1,      1,      1, sizecmd },
        { "status",     statushelp,     0,      0,      1,      1, status },
        { "struct",     structhelp,     0,      1,      1,      3, setstruct },
        { "system",     systemhelp,     0,      1,      1,      3, syst },
        { "sunique",    suniquehelp,    0,      0,      1,      3, setsunique },
        { "tenex",      tenexhelp,      0,      1,      1,      3, settenex },
        { "trace",      tracehelp,      0,      0,      0,      3, settrace },
        { "type",       typehelp,       0,      1,      1,      2, settype },
        { "upload",     uploadhelp,     1,      0,      1,      0, upload },
        { "user",       userhelp,       0,      1,      1,      1, user },
        { "umask",      umaskhelp,      0,      1,      1,      3, do_umask },
        { "verbose",    verbosehelp,    0,      0,      0,      2, setverbose },
        { "?",          helphelp,       0,      0,      1,      3, help },
        { 0 },
};

#else /* not REMOTE_TERMINAL */

struct cmd cmdtab[] = {
	{ "!",		shellhelp,	0,	0,	0,	shell },
	{ "$",		domachelp,	1,	0,	0,	domacro },
	{ "account",	accounthelp,	0,	1,	1,	account},
	{ "append",	appendhelp,	1,	1,	1,	put },
	{ "ascii",	asciihelp,	0,	1,	1,	setascii },
	{ "bell",	beephelp,	0,	0,	0,	setbell },
	{ "binary",	binaryhelp,	0,	1,	1,	setbinary },
	{ "bye",	quithelp,	0,	0,	0,	quit },
	{ "case",	casehelp,	0,	0,	1,	setcase },
	{ "cd",		cdhelp,		0,	1,	1,	cd },
	{ "cdup",	cduphelp,	0,	1,	1,	cdup },
	{ "chmod",	chmodhelp,	0,	1,	1,	do_chmod },
	{ "close",	disconhelp,	0,	1,	1,	disconnect },
	{ "cr",		crhelp,		0,	0,	0,	setcr },
	{ "delete",	deletehelp,	0,	1,	1,	delete },
	{ "debug",	debughelp,	0,	0,	0,	setdebug },
	{ "dir",	dirhelp,	1,	1,	1,	ls },
	{ "disconnect",	disconhelp,	0,	1,	1,	disconnect },
	{ "form",	formhelp,	0,	1,	1,	setform },
	{ "get",	receivehelp,	1,	1,	1,	get },
	{ "glob",	globhelp,	0,	0,	0,	setglob },
	{ "hash",	hashhelp,	0,	0,	0,	sethash },
	{ "help",	helphelp,	0,	0,	1,	help },
	{ "idle",	idlehelp,	0,	1,	1,	idle },
	{ "image",	binaryhelp,	0,	1,	1,	setbinary },
	{ "lcd",	lcdhelp,	0,	0,	0,	lcd },
	{ "ls",		lshelp,		1,	1,	1,	ls },
	{ "macdef",	macdefhelp,	0,	0,	0,	macdef },
	{ "mdelete",	mdeletehelp,	1,	1,	1,	mdelete },
	{ "mdir",	mdirhelp,	1,	1,	1,	mls },
	{ "mget",	mgethelp,	1,	1,	1,	mget },
	{ "mkdir",	mkdirhelp,	0,	1,	1,	makedir },
	{ "mls",	mlshelp,	1,	1,	1,	mls },
	{ "mode",	modehelp,	0,	1,	1,	setmode },
	{ "modtime",	modtimehelp,	0,	1,	1,	modtime },
	{ "mput",	mputhelp,	1,	1,	1,	mput },
	{ "newer",	newerhelp,	1,	1,	1,	newer },
	{ "nmap",	nmaphelp,	0,	0,	1,	setnmap },
	{ "nlist",	nlisthelp,	1,	1,	1,	ls },
	{ "ntrans",	ntranshelp,	0,	0,	1,	setntrans },
	{ "open",	connecthelp,	0,	0,	1,	setpeer },
	{ "prompt",	prompthelp,	0,	0,	0,	setprompt },
	{ "proxy",	proxyhelp,	0,	0,	1,	doproxy },
	{ "sendport",	porthelp,	0,	0,	0,	setport },
	{ "put",	sendhelp,	1,	1,	1,	put },
	{ "pwd",	pwdhelp,	0,	1,	1,	pwd },
	{ "quit",	quithelp,	0,	0,	0,	quit },
	{ "quote",	quotehelp,	1,	1,	1,	quote },
	{ "recv",	receivehelp,	1,	1,	1,	get },
	{ "reget",	regethelp,	1,	1,	1,	reget },
	{ "rstatus",	rmtstatushelp,	0,	1,	1,	rmtstatus },
	{ "rhelp",	remotehelp,	0,	1,	1,	rmthelp },
	{ "rename",	renamehelp,	0,	1,	1,	renamefile },
	{ "reset",	resethelp,	0,	1,	1,	reset },
	{ "restart",	restarthelp,	1,	1,	1,	restart },
	{ "rmdir",	rmdirhelp,	0,	1,	1,	removedir },
	{ "runique",	runiquehelp,	0,	0,	1,	setrunique },
	{ "send",	sendhelp,	1,	1,	1,	put },
	{ "site",	sitehelp,	0,	1,	1,	site },
	{ "size",	sizecmdhelp,	1,	1,	1,	sizecmd },
	{ "status",	statushelp,	0,	0,	1,	status },
	{ "struct",	structhelp,	0,	1,	1,	setstruct },
	{ "system",	systemhelp,	0,	1,	1,	syst },
	{ "sunique",	suniquehelp,	0,	0,	1,	setsunique },
	{ "tenex",	tenexhelp,	0,	1,	1,	settenex },
	{ "trace",	tracehelp,	0,	0,	0,	settrace },
	{ "type",	typehelp,	0,	1,	1,	settype },
	{ "user",	userhelp,	0,	1,	1,	user },
	{ "umask",	umaskhelp,	0,	1,	1,	do_umask },
	{ "verbose",	verbosehelp,	0,	0,	0,	setverbose },
	{ "?",		helphelp,	0,	0,	1,	help },
	{ 0 },
};
#endif /* !REMOTE_TERMINAL */

int	NCMDS = (sizeof (cmdtab) / sizeof (cmdtab[0])) - 1;
