/*
main.c: Main file for selectnews.
        Provide easy interface for users to hone down their .newsrc file

Copyright (C) 1993 Eugene Eric Kim
All rights reserved.

LAST REVISION: September 4, 1993

SHORTCOMINGS:
-will only help edit what's in .newsrc; cannot
 find new newsgroups not in .newsrc
*/

#include <stdio.h>
#include "headers.h"

main()
{
  dllist sub;
  dllist usub;
  node* wsub;
  node* wusub;
  char* curschar = "->";
  int ch, last1, last2, c, utop, stop, ucpos, scpos;
  short QUIT = 0,LAST;

  /* initialize linked lists */
  list_create(&sub);
  list_create(&usub);

  /* sort contents of .newsrc */
  sortfile(GetFile(),&sub,&usub,&last1,&last2);
  wsub = list_start(sub);
  wusub = list_start(usub);

  initwin();
  scpos = ucpos = 0;
  utop = stop = 0;
  showbuffer(leftscr,usub,0);
  showbuffer(rightscr,sub,0);
  if (usub.head != 0) {
    c = 0;
    cursor(leftscr,ucpos,curschar);
  }
  else {
    c = 1;
    cursor(rightscr,scpos,curschar);
  }

  do {
    ch = getch();
    switch (ch) {
    case 'i': case 'I':
      Instructions();
      getch();
      clear();
      Topline();
      Credits();
      showbuffer(leftscr,usub,utop);
      showbuffer(rightscr,sub,stop);
      if (c) cursor(rightscr,scpos,curschar);
      else cursor(leftscr,ucpos,curschar);      
      break;
    case ' ': case 'h': case 'H': case 'l': case 'L':
#ifdef NCURSES
    case KEY_LEFT: case KEY_RIGHT:
#endif
      if (c && (usub.head != 0)) {
	delcursor(rightscr,scpos);
	cursor(leftscr,ucpos,curschar);
	c = 0;
	wusub = list_position(usub,utop+ucpos);
      }
      else if (!c && (sub.head != 0)) {
	delcursor(leftscr,ucpos);
	cursor(rightscr,scpos,curschar);
	c = 1;
	wsub = list_position(sub,stop+scpos);
      }
      break;
    case 'k': case 'K':
#ifdef NCURSES
    case KEY_UP:
#endif
      if (c)
	wsub = moveup(rightscr,&scpos,&stop,wsub,curschar);
      else
	wusub = moveup(leftscr,&ucpos,&utop,wusub,curschar);
      break;
    case 'j': case 'J':
#ifdef NCURSES
    case KEY_DOWN:
#endif
      if (c)
	wsub = movedown(rightscr,&scpos,&stop,sub,wsub,curschar);
      else
	wusub = movedown(leftscr,&ucpos,&utop,usub,wusub,curschar);
      break;
    case '>':
#ifdef NCURSES
    case KEY_NPAGE:
#endif
      if (c)
	wsub = scrolldown(rightscr,&scpos,&stop,sub,wsub,curschar);
      else
	wusub = scrolldown(leftscr,&ucpos,&utop,usub,wusub,curschar);
      break;
    case '<':
#ifdef NCURSES
    case KEY_PPAGE:
#endif
      if (c)
	wsub = scrollup(rightscr,&scpos,&stop,sub,wsub,curschar);
      else
	wusub = scrollup(leftscr,&ucpos,&utop,usub,wusub,curschar);
      break;
    case '0':
      if (c)
	wsub = homepage(rightscr,&scpos,&stop,sub,curschar);
      else
	wusub = homepage(leftscr,&ucpos,&utop,usub,curschar);
      break;
    case '$':
      if (c)
	wsub = endpage(rightscr,&scpos,&stop,sub,curschar);
      else
	wusub = endpage(leftscr,&ucpos,&utop,usub,curschar);
      break;
    case '\n':
      if (c) {
	LAST = list_last(wsub);
	wusub = list_insafter(&usub,list_end(usub),(*wsub).entry);
	wsub = list_del(&sub,wsub);
	if (list_empty(sub)) {
	  c = 0;
	  wusub = list_position(usub,utop+ucpos);
	}
	else if (LAST) {
	  if ( (stop != 0) && (scpos == 0) ) {
	    if (stop - LINES - 2 >= 0)
	      stop -= LINES - 2;
	    else
	      stop = 0;
	    scpos = LINES - 3;
	  }
	  else if (scpos>0)
	    scpos--;
	}
	showbuffer(leftscr,usub,utop);
	showbuffer(rightscr,sub,stop);
	if (c) cursor(rightscr,scpos,curschar);
	else cursor(leftscr,ucpos,curschar);
      }
      else {
	LAST = list_last(wusub);
	wsub = list_insafter(&sub,list_end(sub),(*wusub).entry);
	wusub = list_del(&usub,wusub);
	if (list_empty(usub)) {
	  c = 1;
	  wsub = list_position(sub,stop+scpos);
	}
	else if (LAST) {
	  if ( (utop != 0) && (ucpos == 0) ) {
	    if (utop - LINES - 2 >= 0)
	      utop -= LINES - 2;
	    else
	      utop = 0;
	    ucpos = LINES - 3;
	  }
	  else if (ucpos>0)
	    ucpos--;
	}
	showbuffer(leftscr,usub,utop);
	showbuffer(rightscr,sub,stop);
	if (c) cursor(rightscr,scpos,curschar);
	else cursor(leftscr,ucpos,curschar);
      }
      break;
    case 's': case 'S':
      if (c && Sure("Sort subscribed (y/n)? "))
	sort(rightscr,&sub,stop,scpos,curschar);
      else if (!c && Sure("Sort unsubscribed (y/n)? "))
	sort(leftscr,&usub,utop,ucpos,curschar);
      break;
    case 'g': case 'G':
      if (c) {
	if (Sure("Unsubscribe all (y/n)? ")) {
	  wsub = list_start(sub);
	  while (!list_empty(sub)) {
	    wusub = list_insafter(&usub,list_end(usub),(*wsub).entry);
	    wsub = list_del(&sub,wsub);
	  }
	  c = 0;
	  Credits();
	}
      }
      else {
	if (Sure("Subscribe all (y/n)? ")) {
	  wusub = list_start(usub);
	  while (!list_empty(usub)) {
	    wsub = list_insafter(&sub,list_end(sub),(*wusub).entry);
	    wusub = list_del(&usub,wusub);
	  }
	}
	c = 1;
	Credits();
      }
      showbuffer(leftscr,usub,utop);
      showbuffer(rightscr,sub,stop);
      if (c) cursor(rightscr,scpos,curschar);
      else cursor(leftscr,ucpos,curschar);
      break;
    case 'f': case 'F':
      if (c)
	wsub = find(rightscr,&scpos,&stop,sub,curschar);
      else
	wusub = find(leftscr,&ucpos,&utop,usub,curschar);
      break;
    case 'r': case 'R': case 12:
      wrefresh(curscr);
      break;
    case 'q': case 'Q':
      QUIT = Sure("Quit without saving (y/n)? ");
      break;
    case 'w': case 'W':
      if (Sure("Write .newsrc and quit (y/n)? "))
	QUIT = Write(sub,usub);
      break;
    default:
      break;
    }
  } while (!QUIT);

  list_clear(&sub);
  list_clear(&usub);

  standend();
  clear();
  mvaddstr(0,0,"selectnews");
  mvaddstr(1,0,VERSION);
  mvaddstr(2,0,"Copyright (C) 1993 Eugene Kim");
  mvaddstr(3,0,"All rights reserved.");
  mvaddstr(5,0,"Good-bye!\n");
  refresh();
  endwin();
}
