/*
 * NAME
 *   GetSubjectsOfNewArticlesInGroup.c
 * USAGE
 *   GetSubjectsOfNewArticlesInGroup GroupName FromArticleNumber
 * DESCRIPTION
 *   Retrieve the subject header line from the NNTP server for all articles 
 *   in group `GroupName' starting with article number `FromArticleNumber'.
 *   The lines are printed on standard ouput, with the following format:
 *
 *     <ArticleNumber> <Subject>
 *
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/GetSubjectsOfNewArticlesInGroup.c,v 1.13 1995/08/15 19:33:35 rpijlman Exp");

int main( int argc, char **argv )
{
    FILE * NewsServer;

    if ( argc != 3 )
    {
        fprintf( stderr, "%s\n",
	 "Usage: GetSubjectsOfNewArticlesInGroup GroupName FromArticleNumber" );
        exit( EXIT_FAILURE );
    }

    /* Open standard I/O stream to NNTP server. */
    NewsServer = NNTPStreamOpen();

    /* Make group current. */
    if ( fprintf( NewsServer, "group %s\r\n", argv[1] ) == EOF ||
         fflush( NewsServer ) == EOF )
    {
        fprintf( stderr, "Error writing to NewsServer.\n" );
        exit( EXIT_FAILURE );
    }

    CheckStatusResponse( NewsServer, argv[1], "2" );

    /*
     * Retrieve the subject lines.
     *
     * Note: the xhdr command is not part of the NNTP protocol in RFC-977. The
     * RFC does allow extensions, however, and I think many servers do support
     * the xhdr command. When in doubt, query your NNTP server:
     *
     *   telnet $NNTPSERVER 119
     *   help
     *       Additionally, the following extension(s) are supported:
     *       XHDR    Retrieve a single header line from a range of articles.
     *   xhdr
     *       501 USAGE: XHDR headerfield [artrange|<message-id>]
     *   quit
     */
    if ( fprintf( NewsServer, "xhdr subject %s-\r\n", argv[2] ) == EOF ||
         fflush( NewsServer ) == EOF )
    {
        fprintf( stderr, "Error writing to NewsServer.\n" );
        exit( EXIT_FAILURE );
    }
    CheckStatusResponse( NewsServer, argv[1], "2" );

    /* Write the subject lines to stdout. */
    TextResponseToFile( NewsServer, stdout );

    NNTPStreamClose( NewsServer );

    return EXIT_SUCCESS;
}
