/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB

#include "config.h"
#include "includes.h"
#include "prototypes.h"



int termforward(char *file,char *forward){
  FILE *fdin;
  int  i,pid,fdpipe[2];
  char command_option[LINESIZE], *path, *command;

  path=getenv("PATH");
  sprintf(file,"/tmp/%d",getpid());

/* Tupload is so slow, I copy input to a /tmp file...  Thus I must
 * keep checking if the a new mailbox has been created....
 */

/* Upload to the other machine */

  if((pid=fork())==-1){
    fprintf(fstdio[2],"%s\n","Fork failed");
    signal(SIGTERM,SIG_DFL);
    return -1;
  }else if(!pid) {
    signal(SIGTERM,SIG_IGN);
    command=hash(path,"tupload");
    close(1);
    dup2(2,1);
    execl(command,"tupload","-fuv",file,"/tmp",(char *) 0);
    exit(-1);
  };
  wait(&i);

/* If the file is still there, copy the mailbox back and abort */

  if((fdin=fopen(file,"r"))!=NULL){
    fprintf(fstdio[2],"%s\n","tupload failed");
    unlink(file);
    return -1;

/* Otherwise move the file into the other machine's mailbox. */

  }else{
    signal(SIGTERM,SIG_DFL);
    if((pid=fork())==-1){
      fprintf(fstdio[2],"%s\n","Fork failed");
      return -1;
    }else if(!pid) {
      command=hash(path,"trsh");
      if(command!=NULL){
        if(forward==NULL){
          sprintf(command_option,"getmail -qi %s ; rm -f %s",file,file);
        }else{
          sprintf(command_option,
            "(echo 'Subject: %s';echo '';cat %s)|" SENDMAIL " -i -em '%s'",
            C_FORWARD,file,forward);
        };
        execl(command,"trsh","-s",command_option,(char *) 0);
      };
      exit(-1);
    };
    wait(&i);
    if(i<0) exit(i);
  };
  return 0;
}
