/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_ERRNO
#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT

#include "config.h"
#include "includes.h"
#include "readline.h"

/* The idea of this routine is to have the equivalent of fgets, but
 * able to rewind...  Return values are:
 *    -1 == EOF or error (line is NULL)
 *     0 == OK (line read, all lines saved)
 *     # == first saved line + 1
 * I think, this routine is not 8 bit clean, in that '\0' gets silently
 * removed.  However, there should be no problems with ascii data of
 * unlimited line lengths...  See fgets(), for what is returned as a line.
 *
 * The functioning of this routine should be completely independant of
 * setbuf and setvbuf...  If the device is rewindable, this routine will
 * rewind when an unsaved line is requested, otherwise a NULL will
 * be returned.
 */ 

int readline(struct BFILE *input, int n){

#ifdef DEBUG
  fprintf(fstdio[1],"Entering readline\n");
  fflush(fstdio[1]);
#endif
  input->line=NULL;
  if(input->fd==NULL) return -1;

/* If you want to go back too far, I try to rewind... If this fails,
 * Then a NULL will be returned.  
 */
  if(input->NR==0){
    input->nlines=0;
    input->pbuffer=input->buffer;
    input->looped=0;
  };
 
  if(n+input->nlines<input->NR){
    if(!fseek(input->fd,0L,0))
      return 0;
    input->NR=0;
    input->nlines=0;
    input->pbuffer=input->buffer;
    input->looped=0;
  };

/* OK, now we are ready to either read in the new line, or
 * report the old one.
 */

  if(n<input->NR){
    if(n+input->nlines<input->NR) return 0;
    input->line=&input->lines[(n+1)%SAVEDLINES][0];
#ifdef DEBUG
    fprintf(fstdio[1],"Exiting 1 readline: %s\n",input->line);
    fflush(fstdio[1]);
#endif
    return 0;
  }else{
    while((!feof(input->fd))&&(n>=input->NR)){
      input->NR++;
      do{
        fgets(input->pbuffer,LINESIZE,input->fd);
      }while((*input->pbuffer==0)&&!feof(input->fd));

      input->lines[input->NR%SAVEDLINES]=input->pbuffer;
/*      c=index(input->lines[input->NR%SAVEDLINES],'\n'); */
/*      if(c!=NULL) c[0]='\0'; */

      input->nlines += (input->nlines<SAVEDLINES);
      if(input->looped)
        while(input->lines[(input->NR+1-input->nlines)]>=input->buffer &&
          input->lines[(input->NR+1-input->nlines)]<input->buffer+strlen(input->pbuffer)+1)
            input->nlines--;
      input->pbuffer[LINESIZE-1]='\0';
      input->pbuffer = index(input->pbuffer,'\0')+1;
      if(input->pbuffer>=&input->buffer[BUFFERSIZE-LINESIZE]){
        input->looped &= (input->buffer==input->pbuffer);
        input->pbuffer=input->buffer;
      };
    };
    if(feof(input->fd)) {
#ifdef DEBUG
      fprintf(fstdio[1],"Exiting EOF readline\n");
      fflush(fstdio[1]);
#endif
      return -1;
    };
    input->line=&input->lines[input->NR%SAVEDLINES][0];
  };
#ifdef DEBUG
  fprintf(fstdio[1],"Exiting 2 readline: %s \n",input->line);
  fflush(fstdio[1]);
#endif
  if(!feof(input->fd))
    if(input->NR >= SAVEDLINES)
      return 1 + input->NR - SAVEDLINES;
    else
      return input->looped;
  else
    return -1;
}

