/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_STRING

#include "config.h"
#include "includes.h"
#include "mailflags.h"
#include "prototypes.h"



long queuefiles(int nsubjects, char **subject, char *replyto,
    char *home, char *basepath, int max_size){
  FILE *fd;
  int i=0,n=0,unused=1,lpath, binary=0, compress=0, size=0;
  char path[LINESIZE], file[LINESIZE], form_letter[LINESIZE];

  {
    char *queue=form_letter;
    if(QUEUEDIR [0] == '~')
      sprintf(queue,"%s%s/%s",home,&QUEUEDIR[1],QUEUE);
    else
      strcpy(queue,QUEUEDIR "/" QUEUE);
    fd = fopen(queue,"a");
#ifdef DEBUG
    fprintf(fstdio[1],"queue %s\n",queue);
#endif
  };
  if(fd==NULL)return MF_PRIVATE|MF_RECEIVE;

#ifdef DEBUG
    fprintf(fstdio[1],"special %s\n","ok");
#endif
/* These are special commands */

  for(n=i=0;i<nsubjects;i++)
    if( !strcmp(subject[i],"binary")
        || !strcmp(subject[i],"encode") ){
      max_size = ( MINSIZE < max_size ) ? MINSIZE : max_size ;
      binary=1;
    }else if( !strcmp(subject[i],"ascii")
              || !strcmp(subject[i],"text") ){
      max_size = ( MAXSIZE > max_size ) ? MAXSIZE : max_size ;
      binary=0;
    }else subject[n++]=subject[i];
  nsubjects=n;

  if ( rindex(FORM_LETTER,'/') == NULL) 
    sprintf(form_letter,"%s/%s",home,FORM_LETTER);
  else if ( FORM_LETTER[0] == '~' )
    sprintf(form_letter,"%s%s",home,&FORM_LETTER [1]);
  else
    strcpy(form_letter,FORM_LETTER);
#ifdef DEBUG
  fprintf(fstdio[1],"form_letter %s\n",form_letter);
#endif

  if ( nsubjects < 1 ){
    queueletter(fd,0,0,replyto,form_letter,"none given",
      rindex(form_letter,'/')+1,LAST_OFS);
    fclose(fd);
    return MF_PRIVATE|MF_RECEIVE|MF_OUTGOING;
  };

/* Parse the subjects for filenames */

  if(max_size < 1024) max_size *= 1024;
  lpath=strlen(basepath)+1;

/* The outer loop is for different directory names, then inner is
 * for filenames...
 */

  for(i=0;i<nsubjects;){
    strcpy(path,basepath);
    path[lpath]='\0'; 
    unused=1; 
    for(;i<nsubjects;i++){
      int fs=-1;
#ifdef DEBUG
      fprintf(fstdio[1],"loop %d %s %s\n",i,path,subject[i]);
#endif
      if((fs=getfiletype(file,path,subject[i],&size,&compress))<0) break;
      if(!fs){
#ifdef DEBUG
        fprintf(fstdio[1],"found file ok %s\n",file);
#endif
        queueletter(fd, binary || (size > max_size), compress,
          replyto, file,&file[lpath],"file-transmition",LAST_OFS);
        unused=0;
      };
    };

/* Now if we haven't found any files within the loop, search for a default */
    if(unused && !!strcmp(path,basepath)){
      if(!getfiletype(file,path,DEFAULT,&size,&compress)){
#ifdef DEBUG
        fprintf(fstdio[1],"found file ok %s\n",file);
#endif
        queueletter(fd, binary || (size > max_size), compress,
          replyto, file,&file[lpath],"file-transmition",LAST_OFS);
        unused=0;
      };
    };
    if(unused) break;
  };
  if(unused){
    queueletter(fd,0,0,replyto,form_letter,
      subject[(i<nsubjects) ? i : nsubjects-1],
      rindex(form_letter,'/')+1, '\0');
    if(strlen(path)>lpath)
      fprintf(fd,"%s",&path[lpath]);
    for(;i<nsubjects;i++)fprintf(fd," %s",subject[i]);
    fprintf(fd,"%s","\n");
    fclose(fd);
    return MF_PRIVATE|MF_RECEIVE|MF_OUTGOING;
  }else
    fclose(fd);
  return MF_OUTGOING;
}
    
void queueletter(FILE *fd, int binary, int compress, char *replyto, char *file, 
        char *expression, char *subject, char last){
  char e[LINESIZE], *ptr_e;
#ifdef DEBUG
  fprintf(fstdio[1],"Entering queueletter\n");
  fprintf(fstdio[1],"queueletter %d %d %s %s %s %s %c\n",binary,compress,
    file,replyto,expression,subject,last);
#endif
  strcpy(e,expression);
  for(ptr_e=e;*ptr_e!='\0';ptr_e++)
    if(index(FS "/",*ptr_e)!=NULL) *ptr_e=OFS;
  
  if((ptr_e=rindex(e,'.'))!= NULL){
    if(!strcmp(ptr_e,".z"))
      *ptr_e='\0';
    else if(!strcmp(ptr_e,".gz"))
      *ptr_e='\0';
  };

  if(*replyto=='<'&&rindex(replyto,'>')!=NULL)
    fprintf(fd," %d %d %s %s %s Re: %s: ",binary,compress,
      replyto,file,e,subject);
  else
    fprintf(fd," %d %d <%s> %s %s Re: %s: ",binary,compress,
      replyto,file,e,subject);

  if(last != '\0'){
    if((ptr_e=rindex(e,OFS))!=NULL)
      *ptr_e=last;
    fprintf(fd,"%s\n",e);
  };
#ifdef DEBUG
  fprintf(fstdio[1],"%s\n","Leaving queueletter");
#endif
}

