/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_STDIO
#define IS_UNISTD
#define IS_STRING
#define IS_STAT

#include "config.h"
#include "includes.h"
#include "prototypes.h"

char *parseaddress(char *line,char **newline){
  int quote=0,superquote=0;
  char *s, *t;
  static char addr[LINESIZE];

  *newline=NULL;
  if(line==NULL) return NULL;

  for(s=line;(index(FS,*s)!=NULL&&*s!='\0');s++);
  if(s=='\0') return NULL;

  for(t=s;(*t!='\0'&&(index(FS,*t)==NULL||quote));t++){
    if(*t=='\\'){
      if(t++[1]=='\0') break;
    }else if(*t=='"'){
      quote=!quote;
    }else if(!quote){
      if(*t=='<'){
        s=t;
        superquote=1;
      }else if(*t=='>'){
        if(superquote){
          t++;
          superquote--;
        };
        break;
      };
    };
  };
  if(superquote&&*s!='\0') s++;
  if(t<=s) return NULL;

  strncpy(addr,s,t-s);
  addr[t-s]='\0';
  if(*t!='\0') *newline=t;

  return addr;
}
