/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_GETOPT
#define IS_ERRNO
#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB

#include "config.h"
#include "includes.h"
#include "prototypes.h"


void daemonloop(char option,char *daemon,char *queue,
  char *mailbox,char *command,char **arguments){

  int j,pid;
  char *daemon_name;

  daemon_name=arguments[0];
  do{
    if(!checkpid(daemon,&pid)) break;

    fprintf(fstdio[1],"Daemon looping\n");
    close(0);
    fstdioopen();
    
    if(!strcmp(daemon_name,RECEIVE)){
      if(freopen(mailbox,"r",fstdio[0])==NULL) continue;
      if(feof(fstdio[0])) continue;
    }else if(!strcmp(daemon_name,OUTGOING)){
      if(freopen(queue,"r",fstdio[0])==NULL) continue;
      if(feof(fstdio[0])) continue;
    }; 


    if(fileno(fstdio[0])!=0)
      dup2(fileno(fstdio[0]),0);

    fprintf(fstdio[1],"Standard input redirected\n");

    switch(option){
      case 't':		/* Term */
      case 'f':
        j=forward(option,mailbox,arguments[4],arguments[3],arguments[2]);
        fprintf(fstdio[1],"forward returned %d\n",j);
	break;
      case 'o':		/* Outgoing */
	j=outgoing(queue);
	break;
      default:		/* An external program */
        fprintf(fstdio[1],"Forking shell command\n",j);
	if(!(pid=fork())){
	  execv(command,arguments);
	  fprintf(fstdio[1],"Errno %d\n",errno);
	  exit(1);
	};
	if(pid != -1)
	  wait(&j);
	else 
	  j=pid;
	break;
    };
    close(0);

    if(j != 0) {
      fprintf(fstdio[2],"Return  status %d\n",j);
      if(j<0) break;
      continue;
    };

    fprintf(fstdio[1],"Removing files");
    if(!strcmp(daemon_name,RECEIVE))
      unlink(mailbox);
    else if(!strcmp(daemon_name,OUTGOING))
      unlink(queue);

  }while(!kill(getpid(),SIGSTOP));

  if(checkpid(daemon,&pid)) unlink(daemon);
  exit(1);
}

