/* proto.h
 * David Lutz
 * Jason Hunter
 *
 * This header file contains the function prototypes.
 */

/* readdisk.c */
void convert(unsigned long x, int *head, int *track, int *sector, int *offset);
void examine_drive(void);
int readdisk( char *buf, unsigned long loc, size_t size );

/* super.c */
int load_super( void );
void print_super( void );

/* group.c */
int load_groups( void );
void print_groups( void );

/* inode.c */
inode *load_inode( unsigned long inode_no );
void print_inode( inode *i );
unsigned long block_list( inode *i, int pflg );
int read_inode( inode *i, byte *buffer, size_t size );
void print_blocks( inode *i );

/* dir.c */
long eatpath( char *path );
void print_dir( struct dir *head );
void list_dir( inode *i );
struct dir *build_dir( byte *buf, size_t buf_size );
long search_dir( struct dir *head, char *str );
void kill_dir( struct dir *head );
char *build_mode( inode *i );
