/*
 *  linux/fs/msdos/lfn.h
 *
 *  Written in 1995 by Gilles Vollant (100144.2636@compuserve.com)
 *  Based on information on "Inside Windows 95" book from Adrian King
 *
 *
 */

#ifndef BYTE
typedef unsigned char   BYTE ;
typedef unsigned short  WORD ;
typedef unsigned long   DWORD ;
#endif

#ifndef BOOL
typedef int BOOL ;
#define FALSE 0
#define TRUE  1
#endif


#ifndef NULL
#ifdef __cplusplus
#define NULL    0
#else
#define NULL    ((void *)0)
#endif
#endif

typedef struct 
{
  char nom[8];
  char ext[3];
  BYTE bAttr;

  BYTE cMinMajinfo;
  BYTE dir_CreateMSec;
  WORD dir_CreateTime;
  WORD dir_CreateDate;
  WORD dir_LastAccessDate;
  WORD dir_EAhandle;

  WORD DosTime;
  WORD DosDate;
  WORD wFirstClus;
  DWORD dwSize;
} DOSDIRENTRY;
typedef DOSDIRENTRY * LPDOSDIRENTRY;

#ifndef _A_VOLID
#define _A_NORMAL   0x00    /* Normal file - No read/write restrictions */
#define _A_RDONLY   0x01    /* Read only file */
#define _A_HIDDEN   0x02    /* Hidden file */
#define _A_SYSTEM   0x04    /* System file */
#define _A_VOLID    0x08    /* Volume ID file */
#define _A_SUBDIR   0x10    /* Subdirectory */
#define _A_ARCH     0x20    /* Archive file */
#endif

#ifndef _A_LONG
#define _A_LONG 0x0f
#define _A_LONG_MASK 0x3f
#endif

#ifndef LAST_LONG_ENTRY
#define LAST_LONG_ENTRY 0x40
#endif

typedef struct tagLONGNAME_ENTRY
{
char lfn_ord;
char lfn_name1[10];
BYTE lfn_attr;
BYTE lfn_type;
BYTE lfn_chksum;
char lfn_name2[12];
WORD lfn_first_clus;
char lfn_name3[4];
} LONGNAME_ENTRY;
typedef LONGNAME_ENTRY * LPLONGNAME_ENTRY;

#define MAXLFN 256
                                           
typedef struct tagREADLFN
{
char szBuildLFN[MAXLFN+32];
BYTE bCheckSum;
BOOL fBeginFillEntry;
BYTE bLastDef;
} READLFN;
BYTE ChkSum(unsigned char  * pFcbName);
void ResetReadLfn(READLFN * pReadLfn) ;
BOOL GetLfn(READLFN * pReadLfn,BYTE bCheckSum,char * pszLfn,int *piLongLfn) ;
BOOL UpdateReadLfn(READLFN * pReadLfn,void *direntry) ;
BOOL UpdateReadLfnReverse(READLFN * pReadLfn,void *direntry,BYTE bChecksum);
void GetDosDirEntryNameInfo(void *direntry,BYTE * pbCheckSum,
                            BOOL * pfNameLowerCase,BOOL * pfExtLowerCase) ;
BOOL IsValid83Entry(void *direntry);
BOOL IsValidLfnEntry(void *direntry);

int GetNbLfnEntry(int len);
void FillLfnEntry(void* direntry,const char*longname,int len,int iNumEntry,BYTE bCheckSum);
