/*
 *  linux/fs/msdos/lfn.c
 *
 *  Written in 1995 by Gilles Vollant (100144.2636@compuserve.com)
 *  Based on information on "Inside Windows 95" book from Adrian King
 *  see lfn.h for more info
 *
 */

/*
#ifdef MODULE
#include <linux/module.h>
#endif

#include <asm/segment.h>

#include <linux/fs.h>
#include <linux/msdos_fs.h>
#include <linux/errno.h>
#include <linux/stat.h>
#include <linux/string.h>

#include "msbuffer.h"
*/
#include "lfn.h"

#define PRINTK(x)

/* 
typedef struct tagREADLFN
{
char szBuildLFN[MAXLFN+1];
BYTE bCheckSum;
BOOL fBeginFillEntry;
BYTE bLastDef;
} READLFN;
*/

BYTE ChkSum(unsigned char  * pFcbName)
{
short FcbNameLen;
BYTE Sum = 0;
  for (FcbNameLen=11; FcbNameLen!=0; FcbNameLen--)
    {
    if (Sum & 1)
      Sum = (Sum/2)+0x80;
    else
      Sum = (Sum/2);
    Sum += *(pFcbName++);
    }
  return Sum;
}

void ResetReadLfn(READLFN * pReadLfn)
{
  pReadLfn->szBuildLFN[0]='\0';
  pReadLfn->fBeginFillEntry=FALSE;
}

BOOL GetLfn(READLFN * pReadLfn,BYTE bCheckSum,char * pszLfn,int *piLongLfn)
{
char * pSrcLfn;
int i=0;
  if ((!pReadLfn->fBeginFillEntry) ||
      (pReadLfn->bLastDef != 1) ||
      (pReadLfn->bCheckSum != bCheckSum))
    {
      pReadLfn->fBeginFillEntry=FALSE;
      return FALSE;
    }
  
  pSrcLfn = pReadLfn->szBuildLFN;
  while ((*(pSrcLfn+i)) != '\0')
    {
      *(pszLfn+i) = *(pSrcLfn+i) ;
      i++;
    }
  *(pszLfn+i) = '\0';

  pReadLfn->fBeginFillEntry=FALSE;
  if (piLongLfn != NULL)
    *piLongLfn = i;
  return TRUE;
}

BOOL IsValid83Entry(void *direntry)
{
LONGNAME_ENTRY * ple = (LONGNAME_ENTRY *)direntry;
  if ((((BYTE)(ple->lfn_ord)) == ((BYTE)0xE5)) || (((BYTE)(ple->lfn_ord)) == ((BYTE)0x0)))
    return FALSE;
  if (((ple->lfn_attr & _A_VOLID) != 0) &&
      ((ple->lfn_attr & _A_LONG_MASK) != _A_LONG))
    return FALSE; /* volume */
  return ((ple->lfn_attr & _A_VOLID) == 0) ;/* normal file 8.3 entry */
}

BOOL IsValidLfnEntry(void *direntry)
{
LONGNAME_ENTRY * ple = (LONGNAME_ENTRY *)direntry;
  if ((((BYTE)(ple->lfn_ord)) == ((BYTE)0xE5)) || (((BYTE)(ple->lfn_ord)) == ((BYTE)0x0)))
    return FALSE;
  if (((ple->lfn_attr & _A_VOLID) != 0) &&
      ((ple->lfn_attr & _A_LONG_MASK) != _A_LONG))
    return FALSE; /* volume */
  return ((ple->lfn_attr & _A_VOLID) != 0) ;
}

BOOL UpdateReadLfn(READLFN * pReadLfn,void *direntry)
{
LONGNAME_ENTRY * ple = (LONGNAME_ENTRY *)direntry;
BYTE b_ord;
int i;
char * pLongNameFill;
WORD wPosit;

  if ((((BYTE)(ple->lfn_ord)) == ((BYTE)0xE5)) || (((BYTE)(ple->lfn_ord)) == ((BYTE)0x0)))
        {
          pReadLfn->fBeginFillEntry=FALSE;
          return FALSE;
        }      

  if (((ple->lfn_attr & _A_VOLID) != 0) &&
      ((ple->lfn_attr & _A_LONG_MASK) != _A_LONG))
    /* volume label */
        {
          pReadLfn->fBeginFillEntry=FALSE;
          return FALSE;
        }      

  if ((ple->lfn_attr & _A_VOLID) == 0) /* normal file 8.3 entry */
        {
          return FALSE;
        }      

  b_ord = ple->lfn_ord & 0x3F;
  if ((b_ord > 19) || (b_ord == 0))
    return FALSE;
  if ((ple->lfn_ord & 0x40) == 0)/* if not first of lfn */
    {
      if (!pReadLfn->fBeginFillEntry)
        return FALSE;
      if ((pReadLfn->bCheckSum != ple->lfn_chksum) ||
          (b_ord != (pReadLfn->bLastDef-1)))
        {
          pReadLfn->fBeginFillEntry=FALSE;
          return FALSE;
        }      
    }
  else 
    {
      pReadLfn->fBeginFillEntry=TRUE;
      pReadLfn->bCheckSum = ple->lfn_chksum;
    }
  pReadLfn->bLastDef = b_ord;

  wPosit = (b_ord-1)*13;

  pLongNameFill = ((char*)pReadLfn->szBuildLFN) + wPosit;


  for (i=0;i<10/2;i++)
          *(pLongNameFill++) = ple->lfn_name1[i*2];
              
  for (i=0;i<12/2;i++)
          *(pLongNameFill++) = ple->lfn_name2[i*2];
              
  for (i=0;i< 4/2;i++)
          *(pLongNameFill++) = ple->lfn_name3[i*2];
              
  if (ple->lfn_ord & 0x40)
    *pLongNameFill = '\0';
  return TRUE;
}

/* return TRUE if need continue */
BOOL UpdateReadLfnReverse(READLFN * pReadLfn,void *direntry,BYTE bCheckSum)
{
LONGNAME_ENTRY * ple = (LONGNAME_ENTRY *)direntry;
BYTE b_ord;
int i;
char * pLongNameFill;
  if ((!IsValidLfnEntry(ple)) || (bCheckSum != ple->lfn_chksum))
        {
          pReadLfn->fBeginFillEntry=FALSE;
          return FALSE;
        }      


  b_ord = ple->lfn_ord & 0x3F;
  if (!pReadLfn->fBeginFillEntry)
    {
      if (b_ord!=1)
        return FALSE;
    }
  else
    {
      if ((b_ord != (pReadLfn->bLastDef+1)) || (b_ord > 19))
        {
          pReadLfn->fBeginFillEntry=FALSE;
          return FALSE;
        }      
    }

  pReadLfn->fBeginFillEntry=TRUE;
  pReadLfn->bLastDef = b_ord;

  pLongNameFill = ((char*)pReadLfn->szBuildLFN) + ((b_ord-1)*13);


  for (i=0;i<5;i++)
          *(pLongNameFill++) = ple->lfn_name1[i*2];
              
  for (i=0;i<6;i++)
          *(pLongNameFill++) = ple->lfn_name2[i*2];
              
  for (i=0;i<2;i++)
          *(pLongNameFill++) = ple->lfn_name3[i*2];
              
  *pLongNameFill = '\0';
  return (!(ple->lfn_ord & 0x40));
}

void GetDosDirEntryNameInfo(void *direntry,BYTE * pbCheckSum,
                            BOOL * pfNameLowerCase,BOOL * pfExtLowerCase)
{
DOSDIRENTRY * pde = (DOSDIRENTRY *)direntry;
  if (pbCheckSum != NULL)
    *pbCheckSum = ChkSum((unsigned char*)direntry);

  if (pfNameLowerCase != NULL)
    *pfNameLowerCase = (pde->cMinMajinfo & 0x8) != 0;

  if (pfExtLowerCase != NULL)
    *pfExtLowerCase = (pde->cMinMajinfo & 0x10) != 0;
}

int GetNbLfnEntry(int len)
{
  return (len+12)/13;
}

/* 0 <= iNumEntry < GetNbLfnEntry. 0 is for first entry */
void FillLfnEntry(void* direntry,const char*longname,int len,int iNumEntry,BYTE bCheckSum)
{
LONGNAME_ENTRY * ple = (LONGNAME_ENTRY *)direntry;
int i,iNbEntry,iOrd;
  if (iNumEntry >= (iNbEntry=GetNbLfnEntry(len)))
    {
      PRINTK(("Error in FillEntry\n"));
      return;
    }

  iOrd = (iNbEntry) - iNumEntry;

  len -= (iOrd-1)*13;
  longname += (iOrd-1)*13;

  ple -> lfn_ord = iOrd | ((iNumEntry==0) ? 0x40 : 0);

  ple -> lfn_attr = 0x0F;
  ple -> lfn_type =0 ;
  ple -> lfn_chksum = bCheckSum;
  ple -> lfn_first_clus = 0;

  for (i=0;i<5;i++,len--,longname++)
      {
         if (len > 0)
           {
             ple->lfn_name1[i*2] = *longname;
             ple->lfn_name1[(i*2)+1] = '\0';
           }
         else
           ple->lfn_name1[i*2] = ple->lfn_name1[(i*2)+1] = 
                               (len == 0) ? '\0' : ((char)((BYTE)0xFF));
      }
  for (i=0;i<6;i++,len--,longname++)
      {
         if (len > 0)
           {
             ple->lfn_name2[i*2] = *longname;
             ple->lfn_name2[(i*2)+1] = '\0';
           }
         else
           ple->lfn_name2[i*2] = ple->lfn_name2[(i*2)+1] = 
                               (len == 0) ? '\0' : ((char)((BYTE)0xFF));
      }
  for (i=0;i<2;i++,len--,longname++)
      {
         if (len > 0)
           {
             ple->lfn_name3[i*2] = *longname;
             ple->lfn_name3[(i*2)+1] = '\0';
           }
         else
           ple->lfn_name3[i*2] = ple->lfn_name3[(i*2)+1] = 
                               (len == 0) ? '\0' : ((char)((BYTE)0xFF));
      }
}
