/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: xalloc.c,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Safe memory allocation functions
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |	 |___  |   Martin Junius	     FIDO:	2:2452/110.1
 * | | | |   | |   Republikplatz 3	     Internet:	mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:	++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"

char *malloc(), *realloc();


/*
 * Global buffer for temporary usage
 */
char buffer[BUFFERSIZE];



/*
 * xmalloc(), xrealloc()  ---  safe versions of malloc() and realloc()
 */
void *xmalloc(size)
    int size;
{
    char *p;

    if((p = malloc(size)))
	return(p);
    fprintf(stderr, "Memory exhausted.");
    exit(EX_OSERR);

    /**NOT REACHED**/
    return NULL;
}

void *xrealloc(ptr, size)
    void *ptr;
    int size;
{
    char *p;

    if((p = realloc(ptr, size)))
	return(p);
    fprintf(stderr, "Memory exhausted.");
    exit(EX_OSERR);

    /**NOT REACHED**/
    return NULL;
}


/*
 * xfree() --- free() with check for NULL pointer (is safe according to
 *             Standard-C, but older libraries may not check this)
 */
void xfree(p)
    void *p ;
{
    if(p)
	free(p);
}



/*
 * strsave()  ---  make a copy of a string
 */
char *strsave(s)
    char *s;
{
    char *p;

    p = xmalloc(strlen(s) + 1);
    strcpy(p, s);
    return(p);
}



/*
 * strsaveline() --- like strsave(), but remove '\r\n' at end of line if any
 */

char *strsaveline(s)
    char *s;
{
    char *r;
    int len;

    r = strsave(s);
    len = strlen(r);
    if(r[len - 1] == '\n')
	r[len - 1] = 0;
    return(r);
}
