/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: maus.c,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Maus.DE / MAUSNET special processing
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"

#ifdef MAUS_DE


static Maus *maus_list = NULL;
static Maus *maus_last = NULL;



/*
 * Read list of MAUS domains from LIBDIR/MAUS file.
 *
 * Format:
 *     MAUS       domain          [FTN-gateway]
 */
void maus_init()
{
    FILE *fp;
    Maus *p;

    debug(14, "Reading maus file");
    
    fp = libfopen(MAUS, R_MODE);

    while(cf_getline(buffer, BUFFERSIZE, fp))
    {
	char *name, *dom, *gate;
	
	name = strtok(buffer, " \t");	/* MAUS name or "default" */
	dom  = strtok(NULL,   " \t");	/* Internet domain address */
	gate = strtok(NULL,   " \t");	/* FTN gateway for MAUSNET */

	if(name==NULL || dom==NULL)
	    continue;
	
	p = (Maus *)xmalloc(sizeof(Maus));
	p->next = NULL;
	p->name = strsave(name);
	if(*dom == '-')			/* No domain address */
	    p->domain = NULL;
	else
	    p->domain = strsave(dom);
	if(gate==NULL || asc_to_node(gate, &p->gate, FALSE)==ERROR)
	    node_clear(&p->gate);

	debug(15, "maus: %s %s %s", p->name, p->domain ? p->domain : "(none)",
	      p->gate.zone ? node_to_asc(&p->gate, TRUE) : "" );
	
	/*
	 * Put into linked list
	 */
	if(maus_list)
	    maus_last->next = p;
	else
	    maus_list       = p;
	maus_last       = p;
    }
    
    fclose(fp);

    /*
     * Check that "default" entry in the first one in the list
     */
    if(maus_list==NULL)
	log("maus: no default entry");
    if(stricmp(maus_list->name, "default"))
	log("maus: default entry is not the 1st one");
    if(maus_list->domain==NULL)
	log("maus: no domain for default entry");
    if(maus_list->gate.zone==0)
	log("maus: no gate for default entry");
}



/*
 * Return the default entry
 */
Maus *maus_default()
{
    return maus_list;
}



/*
 * Search MAUS
 */
Maus *maus_lookup(name)
    char *name;
{
    Maus *p;
    
    for(p=maus_list; p; p=p->next)
	if(!stricmp(p->name, name))
	    return p;
    
    return maus_list;
}


#endif /**MAUS_DE**/
