/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#include <ncurses.h>
#include <string.h>
#include <ctype.h>
#include "functs.h"
#include "colors.h"
#include "mbedit.h"
#include "mbmenu.h"
#include "mbhelp.h"
#include "mbutil.h"

extern WINDOW *wTxt,*wHlp;
extern int SimpleLink;

int maxMen=4;

MenuType Menu[5]=
{
	{
		8,21,1,"Global",
		{
			"About (Who?)      M-w",
			"Cycle lookup mode C-a",
			"Get files         C-g",
			"Toggle link       C-l",
			"Toggle ClearMarks C-m",
			"Redraw screen     C-d",
			"Call Utility      M-u",
			"Exit FEddi        M-x"
		},
		{7,7,0,7,12,2,5,1},
		{
			showAbout,
			changeShowAll,
			requestFilesfromAddr,
			toggleLink,
			toggleClearMarks,
			redrawScreen,
			callUtility,
			quitFEddi
		}
	},
	{
		7,19,9,"Folder",
		{
			"List            M-f",
			"Cycle aka/route M-a",
			"Change charset  C-h",
			"Folder-info     M-i",
			"Search regex    M-s",
			"Toggle readonly C-r",
			"Choose orgin    M-o"
		},
		{0,6,7,7,0,7,7},
		{
			FolderShell,
			cycleAka,
			changeCharset,
			folderInfo,
			startSearch,
			toggleReadOnly,
			chooseOrigin
		}
	},
	{
		15,18,17,"Message",
		{
			"List           M-l",
			"Change by      M-b",
			"Change dest    M-d",
			"Change subject M-j",
			"Change status  M-y",
			"Insert message INS",
			"Reply          M-r",
			"Netmail reply  M-n",
			"Crosspost      M-c",
			"Forward        C-f",
			"Edit text      M-t",
			"Export         M-e",
			"Print          M-p",
			"Get files      M-g",
			"Show kludges   M-k"
		},
		{0,7,7,10,7,0,0,0,0,0,5,0,0,0,5},
		{
			ListShell,
			changeFrom,
			changeTo,
			changeSubj,
			changeFlags,
			enterMsg,
			replyMsg,
			netreplyMsg,
			crosspost,
			forward,
			changeText,
			exportMsg,
			printMsg,
			requestFiles,
			showKludges
		}
	},
	{
		10,12,26,"Help",
		{
			"Global   M-1",
			"Keyboard M-2",
			"FastNum  M-3",
			"Folders  M-4",
			"Messages M-5",
			"Tree     M-6",
			"Request  M-7",
			"Search   M-8",
			"Regex    M-9",
			"Editor   M-0"
		},
		{0,0,4,0,0,0,0,0,4,0},
		{
			showGlobalHelp,
			showKeyboardHelp,
			showNumblockHelp,
			showFolderHelp,
			showMessageHelp,
			showTreeHelp,
			showRequestHelp,
			showSearchHelp,
			showRegexHelp,
			showEditorHelp
		}
	},
	{
		0,7,32,"Utility",
		{},
		{},
		{
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility,
			execMenuUtility
		}
	}
};

WINDOW *wMen=NULL;

int MenuIsActive=0;
int curMen=0,curMenpos=0;

void showmenu();
void highlight();
void killmenu();

void initmenu()
{
	int i;
	wcolon(wHlp,COL_StatusLine);
	werase(wHlp);
	for (i=0; i<maxMen; i++)
		mvwaddstr(wHlp,0,Menu[i].xpos,Menu[i].name);
	wcolon(wHlp,COL_StatusLineHigh);
	for (i=0; i<maxMen; i++)
		mvwaddch(wHlp,0,Menu[i].xpos,Menu[i].name[0]);
	wcolon(wHlp,COL_StatusLine);
	mvwaddstr(wHlp,0,COLS-8,SimpleLink?"1D-link":"2D-link");
	wrefresh(wHlp);
}

void menukey(int key)
{
	int x;
	if (!MenuIsActive)
	{
		if (key==32)
		{
			showmenu();
			return;
		}
		for (x=0; x<maxMen; x++)
			if (tolower(Menu[x].name[0])==tolower(key)) break;
		if (x==maxMen) {Beep(); return;}
		curMen=x;
		showmenu();
	} else
	{
		if (key==32)
		{
			killmenu();
			return;
		}
		for (x=0; x<Menu[curMen].entries; x++)
			if (tolower(Menu[curMen].entry[x][Menu[curMen].pos[x]])==tolower(key)) break;
		if (x==Menu[curMen].entries) {Beep(); return;}
		killmenu();
		curMenpos=x;
		(*Menu[curMen].funct[x])();
	}
}

int menuarrow(int dir)
{
	if (!MenuIsActive)
		return 1;
	else
		switch (dir)
		{
			case ARROW_NIL:
				Beep();
				return 0;
			case ARROW_CLICK:
				killmenu();
				(*Menu[curMen].funct[curMenpos])();
				break;
			case ARROW_UP:
				if (curMenpos)
					curMenpos--;
				else
					curMenpos=Menu[curMen].entries-1;
				highlight();
				break;
			case ARROW_DOWN:
				if (curMenpos==Menu[curMen].entries-1)
					curMenpos=0;
				else
					curMenpos++;
				highlight();
				break;
			case ARROW_RIGHT:
				if (curMen==maxMen-1)
					curMen=0;
				else
					curMen++;
				killmenu();
				showmenu();
				break;
			case ARROW_LEFT:
				if (curMen)
					curMen--;
				else
					curMen=maxMen-1;
				killmenu();
				showmenu();
				break;
			default:
				return 1;
		}
	return 0;
}

void highlight()
{
	int i;
	for (i=0; i<Menu[curMen].entries; i++)
	{
		if (i==curMenpos)
			wcolon(wMen,COL_MenuHigh);
		else
			wcolon(wMen,COL_Menu);
		mvwaddstr(wMen,1+i,1,Menu[curMen].entry[i]);
		if (i==curMenpos)
			wcolon(wMen,COL_MenuKeyHigh);
		else
			wcolon(wMen,COL_MenuKey);
		mvwaddch(wMen,1+i,1+Menu[curMen].pos[i],
				Menu[curMen].entry[i][Menu[curMen].pos[i]]);
	}
	wcolon(wMen,COL_Menu);
	box(wMen,0,0);
	wrefresh(wMen);
}

void showmenu()
{
	curMenpos=0;
	wMen=newwin(2+Menu[curMen].entries,2+Menu[curMen].width,\
			LINES-3-Menu[curMen].entries,Menu[curMen].xpos-1);
	highlight();
	MenuIsActive=1;
}

void killmenu()
{
	if (MenuIsActive)
	{
		delwin(wMen);
		wMen=NULL;
		touchwin(wTxt);
		wrefresh(wTxt);
		MenuIsActive=0;
	}
}
