/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#include <ncurses.h>
#include "proc.h"
#include "functs.h"
#include "colors.h"
#include "verdate.h"

extern WINDOW *wTop,*wHdr,*wTxt,*wHlp;

static char numblock[2][11][32]=
{
	{
		"!___=___=___ !___=___=___=___",
		"|INS|HOM|PUP| |NUM| / | * | - |",
		"$___#___#___% $___#___#___#___%",
		"|DEL|END|PDN| | 7 | 8 | 9 |   |",
		"&___(___(___) $___#___#___% + |",
		"              | 4 | 5 | 6 |   |",
		"    !___     $___#___#___#___%",
		"    |UP |     | 1 | 2 | 3 |   |",
		"!___#___#___ $___(___#___%CR |",
		"|LE |DN |RI | |   0   | , |   |",
		"&___(___(___) &_______(___(___)"
	},
	{
		"!___=_______ !___=_______=___",
		"|OTH|  MOV  | |XXX|FOLDERS|   |",
		"$___%  MSG  | $___(_______)   |",
		"|FLG|  TXT  | |               |",
		"&___(_______) |   !___  MSG  |",
		"              |   |FLG|       |",
		"    !___     |   &___)   !___%",
		"    |MOV|     |           |   |",
		"!___%MSG$___ $_______=___)   |",
		"|MSG|TXT|MSG| |  FLG  | OTHER |",
		"&___(___(___) &_______(_______)"
	}
};

void closeHelp(WINDOW *win)
{
	wrefresh(win);
	while (getchn()!=0xa);
	delwin(win);
	touchwin(wHlp);
	touchwin(wTop);
	touchwin(wTxt);
	touchwin(wHdr);
	wrefresh(wHlp);
	wrefresh(wTop);
	wrefresh(wTxt);
	wrefresh(wHdr);
}

WINDOW *openHelp(int depth, int width, char *text)
{
	WINDOW *win=NULL;
	if ((LINES-depth+1)>0 && (COLS-width+1)>0)
	{
		if ((win=openask(depth,width,(LINES-depth+1)/2,(COLS-width+1)/2,text,COL_HelpBox))!=NULL)
			mvwaddstr(win,depth-1,width-15,"<CR> to leave");
		else
			Beep();
	}
	else
		Beep();
	return win;
}

void hLine(WINDOW *win, int line)
{
	int i;
	wmove(win,line,0);
	waddch(win,ACS_LTEE);
	for (i=0; i<78; i++) waddch(win,ACS_HLINE);
	waddch(win,ACS_RTEE);
}

void showAbout()
{
	WINDOW *w;
	char dummy[40];
	sprintf(dummy,"FEddi V%s (C)1993-95 by Oliver Graf",VERSION);
	if ((w=openHelp(20,46,dummy))!=NULL)
	{
		mvwprintw(w, 1,23-strlen(VERSION_DATE)/2,"%s",VERSION_DATE);
		mvwaddstr(w, 3, 2,"Programming:");
		mvwaddstr(w, 4,12,"Oliver Graf       2:2454/130.69");
		mvwaddstr(w, 6, 2,"Help, keyboard, programming, etc.:");
		mvwaddstr(w, 7,12,"Alexander Graf    2:2454/130.5");
		mvwaddstr(w, 9, 2,"Betatest, scripts:");
		mvwaddstr(w,10,12,"Oliver Andrich    2:2454/130.103");
		mvwaddstr(w,12, 2,"Betatest:");
		mvwaddstr(w,13,12,"Christof Furch    2:2454/130.14");
		mvwaddstr(w,14,12,"Marcel Ackermann  2:2454/130.666");
		mvwaddstr(w,16, 2,"Betatest (multiuser):");
		mvwaddstr(w,17,12,"Andreas Heilwagen 2:2454/100.3");
		closeHelp(w);
	}
}

void showGlobalHelp()
{
	WINDOW *w;
	if ((w=openHelp(25,80,"FEddi - Global Help"))!=NULL)
	{
		mvwaddstr(w, 1, 2,"Here are a few hints about using FEddi:");
		mvwaddstr(w, 3, 2,"* META and CTRL activate almost any function of FEddi (see Keyboard Help).");
		mvwaddstr(w, 4, 2,"* You can enter the menu by pressing the space bar or the highlighted hotkey.");
		mvwaddstr(w, 5, 4,"Now choose a function with the cursor keys and activate it by pressing CR");
		mvwaddstr(w, 6, 4,"or simply by pressing the highlighted hotkey.");
		mvwaddstr(w, 7, 2,"* The numblock has all important functions combined (see FastNum Help).");
		mvwaddstr(w, 9, 2,"* You can activate the online help with M-0 to M-9 and with M-h:");
		mvwaddstr(w,10, 4,"M-1  Global Help");
		mvwaddstr(w,11, 4,"M-2  Keyboard Help");
		mvwaddstr(w,12, 4,"M-3  FastNum Help");
		mvwaddstr(w,13, 4,"M-4  Folderlist Help");
		mvwaddstr(w,10,29,"M-5  Messagelist Help");
		mvwaddstr(w,11,29,"M-6  Tree Help");
		mvwaddstr(w,12,29,"M-7  Request Help");
		mvwaddstr(w,13,29,"M-8  Search Help");
		mvwaddstr(w,10,54,"M-9  Regex Help");
		mvwaddstr(w,11,54,"M-0  Editor Help");
		mvwaddstr(w,13,54,"M-h  Online Help");
		mvwaddstr(w,15, 2,"All your ideas and suggestions are welcome!");
		hLine(w,16);
		mvwaddstr(w,17, 2,"If you have too much money and you like this program, feel free to send a");
		mvwaddstr(w,18, 2,"bit of it to me (a bit of the money, not the program :-) Thanxx!");
		mvwaddstr(w,20, 5,"Oliver Graf");
		mvwaddstr(w,21, 5,"Am Rhein 3");
		mvwaddstr(w,22, 5,"56220 St.Sebastian");
		mvwaddstr(w,23, 5,"GERMANY");
		mvwaddstr(w,20,38,"Bank account: Citibank Koblenz");
		mvwaddstr(w,21,52,"BLZ 300 209 00");
		mvwaddstr(w,22,52,"KNr 2012711496");
		closeHelp(w);
	}
}

void showKeyboardHelp()
{
	WINDOW *w;
	if ((w=openHelp(25,80,"FEddi - Keyboard Help"))!=NULL)
	{
		mvwaddstr(w,1,2,"Meta-functions");
		hLine(w,2);
		mvwaddstr(w,3,2,"<a>  cycle aka/route");
		mvwaddstr(w,4,2,"<b>  change by");
		mvwaddstr(w,5,2,"<c>  crosspost/cc message");
		mvwaddstr(w,6,2,"<d>  change destination");
		mvwaddstr(w,7,2,"<e>  export message");
		mvwaddstr(w,8,2,"<f>  show folderlist");
		mvwaddstr(w,9,2,"<g>  get (request) files");
		mvwaddstr(w,10,2,"<h>  keyboard help");
		mvwaddstr(w,11,2,"<i>  show folderinfo");
		mvwaddstr(w,3,31,"<j>  change subject");
		mvwaddstr(w,4,31,"<k>  show kludges");
		mvwaddstr(w,5,31,"<l>  show messagelist");
		mvwaddstr(w,6,31,"<m>  ---");
		mvwaddstr(w,7,31,"<n>  net-reply message");
		mvwaddstr(w,8,31,"<o>  choose origline");
		mvwaddstr(w,9,31,"<p>  print message");
		mvwaddstr(w,10,31,"<q>  ---");
		mvwaddstr(w,11,31,"<r>  reply message");
		mvwaddstr(w,3,55,"<s>  regex search");
		mvwaddstr(w,4,55,"<t>  edit text");
		mvwaddstr(w,5,55,"<u>  call user utility");
		mvwaddstr(w,6,55,"<v>  ---");
		mvwaddstr(w,7,55,"<w>  about FEddi");
		mvwaddstr(w,8,55,"<x>  exit FEddi");
		mvwaddstr(w,9,55,"<y>  change status");
		mvwaddstr(w,10,55,"<z>  ---");
		hLine(w,12);
		mvwaddstr(w,13,2,"Ctrl-functions");
		hLine(w,14);
		mvwaddstr(w,15,2,"<a>  cycle lookup mode");
		mvwaddstr(w,16,2,"<b>  ---");

		mvwaddstr(w,18,2,"<d>  redraw screen");
		mvwaddstr(w,19,2,"<e>  ---");
		mvwaddstr(w,20,2,"<f>  forward message");
		mvwaddstr(w,21,2,"<g>  get files (from address)");
		mvwaddstr(w,22,2,"<h>  change charset");
		mvwaddstr(w,23,2,"<i>  ---");
		mvwaddstr(w,15,31,"<j>  ---");
		mvwaddstr(w,16,31,"<k>  ---");
		mvwaddstr(w,17,31,"<l>  toggle link mode");
		mvwaddstr(w,18,31,"<m>  toggle clear marks");
		mvwaddstr(w,19,31,"<n>  net-reply to dest.");
		mvwaddstr(w,20,31,"<o>  toggle read-only");
		mvwaddstr(w,21,31,"<p>  ---");

		mvwaddstr(w,23,31,"<r>  reply to dest.");

		mvwaddstr(w,16,55,"<t>  ---");
		mvwaddstr(w,17,55,"<u>  ---");
		mvwaddstr(w,18,55,"<v>  ---");
		mvwaddstr(w,19,55,"<w>  ---");
		mvwaddstr(w,20,55,"<x>  ---");
		mvwaddstr(w,21,55,"<y>  ---");
		mvwaddstr(w,22,55,"<z>  ---");
		closeHelp(w);
	}
}

void showNumblockHelp()
{
	WINDOW *w;
	int x,y,z;
	chtype outchar;
	if ((w=openHelp(25,80,"FEddi - FastNum Help"))!=NULL)
	{
		for (z=0; z<2; z++)
			for (y=0; y<11; y++)
				for (x=0; x<31; x++)
				{
					switch (numblock[z][y][x])
					{
						case '!': outchar=ACS_ULCORNER; break;
						case '&': outchar=ACS_LLCORNER; break;
						case '': outchar=ACS_URCORNER; break;
						case ')': outchar=ACS_LRCORNER; break;
						case '|': outchar=ACS_VLINE; break;
						case '_': outchar=ACS_HLINE; break;
						case '%': outchar=ACS_RTEE; break;
						case '$': outchar=ACS_LTEE; break;
						case '=': outchar=ACS_TTEE; break;
						case '(': outchar=ACS_BTEE; break;
						case '#': outchar=ACS_PLUS; break;
						default: outchar=numblock[z][y][x];
					}
					mvwaddch(w,y+1+z*12,x+2,outchar);
				}
		mvwaddstr(w,2,34,"MOVEMENT BETWEEN FOLDERS");
		mvwaddstr(w,3,40,"/ | *        prev|next folder");
		mvwaddstr(w,5,34,"MOVEMENT BETWEEN MESSAGES");
		mvwaddstr(w,6,40,"- | +        prev|next protected msg");
		mvwaddstr(w,7,40,"7 | 9        prev|next marked msg");
		mvwaddstr(w,8,40,"4 | 6        prev|next brother");
		mvwaddstr(w,9,40,"1 | 3        prev|next personal msg");
		mvwaddstr(w,10,40,"2 | 8        child|mother");
		mvwaddstr(w,11,37,"LEFT | RIGHT    prev|next message");
		mvwaddstr(w,13,34,"MOVING THE MESSAGETEXT");
		mvwaddstr(w,14,36,"(PG)UP/(PG)DOWN  scroll text");
		mvwaddstr(w,15,36,"HOME | END       go to first|last textline");
		mvwaddstr(w,17,34,"FLAGS AND OTHER FUNCTIONS");
		mvwaddstr(w,18,36,"5                toggle marked-flag");
		mvwaddstr(w,19,36,"0                toggle protected-flag");
		mvwaddstr(w,20,36,"DEL              delete message");
		mvwaddstr(w,21,36,"CR               show message-list");
		mvwaddstr(w,22,36,"INS              enter new message");
		mvwaddstr(w,23,36,"BS               delete thread");
		closeHelp(w);
	}
}

void showFolderHelp()
{
	WINDOW *w;
	if ((w=openHelp(19,52,"FEddi - FolderList Help"))!=NULL)
	{
		mvwaddstr(w,2,2,"(PG)UP/(PG)DOWN  choose folder");
		mvwaddstr(w,3,2,"HOME | END       go to first|last folder");
		mvwaddstr(w,4,2,"CR               change to folder/edit seperator");
		mvwaddstr(w,5,2,"SPACE            (un)mark folder/group");
		mvwaddstr(w,6,2,"INS              insert folder/seperator");
		mvwaddstr(w,7,2,"DEL              delete folder");
		mvwaddstr(w,8,2,"TAB              show folder-info");
		mvwaddstr(w,9,2,"RIGHT            go to message-list");
		mvwaddstr(w,10,2,"M-m              move folder (CR to accept)");
		mvwaddstr(w,11,2,"M-i              import folder from other path");
		mvwaddstr(w,13,2,"It is also possible to quick-access a folder by");
		mvwaddstr(w,14,2,"typing its name (BS deletes last character).");
		mvwaddstr(w,16,2,"C-y              cancel quick-access");
		closeHelp(w);
	}
}

void showMessageHelp()
{
	WINDOW *w;
	if ((w=openHelp(20,47,"FEddi - MessageList Help"))!=NULL)
	{
		mvwaddstr(w,2,2,"(PG)UP/(PG)DOWN  choose message");
		mvwaddstr(w,3,2,"HOME | END       go to first|last message");
		mvwaddstr(w,4,2,"CR | RIGHT       change to message");
		mvwaddstr(w,5,19,"(undelete if neccessary)");
		mvwaddstr(w,6,2,"SPACE | 5        (un)mark message");
		mvwaddstr(w,7,2,"DEL              (un)delete message");
		mvwaddstr(w,8,2,"0                (un)protect message");
		mvwaddstr(w,9,2,"N                clear new-flags");
		mvwaddstr(w,10,2,"TAB              show message-header");
		mvwaddstr(w,11,2,"s | c | *        set|clear|toggle all marks");
		mvwaddstr(w,12,2,"2 | 8            prev|next tree-root");
		mvwaddstr(w,13,2,"7 | 9            prev|next marked msg");
		mvwaddstr(w,14,2,"1 | 3            prev|next personal msg");
		mvwaddstr(w,15,2,"- | +            prev|next protected msg");
		mvwaddstr(w,16,2,"LEFT             go to folder-list");
		mvwaddstr(w,17,2,"M-s              toggle long/short subject");
		closeHelp(w);
	}
}

void showTreeHelp()
{
	WINDOW *w;
	if ((w=openHelp(11,45,"FEddi - Tree Help"))!=NULL)
	{
		mvwaddstr(w,2,2,"(PG)UP/(PG)DOWN  choose message");
		mvwaddstr(w,3,2,"HOME | END       go to first|last message");
		mvwaddstr(w,4,2,"TAB              cycle Num/From/To/Subj");
		mvwaddstr(w,5,2,"CR               change to message");
		mvwaddstr(w,6,19,"(undelete if neccessary)");
		mvwaddstr(w,7,2,"2 | 8            child|mother");
		mvwaddstr(w,8,2,"4 | 6            prev|next brother");
		closeHelp(w);
	}
}

void showRequestHelp()
{
	WINDOW *w;
	if ((w=openHelp(10,47,"FEddi - Request Help"))!=NULL)
	{
		mvwaddstr(w,2,2,"(PG)UP/(PG)DOWN  choose file");
		mvwaddstr(w,3,2,"HOME | END       go to first|last file");
		mvwaddstr(w,4,2,"SPACE            (un)tag file");
		mvwaddstr(w,5,2,"CR               edit filename and password");
		mvwaddstr(w,6,2,"INS              add file to request-list");
		mvwaddstr(w,7,2,"M-a              change address");
		closeHelp(w);
	}
}

void showSearchHelp()
{
	WINDOW *w;
	if ((w=openHelp(12,42,"FEddi - Search Help"))!=NULL)
	{
		mvwaddstr(w,2,2,"LEFT | RIGHT  search prev|next");
		mvwaddstr(w,3,2,"- | +         search prev|next message");
		mvwaddstr(w,4,2,"HOME          go to first match");
		mvwaddstr(w,5,2,"END           go to last match");
		mvwaddstr(w,6,2,"UP/DOWN       scroll messagetext");
		mvwaddstr(w,7,2,"CR            change to message");
		mvwaddstr(w,8,2,"5             (un)mark message");
		mvwaddstr(w,9,2,"0             (un)protect message");
		closeHelp(w);
	}
}

void showEditorHelp()
{
	WINDOW *w;
	if ((w=openHelp(17,43,"FEddi - Editor Help"))!=NULL)
	{
		mvwaddstr(w,2,2,"M-i      insert file");
		mvwaddstr(w,3,2,"M-c      toggle special char conversion");
		mvwaddstr(w,4,2,"C-SPACE  mark/unmark region");
		mvwaddstr(w,5,2,"C-y      kill line");
		mvwaddstr(w,6,2,"C-l      kill to eol");
		mvwaddstr(w,7,2,"C-k      kill region/buffer");
		mvwaddstr(w,8,2,"C-u      yank out buffer");
		mvwaddstr(w,9,2,"C-p      pipe buffer through script");
		mvwaddstr(w,10,2,"M-b      show buffer");
		mvwaddstr(w,11,2,"C-b      backward one word");
		mvwaddstr(w,12,2,"C-f      forward one word");
		mvwaddstr(w,13,2,"M-s      insert smilie");
		mvwaddstr(w,14,2,"M-0..9   insert textmacro");
		closeHelp(w);
	}
}

void showRegexHelp()
{
	WINDOW *w;
	if ((w=openHelp(25,80,"FEddi - regex Help"))!=NULL)
	{
		mvwaddstr(w,1,2,"The regular expressions conform to the posix extended grep syntax.");
		mvwaddstr(w,3,2,"A list of characters enclosed by [ and ] matches any single character in");
		mvwaddstr(w,4,2,"that list. If the first character of the list is the caret ^ then it matches");
		mvwaddstr(w,5,2,"any character _not_ in the list. For example, the regular expression");
		mvwaddstr(w,6,2,"[0123456789] matches any single digit. A range of ASCII characters may be");
		mvwaddstr(w,7,2,"specified by giving the first and last characters, separated by a hyphen");
		mvwaddstr(w,8,2,"(i.e. [0-9A-Za-z])");
		mvwaddstr(w,9,2,"The period . matches any single character. A regular expression matching a");
		mvwaddstr(w,10,2,"single character may be followed by one of several repetition operators:");
		mvwaddstr(w,11,2,"?      The preceding item is optional and matched at most once.");
		mvwaddstr(w,12,2,"*      The preceding item will be matched zero or more times.");
		mvwaddstr(w,13,2,"+      The preceding item will be matched one or more times.");
		mvwaddstr(w,14,2,"{n}    The preceding item is matched exactly n times.");
		mvwaddstr(w,15,2,"{n,}   The preceding item is matched n or more times.");
		mvwaddstr(w,16,2,"{,m}   The preceding item is optional and is matched at most m times.");
		mvwaddstr(w,17,2,"{n,m}  The preceding item is matched at least n times, but not more than");
		mvwaddstr(w,18,2,"       m times.");
		mvwaddstr(w,19,2,"Two regular expressions may be joined by the infix operator |; the resulting");
		mvwaddstr(w,20,2,"regular expression matches any string matching either subexpression.");
		mvwaddstr(w,21,2,"In extended regular expressions the characters ?, +, {, |, (, [ and \\ have a");
		mvwaddstr(w,22,2,"special meaning. Instead use the backslashed versions \\?, \\+, \\{, \\|, \\(,");
		mvwaddstr(w,23,2,"\\[ and \\\\ for the normal characters. See the GREP manpage for more.");
		closeHelp(w);
	}
}
