.TH xzx 1
.SH NAME
xzx \- an X11 Sinclair ZX Spectrum emulator
.SH SYNOPSIS
.B xzx
.B [options]
.B [\fIsnaphot-file\fR]
.SH DESCRIPTION
\fBxzx\fR is a z80 emulator with reasonable support for the 48K Sinclair
ZX Spectrum hardware.  Although a usable Spectrum is emulated, a few
features are missing; sound is only emulated on some hardware, for
obvious reasons, and printer support is as yet absent.
.SH OPTIONS
\fBxzx\fR accepts the following command line options.  Options may also
be specified as X Resources using the same spelling.
.TP
.BI \-help
Print a synopsis of the accepted options and exit.
.TP
.BI \-version
Display the version of this \fBxzx\fR and exit.
.TP
.BI \-romName " \fIfilename\fR"
Use \fIfilename\fR as the file containing the Spectrum ROM image.  This
defaults to \f(CRspectrum.rom\fR.
.TP
.BI \-libDir " \fIpath\fR"
Use \fIpath\fR as the colon-separated directory list to check when loading
the Spectrum ROM and any snapshots specified.  Directories are guaranteed
to be searched in the order they're listed.  Defaults to ".:/usr/local/lib/xzx".
.TP
.BI \-intStyle " \fI[signal|counter]\fR"
Z80 interrupts are emulated in one of two ways with \fBxzx\fR - either by
forcing an interrupt every few thousand instructions \fI(count)\fR, or by
getting the O/S to generate a signal every 20ms with the \fIsetitimer()\fR
library function \fI(signal)\fR.  signal-style interrupts are preferable,
but are not guaranteed to work on every operating system, which is why
counter-style interrupts are still supported.
.TP
.BI \-recalibrate " \fI<boolean>\fR"
If counter-style interrupts are being used, \fBxzx\fR will attempt to keep
the interrupt frequency at 50/second.  If it ends spending a lot of time
updating the screen (which may happen on a remote X server), there is a
possibility that it will hang.  If this happens, switch recalibration off
with this option.
.TP
.BI \-mitshm " \fI<boolean>\fR"
Attempt to use the MIT-SHM X extension for rapid image transfer.  Defaults
to true.
.TP 
.BI \-mono
Force \fBxzx\fR to use only Black and White.  This is the default for monochrome
X servers, or if \fBxzx\fR fails to allocate 16 colours on a colour X server.
In this case, the foreground and background will contrast, e.g. blue on
black will appear as white on black, and green on white will appear as
black on white.
.TP
.BI \-private
Force \fBxzx\fR to use a private colormap.  This may be preferable to using 
monochrome if you run out of colours, but be warned, every other X client
will go technicolor.
.TP
.BI \-flashing " \fI<boolean>\fR"
Enable/disable flashing.  If disabled any attribute bytes with the
FLASH bit set will instead appear in inverse video.  The FLASH 
implementation is not very optimal yet (i.e. slow :-), so you may
want to disable flashing for action games.
.TP
.BI \-rrShm " \fI<n>\fR"
This options specifies how often your screen is refreshed when running
\fBxzx\fR with MITSHM active.  The screen is refreshed every \fIn\fR
interrupts, so a lower number means more frequent refreshes.  Specifying
it too low, however, could result in more time being spent in screen
painting than in CPU emulation!  Defaults to every 2 interrupts, you 
might get away with every interrupt if you're lucky.
.TP
.BI \-rrNoshm " \fI<n>\fR"
Similar to above, but used when MITSHM is not active.  This should be
somewhat higher than the value used for \fIrrShm\fR.  Defaults to every
4 interrupts - again, you may get away with lower values, or you may need
to raise it slightly.
.PP
If \fBxzx\fR has been built with -DSLOWDOWN defined, it is possible to
set and control \fBxzx\fR's speed.  The following options apply:
.TP
.BI \-slowdown " \fI<n>\fR"
Slow \fBxzx\fR down.  A larger value of \fIn\fR slows \fBxzx\fR more.  
This is implemented by simply running \fIn\fR nop instructions for 
every instruction.
.TP
.BI \-keySlower " \fI<keysym>\fR"
The key to dynamically slow \fBxzx\fR down.  Defaults to KP_Add, i.e. the
keypad Plus key.
.TP
.BI \-keyFaster " \fI<keysym>\fR"
The key to dynamically speed \fBxzx\fR up.  Defaults to KP_Subtract, i.e. the
keypad Minus key.
.PP
It is possible to redefine keys to emulate a Kempston joystick.  The
following resources apply:
.TP
.BI \-kempstUp " \fI<keysym>\fR"
The key to emulate moving the joystick forwards.  Default is \fIq\fR.
.TP
.BI \-kempstDown " \fI<keysym>\fR"
The key to emulate moving the joystick backwards.  Default is \fIa\fR.
.TP
.BI \-kempstLeft " \fI<keysym>\fR"
The key to emulate moving the joystick to the left.  Default is \fIo\fR.
.TP
.BI \-kempstRight " \fI<keysym>\fR"
The key to emulate moving the joystick to the right.  Default is \fIp\fR.
.TP
.BI \-kempstFire " \fI<keysym>\fR"
The key to emulate pressing the joystick fire button.  Default is \fIspace\fR.
.PP
Note that it's entirely possible for a key to emulate both a keyboard
keypress and a joystick movement.  No checks are made to ensure that
the same key isn't mapped to two or more joystick directions.  It's
also possible to fool \fBxzx\fR into thinking that the joystick is
being simultaneously moved in opposite directions!
.PP
If you're running \fBxzx\fR on Linux, and you've installed the joystick
kernel patches (available from tsx-11.mit.edu and sunsite.unc.edu), then
it's possible to use a PC analogue joystick to emulate a Kempston 
joystick.  In this case, the following options also apply.
.TP
.BI \-joystick " \fI<boolean>\fR"
Enable/disable joystick emulation.  This is disabled by default.  If
emulation is enabled, you'll be asked to calibrate your joystick when
\fBxzx\fR starts up.  Move the joystick to the lower right and press
either Fire button, then centre your joystick and press either fire button.
.TP
.BI \-joyDev " \fI<path>\fR"
This is the device that \fBxzx\fR uses to read the joystick status, 
\fI/dev/js0\fR by default.  You may want to use \fI/dev/js1\fR, depending
on how your system is setup.
.TP
.BI -tolerance " \fI<int>\fR"
This specifies how far from centre your joystick must be displaced before it
registers with \fBxzx\fR as being moved. The default displacement tolerance
is 20.  You may have to experiment with this to get the best response for
your joystick.
.PP
If you're running \fBxzx\fR on a machine with Sun Sparc \fI/dev/audio\fR
style sound support, then it's possible to get (fairly inaccurate) sound
emulation.  This option will also work on Linux with the kernel sound drivers
(tested with a SoundBlaster Pro - quality is poor), and on the NEC EWS 4800/330
workstation (works very well, but with a 150MHz Mips R4400, it ought to :-).
Alternatively, if you're on Linux, and \fBxzx\fR is compiled with
\fI-DPCSPKR_AUDIO\fR, you can get Spectrum sound from the PC Speaker.  This
works much better than \fI/dev/audio\fR style sound on Linux.  No extra
kernel support is necessary for this, but \fBxzx\fR must be run with
root privileges.  The following options apply:
.TP
.BI -sound " \fI<boolean>\fR"
Enable/disable sound.  Sound is disabled by default.
.TP
.BI -audioDev " \fI<path>\fR"
Specifies the audio device that \fBxzx\fR uses.  By default, this is
\fI/dev/audio\fR; you shouldn't need to change this, unless your system
is set up very oddly, or you're on an EWS 4800/330, in which case, use
\fI/dev/audio/audio\fR.  This doesn't apply if you use Linux PC Speaker
audio.
.PP
If you have compiled in the ZX Microdrive emulation you can use .MDR files as
Microdrive cartridges. The following options apply:
.TP
.BI -if1 " \fI<boolean>\fR"
Enable or disable the Interface 1. Enabled by default. Turn it off if you want
to work without extended basic / microdrive support.
.TP
.BI -if1Rom " \fI<path>\fR"
Specify the path to load an image of the 8K Interface 1 ROM. The current
directory and the lib directory (see above) are searched for the file 
if1.rom by default.
.TP
.BI -crlf " \fI<boolean>\fR"
Enable translation of carriage returns to linefeeds on RS232 output and vice
versa on RS232 input.  This is useful if you're transferring textual data
between Unix and your Spectrum.  Don't use it if you want to transfer binary
data.  See the 'Extensions and Alterations' section below for more details
on RS232 I/O.
.TP
.BI -m\fI<n>\fR " \fI<path>\fR"
Load a cartridge file into an emulated Microdrive (n is 1-8).  A blank,
unformatted cartridge file can be created by a command such as
\fIdd if=/dev/zero of=test.mdr bs=137923 count=1\fR.  A shell script,
\fBmkcart\fR has also been provided to do this.  You can then format it with
the Sinclair BASIC \fBFORMAT\fR command as normal.  Do not load the same file
into more than one drive!
.SH RUNNING THE EMULATOR
If \fBxzx\fR is started with no snapshot file as a command-line argument,
it will reset the machine and enter Sinclair BASIC, displaying the 
"(c) 1982 Sinclair Research Ltd".  If exactly one argument is given 
(not counting options), \fBxzx\fR will try to find that file first in
the current directory and then in its library directory.  \fBxzx\fR
is able to read and write .SNA format snapshots, and is able to read
48K .Z80 format snapshots.  If the file to be read has a .z80 
extension, then it will attempt to read it in Z80 format.  Not very
clever, but it works.
.PP
Once the emulator is up and running, the following keys have special
meanings:
.TP 12
.B F1/F2
Cause a CPU reset, dropping you back into Sinclair BASIC.
.TP 12
.B F3
You will be prompted on the command\-line for the name of a snapshot
file to dump.  This saves the current state of the machine for later
use.
.TP 12
.B F4
You will be prompted on the command\-line for the name of a snapshot
file to load.
.TP 12
.B F5
This key only has an effect if \fBxzx\fR has sound support.  Pressing it will
toggle sound on and off.
.TP 12
.B F8
Pressing this generates an NMI.
.TP 12
.B F10/F12
Pressing either of these keys immediately exits the emulator.
.PP
Support for the original Spectrum keyboard is emulated as follows:
both Shift and Control emulate Caps Shift, Alt emulates Symbol Shift,
Return emulates Enter, Backspace and Delete emulate CapsShift-0 
(Rubout), the cursor keys emulate CapsShift-5 to 8, and Escape emulates
CapsShift-1 (Edit).  These are the only keys which are guaranteed to
be emulated correctly; other keys on your keyboard may work, but
since keyboards vary so much, it'll be a matter of experimentation.
.SH EXTENSIONS AND ALTERATIONS TO THE BASIC
.PP
If \fBxzx\fR has been compiled with the \fI-DPSEUDO_IO\fR define, it
will be possible to read characters from stdin and write characters
to stdout and stderr using I/O ports.  By default the ports are as follows:
reading port 48896 will read a character from stdin, returning 255 if no
input is pending; writing port 48897 will send a character to stdout; and
writing port 48898 will send a character to stderr.  These port numbers
can be overriden at compile\-time by changing the definitions in spectrum.c.
This isn't particularly useful interactively, but has certain possibilities
as an unusual filtering shelltool.
.PP
If \fBxzx\fR has been compiled with the \fI-DLOAD_SAVE_1\fR or \fILOAD_SAVE_2\fR
define, the BASIC LOAD and SAVE commands will behave differently.  Instead
of trying to read or write data to a tape, SAVE will immediately dump data to a
file on disk, and LOAD will try and read data from a file on disk.  The
filename used when saving is the string passed to SAVE with a file 
extension of \fI.zxf\fR.  It is possible to SAVE BASIC programs, blocks
of memory (CODE), and arrays.  When LOADing, the filename used will be
the string passed to LOAD plus either \fI.sna\fR or \fI.zxf\fR appended.
.PP
If \fBxzx\fR as been compiled with the \fI-DZX_IF1\fR define the
emulator behaves as though an Interface 1 is attached in terms of
paging the shadow ROM in and out, allowing the use of extended basic
commands and emulating the Microdrive hardware.
.PP
The cartridge file format used is the .MDR format used by several
other Spectrum emulators.
.PP
When the IF1 emulation is active the RS232 channels are connected to
stdio so listings and blocks of code can be obtained and transferred
by appropriate redirections.  For example:  \fIxzx > listing.bas\fR,
followed by the BASIC commands to xzx:  \fIOPEN #4, 'T': LIST #4:
CLOSE #4\fR.  Channel 'T' is a text channel; BASIC keywords are expanded
and end-of-line is converted to CR/LF.  Channel 'B' is a binary channel;
no conversion is performed.
.SH BUGS AND DEFICIENCIES
Probably loads.  \fBxzx\fR does not run all of the snapshots I have tried,
but I don't know whether the emulator is at fault 100% of the time.  The
snapshot loading and saving mechanism is awkward and clunky (ok, it was a
quick hack to get something together :-), and will be replaced in a later
version.  Hardware support is limited, but this is slowly improving.
Loading snaps on the fly doesn't always seem to work.  Z80 snapshot support
doesn't seem to work properly.
.SH AUTHOR
Des Herriott <dnh@mfltd.co.uk>, and plenty others.  See the README and
ChangeLog files.
