/*
 * Copyright (c) Des Herriott 1993, 1994
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holder not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holder makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 */

/* For run-time configuration of various options */

struct config {
	int try_mitshm;		/* attempt to use MIT-SHM for image transfer */
	int private;		/* use a private colormap */
	int monochrome;		/* use only BlackPixel and WhitePixel */
	int recalibrate;	/* attempt to keep the interrupt rate at 50/sec */
	char visual[16];	/* name of X11 Visual to use */
	char rom_name[256];	/* spectrum ROM image filename */
	char lib_dir[256];	/* directory to check for support files */
	int icnt;			/* whether or not to use counter-style interrupts */
	int flashing;		/* is flashing enabled? */
	int rr_shm;			/* refresh frequency when using MITSHM */
	int rr_noshm;		/* as above, but not using MITSHM */
#ifdef SLOWDOWN
	int slowdown;		/* slowdown factor for very fast machines */
#endif
#ifdef JOY
	int use_js;			/* try to use a joystick */
	int js_tolerance;	/* joystick displacement tolerance */
	char js_device[256];/* joystick device name (/dev/js[0|1]) */
#endif
#if defined(DEV_AUDIO) || defined(PCSPKR_AUDIO)
	int use_sound;		/* use Sparc audio to emulate the speaker */
				/* (or use the PC speaker with PCSPKR_AUDIO) */
#endif
#ifdef DEV_AUDIO
	char audio_dev[256];/* name of audio device */
#endif
#ifdef ZX_IF1
	int if1_active;		/* are we emulating if1 ? */
	char if1_rom[256];	/* interface 1 ROM image filename */
	char cartfiles[8][256]; /* names of cartridge files */	
	int translate_nl;	/* Translate CR <-> LF ? */
#endif
};


/* These are the spectrum keys/joystick actions which can be bound
 * to X keysyms.
 */
enum { 
	KM_KEMPST_UP, KM_KEMPST_DOWN,
	KM_KEMPST_LEFT, KM_KEMPST_RIGHT,
	KM_KEMPST_FIRE,
#ifdef SLOWDOWN
	KEY_SLOWER,
	KEY_FASTER,
#endif
	NUM_KEYMAPPINGS
};
