/*
 * Copyright (c) Des Herriott 1993, 1994
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the copyright holder not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  The copyright holder makes no
 * representations about the suitability of this software for any purpose.  It
 * is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 */

/* 
 * Source file cbops.c - operations prefixed by 0xCB.
 */

#include "z80.h"
#include "cbops.h"

#include "auxfuncs.c"

static uns8  work8;

PFV cbops[256] = {
	rlc_b, rlc_c, rlc_d, rlc_e, rlc_h, rlc_l, rlc__hl_, rlc_a,
	rrc_b, rrc_c, rrc_d, rrc_e, rrc_h, rrc_l, rrc__hl_, rrc_a,
	rl_b,  rl_c,  rl_d,  rl_e,  rl_h,  rl_l,  rl__hl_,  rl_a, 
	rr_b,  rr_c,  rr_d,  rr_e,  rr_h,  rr_l,  rr__hl_,  rr_a, 
	sla_b, sla_c, sla_d, sla_e, sla_h, sla_l, sla__hl_, sla_a,
	sra_b, sra_c, sra_d, sra_e, sra_h, sra_l, sra__hl_, sra_a,
	wsl_b, wsl_c, wsl_d, wsl_e, wsl_h, wsl_l, wsl__hl_, wsl_a,
	srl_b, srl_c, srl_d, srl_e, srl_h, srl_l, srl__hl_, srl_a,
	bit_0_b, bit_0_c, bit_0_d, bit_0_e, bit_0_h, bit_0_l, bit_0__hl_, bit_0_a,
	bit_1_b, bit_1_c, bit_1_d, bit_1_e, bit_1_h, bit_1_l, bit_1__hl_, bit_1_a,
	bit_2_b, bit_2_c, bit_2_d, bit_2_e, bit_2_h, bit_2_l, bit_2__hl_, bit_2_a,
	bit_3_b, bit_3_c, bit_3_d, bit_3_e, bit_3_h, bit_3_l, bit_3__hl_, bit_3_a,
	bit_4_b, bit_4_c, bit_4_d, bit_4_e, bit_4_h, bit_4_l, bit_4__hl_, bit_4_a,
	bit_5_b, bit_5_c, bit_5_d, bit_5_e, bit_5_h, bit_5_l, bit_5__hl_, bit_5_a,
	bit_6_b, bit_6_c, bit_6_d, bit_6_e, bit_6_h, bit_6_l, bit_6__hl_, bit_6_a,
	bit_7_b, bit_7_c, bit_7_d, bit_7_e, bit_7_h, bit_7_l, bit_7__hl_, bit_7_a,
	res_0_b, res_0_c, res_0_d, res_0_e, res_0_h, res_0_l, res_0__hl_, res_0_a,
	res_1_b, res_1_c, res_1_d, res_1_e, res_1_h, res_1_l, res_1__hl_, res_1_a,
	res_2_b, res_2_c, res_2_d, res_2_e, res_2_h, res_2_l, res_2__hl_, res_2_a,
	res_3_b, res_3_c, res_3_d, res_3_e, res_3_h, res_3_l, res_3__hl_, res_3_a,
	res_4_b, res_4_c, res_4_d, res_4_e, res_4_h, res_4_l, res_4__hl_, res_4_a,
	res_5_b, res_5_c, res_5_d, res_5_e, res_5_h, res_5_l, res_5__hl_, res_5_a,
	res_6_b, res_6_c, res_6_d, res_6_e, res_6_h, res_6_l, res_6__hl_, res_6_a,
	res_7_b, res_7_c, res_7_d, res_7_e, res_7_h, res_7_l, res_7__hl_, res_7_a,
	set_0_b, set_0_c, set_0_d, set_0_e, set_0_h, set_0_l, set_0__hl_, set_0_a,
	set_1_b, set_1_c, set_1_d, set_1_e, set_1_h, set_1_l, set_1__hl_, set_1_a,
	set_2_b, set_2_c, set_2_d, set_2_e, set_2_h, set_2_l, set_2__hl_, set_2_a,
	set_3_b, set_3_c, set_3_d, set_3_e, set_3_h, set_3_l, set_3__hl_, set_3_a,
	set_4_b, set_4_c, set_4_d, set_4_e, set_4_h, set_4_l, set_4__hl_, set_4_a,
	set_5_b, set_5_c, set_5_d, set_5_e, set_5_h, set_5_l, set_5__hl_, set_5_a,
	set_6_b, set_6_c, set_6_d, set_6_e, set_6_h, set_6_l, set_6__hl_, set_6_a,
	set_7_b, set_7_c, set_7_d, set_7_e, set_7_h, set_7_l, set_7__hl_, set_7_a,
};

void rlc_b()
{
	carryFlag = *b & 0x80;
	*b = (*b << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*b);
}

void rlc_c()
{
	carryFlag = *c & 0x80;
	*c = (*c << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*c);
}

void rlc_d()
{
	carryFlag = *d & 0x80;
	*d = (*d << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*d);
}

void rlc_e()
{
	carryFlag = *e & 0x80;
	*e = (*e << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*e);
}

void rlc_h()
{
	carryFlag = *h & 0x80;
	*h = (*h << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*h);
}

void rlc_l()
{
	carryFlag = *l & 0x80;
	*l = (*l << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*l);
}

void rlc__hl_()
{
	carryFlag = theMemory[*hl] & 0x80;
	mem_write(*hl, (theMemory[*hl] << 1) | (carryFlag ? 0x01 : 0x00));
	do_shift_test(theMemory[*hl]);
}

void rlc_a()
{
	carryFlag = *a & 0x80;
	*a = (*a << 1) | (carryFlag ? 0x01 : 0x00);
	do_shift_test(*a);
}


void rrc_b()
{
	carryFlag = *b & 0x01;
	*b = (*b >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*b);
}

void rrc_c()
{
	carryFlag = *c & 0x01;
	*c = (*c >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*c);
}

void rrc_d()
{
	carryFlag = *d & 0x01;
	*d = (*d >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*d);
}

void rrc_e()
{
	carryFlag = *e & 0x01;
	*e = (*e >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*e);
}

void rrc_h()
{
	carryFlag = *h & 0x01;
	*h = (*h >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*h);
}

void rrc_l()
{
	carryFlag = *l & 0x01;
	*l = (*l >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*l);
}

void rrc__hl_()
{
	carryFlag = theMemory[*hl] & 0x01;
	mem_write(*hl,(theMemory[*hl] >> 1) | (carryFlag ? 0x80 : 0x00));
	do_shift_test(theMemory[*hl]);
}

void rrc_a()
{
	carryFlag = *a & 0x01;
	*a = (*a >> 1) | (carryFlag ? 0x80 : 0x00);
	do_shift_test(*a);
}


void rl_b()
{
	work8 = *b & 0x80;
	*b = (*b << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8;
	do_shift_test(*b);
}

void rl_c()
{
	work8 = *c & 0x80;
	*c = (*c << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8; 
	do_shift_test(*c);
}

void rl_d()
{
	work8 = *d & 0x80;
	*d = (*d << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8; 
	do_shift_test(*d);
}

void rl_e()
{
	work8 = *e & 0x80;
	*e = (*e << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8; 
	do_shift_test(*e);
}

void rl_h()
{
	work8 = *h & 0x80;
	*h = (*h << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8; 
	do_shift_test(*h);
}

void rl_l()
{
	work8 = *l & 0x80;
	*l = (*l << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8; 
	do_shift_test(*l);
}

void rl__hl_()
{
	work8 = theMemory[*hl] & 0x80;
	mem_write(*hl,(theMemory[*hl] << 1) | (carryFlag ? 0x01 : 0x00));
	carryFlag = work8; 
	do_shift_test(theMemory[*hl]);
}

void rl_a()
{
	work8 = *a & 0x80;
	*a = (*a << 1) | (carryFlag ? 0x01 : 0x00);
	carryFlag = work8; 
	do_shift_test(*a);
}


void rr_b()
{
	work8 = *b & 0x01;
	*b = (*b >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*b);
}

void rr_c()
{
	work8 = *c & 0x01;
	*c = (*c >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*c);
}

void rr_d()
{
	work8 = *d & 0x01;
	*d = (*d >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*d);
}

void rr_e()
{
	work8 = *e & 0x01;
	*e = (*e >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*e);
}

void rr_h()
{
	work8 = *h & 0x01;
	*h = (*h >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*h);
}

void rr_l()
{
	work8 = *l & 0x01;
	*l = (*l >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*l);
}

void rr__hl_()
{
	work8 = theMemory[*hl] & 0x01;
	mem_write(*hl,(theMemory[*hl] >> 1) | (carryFlag ? 0x80 : 0x00));
	carryFlag = work8; 
	do_shift_test(theMemory[*hl]);
}

void rr_a()
{
	work8 = *a & 0x01;
	*a = (*a >> 1) | (carryFlag ? 0x80 : 0x00);
	carryFlag = work8; 
	do_shift_test(*a);
}


void sla_b()
{
	carryFlag = *b & 0x80;
	*b <<= 1;
	do_shift_test(*b);
}

void sla_c()
{
	carryFlag = *c & 0x80;
	*c <<= 1;
	do_shift_test(*c);
}

void sla_d()
{
	carryFlag = *d & 0x80;
	*d <<= 1;
	do_shift_test(*d);
}

void sla_e()
{
	carryFlag = *e & 0x80;
	*e <<= 1;
	do_shift_test(*e);
}

void sla_h()
{
	carryFlag = *h & 0x80;
	*h <<= 1;
	do_shift_test(*h);
}

void sla_l()
{
	carryFlag = *l & 0x80;
	*l <<= 1;
	do_shift_test(*l);
}

void sla__hl_()
{
	carryFlag = theMemory[*hl] & 0x80;
	mem_write(*hl, theMemory[*hl] << 1);
	do_shift_test(theMemory[*hl]);
}

void sla_a()
{
	carryFlag = *a & 0x80;
	*a <<= 1;
	do_shift_test(*a);
}


/* shift right arithmetic operations preserve bit 7 */
void sra_b()
{
	work8 = *b & 0x80;
	carryFlag = *b & 0x01;
	*b = (*b >> 1) | work8;
	do_shift_test(*b);
}

void sra_c()
{
	work8 = *c & 0x80;
	carryFlag = *c & 0x01;
	*c = (*c >> 1) | work8;
	do_shift_test(*c);
}

void sra_d()
{
	work8 = *d & 0x80;
	carryFlag = *d & 0x01;
	*d = (*d >> 1) | work8;
	do_shift_test(*d);
}

void sra_e()
{
	work8 = *e & 0x80;
	carryFlag = *e & 0x01;
	*e = (*e >> 1) | work8;
	do_shift_test(*e);
}

void sra_h()
{
	work8 = *h & 0x80;
	carryFlag = *h & 0x01;
	*h = (*h >> 1) | work8;
	do_shift_test(*h);
}

void sra_l()
{
	work8 = *l & 0x80;
	carryFlag = *l & 0x01;
	*l = (*l >> 1) | work8;
	do_shift_test(*l);
}

void sra__hl_()
{
	work8 = theMemory[*hl] & 0x80;
	carryFlag = theMemory[*hl] & 0x01;
	mem_write(*hl,(theMemory[*hl] >> 1) | work8);
	do_shift_test(theMemory[*hl]);
}

void sra_a()
{
	work8 = *a & 0x80;
	carryFlag = *a & 0x01;
	*a = (*a >> 1) | work8;
	do_shift_test(*a);
}

/* wsl = weird shift left ;-)  These 8 ops. aren't documented.. */

void wsl_b()
{
	carryFlag = *b & 0x80;
	*b = (*b << 1) | 0x01;
	do_shift_test(*b);
}

void wsl_c()
{
	carryFlag = *c & 0x80;
	*c = (*c << 1) | 0x01;
	do_shift_test(*c);
}

void wsl_d()
{
	carryFlag = *d & 0x80;
	*d = (*d << 1) | 0x01;
	do_shift_test(*d);
}

void wsl_e()
{
	carryFlag = *e & 0x80;
	*e = (*e << 1) | 0x01;
	do_shift_test(*e);
}

void wsl_h()
{
	carryFlag = *h & 0x80;
	*h = (*h << 1) | 0x01;
	do_shift_test(*h);
}

void wsl_l()
{
	carryFlag = *l & 0x80;
	*l = (*l << 1) | 0x01;
	do_shift_test(*l);
}

void wsl__hl_()
{
	carryFlag = theMemory[*hl] & 0x80;
	mem_write(*hl, (theMemory[*hl] << 1) | 0x01);
	do_shift_test(theMemory[*hl]);
	
}

void wsl_a()
{
	carryFlag = *a & 0x80;
	*a = (*a << 1) | 0x01;
	do_shift_test(*a);
}


/* Shift right logical operations: bit 0 -> carry, 0 -> bit 7 */

void srl_b()
{
	carryFlag = *b & 0x01;
	*b >>= 1;
	do_shift_test(*b);
}

void srl_c()
{
	carryFlag = *c & 0x01;
	*c >>= 1;
	do_shift_test(*c);
}

void srl_d()
{
	carryFlag = *d & 0x01;
	*d >>= 1;
	do_shift_test(*d);
}

void srl_e()
{
	carryFlag = *e & 0x01;
	*e >>= 1;
	do_shift_test(*e);
}

void srl_h()
{
	carryFlag = *h & 0x01;
	*h >>= 1;
	do_shift_test(*h);
}

void srl_l()
{
	carryFlag = *l & 0x01;
	*l >>= 1;
	do_shift_test(*l);
}

void srl__hl_()
{
	carryFlag = theMemory[*hl] & 0x01;
	mem_write(*hl, theMemory[*hl] >> 1);
	do_shift_test(theMemory[*hl]);
}

void srl_a()
{
	carryFlag = *a & 0x01;
	*a >>= 1;
	do_shift_test(*a);
}


/* lots of bit-type things now... */

void bit_0_b()
{
	zeroFlag = !(*b & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0_c()
{
	zeroFlag = !(*c & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0_d()
{
	zeroFlag = !(*d & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0_e()
{
	zeroFlag = !(*e & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0_h()
{
	zeroFlag = !(*h & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0_l()
{
	zeroFlag = !(*l & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_0_a()
{
	zeroFlag = !(*a & 0x1);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_b()
{
	zeroFlag = !(*b & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_c()
{
	zeroFlag = !(*c & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_d()
{
	zeroFlag = !(*d & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_e()
{
	zeroFlag = !(*e & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_h()
{
	zeroFlag = !(*h & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_l()
{
	zeroFlag = !(*l & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_1_a()
{
	zeroFlag = !(*a & 0x2);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_b()
{
	zeroFlag = !(*b & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_c()
{
	zeroFlag = !(*c & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_d()
{
	zeroFlag = !(*d & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_e()
{
	zeroFlag = !(*e & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_h()
{
	zeroFlag = !(*h & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_l()
{
	zeroFlag = !(*l & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_2_a()
{
	zeroFlag = !(*a & 0x4);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_b()
{
	zeroFlag = !(*b & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_c()
{
	zeroFlag = !(*c & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_d()
{
	zeroFlag = !(*d & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_e()
{
	zeroFlag = !(*e & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_h()
{
	zeroFlag = !(*h & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_l()
{
	zeroFlag = !(*l & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_3_a()
{
	zeroFlag = !(*a & 0x8);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_b()
{
	zeroFlag = !(*b & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_c()
{
	zeroFlag = !(*c & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_d()
{
	zeroFlag = !(*d & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_e()
{
	zeroFlag = !(*e & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_h()
{
	zeroFlag = !(*h & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_l()
{
	zeroFlag = !(*l & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_4_a()
{
	zeroFlag = !(*a & 0x10);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_b()
{
	zeroFlag = !(*b & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_c()
{
	zeroFlag = !(*c & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_d()
{
	zeroFlag = !(*d & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_e()
{
	zeroFlag = !(*e & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_h()
{
	zeroFlag = !(*h & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_l()
{
	zeroFlag = !(*l & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_5_a()
{
	zeroFlag = !(*a & 0x20);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_b()
{
	zeroFlag = !(*b & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_c()
{
	zeroFlag = !(*c & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_d()
{
	zeroFlag = !(*d & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_e()
{
	zeroFlag = !(*e & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_h()
{
	zeroFlag = !(*h & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_l()
{
	zeroFlag = !(*l & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_6_a()
{
	zeroFlag = !(*a & 0x40);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_b()
{
	zeroFlag = !(*b & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_c()
{
	zeroFlag = !(*c & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_d()
{
	zeroFlag = !(*d & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_e()
{
	zeroFlag = !(*e & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_h()
{
	zeroFlag = !(*h & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_l()
{
	zeroFlag = !(*l & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7__hl_()
{
	zeroFlag = !(theMemory[*hl] & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void bit_7_a()
{
	zeroFlag = !(*a & 0x80);
	Set(hcarryFlag); Clr(addsubFlag);
}

void res_0_b()
{
	*b &= 0xfe;
}

void res_0_c()
{
	*c &= 0xfe;
}

void res_0_d()
{
	*d &= 0xfe;
}

void res_0_e()
{
	*e &= 0xfe;
}

void res_0_h()
{
	*h &= 0xfe;
}

void res_0_l()
{
	*l &= 0xfe;
}

void res_0__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xfe);
}

void res_0_a()
{
	*a &= 0xfe;
}

void res_1_b()
{
	*b &= 0xfd;
}

void res_1_c()
{
	*c &= 0xfd;
}

void res_1_d()
{
	*d &= 0xfd;
}

void res_1_e()
{
	*e &= 0xfd;
}

void res_1_h()
{
	*h &= 0xfd;
}

void res_1_l()
{
	*l &= 0xfd;
}

void res_1__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xfd);
}

void res_1_a()
{
	*a &= 0xfd;
}

void res_2_b()
{
	*b &= 0xfb;
}

void res_2_c()
{
	*c &= 0xfb;
}

void res_2_d()
{
	*d &= 0xfb;
}

void res_2_e()
{
	*e &= 0xfb;
}

void res_2_h()
{
	*h &= 0xfb;
}

void res_2_l()
{
	*l &= 0xfb;
}

void res_2__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xfb);
}

void res_2_a()
{
	*a &= 0xfb;
}

void res_3_b()
{
	*b &= 0xf7;
}

void res_3_c()
{
	*c &= 0xf7;
}

void res_3_d()
{
	*d &= 0xf7;
}

void res_3_e()
{
	*e &= 0xf7;
}

void res_3_h()
{
	*h &= 0xf7;
}

void res_3_l()
{
	*l &= 0xf7;
}

void res_3__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xf7);
}

void res_3_a()
{
	*a &= 0xf7;
}

void res_4_b()
{
	*b &= 0xef;
}

void res_4_c()
{
	*c &= 0xef;
}

void res_4_d()
{
	*d &= 0xef;
}

void res_4_e()
{
	*e &= 0xef;
}

void res_4_h()
{
	*h &= 0xef;
}

void res_4_l()
{
	*l &= 0xef;
}

void res_4__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xef);
}

void res_4_a()
{
	*a &= 0xef;
}

void res_5_b()
{
	*b &= 0xdf;
}

void res_5_c()
{
	*c &= 0xdf;
}

void res_5_d()
{
	*d &= 0xdf;
}

void res_5_e()
{
	*e &= 0xdf;
}

void res_5_h()
{
	*h &= 0xdf;
}

void res_5_l()
{
	*l &= 0xdf;
}

void res_5__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xdf);
}

void res_5_a()
{
	*a &= 0xdf;
}

void res_6_b()
{
	*b &= 0xbf;
}

void res_6_c()
{
	*c &= 0xbf;
}

void res_6_d()
{
	*d &= 0xbf;
}

void res_6_e()
{
	*e &= 0xbf;
}

void res_6_h()
{
	*h &= 0xbf;
}

void res_6_l()
{
	*l &= 0xbf;
}

void res_6__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0xbf);
}

void res_6_a()
{
	*a &= 0xbf;
}

void res_7_b()
{
	*b &= 0x7f;
}

void res_7_c()
{
	*c &= 0x7f;
}

void res_7_d()
{
	*d &= 0x7f;
}

void res_7_e()
{
	*e &= 0x7f;
}

void res_7_h()
{
	*h &= 0x7f;
}

void res_7_l()
{
	*l &= 0x7f;
}

void res_7__hl_()
{
	mem_write(*hl, theMemory[*hl] & 0x7f);
}

void res_7_a()
{
	*a &= 0x7f;
}

void set_0_b()
{
	*b |= 0x1;
}

void set_0_c()
{
	*c |= 0x1;
}

void set_0_d()
{
	*d |= 0x1;
}

void set_0_e()
{
	*e |= 0x1;
}

void set_0_h()
{
	*h |= 0x1;
}

void set_0_l()
{
	*l |= 0x1;
}

void set_0__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x01);
}

void set_0_a()
{
	*a |= 0x1;
}

void set_1_b()
{
	*b |= 0x2;
}

void set_1_c()
{
	*c |= 0x2;
}

void set_1_d()
{
	*d |= 0x2;
}

void set_1_e()
{
	*e |= 0x2;
}

void set_1_h()
{
	*h |= 0x2;
}

void set_1_l()
{
	*l |= 0x2;
}

void set_1__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x02);
}

void set_1_a()
{
	*a |= 0x2;
}

void set_2_b()
{
	*b |= 0x4;
}

void set_2_c()
{
	*c |= 0x4;
}

void set_2_d()
{
	*d |= 0x4;
}

void set_2_e()
{
	*e |= 0x4;
}

void set_2_h()
{
	*h |= 0x4;
}

void set_2_l()
{
	*l |= 0x4;
}

void set_2__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x04);
}

void set_2_a()
{
	*a |= 0x4;
}

void set_3_b()
{
	*b |= 0x8;
}

void set_3_c()
{
	*c |= 0x8;
}

void set_3_d()
{
	*d |= 0x8;
}

void set_3_e()
{
	*e |= 0x8;
}

void set_3_h()
{
	*h |= 0x8;
}

void set_3_l()
{
	*l |= 0x8;
}

void set_3__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x08);
}

void set_3_a()
{
	*a |= 0x8;
}

void set_4_b()
{
	*b |= 0x10;
}

void set_4_c()
{
	*c |= 0x10;
}

void set_4_d()
{
	*d |= 0x10;
}

void set_4_e()
{
	*e |= 0x10;
}

void set_4_h()
{
	*h |= 0x10;
}

void set_4_l()
{
	*l |= 0x10;
}

void set_4__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x10);
}

void set_4_a()
{
	*a |= 0x10;
}

void set_5_b()
{
	*b |= 0x20;
}

void set_5_c()
{
	*c |= 0x20;
}

void set_5_d()
{
	*d |= 0x20;
}

void set_5_e()
{
	*e |= 0x20;
}

void set_5_h()
{
	*h |= 0x20;
}

void set_5_l()
{
	*l |= 0x20;
}

void set_5__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x20);
}

void set_5_a()
{
	*a |= 0x20;
}

void set_6_b()
{
	*b |= 0x40;
}

void set_6_c()
{
	*c |= 0x40;
}

void set_6_d()
{
	*d |= 0x40;
}

void set_6_e()
{
	*e |= 0x40;
}

void set_6_h()
{
	*h |= 0x40;
}

void set_6_l()
{
	*l |= 0x40;
}

void set_6__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x40);
}

void set_6_a()
{
	*a |= 0x40;
}

void set_7_b()
{
	*b |= 0x80;
}

void set_7_c()
{
	*c |= 0x80;
}

void set_7_d()
{
	*d |= 0x80;
}

void set_7_e()
{
	*e |= 0x80;
}

void set_7_h()
{
	*h |= 0x80;
}

void set_7_l()
{
	*l |= 0x80;
}

void set_7__hl_()
{
	mem_write(*hl, theMemory[*hl] | 0x80);
}

void set_7_a()
{
	*a |= 0x80;
}

