/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  init.c                                                       */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <strings.h>
#include <ntape.h>

tape_entry   *tape;                            /* Infos about current tape */
file_entry   *archive;                         /* Infos about sel. archive */
char         tapedevice[TAPEDEVICELEN];        /* Normally /dev/tape */
unsigned int add_info;                         /* Additional info to archive */
int          sort_type,                        /* How to sort listbox */
             sort_ascdesc,                     /* Sort listbox ascending/descending */
             no_platforms,                     /* How many platforms are given ? */
             no_categories,                    /* How many categories are given ? */
             watch_tape;                       /* Watch tape operations ? */
char         tape_db[MAXLEN],                  /* Tape database path */
             archive_db[MAXLEN],               /* Archive database path */
             contents_db[MAXLEN];              /* Archive contents db path */
char	     platform[NO_PLATFORMS][PFLENGTH]; /* Platforms see .ntaperc */
char	     category[NO_CATEGORIES][CATEGORYLENGTH]; /* Categories see .ntaperc */
long         last_tape_pos,                    /* Position of the last tape that was active */
             last_tape_id;                     /* ID of the last tape that was active */

/*************************************************************************/
/* Name:     nta_init                                                    */
/* Purpose:  Init: Parse the .ntaperc-File, init some global vars        */
/*************************************************************************/
void nta_init()
{
    FILE *rcfp;
    char path[MAXLEN];
    char *arg1,*arg2;
    int i;
    int pf = 0, cat = 0;

    /* Init current tape vars */
    last_tape_pos = 0;
    last_tape_id = 0;
    sort_type = 0;
    sort_ascdesc = 0;
    add_info = 0;
    watch_tape = 0;
    searchstring[0] = '\0';
    archive = (file_entry *) malloc(sizeof(file_entry));
    tape = (tape_entry *) malloc(sizeof(tape_entry));
    tape->name[0] = '\0';
    tape->id = 0;

    strcpy(path, getenv("HOME"));
    strcat(path, "/");
    strcat(path, NTAPERC);
    if ((rcfp = fopen(path, "r")) == NULL)
    {
	fprintf(stderr, "No %s file found. Exiting...\n", NTAPERC);
	exit(1);
    }
    while (fgets(path, MAXLEN-1, rcfp) != NULL)
    {
	path[strlen(path) - 1] = '\0';
	for (i = 0; i < strlen(path) && path[i] != '#'; i++)
	    ;
	path[i] = '\0';
	arg1 = strtok(path," \t");
	if (arg1 == NULL)
	    continue;
	
	arg2 = strtok(NULL," \t");
	if (arg2 == NULL)
	    continue;
	for (i = 0; i < strlen(arg1); i++)
	    arg1[i] = toupper(arg1[i]);

	if (!strcmp(arg1, "DATABASEPATH"))
	{
	    sprintf(tape_db, "%s/ntape_tapes",arg2);
	    sprintf(archive_db, "%s/ntape_archives",arg2);
	    sprintf(contents_db, "%s/ntape_contents",arg2);
#ifdef DEBUG
	    fprintf(stderr,"nta_init: %s\nnta_init: %s\nnta_init: %s\n", 
		    tape_db, archive_db, contents_db);
#endif
	    continue;
	}

	if (!strcmp(arg1, "PLATFORM"))
	{
	    if (pf < NO_PLATFORMS)
	    {
		strcpy(platform[pf],arg2);
#ifdef DEBUG
		fprintf(stderr,"nta_init: Platform %d: %s\n",pf,platform[pf]);
#endif
		pf++;
		continue;
	    }
#ifdef DEBUG
	    else
		fprintf(stderr,"nta_init: Number of Platforms exceeded! %s not registered!\n",
			arg2);
#endif
	}

	if (!strcmp(arg1, "CATEGORY"))
	{
	    if (cat < NO_CATEGORIES)
	    {
		strcpy(category[cat],arg2);
#ifdef DEBUG
		fprintf(stderr,"nta_init: Category %d: %s\n",cat,category[cat]);
#endif
		cat++;
		continue;
	    }
#ifdef DEBUG
	    else
		fprintf(stderr,"nta_init: Number of Categories exceeded! %s not registered!\n",
			arg2);
#endif
	}

	for (i = 0; i < strlen(arg2); i++)
	    arg2[i] = toupper(arg2[i]);

	if (!strncmp(arg1, "COL", 3))          /* A color pair config line */
	    config_color_pair(arg1,arg2);
	
	if (!strcmp(arg1, "DEFAULTSORTORDER"))
	{
	    if (!strcmp(arg2, "NAME"))
		sort_type = 0;
	    else if (!strcmp(arg2, "SIZE"))
		sort_type = 1;
	    else if (!strcmp(arg2, "POSITION"))
		sort_type = 2;
#ifdef DEBUG
	    fprintf(stderr,"nta_init: sort_type %d\n",sort_type);
#endif
	    continue;
	}
	
	if (!strcmp(arg1, "DEFAULTSORTTYPE"))
	{
	    if (!strcmp(arg2, "ASCENDING"))
		sort_ascdesc = 0;
	    else if (!strcmp(arg2, "DESCENDING"))
		sort_ascdesc = 1;
#ifdef DEBUG
	    fprintf(stderr,"nta_init: Sort %s\n",
		    sort_ascdesc == 0 ? "ASCENDING" : "DESCENDING");
#endif
	    continue;
	}

	if (!strcmp(arg1, "SAVECONTENTS"))
	{
	    if (!strcmp(arg2, "YES"))
		add_info |= CONTENTS_SAVED;
#ifdef DEBUG
	    fprintf(stderr,"nta_init: Additional Info: $%x\n",add_info);
#endif
	    continue;
	}

	if (!strcmp(arg1, "WATCHTAPE"))
	{
	    if (!strcmp(arg2, "YES"))
		watch_tape = 1;
#ifdef DEBUG
	    fprintf(stderr,"nta_init: Watching tape operations: %s\n",
		    watch_tape ? "Yes" : "No");
#endif
	}
    }
    platform[pf][0] = '\0';
    category[cat][0] = '\0';
    no_platforms = pf;
    no_categories = cat;
    if (getenv("TAPE") == NULL)
    {
	fprintf(stderr,"Environment variable TAPE undefined. Exiting...");
	exit(1);
    }
    strcpy(tapedevice, getenv("TAPE"));
    popup_active = 0;
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
