/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  entryfld.c                                                   */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <strings.h>
#include <ntape.h>

static int chosen_cell;
static char *button[] = {"   OK   "," Cancel "};
static WINDOW *entryfld;

void draw_contents(char *,int,int);

/*************************************************************************/
/* Name:     EntryField                                                  */
/* Purpose:  Opens and manages a window for text entries                 */
/*************************************************************************/
void EntryField(char *msg,int len,char *input,int active,char *deflt,
		int extchars)
{
    int i, j, c, max, lines = 0, fertig = 0;
    char line[256];
  
    max = len + 3;
    for (i = 0, j = 0; i <= strlen(msg); i++,j++)
    {
	if (msg[i] == '\n' || msg[i] == '\0')
	{
	    if (max < j)
		max = j;
	    j = 0;
	    lines++;
	}
    }
  
    entryfld = newwin(5+lines,max+3,(LINES-3-5-lines)/2+2,(COLS-max-3)/2);
    leaveok(entryfld,TRUE);
    keypad(entryfld,TRUE);
    set_color_pair(entryfld,INPUTDIALOG);
    winclr(entryfld);
  
    for (c = 1,i = 0,j = 0; i <= strlen(msg); i++,j++)
    {
	line[j] = msg[i];
	if (msg[i] == '\n' || msg[i] == '\0')
        {
	    line[j] = '\0';
	  
	    mvwaddstr(entryfld,c,(max+3-j)/2,line);
	    winclrtoeol(entryfld);
	    j = -1;
	    c++;
        }
    }
    box(entryfld,ACS_VLINE,ACS_HLINE);

    i = 0;
    chosen_cell = active;
    strcpy(input,deflt);
    i = strlen(input);
    
    while(!fertig)
    {
	draw_contents(input,lines,len);
	touchwin(entryfld);
	wrefresh(entryfld);
	c = getch();
	if (c == TAB_KEY || c == KEY_LEFT || c == KEY_RIGHT)
	{
	    chosen_cell = 1 - chosen_cell;
	}
	else if (c == CR_KEY)
	{
	    fertig = 1;
	    if (chosen_cell == 1)
		input[0] = '\0';
	}
	else if (c == BS_KEY1 || c == BS_KEY2 || c == KEY_BACKSPACE)
	{
	    if (i > 0)
		input[--i] = '\0';
	}
	else if (strchr(VALIDCHARSTR,c) || 
		 (extchars == WITH_SPECIAL_CHARS && strchr(SPECIALCHARSTR,c)))
	{
	    if (i < len - 1)
	    {
		input[i] = c;
		input[++i] = '\0';
	    }
	}
	
    }
    delwin(entryfld);
    touchwin(listbox);
    wrefresh(listbox);
}


/*************************************************************************/
/* Name:     draw_contents                                               */
/* Purpose:  Draw the entryfield and the buttons                         */
/*************************************************************************/
void draw_contents(char *text,int lines,int length)
{
    int i;
    char txt[MAXLEN];

    set_color_pair(entryfld,ENTRYFIELD);
    strcpy(txt,text);
    for (i = strlen(txt) + 1; i < length; i++)
	strcat(txt," ");

    mvwaddstr(entryfld,lines+1,(entryfld->_maxx - length + 2) / 2,txt);

    for (i = 0; i < 2; i++)
    {
	if (i == chosen_cell)
	    set_color_pair(entryfld,INV_INPUTDIALOG);
	else
	    set_color_pair(entryfld,INPUTDIALOG);
	if (i == 0)
	    mvwaddstr(entryfld,lines+3,(entryfld->_maxx - 16) / 2,button[0]);
	else
	    mvwaddstr(entryfld,lines+3,(entryfld->_maxx - 16) / 2 + 10,button[1]);
    }
}
  
/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
