/*	$Header$
	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

Created by:

	David Sugar, Tycho Softworks
   	E-Mail: dyfet@aol.com, BBS: 201-858-3429

Synopsis:

	Interface to master server control task which maintains system
	and error logs for a server group.

History:

	$Logs$
*/

#ifndef	__LOGS_H__
#define	__LOGS_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#include <time.h>

typedef	struct
{
	short	log_level;
	char	log_text[128];
}	SYSLOG;

typedef	struct
{
	time_t	audit_time;
	long	audit_size;
	char	audit_userid[17];
	char	audit_class[17];
	char	audit_jobtype[17];
}	AUDIT;

enum
{
	__DAYLOG=1,
	__WKLOG,
	__MONLOG
};

#define	print_joblog(logpath, logtype, jobtype, jobsize, jobstatus) print_logfile(logpath, logtype, "%-16s %10d %s", jobtype, (long)jobsize, logstatus)

IMPORT	char	*name_logfile PROTO((int logtype, time_t date));
IMPORT	int		print_logfile PROTO((char *logpath, int logtype, char *logmsg, ...));
IMPORT	int		write_logfile PROTO((char *logpath, int logtype, PTR addr, int len));
IMPORT	int		print_syslog PROTO((int level, char *text, ...));
IMPORT	int		audit_logfile PROTO((int logtype, char *jobclass, char *jobtype, long jobsize));
IMPORT	int		islogged PROTO((char *logpath));

#endif
