#ifndef	__CRON_H__
#define	__CRON_H__

#include <stdio.h>

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

typedef	FILE * CRONTAB;

typedef	struct
{
	char	*cr_min;
	char	*cr_hour;
	char	*cr_day;
	char	*cr_mon;
	char	*cr_dow;
	char	*cr_cmd;
}	CRON;

#define	open_cron(fname, mode)	(CRONTAB)fopen(fname, mode)
#define	close_cron(crontab)		fclose((FILE *)crontab)

CRON	*read_cron PROTO((CRONTAB tab));
CRON	*write_cron PROTO((CRONTAB tab, CRON *entry));
CRON	*remove_cron PROTO((char *job));
CRON	*replace_cron PROTO((CRON *entry));
CRON	*append_cron PROTO((CRON *entry));
#endif
