/*  Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

	Private declairations used by internal VU support routines.
*/

#include <vu.h>

typedef struct  eventq
{
	VUPORT  evport;
	EVENT   event;
	PARM    ev_p1,ev_p2;
}   EVENTQ;

typedef struct  redrawq
{
	EVENT   redmode;
	VUPORT  redvu;      /* or null */
	RECT    redrc;
}   REDRAWQ;

typedef struct  queue
{
	int     qsize;
	int     qhead;
	int     qtail;
}   QUEUE;

typedef struct                      /* internal user preference record */
{
	long    prefnext;               /* next linked preference record */
	int     prefid;                 /* preference id type (0==desktop) */
	char    prefs[64];              /* 64 byte preference record */
}   VUPREFDATA;

typedef struct                      /* preference user header record */
{
	long    preflink;               /* next hash and scavange entry */
	time_t  prefset,prefchk;        /* last access times */
	long    prefdata;               /* link to data */
	char    prefuser[18];           /* user id */
}   VUPREFUSER;

typedef struct
{
	char    prefsysid[4];           /* pref file identifier */
	long    prefhash[255];          /* hash table by user id */
	long    prefscavange;           /* scavanger list */
	long    prefdatafree;           /* data records freed by scavanger */
}   VUPREFHDR;

/*  system build constants */

#define MAXEVQ  16          /* maximum event queue size */
#define MAXRDQ  16          /* maximum redraw queue size */

extern  time_t  _login_time,_event_time;

