/*****************************************************************************
*                           Linux OMEN Reader 1.0                            *
*                  Copyrights (c) 1995 by Ville Hallivuori.                  *
*                                                                            *
*    This program is free software; you can redistribute it and/or modify    *
*    it under the terms of the GNU General Public License version 2 as       *
*    published by the Free Software Foundation.                              *
*                                                                            *
*    This program is distributed in the hope that it will be useful,         *
*    but WITHOUT ANY WARRANTY; without even the implied warranty of          *
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
*    GNU General Public License for more details.                            *
*                                                                            *
*    You should have received a copy of the GNU General Public License       *
*    along with this program; if not, write to the Free Software             *
*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               *
*                                                                            *
*****************************************************************************/


/*****************************************************************************
* Some constants. Note that more space you reserve for skipping, more memory *
* will go. 999 should be enought for evryone. Feel free to change SkipSpace. *
*****************************************************************************/

char Version[]="1.65";                        //Versionnumber. Do NOT change.
const int MaxNameSkip=1000;                   //How many writers may skipped
const int MaxSubjSkip=1000;                   //How many subject may slipped
const int MaxBoardA=1000;                     //How many boards is maximum
const int MaxMessages=1000;                   //How many messaes is in 1 packet


/*****************************************************************************
* Screen handling routines (ANSI/VT-100 required)                            *
*****************************************************************************/

void TextColor(int tfgcolor);                 //Changes text's foreground-color
void TextBackColor(int tbgcolor);             //Changes text's background-color
void BoldText(void);                          //Bolds text
void ClrAttrib(void);                         //Clears all attributes (eg bold)
void EraseDisplay(void);                      //Clears screen
void GotoXY(int, int);                        //Moves cursor position X,Y


/*****************************************************************************
* Functions which are called from menubar (most of these make own instance   *
* from some class)                                                           *
*****************************************************************************/

void ExitMnu(void);                           //"Exit"
void ReturnMListBox(void);                    //"Close session"
void RmSessionL(void);                        //"Remove session"
void RP(void);                                //"Reply-packet"
void FindFirst(void);                         //"Find"
void FindNext(void);                          //"Finds next"
void Markings(void);                          //"Bookmarks
void MTY(void);                               //"Messages to you"
void Save2File(void);                         //"Save to file"
void SkipSubject(void);                       //"Skip subject"
void SkipName(void);                          //"Skip writer"
void ReplyMsg(void);                          //"Folowup"
void PostNewMsg(void);                        //"Post message"
void LOper(void);                             //"List operations"
void RmMsg(void);                             //"Remove message (SysOp)"
void MvMsg(void);                             //"Move Message   (SysOp)"
void MkPriv(void);                            //"Make private   (SysOp)"
void Index(void);                             //"Index"
void RHelp(void);                             //"Keys"

void ExitNow(void);                           //"Exit"
void setglobal(void);                         //"Global settings"
void setbbs(void);                            //"Settings for BBS"
void SHelp(void);                             //"Keys"

void LAbout(void);                            //Displays aboutbox.
void NYI(void);                               //Shows "Not Yet Implemented"


/*****************************************************************************
* Some global functions and variables, which make life lot more easier       *
*****************************************************************************/

void MakeMenu(void);                          //Creates menubars
void DrawBackGround(void);                    //Draws bg (menu-class uses this)
int SManager;                                 //1 if we are reading messages 
typedef void(*MFP)();                         //Menues param type (function)
void strConvert(unsigned char *TTC);          //Converts incoming strings
unsigned char Convert(unsigned char);         //Converts incoming chars
void resetOT(void);                           //Clears OutText
void oaddstr(char Str[9], int position);      //Add string to OutText
void strnadd(char *addto, int addpos, char *addfrom, int addn); //Very usefull
void uitos(unsigned int INro, char *Out);     //Unsigned integer->string (3ch)
void ReadBNames(char *FileName);              //Reads BNAMESxy.BBS
     
char FindText[28];                            //Text to fid
int FFDone;                                   //1, if find first has been used
int sessionindex;                             //Index for MListBox class
int pid_m;                                    //pid of lores main-procces
int HasColors;                                //1 if terminal suport colors


/*****************************************************************************
* Symbolic names to ANSI-colors                                              *
*****************************************************************************/

const char AnsiBegin=27;  //Esc character ((begin of ANSI sequence).
const int black=30;       //Color constants.
const int red=31;
const int green=32;
const int yellow=33;
const int blue=34;
const int magenda=35;
const int cyan=36;
const int white=37;


/*****************************************************************************
* colors of various elments. Change these if you want diferent look.         *
* For Black and White terminals you can define reverse-video putting +1000   *
* after color name (previous definitions). You can use allso bold-attribute  *
* putting +100 after colorattribute.                                         *
*****************************************************************************/

int MnuFgColor=black;              //Menubar's foreground-color
int MnuBgColor=cyan;               //Menubar's background-color
int MnuBrdColor=blue;              //Menubar's border's foreground-color
int MnuBrdBgColor=cyan+1000;       //Menubar's border's background-color
int AMnuFgColor=white+100;         //Active's menuitem's foreground-color
int AMnuBgColor=red+1000;          //Active's menuitem's background-color
int HdrFgColor=black;              //Color of message's header
int HdrBgColor=white+1000;         //Color of message's header's background
int MsgFgColor=white;              //Color of message-text
int MsgBgColor=blue;               //Color of message-text's background
int StatFgColor=black;             //Statusline's foreground-color
int StatBgColor=cyan+1000;         //Statusline's background-color
int WinFgColor=black;              //Window's foreground-color
int WinBgColor=cyan;               //Window's background-color
int WinBFgColor=black;             //Window's border's foreground-color
int WinBBgColor=cyan+1000;         //Window's border's background-color
int TextBoxFgColor=white;          //TextBox's foreground-color
int TextBoxBgColor=blue;           //TextBox's background-color
int ATextBoxFgColor=white+100;     //Selected TextBox's foreground-color
int ATextBoxBgColor=red+1000;      //Selected TextBox's background-color
int SLstFgColor=white;             //Listbox's foreground-color
int SLstBgColor=blue;              //Listbox's background-color
int ASLstFgColor=blue;             //Active ListBox's foreground-color
int ASLstBgColor=white+1000;       //Active ListBox's background-color
int CBoxFgColor=black;             //CheckBox's foreground-color
int CBoxBgColor=cyan;              //CheckBox's background-color
int ACBoxFgColor=white+100;        //Active CheckBox's foreground-color
int ACBoxBgColor=red+1000;         //Active CheckBox's background-color
int VSelectFgColor=white;          //Vertical selection's foreground-color
int VSelectBgColor=blue;           //Vertical selection's background-color
int AVSelectFgColor=white+100;     //Active Vertical selection's fg-color
int AVSelectBgColor=red+1000;      //Active Vertical selection's bg-color


/*****************************************************************************
* This class keeps track on skipped messages                                 *
*****************************************************************************/

class SkipList                     //Keeps track on skipped messages
{
public:
  SkipList(void);
  SkipList (const SkipList &);
  int LastName;                    //Number of skipped names (starting from 0)
  char *Names[MaxNameSkip];        //Pointers to skipped names
  int LastSubject;                 //Number of skipped subjects (--||--)
  char *Subjects[MaxSubjSkip];     //Pointers to skipped subjects
  void ReadFiles(void);            //Reads skipfiles
  int IsSkipped(int MsgNro);       //Test, if msg has been skipped
};


/*****************************************************************************
* ListBox -widget                                                            *
*****************************************************************************/

class ListBox                      //ListBox -widget
{
private:
  int X1,Y1,X2,Y2;                 //Coordinates
  int OnSrcItem;                   //Firs item on screen
  int CurItem;                     //Index of curent item
  void DrawItem(int Index);        //Draws one item
  void ScrollDown(void);           //Scrolls listbox down
  void ScrollUp(void);             //Scrolls listbox up
public:
  char Items[1000][80];            //All items
  int LastItem;                    //Index of last item
  ListBox(int Xc1, int Yc1, int Xc2, int Yc2, int CI); //Initial parameters
  void AddItem(char *AItem);       //Adds item to listbox
  void ModifyItem(char *AItem, int ItemNro);  //Modify listbox-item
  void Draw(void);                 //Draws list and background
  int Handle(void);                //User-interface
};


/*****************************************************************************
* TextBox -widget (input-field)                                              *
*****************************************************************************/

class TextBox                      //TextBox -widget (input-field)
{
private:
  char *Text;                      //Text to edit
  int SPos;                        //Length of text whic don't fit to field
  int Status;                      //Is field active/inactive
public:
  int X1,X2,Y;                     //Coordinates
  TextBox(int Xc1,int Xc2,int Yc,char *PText); //Initial values
  void Draw(void);                 //Draws textbox     
  int ReadInput(int MaxPos);       //User-interface
};


/*****************************************************************************
* Posts message (new message, folowup, move, delete pub/priv togle)          *
*****************************************************************************/

class PostMsg
{
private:
  unsigned int BrdIndex;           //Boards placement in array
  unsigned int Board;              //Which board message will be placed
  unsigned int MoveTo;             //Which board message will be moved
  unsigned int ReplyTo;            //Number of original message
  char Subject[74];                //Subject of message
  char WhoTo[74];                  //Receirver of message
  int Security;                    //Public/private
  int DestZone;                    //NetMail addres
  int DestNet;
  int DestNode;
  int MsgType;                     //1=new, 2=reply, 3=delete, 4=move, 5=priv.
  int AskBoard(void);              //Asks where message will be put
  int AskMsgInfo(void);            //Ask subject, reseirver, P/R
  int AskNetMail(void);            //Ask information ned by netmail
  void GetFreeNames(char *MsgFile, char *HeaderFile);
  void EditMessage(char *MsgFile);    //Loads file to editor
  void WriteHeader(char *HeaderFile); //Writes message header to file
public:
  int NewMessage(void);            //Posts new message
  int ReplyMessage(void);          //Replys to message
  int RemoveMsg(void);             //Removes message (SysOp only)
  int MoveMsg(void);               //Moves message (SysOp only)
  int MakePrivate(void);           //Makes msg private (SysOp only)
};


/*****************************************************************************
* Class to show/reedit/undo all operations create by PostMsg -class          *
*****************************************************************************/

class OperList                     //Creates list of operations
{
private:
  ListBox *lst_Operations;         //List of operations
  void GetBoardName(unsigned int BrdNum, char *BrdName); //Brd number -> -name
  void MsgMnu(int Index);          //Things to do message (menu)
  void UndoMnu(int Index);         //Undo operation
public:
  ListBox (const ListBox &);
  void ReadOperations(void);       //Reads all headerfile
  int LastOperation;               //Number of operations (-1=0, 0=1, ...);
  struct OStruct                   //Struct to save found operations
   {
     char Command;
     unsigned int CurBoard;
     unsigned int MoveBoard;
     char WhoTo[36];
     char Subject[73];
     char Extension[4];           //Info to reconstruct filenames
     char IDchars[3];
     char FIndex[4];
   };
  OStruct *Operations;           //Pointer to array of OStuct's
  void LisOper(void);            //Lists all operatons
};


/*****************************************************************************
* Class to create return-packet (handles allso converting characters)        *
*****************************************************************************/

class RPacket
{
private:
  OperList *OList;               //OperList havesome information for RPacket.
  void OstrConvert(unsigned char *TTC); //Converts outgoing character
  unsigned char OConvert(unsigned char Text); //Converts outgoing strings
  void ClearTemp(void);          //Clears temp-directory
  void WriteHeader(void);        //Writes one header from deparate headers
  void WriteMessages(void);      //Writes messagefiles 
  void WriteSkip(void);          //Copyes skipfile
  void WriteTrash(void);         //Creates trash-file (unwanted writers)
  void ZipPackets(void);         //Zips returnpacket
  int IsOld(void);               //Removes old messagepackets
public:
  RPacket (const RPacket &);
  void WriteAll(void);           //Creates returnpacket
  RPacket();                     //Constructor
  ~RPacket();                    //Destructor
};


/*****************************************************************************
* Window -widget                                                             *
*****************************************************************************/

class Window                     //Window -widget
{
private:
  char *Caption;                 //Pointer to window's caption
public:
  int X1;                        //Coordinates
  int Y1;
  int X2;
  int Y2;
  Window(int WX1,int WY1,int WX2,int WY2,char *WCaption); //Initial values
  void Draw(void);               //Draws window
};


/*****************************************************************************
* Class which contain all information from SYSTEMxy.BBS -file                *
*****************************************************************************/

class BBSInfo                    //Contains all data from SYSTEMxy.BBS -file
{
private:
  ifstream *SystemFile;          //Stream from  SYSTEMxy.BBS -file
  int ReadSysName(void);         //Reads name of BBS-system
  int ReadBoardInfo(int Nro, unsigned char linput); //Reads boards
public:
  BBSInfo (const BBSInfo &);
  int MaxBoard;                  //Number of last board (internal)
  char SystemName[42];           //Name of system
  struct BrdRecord               //Info about boards
  {
    unsigned int BrdNro;         //Number of board
    unsigned char BrdStatus;     //Statusbits
    char *BrdName;               //Name of board
  };
  BrdRecord Boards[MaxBoardA];   //Aray to store board-information
  BBSInfo(char FileName[100]);   //Initial values
  ~BBSInfo();
  void ReadFile(void);           //Reads file to memory
};


/*****************************************************************************
* Class which contain all information from NEWMSGxy.TXT -file                *
*****************************************************************************/

class Messages                   //Contains all data from NEWMSGxy.TXT -file
{
private:
  ifstream MsgFile;              //Stream from NEWMSGxy.TXT
  int EatWhiteSpace(void);       //Reads SkipListextra spaces
  int ReadMsgNro(int CurMsg);    //Read MessageNumber
  void ReadBrdName(int CurMsg);  //Reads board name
  void ReadMsgDate(int CurMsg);  //Reads date of message
  void ReadMsgStatus(int CurMsg);//Reads message's status
  void ReadWhoFrom(int CurMsg);  //Reads writers name
  void ReadWhoTo(int CurMsg);    //Read receiver's name
  void ReadSubject(int CurMsg);  //Reads subject
  void ReadBodyText(int CurMsg); //Reads message
public:
  Messages (const Messages &);
  struct MsgRecord               //Information about message
  {
    unsigned int MsgNum;         //Messagenumber
    unsigned int BrdNum;         //Boardnumber
    char BrdName[81];            //Name of board
    char Date[10];               //Creationg date of message
    char Time[10];               //Creationg time of message
    char Chain[12];              //Previos/nex message
    unsigned int Status;         //Private/public status
    char From[36];               //Writer of message
    char To[36];                 //Receirver of message
    char Subject[73];            //Subject of message
    char *tpointer;              //Pointer to messages bodytext
  };
  MsgRecord MBase[MaxMessages];   //Array storing all data abou of messages
  int MaxMsg;                    //Number of messages (starting from 0)
  Messages(char FileName[100]);  //Constructor
  ~Messages(void);               //Destructor
  void ReadMessages(void);       //Reads messages from file
};

/*****************************************************************************
* Session selection list                                                     *
*****************************************************************************/

class MListBox                   //Session selection list
{
private: 
  int LastItem;                  //Index of last item
  int OnSrcItem;                 //Firs item on screen
  void ReadSessions(void);       //Reads list of open sessions
  void DrawSubject(void);        //Open sessions/No open sessions -line
  void DrawItem(int Index);      //Draws one item
  void ScrollDown(void);         //Scrolls list down
  void ScrollUp(void);           //Scrolls list up
  void ReadMsg(void);            //Goes to reading-mode
  void StatusLine(void);         //Draws statusline
public:
  struct IStruct                 //Struct to save info about open sessions
  {
    char Name[42];               //BBS name
    char Date[12];               //First openingdate of session
    char IDc[3];                 //IDchars of session
    char Index[4];               //Index of session (extension)
  };
  IStruct Items[1000];           //Array to save sessions
  int CurItem;                   //Index of curent item
  void Draw(void);               //Draws list and background
  MListBox(void);                //Constructor
  void Handle(void);             //User-interface
  void RmSession(void);          //Removes session
};


/*****************************************************************************
*  All LORE's configuration info                                             *
*****************************************************************************/

class Config                     //All LORE's configuration info
{
private:
  Window *SWin;                  //Pointer to Globat/BBS settings window
public:
  Config (const Config &);
  char LoreHome[200];            //Full  path of "~/.LORE/"
  char DownLoad[200];            //DownLoad directory
  char UpLoad[200];              //UpLoad directory
  char Editor[200];              //Editor name (needs ful path)
  char Signature[200];           //Signature -file
  char TagLine[200];             //TagLines -file
  char UName[33];                //Name of user in selected BBS
  char UAlias[33];               //Alias of user in selected BBS
  int OutChars;                  //0=latin, 1=ibm, 2=sf7
  int IBMConv;                   //0=no conversion, 1=conversion
  int SF7Conv;                   //0=no conversion, 1=conversion
  Config(void);                  //Initial variables
  void ReadGConfig(void);        //Reads settings from file
  int ReadBBS(int IndexID);      //Reads BBS-settings from file 
  void SetGlob(void);            //Modifyes globat settings
  void SetBBS(int IndexID);      //Modifyes BBS settings
};


/*****************************************************************************
*  Vertical select -vidget                                                   *
*****************************************************************************/

class VSelect                    //Vertical select -vidget
{
private:
  int X1,X2,Y;                   //Coordinates
  int LastItem;                  //Index of last item
public:
  int Active;                    //Index of active item
  char Items[10][30];            //Max 10 items, max 29 chars each
  VSelect(int Xc1,int Xc2,int Yc,int MaxItem); //Initial values
  void Draw(int State);          //Draws widget (parameter: 1=active, 0=inact.)
  int VSelect::Handle(void);     //UserInterface
};


/*****************************************************************************
*  CheckBox -vidget                                                          *
*****************************************************************************/

class CheckBox                   //CheckBox -vidget
{
private:
  int X,Y;                       //Coordinates
  char *Caption;                 //Pointer to CheckBox's caption
public:
  CheckBox (const CheckBox &);
  CheckBox(int Xc,int Yc,char *Capt, int DefStat=1); //Initial values
  void Draw(int AState);         //Draws vidget (parameter: 1=actv. 0=inactiv.)
  int Handle(void);              //UserInterface
  int Status;                    //0= not checked, 1=checked
};


/*****************************************************************************
*  MenuBar -vidget                                                           *
*****************************************************************************/

class AppMenus                   //MenuBar -vidget
{
private:
  struct MnuBase                 //Info about menuitem
  {
    char Name[30];
    int ParentNro;
    int Type;
    int PosX;
    int PosY;
    MFP MFunction;
  };
  MnuBase MBase[100];            //Struct's of menuitems
  int OMenu;                     //Old selected menu
  int Update;                    //Updateleve: bigger value = bigger update
  int MMenuLoop(void);           //UserInterface for root-menus
  int MxMenu;                    //Index of last menu-item
  int CMenu;                     //Selected menu-item
  int SeekMenu(int MType, int MenuOH); //Searsh next menu, whic has same parent
  void HBMenuBar(int MnuNro, int Type); //Partial redraw of MenuBar (1st line)
  int GetMLen(int ParentNro);    //Get menu's with
  int GetRParent(int MnuNro);    //Get's original parent of menu
  void DrawMenu(void);           //Draws menu depending Update-level
  int NextSMnu(void);            //Finds next submenu
  int PrevSMnu(void);            //Finds previous submenu
  int NextMMnu(void);            //Finds next mainmenu
  int PrevMMnu(void);            //Finds previous mainmenu
  int MenuLoop(void);            //MainLoop of menuvidget
  void DrawSep(int SepWidth, int SepNro); //Draws separator (type 2)
  void DrawSMenu(void);          //Draws submenu
  void HSMenu(int Menu, int Type); //Partial draw of submnu (sel+unsel item)
public:
  AppMenus(void);                //Initial values
  int AddMenu(char MName[30], int PNro, int Type=1, MFP MF=&NYI); //Adds menu
  int Handle(void);              //Userinterface
  void BMenuBar(void);           //Draws menubar (1st line)
};


/*****************************************************************************
*  Userinterface to look messages                                            *
*****************************************************************************/

class MsgScreen                  //Userinterface to look messages
{
private:
  char PointerName[200];         //Name of POINTERSxy.zzz  
  void DrawMsgLine(int AddLine); //Draws one line of message
  int update;                    //UpdateLevel
  void StatusLine(void);         //Draws statusline
public:
  int msgpos;                    //Position of message
  MsgScreen(int Index);          //Initial values (reads messagepointers)
  ~MsgScreen(void);              //Saves messagepointers
  char MsgText[1005] [85];       //Text of selected message
  int MxLine;                    //Last line of message
  void Handle(void);             //Userinterface
  void DrawMessage(int DLines);
  void DrawHeader(void);
  void NextMessage(int operation);
  int exit;
};


/*****************************************************************************
*  File Handler - unzips new messages                                        *
*****************************************************************************/

class FHandler                   //File Handler - unzips new messages
{
private:
  FHandler (const FHandler &);
  char Down[200];                //Download directory
  char FExt[5];                  //Files extension
  char DownMask[200];            //All OMEN-packets
  char TmpDir[200];              // ~/.LORE/tmp/
  char LoreDir[200];             // ~/.LORE
  char FileMask[200];            // ~/.LORE/NEWMSGxy.???
  char IDc[3];                   //ID-characters (xy on filename)
  void itos(int INro);           //Converts integer to string (INro<=999)
  void ReadIDChars(char *FileName); //Reads ID-characters
  int GetFreeNro(void);          //Gets first fee number for extension
  void UnZip(char *FileName, char *ToDir); //UnZips messages
  void Move(void);               //Moves files to LoreDir
  char *CutName(char *FName);    //Separates files-name and -path
  void AddEntry(char *Ext);      //Adds entry to sessions.dat
  void ReMove(char *FileName);   //Removes Zipped packet
public:
  FHandler(void);                //Initial values
  ~FHandler(void);               //Unused
  void GetNew(void);             //Gets new omenpackets
};

/*****************************************************************************
*  Symbolic names of menus                                                   *
*****************************************************************************/

//Menus while reading messages
int mnu_root;
  int mnu_about;
  int mnu_exit;
int mnu_file;
  int mnu_closesession;
  int mnu_removesession;
  int mnu_replypacket;
int mnu_edit;
  int mnu_find;
  int mnu_findnext;
  int mnu_markings;
  int mnu_messagestoyou;
  int mnu_savetofile;
  int mnu_skipsubject;
  int mnu_skipwriter;
int mnu_message;
  int mnu_folowup;
  int mnu_postmessage;
  int mnu_listwrittenmessages;
  int mnu_removemessage;
  int mnu_movemessage;
  int mnu_makeprivate;
  int mnu_index;
int mnu_help;
  int mnu_keys;
 
//Menus on session selection screen
int Mnu_root;
  int Mnu_about;
  int Mnu_exit;
int Mnu_session;
  int Mnu_newsession;
  int Mnu_removesession;
int Mnu_settings;
  int Mnu_global;
  int Mnu_thisbbs;
int Mnu_help;
  int Mnu_keys;







