/*
     ATP QWK MAIL READER FOR READING AND REPLYING TO QWK MAIL PACKETS.
     Copyright (C) 1992  Thomas McWilliams 
     Copyright (C) 1990  Rene Cougnenc
    
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
system.h
*/

#include <ctype.h>

extern  void Erase(const char *PathName);

#if defined(__EMX__)
#ifndef OS2
#define OS2
#endif
#define termios termio
#define CHPATH _chdir2
#define GETWD _getcwd2
#define ADDRIVE(X) addrive(X)
#define HAVE_SIGINT
#define HAVE_UTIME
extern void addrive(char *path);
#endif

#ifdef unix
#include <sys/param.h>
#include <unistd.h>
#define NEEDSTRI
#define USEDIRENT
#ifndef S_IRWXU
#define S_IRWXU 0
#endif
#define my_mkdir(c) mkdir(c,S_IRWXU)
#ifndef DJD
#ifndef OS2
#define GETWD getcwd
#define CHPATH chdir
#define UNIXCMDS
#define HAVE_SIGINT
#define HAVE_SETGET
#define HAVE_LINK
#define HAVE_UTIME
#define SHELL "SHELL"
#define SEP '/'
#include <sys/ioctl.h>
#endif
#endif
#endif

/* define LATIN1 if your terminal supports ISO character set */

#ifdef __linux__
#define VT220
#define LATIN1
#endif

#ifdef DJD  /* D.J.Delore gcc for ms-dos */
#ifndef __MSDOS__
#define __MSDOS__
#endif
#include <gppconio.h>
#define NEEDISKS
#define HAVE_UTIME
#define getch() getkey()
#ifdef getcwd
#undef getcwd
#endif
#ifndef __HUGE__
#define __HUGE__
#endif
char *djgetwd( char *buf , int len);
#define GETWD djgetwd /* bug in DJD */
extern int getkey( void ) ; /* this is in DJD libpc.a */
#endif

#ifdef SIMP 
#define NEEDREADLINE  /* not using Salz/Tumlee editline lib */
#define add_history(x) /* null x */
#endif

#ifdef OS2
#include <io.h>
#include <process.h>
typedef int pid_t ;
#ifndef __EMX__
#define GETWD getcwd
#define CHPATH chdir
#endif
#define unlink(X) remove(X)
#define link(S,D) fcopy(S,D)
#define SHELL "COMSPEC"
#define USESYSTEM
#define SEP '\\'
#define tempnam(X,Y) mytempnam(X,Y)
extern char *mytempnam( const char *workpath , const char *rep );
#define NEEDTEMPNAM
#undef NEEDSTRI  /* don't need case-insensitive string compare */
#endif

#ifdef MSDOS
#ifndef __MSDOS__
#define __MSDOS__
#endif
#endif

#ifdef WIN32
typedef int pid_t ;
#define USESYSTEM
#define CHPATH chdir
#define ADDRIVE(X) addrive(X)
#define my_mkdir(c) mkdir(c)
#define sleep(t) _sleep(t)
#define GETWD getcwd
#define link(S,D) fcopy(S,D)
#define SHELL "COMSPEC"   /* environment variable used for command shell */
#define SEP '\\'
#endif

#ifdef __MSDOS__
#define MAXPATHS 128
#define NEEDTEMPNAM
#define USESYSTEM 
#define SHELL "COMSPEC"   /* environment variable used for command shell */
#define SEP '\\'
#define tempnam(X,Y) mytempnam(X,Y)
#define ADDRIVE(X) addrive(X)
extern void addrive(char *path);
#define CHPATH DosChPath
extern int DosChPath(char *path);
#define link(S,D) fcopy(S,D)
extern char *mytempnam( const char *path , const char *rep );

#ifndef DJD 
#define GETWD getcwd
extern int getch( void );
#define unlink(X) remove(X)
#endif 

#ifdef __TURBOC__
#include <conio.h>
#define HAVE_SIGINT
#define HAVE_FTIME   /* getftime() and setftime() library functions */
#define my_mkdir(c) mkdir(c)
typedef int pid_t ;
#endif

#else /* NOT MSDOS */
#ifndef ADDRIVE
#define ADDRIVE(X) /* nothing X */
#endif
#define MAXPATHS 1024
#define __HUGE__   /* this assumes no 64K segment limitations... */
#endif  /* if __MSDOS__ */

#ifndef CLSCRN
#define CLSCRN cls
#endif 

#ifndef __GNUC__
#ifndef __TURBOC__
#define LOOSE
#endif
#endif

#ifdef LOOSE
#define CONSPTR *
#else 
#define CONSPTR *const
#endif

#ifndef HAVE_SETGET
#define ATPGETERM /* null */	
#define ATPSETERM /* null */	
#define ATPABRTRP goto abrtreps
#else
#define ATPGETERM tcgetattr(STDIN_FILENO, &savedterm )	
#define ATPSETERM tcsetattr(STDIN_FILENO, TCSANOW, &savedterm )	
#define ATPABRTRP goto abrtreps
#endif

/* #ifdef NEEDSTRI */
#if defined(__STDC__) || defined(NEEDSTRI)
int strnicmp(const char *s1, const char *s2, size_t n);
int stricmp(const char *s1, const char *s2);
char *strlwr(char *s);
char *strupr(char *s);
#endif

#ifdef NEEDISKS  /* brain dead dos stuff */
#ifdef __MSDOS__
int getdisk(void);
int setdisk(int driv);
#endif
#endif

#ifndef R_OK
#define R_OK 4
#define W_OK 2
#define X_OK 1
#define F_OK 0
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

#ifndef STDIN_FILENO
#define STDIN_FILENO	0
#define STDOUT_FILENO	1
#define STDERR_FILENO	2
#endif

#ifndef SEEK_SET
#define SEEK_SET 0
#define SEEK_CUR 1
#define SEEK_END 2
#endif

/* define ATP tagline */

#define ATPVER " 1.42 " /* DON'T CHANGE THIS it will mess up formatting */

/* #define ATPSYST  "your_system" */ /* you shouldn't  have to define this */

#ifndef ATPSYST
#ifdef linux 
#define ATPSYST "Linux"
#elif defined(hurd)
#define ATPSYST "Hurd"
#elif defined(esix)
#define ATPSYST "Esix"
#elif defined(WIN32)
#define ATPSYST "Win32"
#elif defined(OS2) 
#define ATPSYST "OS2"
#elif defined(xenix)
#define ATPSYST "Xenix"
#elif defined(usl)
#define ATPSYST "USL"
#elif defined(DJD)
#define ATPSYST "DJgcc"
#elif defined(__MSDOS__)
#define ATPSYST "qwk"
#elif defined(amiga)
#define ATPSYST "Amiga"
#elif defined(mach)
#define ATPSYST "Mach"
#elif defined(BSD)
#ifdef i386
#define ATPSYST "386bsd"
#define BADLWR
#else
#define ATPSYST "BSD"
#endif
#elif defined(sun)
#define ATPSYST "Sun"
#elif defined(unix)
#define ATPSYST "Unix"
#else
#define ATPSYST "QWK"
#endif
#endif

#define NTAG  "\n---\n \376 ATP/" ATPSYST ATPVER "\376 "
#define FTAG  "\n...\n * ATP/"    ATPSYST ATPVER "* " 

#ifdef BADLWR     /* some versions of GCC 1.40 and before */
#undef tolower(c)
#undef toupper(c)
#define tolower(x) (((x)>0x40)&&((x)<0x5b)?((x)|0x20):(x))
#define toupper(x) (((x)>0x60)&&((x)<0x7b)?((x)&0xdf):(x))
#endif

