/*
     ATP QWK MAIL READER FOR READING AND REPLYING TO QWK MAIL PACKETS.
     Copyright (C) 1992  Thomas McWilliams 
     Copyright (C) 1990  Rene Cougnenc
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
reader.h  
*/

#define TRUE 1
#define FALSE 0 
#define BELL (silent? (char) 0x20 :(char) 7)
#define PCBLONG (pcbext)
/* #define PCBLONG (!fido && pcbext) */

						/* character set modes */
#define CHR7BIT 2						
#define ISOLAT1 1
#define CHRDOS  0

#define SEPDOS '\\'
#define ERROR    -1
#define OK        0
#define EOS       0       /* End of string */

#ifndef __STDC__
#ifndef size_t
#define size_t int
#endif
#endif

/* test for MS-DOS block graphic line drawing character */
#define vtspecial(c)  ((((c)>0xaf)&&((c)<0xe0)) ? 1 : 0 )

#define CONFIG_FILE "atprc"
#define WORK_DIR    "atpwork"
#define TAGFILE     "taglines.atp" /* taglines file                      */
#define RESET 0
#define UPDATE 1


/*===== Size limits . & memory model dependances =========================*/

#define ULZ (unsigned long)

#ifndef __HUGE__  /* not defined -- MS-DOS */

/* large model */
#define MAXCONF     4000    /* Increase if you need more conferences       */
#define MYBUF      25600L   /* MAX message len .(buffer ) RECEIVED MESSAGE */
#define MAXBUF     65408L   /* Worst case buffer size                      */
#define MAXSEND    50048L   /* MAX message len  (buffer ) SENDED   MESSAGE */
                            /* (40000 = about 600 lines with 65 chars/line)*/

#else /* use huge model 32 bit */

/*  huge model  */
#define MAXCONF       8191    /* Can not exceed 8191 but could be less.      */
#define MYBUF        32768L   /* MAX message len .(buffer ) RECEIVED MESSAGE */
#define MAXBUF      179200L   /* Worst case message buffer size              */
#define MAXSEND      65408L    /* MAX message len  (buffer ) SENT MESSAGE     */
                              /* about 153,600 bytes, about 2560 lines       */ 

#endif  /* memory models */

#ifndef CLSCRN
#define CLSCRN cls
#endif 

/*------------------------------------------------------------------------*/

#define REPLY     0
#define ENTER     1
#define EDIT	  2

#define YES 1
#define NO  0

#ifndef BYTE_DECL
typedef unsigned char byte ;
#define BYTE_DECL
#endif

/* typedef */
struct  MyIndex {
         
            long  LastRead  ;    /* Last Message Read, Used once...            */
            long  MaxMsg    ;    /* Max Messages allowed in conf. (future use) */
            long  MsgNum    ;    /* Number of This message                     */
            long  Offset    ;    /* Offset in the Conference file              */
            unsigned long Size ; /* Size of the message,with Header            */
        }  ;

/* The last read field is only used in the first structure of the file ...   */

extern char CurTag[];
extern long RbufSize ;
extern size_t RbufRecs ;
extern int  SaveConf ;
extern char HomePath [];   /* Home directory for exe file & root of msg dirs */
extern char MailPath [];   /* Where to look for new mail                     */
extern char ReplyPath[];   /* Where to put replies                           */
extern char WorkPath[] ;   /* Where to archive /unarchive mail               */
extern char SubjBuf[];     /* used for PCB long subjects */
extern char CurBoard[] ;   /* name of the current board                      */
extern char Welcome[] ;  	
extern char News[] ;
extern char GoodBye[] ;

extern char Editor  [];    /* Name of the standard text editor               */
extern char Archiver [];
extern char UnArchiver[];

extern struct MyIndex Index ;

extern int  CurConf ;     /* Name of the current Conference...             */
extern long TotMsg  ;     /* total messages in conf                        */
extern int ReplyExist ;   /* Flag, true if there are replies not packed.   */
extern int HeadLetter ;   /* Automatic header                              */
extern int autotag    ;   /* Automatic tagline selection                   */
extern int pcbext     ;   /* Support for PCBoard long subjects             */
extern int graphics   ;   /* When TRUE vt100 graphics are enabled          */
extern int charset    ;   /* Flag for ISO, DOS, or 7bit character set      */
extern int silent	  ;   /* Flag for console bell on or off 			   */
extern int ActvCnt    ;   /* number of conferences with messages available */

extern FILE *fidx,*fmsg;  /* Files opened for message and index            */
extern int FilesOpen ;    /* Flag true if these files are opened           */
extern char *luxptr ;     /* if not null, points to readline init string   */
extern char termtype[] ;  /* hold environment variable TERM                */
extern byte *rbuf;        /* Buffer containing current message.            */
extern const char *txt[];       /* Language-dependant text messages ( general)*/
extern const char *hlp[];       /* Language-dependant text messages ( help )*/
extern const char *taghlp[];    /* Language-dependant text messages ( tag help)*/
extern const char *Months[];    /* Language-dependant text messages (Dates)*/
extern const char *terms[];  /* Gnu copyleft message */

/* chosetag.c */
int ChooseTag(void);
void TagSeek(const unsigned int tagchoice);
int clip( char *cnf, char Tflg, long trunc_num );

/* makemail.c */
extern int reup( unsigned long bufsiz );

/* text.c */
void Title( void );

/* editline.c */

extern char	*readline(const char *prompt, int scrollflag);
extern void	rl_initialize(void);     

#ifndef NEEDREADLINE
extern void	add_history(const char *line);
#endif

/*------------------------- end of reader.h -------------------------------*/

