/*
     ATP QWK MAIL READER FOR READING AND REPLYING TO QWK MAIL PACKETS.
     Copyright (C) 1992  Thomas McWilliams 
     Copyright (C) 1990  Rene Cougnenc
   
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*
qmail.h
*/

#define  call   goto        /* :-))                                  */

#ifndef BYTE_DECL
typedef unsigned char byte ;
#define BYTE_DECL
#endif

/*--------- FILES RECEIVED in *.QWK.-- Warning : DOS is not case-sensitive */

#define MSG_FILE    "messages.dat" /* Message filename prepared by Qmail */
#define CNTRL_FILE  "control.dat"  /* List of conferences by Qmail       */
#define DOORID		"door.id"	   /* Info for the BBS QWK door 		 */
#define NEWFILES    "newfiles.dat" /* List of new files   by Qmail       */
#define WELCOME     "welcome"      /* 1st Screen of te BBS               */
#define NEWS        "news"         /* news file, ascii mode              */
#define TAGFILE     "taglines.atp" /* taglines file                      */
#define MSG_EXT     ".msg"         /* Extension of reply file            */
#define CNF_EXT		".cnf"	       /* Extension of conference file       */		
#define IDX_EXT     ".idx"         /* Extension of index files           */
#define PERS_CONF   9000           /* Conference number for personal mail*/
#define REPL_CONF   9001           /* Conference number for replies      */
#define PCONF_IDX   LastConf
#define RCONF_IDX   LastConf-1
#define VIRGINDX    -1L				/* Index.LastRead flag for virgin index */
/*-------------------------------------------------------------------------*/

/* typedef */
struct MsgHeaderType         /* RECEIVED MESSAGE HEADER STRUCTURE      */
       {
           byte Status        ,   /* ??? */
                NumMsg   [7 ] ,   /* Numero du message,envoi = conf !  */
                MsgDate  [8 ] ,   /* mm-dd-yy                          */
                MsgTime  [5 ] ,   /* HH:MM                             */
                ForWhom  [25] ,   /* Destinataire                      */
                Author   [25] ,   /* Nous mme...                      */
                Subject  [25] ,   /*                                   */
                PassWord [12] ,   /* Si sender ou group password       */
                RefMsg   [8 ] ,   /* Message rfrenc                 */
                SizeMsg  [6 ] ,   /* en ascii, nb blocs de 128 bytes   */
                MsgActive     ,   /* 0xE1 = active  0xE2 = inactive    */
                BinConfN [2 ] ,   /* 16 bit unsigned binary word       */
                Unused1       ,   /* space                             */
                Unused2       ,   /* space                             */
				NetTag        ;   /* space                             */
       } ;

/* typedef */
struct QmailRepType   /* SEND MESSAGE HEADER STRUCTURE. */
       {
           byte Status;            /* '+' = private  ' ' = public     */
           byte ConfNum  [7] ;     /* Numero de la confrence concerne */
           byte MsgDate  [13];     /* mm-dd-yyHH:MM                     */
           byte ForWhom  [25];     /* Destinataire                      */
           byte Author   [25];     /* Nous mme...                      */
           byte Subject  [25];     /*                                   */
           byte PassWord [12];     /* Si sender ou group password       */
           byte RefMsg   [8] ;     /* Message rfrenc                 */
           byte SizeMsg  [6] ;     /* en ascii, nb blocs de 128 bytes   */
           byte MsgActive    ;     /* 0xE1 = active                     */
           byte BinConfN [2] ;     /* 16 bit conference number binary.  */
           byte Unused1      ;     /* space                             */
           byte Unused2      ;     /* space                             */
           byte NetTag       ;     /* space                             */
       } ;
                        /* Variables used to read Control.dat         */

typedef char  string16[16]  ;

#if	!defined(SIZE_T)
#define SIZE_T	unsigned int
#endif	/* !defined(SIZE_T) */
#ifdef USEDIRENT
extern SIZE_T FindMatches(char *dir, const char *file, char ***avp) ;
#else
extern SIZE_T FindMatches(char *path , char ***avp) ;
#endif

extern int pmail ; /* global flag in read.c is true if personal mail found */
extern int LastConf ;
extern char BoardName[], UserName [], User1Name [], User2Name [] ; 

int  findCindex( const int );
int  MkIndex( const char * , const char * );
int  readCnum( const byte * );
void ActvConf( void );
int  OpenCon( FILE **, FILE **, const char * );
int  ReadControl( const char *Path );
int  WriteIndex( FILE *fx, const long count, const unsigned long Size, const long Offset );
void StripLSpace(char *);
void StripRSpace(char *);

extern string16 *ConfName ;
extern int  *ConfNumbers /* [MAXCONF] */;
extern int  *ConfActive /* [MAXCONF] */; 

/*---------------------------- end of qlib.h ----------------------------*/
