/*
     ATP QWK MAIL READER FOR READING AND REPLYING TO QWK MAIL PACKETS.
     Copyright (C) 1992  Thomas McWilliams 
     Copyright (C) 1990  Rene Cougnenc
  
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 1, or (at your option)
     any later version.
     
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
     
     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
 
/*
makemail.c 
*/

#include <time.h>
#include <stdio.h>
#include <fcntl.h>
#include <assert.h>
#ifndef unix
#ifdef WIN32
#include <malloc.h>
#else
#include <alloc.h>
#endif
#include <dos.h>
#include <io.h>
#endif
#include "system.h"
#include <stdlib.h>
#include <string.h>
#include "ansi.h"
#include "makemail.h"
#include "qlib.h"
#include "reader.h"
#include "readlib.h"

static FILE           *MsgFile, *IdxFile, *RepMsg, *TmpFile;
static char            MessageFile[MAXPATHS];
static char            IndexFile[MAXPATHS];
static char           *tetedate( void );
static void            FirstHeader( void);

/* Creation du bloc d'entete  du fichier message correspondant au serveur */
/*------------------------------------------------------------------------*/
/* Creation of message file header block corresponding to the server BBS  */


static void 
FirstHeader(void)
{
	char            Block[128], tbuf[25];

	memcpy(tbuf, CurBoard, 25);	/* Preserve lowercase name for   */
	tbuf[25] = 0 ;
	strupr(tbuf);		/* later use ....                */
	memset(Block, 0x20, 128);	/* Fill with spaces              */
	str2mem(Block, tbuf);	/* Insert BBS name for header    */
	fwrite(Block, 128, 1, RepMsg);
	fflush(RepMsg);	/* Write this block to the file  */
}


/* Remise du Header aux paramtres par dfaut                        */
/*----------------------------------------------------------------------*/
/* Put the default parameters in the reply header                      */


void 
ResetHeader(struct QmailRepType * Qmail)
{

	byte            word16[2];	/* space for 16 bit unsigned word */
	int             RealConfN = ConfNumbers[CurConf];	/* given index, find real conf. num. */
	char            qbuf[30];	/* temporary buffer */

	/* fill struct with spaces / struct remplie d'espaces    */

	memset(&Qmail->Status, 0x20, sizeof(struct QmailRepType));

	Qmail->Status = 0x20;	/* Public Message Unread */
	sprintf(qbuf, "%-7d", ConfNumbers[CurConf]);
	str2mem((char *) (Qmail->ConfNum), qbuf);	/* Conference Number     */
	str2mem((char *) (Qmail->MsgDate), tetedate());	/* Current Date Time     */

	word16[0] = (byte) (RealConfN & 0x00ff);
	word16[1] = (byte) ((RealConfN & 0xff00) >> 8);
	memcpy( (void *) &(Qmail->BinConfN), (void *) word16, 2);	/* 16bit unsigned conference number */

	Qmail->MsgActive = 0xE1;/* 0xE1 = active  0xE2 = non active  */
	Qmail->Unused1 = 0x20;	/* space                             */
	Qmail->Unused2 = 0x20;	/* space                             */
	Qmail->NetTag = 0x20;	/* space                             */
}

/*----------------------------------------------------------------------*/
/*  take ".cnf" file and make into ".msg" file  for export              */

int 
Cnf2Msg( const char *filemsg  ) {

struct 			MsgHeaderType Qmail;
unsigned        i;
int             mrep = FALSE ; 
unsigned long   MaxChars; 
unsigned        NbBlocs ;
unsigned        Head = sizeof(struct MsgHeaderType);
byte            *ptr ;
	/* open messpath */
	
    if(! OpenRepFile(PACK) ) /* Open MsgFile and IdxFile */
         return (FALSE) ;
	
   	if ((RepMsg = fopen( filemsg, "wb")) == NULL ){
		printf("%s %s\n", txt[51], IndexFile);	/* "unable to open file" */
		perror("System");
		fclose(IdxFile) ; fclose(MsgFile) ;
		return (FALSE) ;
	}

    FirstHeader();

	/* copy .cnf to messpath */

	if(fseek( MsgFile, 0, SEEK_SET)) {
		printf("Seek error in Cnf2Msg()\n");
		fclose(IdxFile) ; fclose(MsgFile) ;
		return(FALSE);
	}
		
	while ((fread(&Qmail.Status, 1, Head, MsgFile)) != (size_t) 0 ) {
		
		memcpy((char *) rbuf, (char *) &Qmail.Status, (unsigned) Head);
		NbBlocs = atoi((char *) Qmail.SizeMsg) - 1;
        MaxChars = NbBlocs * 128L ;

		if ( (MYBUF-128) <= MaxChars && MaxChars < (MAXBUF-128) ){
			if ( ! reup ( MaxChars+Head )) 
				MaxChars = MYBUF-Head ; /* just truncate the message */
		}				

		if(MaxChars != 0) {  /* no need to read 0 chars */
			if (fread((char *) (rbuf + Head), 128, NbBlocs, MsgFile ) != NbBlocs) {	/* Read the message..... */
				printf("max char %ld\n", (unsigned long) MaxChars);
				printf("%s %s\n", txt[58], MessageFile );	/* "error reading file " */
				fclose(MsgFile);
				fclose(IdxFile); 
				fclose(RepMsg); 
				return (FALSE);
			}
		}		
		if (Qmail.Status <= 0x80 ) {
			ptr =  (byte *) (rbuf + Head);
			for (i = 0; i < MaxChars; i++) { /* Translate to normal Line Feed */
				if (*ptr == '\n' ) 
					*ptr = 227 ;
				else if (*ptr == 255 )
				    *ptr = '\040' ;
				ptr++;
			}
			fflush(stdout);
            if ( fwrite(rbuf, 128, NbBlocs+1, RepMsg ) != NbBlocs+1 ) {   /* And copy it.         */
				printf("%s %s\n", txt[73], filemsg ); /* "error writing file " */
				fclose(MsgFile);
				fclose(IdxFile); 
				fclose(RepMsg); 
				return (FALSE);
			}
			mrep = TRUE ;
		}	
		
	}  /* end of while() */
	/* close messpath */

	fclose( MsgFile );
	fclose( IdxFile );
	fclose( RepMsg  );
	return(mrep);
}


/*----------------------------------------------------------------------*/
/*
 * Ecriture du message proprement dit, cod selon le format PcBoard, c.a.d les cr/lf remplacs par  '\343'
 * 
 * Write the message encoded according to the format of PcBoard. CR/LF are replaced with '\343'.
 */

/* this table converts a LINUX screen code to an MS-DOS screen code */
const unsigned char codepc[] = {

        0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
        0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
        0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
        0x18, 0x19, 0x20, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 

        0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,  /* 87 */
        0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,  /* 8f */
        0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,  /* 97 */
        0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,  /* 9f */
        0x20, 0xad, 0x9b, 0x9c, 0xfe, 0x9d, 0x7c, 0xfe,  /* a7 */
        0xfe, 0xfe, 0xa6, 0xae, 0xaa, 0x2d, 0xfe, 0xfe,  /* af */
        0xf8, 0xf1, 0xfd, 0xfe, 0xfe, 0xe6, 0xfe, 0xf9,  /* b7 */
        0xfe, 0xfe, 0x97, 0xaf, 0xac, 0xab, 0xfe, 0xa8,  /* bf */
        0xfe, 0xfe, 0xfe, 0xfe, 0x8e, 0x8f, 0x92, 0x80,  /* c7 */
        0xfe, 0x90, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,  /* cf */
        0xfe, 0xa5, 0xfe, 0xfe, 0xfe, 0xfe, 0x99, 0xfe,  /* d7 */
        0xfe, 0xfe, 0xfe, 0xfe, 0x9a, 0xfe, 0xfe, 0xe1,  /* df */
        0x85, 0xa0, 0x83, 0xfe, 0x84, 0x86, 0x91, 0x87,  /* e7 */
        0x8a, 0x82, 0x88, 0x89, 0x8d, 0xa1, 0x8c, 0x8b,  /* ef */
        0xfe, 0xa4, 0x95, 0xa2, 0x93, 0xfe, 0x94, 0xf6,  /* f7 */
        0xfe, 0x97, 0xa3, 0x96, 0x81, 0xfe, 0xfe, 0x98 } ;

int 
KodeMessage(const char *fname, struct QmailRepType * Qmail)
{
	byte            ch;
	byte           *ptr, *tamp;
	byte            tmp[20];
	byte           *tampon;	/* Pour simplifier les essais, un gros tampon...  */
	unsigned 		CountBlocks = 2,	/* the first block of 128 chars is always the Header */
	                CountSize = 0,		/* this will be the size of the text without Header */
	                CountChar = 0, 
					LinCt = 0 ,			/* counts line length */ 
					MaxChars ; 
	long int    	kcount, klast, repsize, ksavec = 0L, ksavei = 0L ;
					
	/* Ouvre le fichier cr par l'diteur    */
	/*-------------------------------------------*/
	/* Open the reply file created by the editor */

	   
	if ((TmpFile = fopen(fname, "r")) == NULL)
	{
		printf("%s %s\n", txt[51], fname);	/* "unable to open file" */
		return (ERROR);
	}

	fseek(TmpFile, 0L, SEEK_END); 
	if ( (repsize = ftell(TmpFile)) < 1L ) /* empty reply */
		return (ERROR);
	fseek(TmpFile, 0L, SEEK_SET);

	if (repsize > (long) (MAXSEND - 256) ){
			printf("\nERROR: Reply file exceeds %lu bytes%c\n", (unsigned long) MAXSEND, BELL );
			fclose(MsgFile);
			fclose(TmpFile);
			return (ERROR);
	}
			
	if ((tampon = (byte *) malloc ( (unsigned) (repsize+1024) )) == NULL) {
			printf("%s\n", txt[1]);
			fclose(MsgFile);
			fclose(TmpFile);
			return (ERROR);
	}		
	
    	if( SaveConf == RCONF_IDX){
		ksavec = ftell(fmsg);
		ksavei = ftell(fidx);
	}
	fseek(MsgFile, 0L, SEEK_END); 
	klast = ftell(MsgFile);

	/* Codage du message dans le tampon              */
	/*-----------------------------------------------*/
	/* Encode the reply with QWK standard characters */

	tamp = tampon;
	if( PCBLONG && SubjBuf[0] ) {
		*tamp++ = fido ? 0x20 : 0xff ;
		strcpy( (char *) tamp, "@SUBJECT:" ) ;
		tamp += 9 ;
		strcpy( (char *) tamp, SubjBuf ) ;	
		while( *tamp ) tamp++, CountChar++ ;
		while ( CountChar < 54 ) 
			*tamp++ = 0x20, CountChar++ ; 
		tamp = tampon + 64 ; 
		strcpy( (char *) tamp , "      N\n" );	
		tamp = tampon + 72 ;		
		CountSize = CountChar = 72 ; 
	}
	while (fread(&ch, 1, 1, TmpFile) == (size_t) 1 ) {
		
		if( LinCt > 79 ) ch = '\n' ;
		LinCt =  (ch == '\n') ? 0 : LinCt+1 ;
		if(charset == ISOLAT1)
			if (ch > 0x7f)
				ch = codepc[ch];	/* translate back to DOS set */
			
        ch = (ch == 0xff || ch == 0x1a )? '\040' : ch ;
		if (ch == 0x0D)
			continue;
  		*tamp = ch;   
		tamp++;
		CountChar++;
		CountSize++;
		if (CountChar > 128) {
			CountBlocks++;
			CountChar = 1;
		}
	}
	if ( tamp > tampon )   /* point to last character */
		tamp-- ;
	else {
		*tampon = '\040';  /* guarantee a non-empty message */
		CountChar++ , CountSize++ ;
	}
	if(*tamp == '\n')
		*tamp = '\040' ;
	tamp++ ;
	*tamp =  (byte) '\377' ;
	tamp++;
	CountChar++;
	CountSize++;
	if (CountChar > 128) {
			CountBlocks++;
			CountChar = 1;
	}

	/* Rajout de la signature du programme */
	/*-------------------------------------*/
	/* Add the the tagline                 */

	if( CurTag[84] != '\0') {        /* truncate tagline to 80 chars */
		CurTag[84] = '\n' ; 
		CurTag[85] = '\0' ; 
	} 
	ptr = (byte *) CurTag;
	while (*ptr) {
		if (charset == ISOLAT1)  
			*tamp = codepc[*ptr];	/* translate Linux to Dos chars */
		else
        	*tamp = *ptr ;

		tamp++;
		ptr++;
		CountChar++;
		CountSize++;
		if (CountChar > 128) {  
			CountBlocks++;
			CountChar = 1;
		}
	}

 
	/* Ajuste la taille du dernier bloc  128 octets      */
	/*-----------------------------------------------------*/
	/* Adjust the size of the last block to 128 bytes      */
	if ( CountChar < 128 ) {
    	while (CountChar < 128) {
		*tamp = 0x20;
		tamp++;
		CountChar++;
		CountSize++;
		}
	}

	/* Inscrit dans le Header le nombre blocs de 128 octets */
	/*------------------------------------------------------*/
	/* Inscribe in the header the number of 128 byte blocks */

	sprintf((char *) tmp, "%d", CountBlocks);
	str2mem((char *) (Qmail->SizeMsg), (char *) tmp);
	MaxChars = 128 * ( CountBlocks - 1 ) ;
	
	/* Ecrit l'entete du message, suivi du message          */
	/*------------------------------------------------------*/
	/* Write the reply header followed by the reply itself  */

	printf("%s...\n", txt[75]);	/* "sauvegarde du message" */
   	fseek( MsgFile, 0L, SEEK_END);
#ifdef ATPDBG2
	printf("klast = %ld  CountBlocks = %d \n", klast, CountBlocks ) ;
	sleep(2);
#endif 
   	fwrite((byte *) Qmail, 1, sizeof(struct QmailRepType), MsgFile );  
    fwrite(tampon, 1, CountSize, MsgFile);
	fflush(MsgFile);
	
	/* Ecrit les fichiers conf et index                    */
	/*-----------------------------------------------------*/
	/* Update the reply index and conf files.              */

    	fseek(IdxFile, 0L, SEEK_END);
	kcount = (long) ( ftell(IdxFile) / sizeof(struct MyIndex) ) ;

	WriteIndex(IdxFile, kcount, MaxChars, klast);
	fflush(IdxFile);

	/* Ferme et efface le fichier de travail               */
	/*------------------------------------------------------*/
	/* Close and erase the work file                       */

	fclose(TmpFile);
	unlink(fname);
	if( SaveConf == RCONF_IDX) {
		fseek(fmsg, ksavec, SEEK_SET ) ;
		fseek(fidx, ksavei, SEEK_SET ) ;
	} else {
        fclose(MsgFile);
        fclose(IdxFile);
    }
    free (tampon);
    ActvConf();   /* update list of active conferences */
	return (OK);
}
/********************** end of KodeMessage ******************************/

/* Ouverture ou creation du fichier messages.                           */
/*----------------------------------------------------------------------*/
/* Open or create the message file                                      */


int 
OpenRepFile(const int mode) /* valid modes are PACK and REP */
{
	int             FileExist;

	sprintf(IndexFile,  "%s%s%c%d%s", HomePath, CurBoard, SEP, REPL_CONF, IDX_EXT);
	sprintf(MessageFile,"%s%s%c%d%s", HomePath, CurBoard, SEP, REPL_CONF, CNF_EXT);

	if (access(MessageFile, F_OK ) == 0 )
		FileExist = TRUE ;
	else
		FileExist = FALSE ;

    if( ( SaveConf == (int) RCONF_IDX ) && FileExist ){
        MsgFile = fmsg ; 
        IdxFile = fidx ; 
    }
    else {
        if (OpenCon(&MsgFile, NULL, MessageFile) == ERROR) {
            printf("%s %s\n", txt[51], MessageFile);    /* "unable to open file" */
            perror("System");
            return(FALSE);
        }
		
        if (OpenCon(&IdxFile, &MsgFile, IndexFile) == ERROR) {
            printf("%s %s\n", txt[51], IndexFile);  /* "unable to open file" */
            perror("System");
            return(FALSE);
        }
    }
    if (mode == ADDREP ){
        if (FileExist)
            printf("%s %s \n", txt[76], MessageFile);/* "Adding message to file" */
        else
            printf("%s %s \n", txt[77], MessageFile);/* "creating file" */
	}
	return(TRUE);
}
/* le date et l'heure d'entete du message.                              */
/*----------------------------------------------------------------------*/
/* returns a pointer to the reply date/time string                      */

static const char  *months[] = {"none", "JAN", "FEB", "MAR", "APR", "MAY", "JUN",
	"JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
static const char  *monums[] = {"00-", "01-", "02-", "03-", "04-", "05-", "06-",
	"07-", "08-", "09-", "10-", "11-", "12-"};

static char *  
tetedate(void)
{

	int             i, j;
	time_t          t;
	char            tbuf[30];
	static char     tbuf2[30];

	t = time(NULL);
	sprintf(tbuf, "%s", ctime(&t));

	tbuf[7] = '\0';
	tbuf[10] = '\0';
	tbuf[16] = '\0';
	tbuf[21] = '-';
	tbuf[24] = '\0';

	for (i = 1; i < 13; i++) {
		j = stricmp(&tbuf[4], months[i]);
		if (j == 0) {
			sprintf(tbuf2, "%s%s%s%s", monums[i], &tbuf[8], &tbuf[21], &tbuf[11]);
			i = 13;
		}
		if (i == 12 && j != 0)	/* default case */
			sprintf(tbuf2, "01-01-8001:00");
		if (tbuf2[3] == '\040')
			tbuf2[3] = '0';
	}

	return (tbuf2);
}

/* reallocate rbuf message buffer */
int
reup( unsigned long bfsz ) 
{
#ifdef ATPDBG		
	assert( MYBUF <= bfsz && rbuf != NULL );
#endif	
	if( bfsz > MAXBUF || ( rbuf = (byte *) realloc (rbuf, bfsz) )==NULL)
	{
		/* realloc failed, use original buffer */
		printf("%s [ %ld > %ld bytes ]%c\n", txt[72], bfsz, MAXBUF, BELL );	/* "msg too big" */
		sleep(2);
		return 0 ; /* failed */
	}
	else{
		/* realloc succeeded */
#ifdef ATPDBG
printf("Inside reup()  bufsize = %ld \n", bfsz ), sleep(4) ;
#endif	
		RbufSize = bfsz ;
		RbufRecs = (( bfsz + 127L ) / 128 ) ; 
		return 1 ; /* success */
	}
}


/* this table converts an MS-DOS screen code to a LINUX screen code */

const unsigned char codelu[] = {

        0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x09, 0x0a, 0x20, 0x20, 0x0d, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x1b, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 

        0xc7, 0xfc, 0xe9, 0xe2, 0xe4, 0xe0, 0xe5, 0xe7,   /* 87 */
        0xea, 0xeb, 0xe8, 0xef, 0xee, 0xec, 0xc4, 0xc5,   /* 8f */
        0xc9, 0xe6, 0xc6, 0xf4, 0xf6, 0xf2, 0xfb, 0xf9,   /* 97 */ 
        0xff, 0xd6, 0xdc, 0xa2, 0xa3, 0xa5, 0x50, 0x66,   /* 9f */ 
        0xe1, 0xed, 0xf3, 0xfa, 0xf1, 0xd1, 0xaa, 0xba,   /* a7 */
        0xbf, 0xad, 0xac, 0xbd, 0xbc, 0xa1, 0xab, 0xbb,   /* af */ 
        0xfe, 0xfe, 0xfe, 0xa6, 0xa6, 0xa6, 0xa6, 0xfe,   /* b7 */
        0xfe, 0xa6, 0xa6, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,   /* bf */
        0xfe, 0xad, 0xad, 0xa6, 0xad, 0x2b, 0xa6, 0xa6,   /* c7 */
        0xfe, 0xfe, 0xad, 0xad, 0xa6, 0xad, 0x2b, 0xad,   /* cf */
        0xad, 0xad, 0xad, 0xfe, 0xfe, 0xfe, 0xfe, 0x2b,   /* d7 */
        0x2b, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,   /* df */
        0xa3, 0xdf, 0xfe, 0xfe, 0x53, 0x73, 0xb5, 0x74,   /* e7 */
        0xa7, 0x4f, 0x4f, 0x64, 0xad, 0x6f, 0xc6, 0xfe,   /* ef */ 
        0xad, 0xb1, 0xfe, 0xfe, 0xa6, 0xa6, 0xf7, 0x7e,   /* f7 */
        0xb0, 0xb7, 0xb7, 0x76, 0x6e, 0xb2, 0xfe, 0x20 } ;


/* this table generates dos line characters with vt100 codes */

unsigned char codevt[] = {
/* dummy 0 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 1 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 2 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 3 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 4 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 5 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 6 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 7 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 8 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy 9 */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* dummy a */  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,	
/* 0xb0 */  'a', 'a', 'a', 'x', 'u', 'u', 'u', 'k', 
/* 0xb8 */  'k', 'u', 'x', 'k', 'j', 'j', 'j', 'k',
/* 0xc0 */  'm', 'v', 'w', 't', 'q', 'n', 't', 't',
/* 0xc8 */  'm', 'l', 'v', 'w', 't', 'q', 'n', 'v',
/* 0xd0 */  'v', 'w', 'w', 'm', 'm', 'l', 'l', 'n',
/* 0xd8 */  'n', 'j', 'l', 'a', 'a', 'a', 'a', 'a' } ;


/* map 8 bit MS-DOS codes to a 7bit approximation */

const unsigned char code7bit[] = {

        0x00, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x09, 0x0a, 0x20, 0x20, 0x0d, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
        0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
        0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
        0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
        0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
        0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
        0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
        0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
        0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
        0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
        0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
        0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f, 

/* 80 */   'C', 'u', 'e', 'a', 'a', 'a', 'a', 'c',
/* 88 */   'e', 'e', 'e', 'i', 'i', 'i', 'A', 'A', 
/* 90 */   'E', 'a', 'A', 'o', 'o', 'o', 'u', 'u',
/* 98 */   'y', 'O', 'U', 'c', 'L', 'v', 'P', 'f',
/* a0 */   'a', 'i', 'o', 'u', 'n', 'N', 'a', 'o',
/* a8 */   '?', '~', '~', '-', '-', '!', '<', '>',
/* b0 */   '#', '#', '#', '|', '+', '+', '+', '+',
/* b8 */   '+', '+', '|', '+', '+', '+', '+', '+',
/* c0 */   '+', '+', '+', '+', '-', '+', '+', '+',
/* c8 */   '+', '+', '+', '+', '+', '-', '+', '+',
/* d0 */   '+', '+', '+', '+', '+', '+', '+', '+',
/* d8 */   '+', '+', '+', '#', '#', '#', '#', '#',
/* e0 */   '8', 'B', 'G', 'p', 'S', 's', 'm', 't',
/* e8 */   'o', 'O', 'O', 'd', '8', 'o', 'E', '-', 
/* f0 */   '=', '#', '<', '>', '|', '|', '/', '=',
/* f8 */   'o', 'o', '.', 'v', 'n', '2', '*', ' ' } ;

/* end of makemail.c */
