// Filename:   bbsipc.h
// Contents:   the definitions for the bbs ipc (socket interface) object
// Author:     Greg Shaw
// Created:        6/13/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSIPC_H_
#define _BBSIPC_H_

// generic defines
#define ETX    0x3              // end of transmission

// Class:  bbsipc
// Purpose:    the interface object for the bbs ipc processes
// Members:
//         socket - the socket connected (or not connected) to
//             transient - are we using transient operation?
//         sock_open - is the socket open?
// Methods:
//         constructor - initialize object
//         destructor - close socket (if open)
//         opensock() - open socket
//         closesock() - close socket
//         send()  - send a message
//         msg_avail() - is a message available
//         receive() - receive message
//         do_connect() - receive message
// Notes:  this object shouldn't be a directly addressible object -- it
//         should be inherited if at all possible.
// Author: Greg Shaw
// Created:    6/13/93

class bbsipc
{
	int    sock_fd;             // socket file descriptor (for read and write)
	int    serv_sock_fd;        // socket file descriptor (for read and write)
	int    sockt;               // socket to use for communication
	char   server;              // server mode?
	char   hostname[255];       // hostname connected to
	char   sock_open;           // is socket open and ready for communication?
	char   connected;           // is socket connected?
	public:
		bbsipc();               // init object
		~bbsipc();              // close socket (if applicable)
		// open socket
		open_sock(char *name, int socknum);
		// close open socket
		close_sock(int client_only);
		send(char *msg);        // send a message
		msg_avail(char wait);   // is a message available?
		receive(char *msg);     // recieve a message
		do_connect(int wait);   // get a connection (server only)
		// see above
};


#endif                          // _BBSIPC_H_







