/* ix/MBox (uudecode.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:
  
   #PU prep_uu()         parse articles to uudecode
   #UU uudecode()        uudecode article(s)
   #DR drucken()         print a mail or an article
   #PW preview()         preview a (gif-) picture
   #MD moderated()	 check whether a newsgroup is moderated
   #SV saver()		 screen saving mode
   #CA chk_adult()       access for adults only
   #MM make_time()	 take time in seconds and make a a propper time

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <signal.h>


#include "mbox.h"

void uudecode();	/* SCO Unix loves this ... don't think about it ;-) */

int noname;



/* #PU - Parse articles to uudecode. */

void prep_uu( argument, pos )
UNSIGNED char argument[];
int pos;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[(STRING * 5)];

  UNSIGNED char subj[STRING];
  UNSIGNED char part[STRING];
  UNSIGNED char sect[STRING];
  UNSIGNED char begi[STRING];

  UNSIGNED char bild[STRING];

  UNSIGNED char p1[STRING];
  UNSIGNED char p2[STRING];
  UNSIGNED char p3[STRING];


  int num1, num2;

  int i, m, a, b, loop;

  int have_it = 0;

  int none = 0;

  int from = atoi( strcopy( argument, 0, (pos -1)));
  int to   = atoi( strcopy( argument, (pos +1), strlen(argument)));

  FILE *fp;
  FILE *ff;
  FILE *fa;

  
  noname = 0;

  if(argument[0] != '\0'){

  	if((from == 0) && (to == 0)) return;

  	if(to < from){
		i = to; to = from; from = i;
  	}
  }
  else{
	sprintf(t, "%s/usr/%c/%d/.uud", HOME, USER.name[0], USER.id);
	fp = fopen( t, "r" );
	if(fp == NULL){
		from = 1;	
	}
	else{
		fgets(s, STRING, fp);
		from = atoi( s ) +1;
		fclose(fp);

		fp = fopen( INHALT, "r" );
		if(fp == NULL){
			nerror("uudecode.c", 88, "uu_prep", "Can't read", INHALT);	
		}
		fgets(s, STRING, fp);
		fgets(s, STRING, fp);
		fgets(s, STRING, fp);
		fclose(fp);
		
		to = atoi( s );

		fp = fopen( t, "w" );
		fprintf(fp, "%d\n", to);
		fclose(fp);
	}

	if(from == (to +1)){
		printf("%s\n", UUD00dMSG);
		return;
	}
  }


  sprintf(t, "%s/usr/%c/%d/.uud", HOME, USER.name[0], USER.id);

  fp = fopen( t, "w" );
  fprintf(fp, "%d\n", to);
  fclose(fp);

  printf("\n");

  sprintf(p1, "%s/parsd.%d", TMP, getpid());
  fa = fopen( p1, "w" );

  sprintf(p2, "%s/parse.%d", TMP, getpid());
  ff = fopen(p2, "w" );

  for(loop = from; loop <= to; loop++){
	
	sprintf(s, "%s/%d", BRETT, loop );
	fp = fopen(s, "r" );
	if(fp != NULL){
		m = 0;
		subj[0] = '\0';
		part[0] = '\0';
		begi[0] = '\0';
		sect[0] = '\0';
		bild[0] = '\0';
	
		while((fgets(s, STRING, fp) != NULL) && (m < 3)){
			if(s[0] == 'M') m++;
			if(strcomp("Subject:", s) == 0){
				strcpy(subj, (UNSIGNED char *) stripped( strcopy( s, 9, strlen(s))));	
			}
			if(sgrep( s, "art" ) != 0){
				strcpy(part, (UNSIGNED char *) stripped( s ));
			}
			if((sgrep(s, "EGIN" ) != 0) || (sgrep(s, "egin") != 0)){
				if(strlen(s) < 12){
					fgets(s, STRING, fp);
					strcpy(begi, (UNSIGNED char *) "begin 644 ");
					strcat(begi, (UNSIGNED char *) s);	
				}
				else
					strcpy(begi, (UNSIGNED char *) stripped( s ));	
			}
			if(sgrep(s, "ection" ) != 0){
				strcpy(sect, (UNSIGNED char *) stripped( s ));
			}
		}		
		fclose(fp);

		if(m >= 3){
			printf("\n");
			ansi2( "md", 0, 0 );
			printf("%s", UUD02_MSG);
			ansi2( "me", 0, 0 );
			printf("%5d %s\n", loop, UUD00aMSG);
			strcpy(s, (UNSIGNED char *) "                                           ");
			s[strlen(UUD02_MSG)] = '\0';
			printf(" %s%s\n%s %s\n%s %s\n%s %s\n", s, subj, s, part, s, begi, s, sect);
			fprintf(ff, "%5d %s\n      %s\n      %s\n      %s\n", loop, subj, part, begi, sect);
	
			num1 = 0; num2 = 0; have_it = 0;

			if(part[0] != '\0'){
				a = 0;
				i = 0;
				while((a == 0) && (part[i] != '\0')){
					if(part[i] == '/') a = i;
					i++;
				}
				num1 = atoi( strcopy(part, (a -2), (a -1)));
				if(num1 == 0)
					num1 = atoi( strcopy(part, (a -1), (a -1)));	
				num2 = atoi( strcopy(part, (a +1), (a +3)));
	
				a = sgrep( part, "Part" ) -1;
				if(a != 0){
					if(part[(a-1)] != ' ') a--;
					i = a -2;
					b = 0;
					while((i > 0) && (b == 0)){
						if(part[i] == ' ') b = i +1;
						i--;
					}
					strcpy(bild, (UNSIGNED char *) strcopy(part, b, (a -2)));
					if(strlen(bild) > 2) have_it++;	
				}	
			}
		
			if((subj[0] != '\0') && (have_it == 0)){
				a = 0;
				i = 0;
				while((a == 0) && (subj[i] != '\0')){
					if(subj[i] == '/') a = i;
					i++;
				}
				i = atoi( strcopy(subj, (a -2), (a -1)));
				if(i == 0)
					i = atoi( strcopy(subj, (a -1), (a -1)));
				if(i != 0) num1 = i;	
				i = atoi( strcopy(subj, (a +1), (a +3)));
				if(i != 0) num2 = i;	

				a = sgrep( subj, "/" ) -1;
				if(a != 0){
					i = a;
					while((subj[i] != ' ') && (i > 0)) i--;
					while((subj[i] == ' ') && (i > 0)) i--;
					b = i;	
					while((subj[i] != ' ') && (i > 0)) i--;
			
					strcpy(bild, (UNSIGNED char *) strcopy(subj, i, b));		
					if(strlen(bild) > 2) have_it++;	
				}
			}
			
			if(sect[0] != '\0'){
				a = 0;
				i = 0;
				while((a == 0) && (sect[i] != '\0')){
					if(sect[i] == '/') a = i;
					i++;
				}
				i = atoi( strcopy(sect, (a -2), (a -1)));
				if(i == 0)
					i = atoi( strcopy(sect, (a -1), (a -1)));	
				if(i != 0) num1 = i;
				i = atoi( strcopy(sect, (a +1), (a +3)));
				if(i != 0) num2 = i;	

				a = sgrep(sect, "file") -1;
				if(a != 0){
					b = 0;
					i = a + 5;
					while((sect[i] != '\0') && (b == 0)){
						if(sect[i] == ' ') b = i -1;
						i++;	
					}
					strcpy(bild, (UNSIGNED char *) strcopy(sect, (a +5), b));
				}
			}

			if(bild[0] == '\0'){
				sprintf(bild, "none-%d.%04d", getpid(), none); 
				none++;
			}	

			sprintf(s, (UNSIGNED char *) "                               ");
			s[strlen(UUD02_MSG)] = '\0';
			ansi2( "us", 0, 0 );
			printf("%s %s: %d (%d) %s <%s>\n", s, UUD00bMSG, num1, num2, UUD00cMSG, (UNSIGNED char *) stripped(bild));
			ansi2( "me", 0, 0 );
	
			fprintf(ff, "      Guess: %d (%d) of <%s>\n\n", num1, num2, bild);
			fprintf(fa, "%-30s%5d%5d%10d\n", (UNSIGNED char *) stripped(bild), num1, num2, loop);
		}
	}
	else{
		fprintf(ff, "%5d: CAN'T OPEN <%s>\n", loop, s);
	}	

  } 
  fclose(ff); 
  fclose(fa);

  sprintf(p3, "%s/parsrt.%d", TMP, getpid());
  sprintf(s, "sort %s > %s", p1, p3);
  system(s);

  t[0] = '\0';
  s[0] = '\0';

  fp = fopen( p3, "r" );
  while(fgets(bild, STRING, fp) != NULL){
	if(s[0] != '\0'){
		if(strcomp(s, bild) != 0){
			uudecode( t );
			sprintf(t, "%s ", (UNSIGNED char *) stripped(strcopy(bild, 40, 50)));
			strcpy(s, (UNSIGNED char *) strcopy(bild, 0, 30));	
			printf("%s\n", s);
		}
		else{
			strcat(t, (UNSIGNED char *) stripped(strcopy(bild, 40, 50)));
			strcat(t, (UNSIGNED char *) " ");
		}
	}
	else{
		sprintf(t, "%s ", (UNSIGNED char *) stripped(strcopy(bild, 40, 50)));
		strcpy(s, (UNSIGNED char *) strcopy(bild, 0, 30));	
		printf("%s\n", s);	
	}
  }

  uudecode( t );

  unlink( p1 );
  unlink( p2 );
  unlink( p3 );

  printf("\n");
}


/* #UU - Uudecode one or more article(s). */

void uudecode( argument )
UNSIGNED char argument[];
{
  FILE *fp;
  FILE *ff;
  
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char old[STRING];
  UNSIGNED char older[STRING];
  UNSIGNED char name[STRING];

  int a = 0, b = 0, x = 0;
  int i;
  int ok = 0;
  int artno = 0, lines = 0;
  int uubegin = 0, uuend = 0;

  struct stat fst;


  headline( UUD01_MSG );

  sprintf(tmp, "%s/%d.UUDECODE", UUINCOMING, getpid());

  ff = fopen( tmp, "w" );
  if(ff == NULL){
	nerror("uudecode.c", 44, "uudecode", "Can't write to", tmp);	
	return;
  }

  a = 0;
  i = 0;
  while(argument[i] != '\0'){
	if(argument[i] == '-') a = i;
	i++;	
  }   
  if((a != 0) || (argument[0] == '\0')){
	prep_uu( argument, a );
	return;
  }
 

  strcat(argument, " ");


  while(argument[x] != '\0'){
	if(argument[x] == ' '){
		b = x - 1;
		strcpy(s, (UNSIGNED char *) bigcopy(argument, a, b));
		if(atoi(s) != 0){

			if (strcomp(BRETT, "PM") != 0) {
				sprintf(t, "%s/%s", BRETT, s);
			}
			else {
				sprintf(t, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, s);
			}
			
			fp = fopen( t, "r" );
			if(fp == NULL){
				goto NOT_FOUND;
			}
			ansi2("md", 0, 0);
			printf("\n%s", UUD02_MSG);
			ansi2("me", 0, 0);
			printf(" %s", s);
			artno++;
			lines = 0;

			while(fgets(s, STRING, fp) != NULL){
					if(strcomp("Subject:", s) == 0){
						i = 0;
						while(s[i] != '\0'){
							if(s[i] == '/'){
								strcpy(t, (UNSIGNED char *) strcopy(s, (i-2), (i-1)));
								if((atoi(t) != artno) && (atoi(t) != 0)){
									ansi2("md", 0, 0);
									printf("  %s (%d %s %d)", UUD03_MSG, atoi(t), UUD04_MSG, artno);
									ansi2("me", 0, 0);
								}
							}
							i++;
						}						
					}
					if((strcomp("begin", s) == 0) && (s[0] == 'b') && (strcomp("begin part ", s) != 0)){
						ok++;
						uubegin = 1;
						strcpy(name, (UNSIGNED char *) stripped( (UNSIGNED char *) strcopy(s, 10, 80)));
						printf("  [%s]", (UNSIGNED char *) name);
					} 
					if((strcomp("end",   s) == 0) && (s[0] == 'e')){
						ok++;
						uuend = 1;
						fputs(older, ff);
						fputs(old, ff);
 					}
					if((s[0] == 'M') && ((strlen(s) == 62) || (strlen(s) == 63))){
						ok++;
					}
			
					if(ok != 0){
						fputs(s, ff);
						lines++;
					}
					ok = 0;
			
					strcpy(older, (UNSIGNED char *) old);				
					strcpy(old, (UNSIGNED char *) s);			
			}			
			fclose(fp);
		}
		a = x + 1;
	}
	NOT_FOUND:
	x++;
  }

  fflush( ff );
  fclose( ff );

  printf("\n\n");

  if(strlen(name) < 2){
	sprintf(name, "noname.%d", noname);
 	noname++; 
  }

  if (uubegin == 0) {
	unlink( tmp );
	printf("%s\n", UUD05_MSG);
	return;
  }
  if (uuend == 0) {
	unlink( tmp );
	printf("%s\n", UUD06_MSG);
	return;
  }

  chdir( UUINCOMING );
  sprintf(s, "%s %s", UUDECODE, tmp);
  system( s );
  chdir( HOME );
/*
  unlink( tmp );    
*/
  sprintf(s, "%s/%s", UUINCOMING, name);
  stat(s, &fst);
  if(fst.st_size == 0){
	printf("%s\n", UUD06aMSG);
	return;
  }
 
  sprintf(s, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  fprintf(fp, "BINFILE\n");
  fprintf(fp, "%s/%s\n", UUINCOMING, name);
  fclose(fp);

  sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
  fp = fopen( s, "w" );
  fprintf(fp, "Decoded %s", name);
  fclose(fp);

  IS_BUFFERED = 1;

  sprintf(s, "%s$", USER.name);
  brief( s );

  printf("%s %s (%ld %s)\n", UUD07_MSG, name, fst.st_size, UUD08_MSG);

  IS_BUFFERED = 0;
}



/* #DR - Print a mail or an article. */

void drucken( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
 
  if (USER.level < ADMIN_LEV) {
	return;
  }

  if (strcomp(BRETT, "PM") != 0) {
	sprintf(s, "%s %s/%s", PRINTER, BRETT, argument);
  }
  else {
	sprintf(s, "%s %s/usr/%c/%d/%s", PRINTER, HOME, USER.name[0], USER.id, argument);
  }

  system(s);
}


/* #PW - Preview a (gif-) picture */

void preview( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;


  if (strcomp(BRETT, "PM") != 0) {
	sprintf(s, "%s/%s", BRETT, argument);
  }
  else {
	sprintf(s, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, argument);
  }

  t[0] = '\0';

  fp = fopen( s, "r" );
  if(fp == NULL){
	ansi2( "md", 0, 0 );
	printf("%s", UUD01aMSG);
	ansi2( "me", 0, 0 );
	return;
  }
  while(fgets(s, STRING, fp) != NULL){
	if(strcomp("BINFILE", s) == 0){
		fgets(s, STRING, fp);
		sprintf(t, "%s %s", PREVIEW, (UNSIGNED char *) stripped(s));
	}
  }
  fclose(fp);

  if(t[0] == '\0'){
	return;
  }
  else{
	printf("\n\n");
	system( t );
  }
}



/* #MD - Check whether a newsgroups is moderated  

   This functions returns 1 if the newsgroups has a moderator. */

int moderated( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char moderator[STRING];
  
  int ok = 0;

  FILE *fp;

#ifndef _MINIX
  return 0;
#endif

#ifdef _CNEWS
  return 0;
#endif

  if((strcomp("local", argument) == 0) && (USER.level >= ADMIN_LEV)) return 0;

  fp = fopen( MODERATORS, "r" );
  if(fp == NULL){
	nerror("uudecode.c", 279, "moderated", "Can't read", MODERATORS);	
	return;
  }
  while(fgets(s, STRING, fp) != 0){
	if(strcomp(NG, s) == 0){
		sscanf(s, "%s %s", t, moderator);
		ok = 1;
	}
  } 
  fclose(fp);
  
  if(ok == 1){
	ansi2( "md", 0, 0 );
	printf(" <- %s\n", UUD09_MSG );
	ansi2( "me", 0, 0 );

	brief( moderator );
  }

  return (int) ok;
}


/* #SV - Screen saving mode */

void saver()
{
  UNSIGNED char s[STRING];
  int a[5][30];
  int i, p;
  int fpid;
  int c;
  int n = 0;
  int first_choice;
  int b1, b2, b3, b4, b5;


  first_choice = (rand() % 4) + 1;
  first_choice = (rand() % 4) + 1;
  first_choice = (rand() % 4) + 1;

  strcpy(s, (UNSIGNED char *) mytime( 0 ));
  srand( (int) atoi( (UNSIGNED char *) strcopy(s, 6, 7 ) ));
  
  for(i = 1; i < 29; i++){
	a[1][i] = (rand() % 78) +  1;
	a[2][i] = (rand() % 24) +  1;
	a[3][i] = (rand() %  7) +  1;
	a[4][i] = (rand() %  4) +  1;
  }
  
  switch( (fpid = fork()) ){
	case -1 :
		return;	
		break;
	case  0 : 

#ifndef _ESTDIO
		nice( 15 );
#endif
		if(USER.schluessel[3] == 128){ /* MS-DOS Charset */	
			b1 = 219; b2 = 250; b3 = 249; b4 = 254; b5 = 220;
		}
		else{				/* Other Charsets (i.e. LINUX) */
			b1 =  32; b2 =  46; b3 =  46; b4 =  46; b5 = 164;
		}

		if(first_choice == 3){

			a[1][1] = 40;
			a[1][2] = 13;
			a[1][3] = 0;

			while(1){
				p = rand() % 20 + 1;
				n = rand() % 4 + 1;
			
				for(i = 0; i <= p; i++){

					do{
						switch(n){
							case 1 : a[1][1]--;
								 break;
							case 2 : a[1][1]++;
								 break;
							case 3 : a[1][2]--;
								 break;
							case 4 : a[1][2]++;
								 break;
						}

						if ((a[1][1] < 1) || (a[1][1] > 79) ||
						    (a[1][2] < 1) || (a[1][2] > 24)){
							n++;
							if(n > 4) n = 1;	
							a[1][3]++;
							if(a[1][3] == 3) a[1][3]++;
							if(a[1][3] > 7) a[1][3] = 0;
						}
					}while((a[1][1] < 1) || (a[1][1] > 79) ||
					       (a[1][2] < 1) || (a[1][2] > 24));

					ansi2( "cm", a[1][1], a[1][2] );
					printf("%c[30;%dm", ESC, 40 + a[1][3]);
					printf("  ");
					ansi2( "cm", 1, 24 );				
					printf("%c[0m%c[30;40m%c%c", ESC, ESC, 32, 8);
					msleep( 1 );	
				}	
			}
		}

		if(first_choice == 1){

			ansi2( "cl", 0, 0 );
	
			while(1){

				for(i = 19; i > 1; i--){
					
					if(a[4][i] < 3){
						printf("%c[%dm", ESC, 30 + a[3][i]);
					}
					else{
						if(a[4][i] < 5){
							printf("%c[1;%dm", ESC, 30 + a[3][i]);
						}
						else	
							printf("%c[%dm", ESC, 30);
					}	

					ansi2( "cm", a[1][i], a[2][i]);

					switch(a[4][i]){
						case 1 : printf("%c", b2);
							 break;
						case 2 : printf("%c", b3);
							 break;
						case 3 : printf("%c", b3);
							 break;
						default: printf(" ");
							 break;
					}		
					printf("%c[0m%c[30;40m%c%c", ESC, ESC, b1, 8);

					a[4][i] += 1;
					
					if(a[4][i] > 5){
						a[1][i] = (rand() % 78) + 1;
						a[2][i] = (rand() % 24) + 1;
						a[3][i] = (rand() %  7) + 1;
						a[4][i] = 1;
					}
				}
				msleep( 50 );
			}
		}
			
		if(first_choice == 2){

			ansi2( "cl", 0, 0 );

			while(1){

				for(i = 28; i > 1; i--){		

					ansi2( "cm", a[1][i], a[2][i]);
					printf("  ");	
					
					printf("%c[0m%c[30;40m%c%c", ESC, ESC, b1, 8);

					if(a[1][i] < 40){
						a[1][i] -= rand() % 3 + 1;
						if(a[1][i] < 1){
							a[1][i] = (rand() % 5) + 37;
							a[3][i] = (rand() % 15) +  1;	
						}
					}			
					else{
						a[1][i] += rand() % 3 + 1;
						if(a[1][i] > 78){
							a[1][i] = (rand() % 5) + 37;
							a[3][i] = (rand() % 15) +  1;
						}
					}	

					if(a[2][i] < 13){
						a[2][i] -= rand() % 3 + 1;
						if(a[2][i] < 1){
							a[2][i] = (rand() % 3) + 12;
							a[3][i] = (rand() % 15) +  1;
						}
					}
					else{
						a[2][i] += rand() % 3 + 1;
						if(a[2][i] > 25){
							a[2][i] = (rand() % 3) + 12;
							a[3][i] = (rand() % 15) +  1;		
						}
					}
			
					p = a[3][i];
					if(p > 8)
						printf("%c[1;%dm", ESC, 30 + a[3][i] - 8);
					else
						printf("%c[%dm", ESC, 30 + a[3][i]);

					ansi2( "cm", a[1][i], a[2][i]);
	

					if(((a[1][i] > 20) && (a[1][i] < 60)) &&
					   ((a[2][i] > 8) && (a[2][i] < 18))){
						printf("%c", b4);
					}
					else{
						if(((a[1][i] > 10) && (a[1][i] < 70)) &&
						   ((a[2][i] > 4) && (a[2][i] < 22))){
							printf("%c", b5);
						}
						else{
							if(p > 8)
								printf("%c[1;%dm", ESC, 40 + a[3][i] - 8);
							else
								printf("%c[%dm", ESC, 40 + a[3][i]);
							printf("%c%c", b1, b1);
						}
					}				
					printf("%c[0m%c[30;40m%c%c", ESC, ESC, b1, 8);
				}
				msleep( 50 );
			}
		}

		if(first_choice == 4){

			ansi2( "cl", 0, 0 );

			printf("%c[32m", ESC);	

			p = (rand() % 4) + 7;			

			for(i = 1; i < p; i++){
			 	a[1][i] = (rand() %   60) + 1;
				a[2][i] = (rand() %   23) + 1;
				a[3][i] = (rand() %    8) + 1;
				a[4][i] = (rand() % 1000) + 1; 	
				a[5][i] = (rand() % 1000) + 1;
			}
	
			while(1){

				for(i = 1; i < p; i++){
					ansi2( "cm", a[1][i], a[2][i] );
					printf("         ");
					ansi2( "cm", a[1][i], a[2][i] + 1 );

					if(a[4][i] == 11111)
						printf("             ");
					else
						printf("       "); 
					msleep( 80 );

					n = 0;

					for(c = 1; c < i; c++){
						if(((a[2][c] > a[2][i]- 2) && (a[2][c] < a[2][i]+ 2)) &&
						   ((a[1][c] > a[1][i]-13) && (a[1][c] < a[1][i]+13))) n++;
					}

					if(n == 0){
						if(a[1][i] < 40) a[1][i] += 3;
						if(a[1][i] > 40) a[1][i] -= 3;

						if(a[2][i] < 11) a[2][i]++;
						if(a[2][i] > 11) a[2][i]--;	
					}

					if(a[4][i] == 11111){
			 			a[1][i] = (rand() %   60) + 1;
						a[2][i] = (rand() %   23) + 1;
						a[3][i] = (rand() %    8) + 1;
						a[4][i] = (rand() % 1000) + 1; 	
						a[5][i] = (rand() % 1000) + 1;
					}

					printf("%c[0m", ESC);

					if(a[4][i] < 100)
						printf("%c[1;5;32m", ESC);
					else
						printf("%c[32m", ESC);	

					ansi2( "cm", a[1][i], a[2][i] );
					printf("o ");
					
					switch( a[3][i] ){
						case 1 : printf("TWA"); 
							 break;
						case 2 : printf("LTU");
							 break;
						case 3 : printf("LH");
							 break;
						case 4 : printf("GBL");
							 break;
						case 5 : printf("SPA");
							 break;
						case 6 : printf("AUS");
							 break;
						case 7 : printf("TAA");
							 break;
						case 8 : printf("BA");
							 break;
					}
			
					printf(" %03d", a[5][i]);

					a[4][i] -= ((rand() % 10) + 1 ) * i;

					ansi2( "cm", a[1][i], a[2][i] + 1 );

					if(a[4][i] < 0){
						a[4][i] = 11111;
						printf("%c[0m", ESC);
						printf("%c[31m", ESC);
						printf("  Out of Fuel");
					}
					else{
						if(((a[1][i] >= 38) && (a[1][i] <= 42)) && (a[2][i] == 11)){
							a[4][i] = 11111;
							printf("  Stabled");
						}
						else{
							printf("  %d%%", a[4][i]);
						}	
					}
					msleep( 80 );
				}

			}
		}
  }
    
  c = getint();
  c = getint();

  kill( fpid, SIGKILL );
  (void) wait( &fpid );		

  if(USER.schluessel[2] == INTEL_INSIDE) 	
	printf("%c[37;40m %c", ESC, BS);

  ansi2( "me", 0, 0 );
  ansi2( "cm", 1, 1 );

  for(i = 0; i < 25; i++){
	ansi2( "al", 0, 0 );
	msleep( 10 );
  }

  headblock( LOP14_MSG, LOP15_MSG );
  show(CALLS, 19, USER.more);

  return;  
} 



/* #UR - Update request (UNNET internal) */

void update_rq( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  UNSIGNED char version[STRING];
  UNSIGNED char sysop[STRING];
  UNSIGNED char phone[STRING];
  UNSIGNED char sysname[STRING];
  UNSIGNED char sysorga[STRING];
  UNSIGNED char bbsname[STRING]; 

  int users, calls;
  int a, b;

  FILE *fp, *ff;


  phone[0] = '\0';

  sprintf(s, "%s/MAILING/Installations", HOME);
  ff = fopen( s, "a" );

  if (strcomp(BRETT, "PM") != 0) {
	sprintf(s, "%s/%s", BRETT, argument);
  }
  else {
	sprintf(s, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, argument);
  }

  fp = fopen( s, "r" );
  while(fgets(s, STRING, fp) != 0){
	if(strcomp("This is ", s) == 0){
		a = sgrep(s, " on <"); 
		strcpy(version, (UNSIGNED char *) strcopy(s, 20, a-1));
		strcpy(sysname, (UNSIGNED char *) stripped(strcopy(s, (a+4), 80)));
		sysname[(strlen(sysname) -2)] = '\0'; sysname[27] = '\0';
	}
	if(strcomp("My sysop", s) == 0){
		a = sgrep(s, " of ");
		strcpy(sysop, (UNSIGNED char *) strcopy(s, 9, a-2));
		strcpy(sysorga, (UNSIGNED char *) stripped(strcopy(s, (a+5), strlen(s))));
	}
	if(strcomp("Our systems'", s) == 0){
		strcpy(bbsname, (UNSIGNED char *) strcopy(s, 21, strlen(s)-2));
	}
	if(strcomp("and we joggle", s) == 0){
		strcpy(t, (UNSIGNED char *) strcopy(s, 26, strlen(s)));
		users = atoi(t);
		a = sgrep(s, "users (");
		strcpy(t, (UNSIGNED char *) strcopy(s, (a+6), strlen(s)));
		calls = atoi(t);
	}
	if(strcomp("You also might", s) == 0){
		strcpy(phone, (UNSIGNED char *) strcopy(s, 33, strlen(s)-6));
	}	
  }
  fclose(fp);
  
  fprintf(ff, "000 %-27.27s %-13.13s %5d %9d   %s\n", sysname, sysop, users, calls, version);
  if(phone[0] != '\0') fprintf(ff, "    %s\n", phone);

  fclose(ff);
}



/* #DR - Distribution request (UNNET internal) */

void distrib_rq( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];


  if (strcomp(BRETT, "PM") != 0) {
	sprintf(s, "%s/%s", BRETT, argument);
  }
  else {
	sprintf(s, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, argument);
  }

  strcpy(t, (UNSIGNED char *) fetch_reciepy( s ));

  sprintf(s, "/bin/sh %s/contrib/distrib %s", HOME, t);
  printf("\nDistrib Request ...\n\n");
  system( s );
  printf("\n");
}

void newhead_rq( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;
  FILE *ff;


  ff = fopen( "/tmp/shit", "w" );
  fp = fopen( argument, "r" );
  if(fp == NULL){
	return;
  }
  while(fgets(s, STRING, fp) != 0){
	fprintf(ff, "%s", s);
	if(strcomp("Subject: ", s) == 0){
		printf("Keywords: ");
		strcpy(t, (UNSIGNED char *) getline(50, 1, ' ', ""));
		fprintf(ff, "Keywords: %s\n", t);
	}
  }
  fclose(fp);
  fclose(ff);

  mbrename( "/tmp/shit", argument );
}



/* #CA - Make sure only adults can enter certain newsgroups
         This function returns -1 if users are NOT allowed to
         enter a group. */

int chk_adult( o )
UNSIGNED char o[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char r[5];
 
  int ok = 1, i, j, a, b, c, l;

  int maxq, cora, fehler = 0; 

  FILE *fp;

  
  if(strcomp(ADULTNG, o) != 0) return (int) 1;
  if(yet_adult != 0) return (int) 1;

  sprintf(t, "%s/src/languages/%s.adt", HOME, LANGUAGE);
  fp = fopen( t, "r" );
  if(fp == NULL){
	nerror("uudecode.c", 1101, "chk_adult", "Can't read", t);	
  }

  adult_run++;

  if(adult_run > 3){
	ansi2( "md", 0, 0 );
	printf("\n\n\nZugriff verweigert! Pro Anruf duerfen nur drei Versuche unternommen\n");
	printf("werden, um in dieses Brett zu kommen!\n\n");
	ansi2( "me", 0, 0 );
	printf("Das Brett [%s] ist nix fuer Kinder!");
	return (int) -1;
  }
  
  ansi2( "md", 0, 0 );
  printf("\n\n\nZugriff nur fuer Erwachsene! Bitte beantworten Sie die drei nun folgenden\n");
  printf("Fragen korrekt, um Ihre Qualifikation zu beweisen!\n\n");
  ansi2( "me", 0, 0 ); 

  i = 0;
  strcpy(t, (UNSIGNED char *) "000");

  do{ 
	i++;
	rewind(fp);
	fgets(s, STRING, fp);
	maxq = atoi(s) -1;
	if(maxq == 0){
		nerror("uudecode.c", 1111, "chk_adult", "No answers in", t);	
	}

	do{	
 		a = (rand() % maxq);
	}while((a == r[0]) || (a == r[1]));

	b = 0; r[(i-1)] = a;

	while(b < a){
		fgets(s, STRING, fp);
		if(strlen(s) < 3) b++;
	}

  	fgets(s, STRING, fp);
	printf("%s\n");
	
	for(j = 1; j < 5; j++){
		fgets(s, STRING, fp);
		l = strlen(s) -2;
		if(s[l] == '*'){
			s[l] = ' ';
			cora = j + 48;
		}
		printf("%d  -  %s", j, s);
	}

	ansi2( "md", 0, 0 );
	printf("\nWie lautet die korrekte Antwort? ");
	ansi2( "me", 0, 0 );

	do{
		c = getch();
	}while((c < '1') || (c > '4'));

	if(c == cora){
		printf("%c ist korrekt!\n\n", c);
	}
	else{
		printf("%c ist falsch!\n\n", c);
		fehler++;
		if(fehler > 1)
			ok = -1;
		else
			i--;
	}
  }while((i < 3) && (ok == 1));

  if(ok == -1){
	printf("Das Brett [%s] ist nix fuer Kinder!");
	sprintf(s, (UNSIGNED char *) "<ADULT> No Access! (%d)", i);	
	strcpy(BRETT, (UNSIGNED char *) "PM");
	sprintf(NG, "%s.PM", USER.name);
	sprintf(INHALT, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
  }
  else{
	printf("Alles klar. Zugriff gestattet ...\n");
	sprintf(s, (UNSIGNED char *) "<ADULT> Alright!");
	yet_adult++;
  }
  control( s, 3 );

  fclose(fp);

  return (int) ok;
}


/* #MM - Take seconds an make up a time output readable by humans.
*/

UNSIGNED char *make_time( seconds )
int seconds;
{
  static UNSIGNED char s[STRING];

  int hour, min, secs;

  hour = seconds / 3600;
  min  = (seconds - (hour * 3600)) / 60;
  secs = seconds - (hour * 3600) - (min * 60);

  sprintf(s, "%02d:%02d:%02d", hour, min, secs);

  return (UNSIGNED char *) s; 
}
