/* ix/MBox (pd.c) by Volker Schuermann, 04.12.1993
 
   This C source code contains the following functions:
 
   #PD pd()              sending a file to user under protocol control
   #ST status()          display users preferences
   #MK mkix()            making a file unix-like
   #SK statistik()       building statistics of the CALLS file
   #AR archivieren()     pack&compress a couple of articles
   #DL download()        do the downloading of a group of files
   #AT alltime()         show "all calls ever"
   #AU auslastung()	 print the usage of the terminal ports

   Contact <volkers@unnet.wupper.de> for help! */




 
  
#include <stdio.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/stat.h>
#include <time.h>

#include "mbox.h"




/* #PD - A file [arg] is transfered under protocol (SZ, SB, SX) control.

   [keywds] stands for Keywords. This header line should contain a 
   few words describing the contents of the file. */

void pd(arg, keywds)
UNSIGNED char arg[], keywds[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char c;
  UNSIGNED char protokoll;
  UNSIGNED char cd[STRING];
  long ts, tn;

  int cps, bps, eff;
  int ok, i;
  int bytes = 0;

  strcpy(cd, stripped(arg));

  printf("\n\n");
  ansi2("md", 0, 0);
  printf("%s\n\n", PD01_MSG);
  
  if(keywds[0] != '\0'){
	printf("%s ", PD02_MSG); 
	ansi2("me", 0, 0);
	printf("%s\n\n", keywds);
  }
  else{
	 ansi2("me", 0, 0);
  }

  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c, (%c)] >  ", CR, PD03_MSG, GBL06_MSG, GBL07_MSG, PD06_MSG);
  ansi2("me", 0, 0);

  do {
	c = getint();
	if (c >= 97) c -= 32;
	if ((c != GBL06_MSG) && (c != GBL07_MSG) && (c != PD06_MSG)) c = 0;
  } while (c == 0);

  printf("%c", c);

  if (c == PD06_MSG) {	/*  X  */
	printf("\n");
	sigcatch(SIGINT);	
  }

  if (c != GBL06_MSG) {	/*  J  */
	printf("\n");
	return;
  }


  if(DOWN_PROT == 0){ 

	ansi2("mr", 0, 0);
	printf("%c[%s] %c, %c, %c, %c ? > ", CR, PD07_MSG, PD08_MSG, PD09_MSG, PD10_MSG, PD11_MSG);
	ansi2("me", 0, 0);


	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi2("mr", 0, 0);
			printf("%c%s > ", CR, PD12_MSG);
			ansi2("me", 0, 0);
		}
		if ((protokoll != PD08_MSG) && (protokoll != PD09_MSG) &&
		    (protokoll != PD10_MSG) && (protokoll != PD11_MSG))
			protokoll = 0;
	} while (protokoll == 0);


	printf("%c", protokoll);
  }
  else{
	switch( DOWN_PROT ){
		case 1: protokoll = PD09_MSG; /* X Modem */
			break;
		case 2: protokoll = PD10_MSG; /* Y Modem */
			break;
		case 3: protokoll = PD11_MSG; /* Z Modem */
			break;
		case 4: protokoll = PD08_MSG; /* ASCII */
			break;
	}
  }

  printf("\n\n");
  ansi2("md", 0, 0);
  printf("%s\n\n", PD13_MSG);
  ansi2("me", 0, 0);

  time(&ts);

  if(check_binfile( cd ) != 0) return;

  switch (protokoll) {
      case PD08_MSG:
		sprintf(s, "exec cat %s", cd);
		break;
      case PD09_MSG:
		sprintf(s, "exec %s -b %s 2> /dev/null", SX, cd);
		break;
      case PD10_MSG:
		sprintf(s, "exec %s %s 2> /dev/null", SB, cd);
		break;
      case PD11_MSG:
		sprintf(s, "exec %s %s 2> /dev/null", SZ, cd);
		break;
  }
  system( s );

  time(&tn); tn = tn - ts; 

  sprintf(tmp, "%s/dnl.%d", TMP, getpid());
  sprintf(s, "wc -c %s > %s", cd, tmp);
  system( s ); 
  fp = fopen( tmp, "r" );
  if(fp == NULL){
	nerror("pd.c", 154, "pd", "Can't read from", tmp);	
  }
  while(fgets(s, STRING, fp) != 0) bytes += atoi(s);
  fclose(fp); 
  unlink( tmp );

  ansi2( "md", 0, 0 );
 
  if(tn < 1) tn = 1;
  cps = bytes / tn;
  bps = cps * 11;

  BAUDRATE = baudrate( bps );

  eff = ((100000 / BAUDRATE) * bps) / 1000;  

  if(bps > BAUDRATE){
	printf("\n\n%s\n", PD14_MSG);
	ok = -1;
  }
  else{
	printf("\n\n%d %s.\n", bytes, PD15_MSG);
	ok = 0;
  }

  ansi2( "me", 0, 0 );
  printf("%s %d cps (ca. %d bps).", PD16_MSG, cps, bps);
  sprintf(tmp, "%s/%d.pd", TMP, getpid());
  ff = fopen( tmp, "w" );


  if(ok == 0){
	fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, cd); 
	if((bps < BAUDRATE) && (bps > 0)){
		fprintf(ff, "  %6d  %6d  %2d%% OK\n", cps, bps, eff);
	}
	else{
		fprintf(ff, "  %6d  %6d  %2d%% BRK\n", cps, bps, eff);
	}
  }

  i = 0;

  fp = fopen( PDLOG, "r" );
  if(fp != NULL){
	while((fgets(s, STRING, fp) != NULL) && (i < PRO_ENTRIES)){
		fputs(s, ff);
		i++;
	}
	fclose(fp);
  }

  fclose(ff);

  sprintf(cd, "mv %s %s", tmp, PDLOG);
  system( cd );

  printf("\n");
}






/* #ST - Show users preferences. */

void status()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char ex[255];
  int i;


  sprintf(s, " %s %d) %s ", PD18_MSG, USER.id, USER.name);
  headline(s);
  printf("\n");

  ansi2("md", 0, 0);
  printf("%s", PD19_MSG);
  ansi2("me", 0, 0);

  printf("\n");

  sprintf(ex, "%s                                        ", USER.name);
  ex[27] = '\0';
  strcat(ex, USER.nick);
  strcat(ex, "                            ");
  ex[45] = '\0';
  strcat(ex, USER.geburtsdatum);
  strcat(ex, "                            ");
  ex[62] = '\0';
  strcat(ex, USER.telefon1);
  printf("%s\n", ex);

  sprintf(ex, "%s                                        ", USER.strasse);
  ex[27] = '\0';
  strcat(ex, USER.sh_name);
  strcat(ex, "                            ");
  ex[45] = '\0';
  strcat(ex, "                            ");
  ex[62] = '\0';
  strcat(ex, USER.telefon2);
  printf("%s\n", ex);

  printf("%s\n\n", USER.wohnort);
  ansi2("md", 0, 0);
  printf("%s", PD20_MSG);  
  ansi2("me", 0, 0);
  printf("\n");

  s[0] = '\0'; strcat(s, datereconv( LASTLOG ));
  strcat(s, "-"); strcat(s, timereconv( LASTTIME ));
  s[16] = '\0';

  sprintf(ex, "       %1d       %1d  %5d     %1d       %1d     %1d      %1d  %6d  %s",
	USER.terminal, USER.editor, USER.level, USER.bell, USER.prompt, USER.more, USER.intro, USER.seq, s);
  printf("%s\n\n", ex);

  ansi2("md", 0, 0);
  printf("%s", PD21_MSG);  
  ansi2("me", 0, 0);
  sprintf(ex, "\n%08.8d                    %06.6d                    %06.6d",
	(USER.elapsed / 60), USER.upratio, USER.downratio);
  printf("%s\n\n", ex);

  ansi2("md", 0, 0);
  printf("%s", PD22_MSG);
  ansi2("me", 0, 0);

  i = 0;
  strcpy(s, (UNSIGNED char *) USER.name);
  while (s[i] != '\0') {
	if (s[i] == ' ') s[i] = '.';
	i++;
  }

  sprintf(t,  "%s: %s@%s", PD23_MSG, s, UUCPID);
  strcpy(d, USER.account); d[10] = '\0';
  strcpy(s, (UNSIGNED char *) strcopy(USER.account, 11, 16));
  i = atoi(s); 
  sprintf(s, "%s  %3d.%02d", d, fix(i), flt(i));
  sprintf(ex, "%-54.54s%s DM\n%s: %s%s", t, s, PD24_MSG, UUCPBANG, USER.nick);
  printf("\n%s\n", ex);
  if (USER.sh_name[0] != '\0')
	printf("%s: %s!%s\n", PD25_MSG, UUCPSITE, USER.sh_name);

  printf("\n");

  ansi2("md", 0, 0);
  printf("%s\n", PD26_MSG);

  ansi2("me", 0, 0);

  printf("%s", USER.newsgrps);

  printf("\n\n");  
}





/* #MX - Converting a file [s] to unix format (i.e. deleting CRs). 

   This function doesn't return anything. The file [s] itself is changed. */

void mkix( pfad )
UNSIGNED char pfad[];
{
  FILE *fp; 
  FILE *ff;

  UNSIGNED char s[LONGSTRING];
  UNSIGNED char p[LONGSTRING];

  int i, ok = 0;

  
  sprintf(p, "%sabc", pfad);

  fp = fopen( pfad, "r" );
  if(fp == NULL){
	return;
  }  	

  ff = fopen( p, "w" );
  if(ff == NULL){
	nerror("pd.c", 243, "mkix", "Can't write to", p);	
  }

  while((ok == 0) && (fgets(s, LONGSTRING, fp) != NULL)){
	i = 0;
	while(s[i] != '\0'){
		if(s[i] == CTRL_Z){
			ok++;
			break;
		}
		i++;
	}
	if(ok == 0){
		i = strlen(s) -2;
		if(s[i] == CR){
			s[i]    = LF;
			s[i +1] = '\0';
		}
		fputs(s, ff);
	}
  }
  fclose(fp);
  fclose(ff);

  unlink(pfad);
  mbrename(p, pfad);
}





/* #SK - Develope a graphical statistic from the CALLS file. */

void statistik()
{
  FILE *fp;

  struct tm *tp;
  time_t tt;

  UNSIGNED char s[STRING];
  UNSIGNED char od[MAX_TAGE][STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char r[STRING];

  UNSIGNED char ex[LONGSTRING];

  int v18u[MAX_TAGE];
  int n18u[MAX_TAGE];
  int v18g = 0;
  int n18g = 0;

  int zeit = 0;
  int tage = 0;
  int max  = 0;

  int i, a;
  int toggle = 0;
  int sonntag;

  int sdep = 7;


  if(USER.terminal == ISO6429) sdep -= 3;

  fp = fopen( CALLS, "r" );
  if(fp == NULL){
	nerror("pd.c", 288, "statistik", "Can't read", CALLS);		
  }

  od[0][0] = '\0';

  headblock( PD27_MSG, PD28_MSG );

  while((fgets(s, (STRING *2), fp) != NULL) && (tage < (MAX_SCR_LINES -sdep))){
	strcpy(t, (UNSIGNED char *) strcopy(s, 64, 71));

	if(strcomp(t, od[tage]) != 0){
		if(tage != 0){
			if((v18u[tage] + n18u[tage]) > max){
				max = v18u[tage] + n18u[tage];
			}
			v18g += v18u[tage];
			n18g += n18u[tage];
		}
		tage++;
		od[tage][0] = '\0'; strcat(od[tage], t);
		v18u[tage] = 0;
		n18u[tage] = 0;
        }
	zeit = atoi(strcopy(s, 74, 75));
	if((zeit >   6) && (zeit < 18)) v18u[tage]++;
	if((zeit >= 18) || (zeit <= 6)) n18u[tage]++;
  }

  sprintf(s, "%s", "ooooooooooooooooooooooooooooooooooooooooooooooooooooo");

  time(&tt);
  tp = localtime(&tt);
  sonntag = tp->tm_wday;

  for(i = 1; i < tage; i++){
	sprintf(t, "%s", s);
	a = (290 / max * (v18u[i] + n18u[i])) / 10;
	if(a < 1) a = 1;
	t[a] = '\0';	
	strcpy(r, "    ");	
	if(sonntag == 0){
		strcpy(r, PD29_MSG);
		toggle++;	
		ansi2( "md", 0, 0 );
	}
	if(sonntag == 6) 
		strcpy(r, PD30_MSG);
	sonntag--;
	if(sonntag == -1) sonntag = 6;

	printf("%s %s %4d        %5d         %5d      %s\n",
                od[i], r, v18u[i], n18u[i], v18u[i]+n18u[i], t);
	if(toggle != 0) ansi2( "me", 0, 0 );
	toggle = 0;
  }

  if(USER.terminal != ISO6429){
	printf("-------------------------------------------------------------------------------\n");
	if((tage-1) > 0){
		printf("%s %5d        %5d         %5d      %s (%d %s)\n",
			PD31_MSG, v18g, n18g, v18g+n18g, PD32_MSG, (v18g+n18g)/(tage-1), PD32aMSG);
	}
	else{
		printf("%s %5d        %5d         %5d      %s\n",
			PD31_MSG, v18g, n18g, v18g+n18g, PD32_MSG);
	}
	printf("===============================================================================\n");
  }
  else{
	if((tage-1) > 0){
		sprintf(ex, (UNSIGNED char *) "%s %5d        %5d         %5d      %s (%d %s)",
			PD31_MSG, v18g, n18g, v18g+n18g, PD32_MSG, (v18g+n18g)/(tage-1), PD32aMSG);
	}
	else{
		sprintf(ex, (UNSIGNED char *) "%s %5d        %5d         %5d      %s",
			PD31_MSG, v18g, n18g, v18g+n18g, PD32_MSG);
	}
	ansi2( "X1", 0, 0 );	
	strcat(ex, (UNSIGNED char *) "                                                                            ");
	ex[79] = '\0';
	printf("%s\n", ex); 
	ansi2( "me", 0, 0 );
  }

  printf("\n%s %d %s.\n", PD33_MSG, (tage -1), PD34_MSG);   

  fclose(fp);
}







/* #AR - Select a packer / compresser and treat a list of articles [arg].

   This function returns the name/path of the new "package". */

UNSIGNED char *archivieren( arg )
UNSIGNED char arg[];
{
  FILE *fp;
  int i, c;

  struct stat fstat;

  UNSIGNED char s[LONGSTRING+STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char packers[10][STRING];
  UNSIGNED char adds[10][STRING];
  UNSIGNED char tar[10][STRING];
  UNSIGNED char en[10][STRING];
  UNSIGNED char cd[LONGSTRING];

  int fpid;


  headline( PD37_MSG );
  printf("\n");

  sprintf(s, "%s/%s", HOME, PACKERS);
  fp = fopen(s, "r");
  if (fp == NULL) {
	nerror("pd.c", 495, "archivieren", "Can't read", s);
  }

  if(DOWN_PACK == 0) printf("  1 - Text/ASCII\n\n");
  strcpy(packers[1], (UNSIGNED char *) "cat");
  strcpy(adds[1], (UNSIGNED char *) "?");
  strcpy(tar[1], (UNSIGNED char *) "-");
  en[1][0] = '\0';
 
  i = 1;
  while((fgets(s, 80, fp) != NULL) && (s[0] != '='));
  while((i < 10) && (fscanf(fp, "%s %s %s %s %s", s, packers[i], adds[i], tar[i], en[i]) > 0)){
	i++;
	if(DOWN_PACK == 0) printf("  %d - %s\n\n", i, s); 
  }
  fclose(fp);

  if(DOWN_PACK == 0){
	ansi2("md", 0, 0);
	printf("\n%s > ", PD38_MSG);
	ansi2("me", 0, 0);

	c = getint();
	if(c > 32) printf("%c", c);
	c -= 49;

	if((c > i) || (c < 0)) return (UNSIGNED char *) "Noe!";
	
	printf("\n\n");
  }
  else{
	c = DOWN_PACK - 1;
  }

  
  printf("%s .", PD39_MSG);

  switch( (fpid = fork()) ){
	case -1 :
		break;
	case  0 : 
		while(1){
			printf(".");
			sleep(2);
		}	
		break;
  }

  strcpy(cd, (UNSIGNED char *) arg);


  if(c != 0){

	if(tar[c][0] != '-'){
		sprintf(t, "%s.tar", mytime(0));
		t[5] = '-';
		t[2] = '-';
		sprintf(s, "exec %s %s %s > /dev/null 2>&1", TAR, t, cd);
		system( s );
		strcpy(cd, (UNSIGNED char *) t);
	}    
	else{
		sprintf(t, "%s", mytime(0));
		t[5] = '-';
		t[2] = '-';
	}

	if(adds[c][0] == '?')
		sprintf(s, "exec %s %s > /dev/null 2>&1", packers[c], cd);
	else
		sprintf(s, "exec %s %s %s %s > /dev/null 2>&1", packers[c], adds[c], t, cd);

	system( s );

	unlink( t );

	strcat(t, (UNSIGNED char *) en[c]);

  }
  else{		/* Text/ASCII */
	
	sprintf(t, "%s", mytime(0));
	t[5] = '-';	
	t[2] = '-';

	sprintf(s, "exec %s %s > %s", packers[c], cd, t);

	system( s );
  }

  kill( fpid, SIGKILL );
  (void) wait( &fpid );

  clearline();

  if(tar[c][0] != '-'){
	ansi2( "md", 0, 0 );
	printf( PD40_MSG );
	ansi2( "me", 0, 0 );
	printf("%s\n", PD41_MSG);
  }  

  stat(t, &fstat);
  printf("%s \"%s\" %s %ld %s.", PD42_MSG, t, PD43_MSG, fstat.st_size, PD44_MSG);


  return (UNSIGNED char *) t;
}






/* #DL - Transfer one or a couple of article(s) [arg] to a user. */

#define MAX_DL_FILES 50

void download( arg )
UNSIGNED char arg[];
{
  int i, k, l, m;
  int von, bis;
  int protokoll, ok;
  int cps, bps, eff;

  long ts, tn;
  long bytes_total = 0L;

  struct stat fst;

  UNSIGNED char s[STRING];
  UNSIGNED char cd[LONGSTRING];
  UNSIGNED char t[(LONGSTRING+STRING)];
  UNSIGNED char tmp[STRING];
  UNSIGNED char ta[STRING];

  UNSIGNED char files[MAX_DL_FILES][STRING];
  int mdlp = 1;

  int art[MAX_PER_NG];
  int artp = 0;
  int lastart;

  int havetokill = 0;


  FILE *fp, *ff;


  if(arg[0] == '\0'){
	ansi( "md" );
	printf(" <- %s\n", PD35_MSG);
	ansi( "me" );
	intuition( 440 );
	return;
  }
 
  if(arg[0] == '!'){
        headline( PD35aMSG ); 
  	
  	printf("\n 1 - X Modem %s\n", PD35bMSG); 
        printf("\n 2 - Y Modem %s\n", PD35bMSG);
  	printf("\n 3 - Z Modem %s\n", PD35bMSG);
 	printf("\n 4 - ASCII %s\n",   PD35cMSG);

	ansi2( "md", 0, 0 );
	printf("\n%s > ", PD35dMSG);
	ansi2( "me", 0, 0 );

	m = getch();

	if((m < '1') || (m > '4')){
		printf(" <- %s\n\n", PD35dMSG);
		return;
	}

	headline( PD37_MSG );
	printf("\n");

	sprintf(s, "%s/%s", HOME, PACKERS);
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("pd.c", 716, "download", "Can't read", s);
	}

	printf("  1 - Text/ASCII\n\n");
 
	i = 1;
	while((fgets(s, 80, fp) != NULL) && (s[0] != '='));
	while((i < 10) && (fscanf(fp, "%s %s %s %s %s", s, ta, ta, ta, ta) > 0)){
		i++;
		printf("  %d - %s\n\n", i, s); 
	}

	ansi2( "md", 0, 0 );
	printf("%s > ", PD35fMSG);
	ansi2( "me", 0, 0 );

	l = getch();
	if((l < '1') || (l > (48 + i))){
		printf(" <- %s\n\n", PD35eMSG);
		return;
	}

	sprintf(s, "%s/usr/%c/%d/.download", HOME, USER.name[0], USER.id);
	fp = fopen(s, "w" );
	if(fp == NULL){
		nerror("pd.c", 741, "download", "Can't read", s);
	}
	fprintf(fp, "%c\n%c\n", m, l);
	fclose(fp);

	DOWN_PROT = m - 48;
  	DOWN_PACK = l - 48;
	
	printf("\n");

	return;
  }

 
  tmp[0] = '\0';

  i = 0;
  k = -1;
  l = -1;
  m = -1;

  while (arg[i] != '\0') {
	if (arg[i] == '-') k = i;
	if (arg[i] == '*') l = i;
	if ((arg[i] > 48) && (arg[i] < 58) && (m == -1)) m = i;
	i++;
  }

  von = 1;
  bis = 32000;

  if ((m == -1) && (l == -1) && (k == -1)) {
	ansi2( "md", 0, 0 );
	if(atoi(arg) != 0)
		printf(" %s\n", PD44aMSG);
	else
		printf(" %s\n", PD44bMSG);
	ansi2( "me", 0, 0 );
	return;
  }

  if ((m != -1) && (l == -1) && (k == -1)) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, m, strlen(arg)));
	von = atoi(s);
	bis = von;
  }
  if (k != -1) {
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (k - 1)));
	von = atoi(s);
	strcpy(s, (UNSIGNED char *) strcopy(arg, (k + 1), strlen(arg)));
	bis = atoi(s);

	if (von == 0) von = 1;
	if (bis == 0) bis = 32000;
  }
  
  if(von > bis){
	i = bis;
	bis = von;
	von = i;
  }

  maybe_locked(INHALT, "r");
  fp = fopen(INHALT, "r");
  if (fp == NULL) {
	nerror("pd.c", 504, "download", "Can't read", INHALT);
  }
  while (fgets(cd, LONGSTRING, fp) != NULL){
	i = atoi(cd);
	if((i >= von) && (i <= bis)){
		art[artp] = i;
		artp++;
		if(artp > MAX_PER_NG){
			printf("This is a known bug ;-)");
			exit(0);
		}		
	}
  }
  fclose(fp);

  printf("\n\n");

  if(DOWN_PROT == 0){

	ansi2("mr", 0, 0);
	printf("%c[%s] %c, %c, %c, %c ? > ", CR, PD07_MSG, PD08_MSG, PD09_MSG, PD10_MSG, PD11_MSG);
	ansi2("me", 0, 0);


	do {
		protokoll = getint();
		if (protokoll >= 97) protokoll -= 32;
		if (protokoll == '?') {
			clearline();
			ansi2("mr", 0, 0);
			printf("%c%s > ", CR, PD12_MSG);
			ansi2("me", 0, 0);
		}
		if ((protokoll != PD08_MSG) && (protokoll != PD09_MSG) &&
		    (protokoll != PD10_MSG) && (protokoll != PD11_MSG))
				protokoll = 0;
	} while (protokoll == 0);

	printf("%c", protokoll);
  }
  else{
	switch( DOWN_PROT ){
		case 1: protokoll = PD09_MSG; /* X Modem */
			break;
		case 2: protokoll = PD10_MSG; /* Y Modem */
			break;
		case 3: protokoll = PD11_MSG; /* Z Modem */
			break;
		case 4: protokoll = PD08_MSG; /* ASCII */
			break;
	}
  }

  if (strcomp(CDROMNG, NG) != 0) {

	if (strcomp(BRETT, "PM") != 0) {
		       sprintf(s, "%s", BRETT); 
	}
	else {
		sprintf(s, "%s/usr/%c/%d", HOME, USER.name[0], USER.id);
	}
	chdir( s );
	
	cd[0] = '\0';
	printf("\n\n%s .", PD36_MSG);

	lastart = artp;

	for( i = 0; i < artp; i++){  

		sprintf(s, "%d", art[i]); 
	
		fp = fopen(s, "r");
		if(fp != 0){
			printf(".");

			while ((fgets(t, LONGSTRING, fp) != NULL) && (t[0] > 32));
			while ((fgets(t, LONGSTRING, fp) != NULL) && (t[0] < 32));

			ok = 0;

			if (strcomp("BINFILE", t) == 0) {
				fgets(t, STRING, fp);
				strcpy(s, (UNSIGNED char *) stripped(t));
  				if(check_binfile( s ) != 0) return;
				ok++;
			}
			if(((2 + strlen(s) + strlen(cd)) < LONGSTRING) && (mdlp < MAX_DL_FILES)){
				stat(s, &fst);
				bytes_total += (long) fst.st_size;

				if(ok != 0){
					strcpy(files[mdlp], s);
					mdlp++;				
					USER.downratio += ((long) fst.st_size / 1024);
				}
	
				strcat(cd, s); 
				strcat(cd, " ");
				lastart = i;
			}
			fclose(fp);
		}
	}
  }
  else{			/* Download from CDROM */
	
	chdir( BRETT );
	
	cd[0] = '\0';
	printf("\n\n%s .", PD36_MSG);

	lastart = artp;

   	fp = fopen( INHALT, "r" );	  
	fgets(s, STRING, fp);
	fgets(s, STRING, fp);

	for( i = 0; i < artp; i++){  

		rewind( fp );	
		printf(".");

		while((fgets(s, STRING, fp) != 0) && (art[i] != atoi(s)));

		l = 6;
		while((s[l] != ' ') && (s[l] != '\0')) l++;	
		strcpy(s, (UNSIGNED char *) strcopy(s, 6, (l - 1)));

		if(((2 + strlen(s) + strlen(cd)) < LONGSTRING) && (mdlp < MAX_DL_FILES)){
			stat(s, &fst);

			bytes_total += (long) fst.st_size;

			sprintf(files[mdlp], "%s/%s", BRETT, s);
			mdlp++;				
			USER.downratio += ((long) fst.st_size / 1024);
	
			strcat(cd, s); 
			strcat(cd, " ");
			lastart = i;
		}
	}
	fclose(fp);
  }	

  if(cd[0] == '\0'){
	ansi2("md", 0, 0);
	printf("%c%s\n", CR, PD35_MSG);
	ansi2("me", 0, 0);
	chdir( HOME );
	return;
  }

  if((protokoll != PD08_MSG) && (strcomp(PDNG, NG) != 0) &&
	(strcomp(ADULTNG, NG) != 0) && (strcomp(CDROMNG, NG) != 0)){
	strcpy(s, (UNSIGNED char *) archivieren( cd ));
	if(strcomp("Noe!", s) != 0){
		strcpy(cd, (UNSIGNED char *) s);
		havetokill++;
	}
  }
  
  printf("\n\n");
  ansi2("md", 0, 0);
  printf("%s\n\n", PD13_MSG);
  ansi2("me", 0, 0);


  time(&ts);

  switch (protokoll) {
      case PD08_MSG:
		sprintf(t, "exec cat %s", cd);
		break;
      case PD09_MSG:
		sprintf(t, "exec %s -b %s 2> /dev/null", SX, cd);
		break;
      case PD10_MSG:
		sprintf(t, "exec %s %s 2> /dev/null", SB, cd);
		break;
      case PD11_MSG:
		sprintf(t, "exec %s %s 2> /dev/null", SZ, cd);
		break;
  }	
  system( t );

  if(havetokill != 0) unlink( cd );

  time(&tn); tn = tn - ts; 

  chdir( HOME );

  ansi2( "md", 0, 0 );
 
  if(tn < 1) tn = 1;
  cps = bytes_total / tn;
  bps = cps * 11;

  BAUDRATE = baudrate( bps );

  eff = ((100000 / BAUDRATE) * bps) / 1000;

  if((bps > BAUDRATE) || (bps < 1)){
	printf("\n\n%s\n", PD14_MSG);
	ok = -1;
  }
  else{	
	printf("\n\n%ld %s.\n", fst.st_size, PD15_MSG);
	ok = 0;
  }

  ansi2( "me", 0, 0 );
  printf("%s %d cps (ca. %d bps).", PD16_MSG, cps, bps);  
  
  if(ok != -1){
	  
	sprintf(tmp, "%s/%d.pd", TMP, getpid());
	ff = fopen( tmp, "w" );

	for(i = 1; i < mdlp; i++){
		fprintf(ff, "%s  %c  %-40.40s", mydate( 1 ), protokoll, files[i]); 
		fprintf(ff, "  %6d  %6d  %2d%% DNL\n", cps, bps, eff);		
	}  

	i = 0;

	fp = fopen( PDLOG, "r" );
	if(fp != NULL){
		while((fgets(s, STRING, fp) != NULL) && (i < (PRO_ENTRIES * 4))){
			fputs(s, ff);
			i++;
		}
		fclose(fp);
	}

	fclose(ff);

	sprintf(cd, "mv %s %s", tmp, PDLOG);
	system( cd );
  }
  else{
	if(ff != 0) fclose(ff);
	if(tmp[0] != '\0') unlink(tmp);
  }

  if(lastart != (artp-1)){
	ansi2( "md", 0, 0 );
	printf("\n%s", PD40_MSG);
	ansi2( "me", 0, 0 );
	printf("%s %d %s %d %s!", PD45_MSG, art[0], PD46_MSG, art[lastart], PD47_MSG);
  }

  printf("\n\n");
}



/* #AT - Make up a statistic out of CALLS and ALLTIME files. */

void alltime()
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[STRING];
  UNSIGNED char z[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char m[STRING];
  UNSIGNED char o[STRING];
  UNSIGNED char w[STRING];

  UNSIGNED char monat[13][STRING];

  int fpid;
  int maxval = 0;
  int i, a;
  int toggle = 0;

  strcpy(monat[ 1], PD51_MSG);
  strcpy(monat[ 2], PD52_MSG);
  strcpy(monat[ 3], PD53_MSG);
  strcpy(monat[ 4], PD54_MSG);
  strcpy(monat[ 5], PD55_MSG);
  strcpy(monat[ 6], PD56_MSG);
  strcpy(monat[ 7], PD57_MSG);
  strcpy(monat[ 8], PD58_MSG);
  strcpy(monat[ 9], PD59_MSG);
  strcpy(monat[10], PD60_MSG);
  strcpy(monat[11], PD61_MSG);
  strcpy(monat[12], PD62_MSG);


  sprintf(t, "%s/all.%d", TMP, getpid() );
  sprintf(m, "%s/al2.%d", TMP, getpid() );

  headblock( PD48_MSG, PD49_MSG );
  printf("%s ..", PD50_MSG);
	
  switch( (fpid = fork()) ){
	case -1 :
		break;
	case  0 : 
		while(1){
			printf(".");
			sleep(4);
		}	
		break;
  }
  sprintf(s, "cp %s %s", ALLTIME, t );
  system( s );
  sprintf(s, "sort %s >> %s", CALLS, t );
  system( s );

  sprintf(s, THIRDCUT, t, m );
  system( s );

  kill( fpid, SIGKILL );
  (void) wait( &fpid );
  printf("%c", CR);

  fp = fopen( m, "r" );
  ff = fopen( t, "w" );

  while(fgets(s, STRING, fp) != NULL){
	if(atoi(s) > maxval) maxval = atoi(s);
  }

  rewind(fp);

  while(fgets(o, STRING, fp) != NULL){
	sscanf(o, "%s %s", s, z);
	if(strlen(z) > 3){
		i = atoi(z);
		a = atoi(s);
		fprintf(ff, "%12.12s '%2.2s  [%4.4d]  ", monat[i], strcopy(z, 3, 4), a);
		i = ((54000L / maxval) * a)  / 1000;
		if(i <  1) i = 1;
		if(i > 53) i = 53;
		strcpy(s, ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
		strcpy(w, "|     |     |     |     |     |     |     |     |     |     |");
		s[i] = '\0';
		if(toggle == 0){
			strcpy(z, (UNSIGNED char *) termansi( "us" ));
			toggle++;
		}
		else{
			z[0] = '\0';
			toggle = 0;	
		}
		a = strlen(w);
		strcpy(w, (UNSIGNED char *) strcopy(w, (a-(53-i)), a));
		fprintf(ff, "%s%s", z, s); 
		strcpy(z, (UNSIGNED char *) termansi( "me" ));
		fprintf(ff, "%s%s\n", z, w);	
	}
  }

  if(USER.terminal != ISO6429){
	fprintf(ff, "===============================================================================\n");
  }
  else{
	strcpy(z, (UNSIGNED char *) termansi( "X1" ));
	strcpy(s, (UNSIGNED char *) PD49_MSG);
	a = 79 - strlen( s );
	for(i = 0; i < a; i++) strcat(s, (UNSIGNED char *) " ");
	fprintf(ff, "%s%s\n", z, s);
	strcpy(z, (UNSIGNED char *) termansi( "me" ));
	fprintf(ff, "%s", z);	
  }

  fclose(ff);
  fclose(fp);

  show( t, 9999, USER.more + 100 );

  unlink( t );
  unlink( m );
}


/* #AU - Print the usage of terminal ports */

void auslastung()
{
  FILE *fp;

  UNSIGNED char s[STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char dat[STRING];

  int zeit = 0, i, l = 5, cal = 0;
  int std, min, sec, per;

 
  headblock( PD63_MSG, PD64_MSG );
 
  strcpy(dat, (UNSIGNED char *) "00.00.00");
  
  fp = fopen( MBSTAT, "r" );
  if(fp == NULL){
  }
  while(fgets(s, STRING, fp) != NULL){
	sscanf(s, "%s %s %d", &d, &t, &i);	

	if(strcomp("00.00.00", dat) == 0){
		strcpy(dat, (UNSIGNED char *) d);
	}

	if(strcomp(dat, d) != 0){

		std = zeit / 3600;
                min = (zeit - (std * 3600)) / 60;
                sec = zeit - (std * 3600) - (min * 60);
		per = 10000 / 864 * zeit / 10000;

		printf("%s  %2d:%02d:%02d    ", dat, std, min, sec);
		ansi2( "md", 0, 0 );
		printf("%3d%%", per);
		ansi2( "me", 0, 0 );
		printf("     %4d\n", cal);
		l++;
			
		strcpy(dat, (UNSIGNED char *) d);
		zeit = 0; cal = 0;
	
		if(l > (MAX_SCR_LINES -1)){
			fclose(fp);
			goto MUST_LEAVE;
		}
	}
	zeit += i;
	cal++;
  }
  fclose(fp); 

  std = zeit / 3600;
  min = (zeit - (std * 3600)) / 60;
  sec = zeit - (std * 3600) - (min * 60);
  per = 10000 / 864 * zeit / 10000;


  printf("%s  %2d:%02d:%02d    ", dat, std, min, sec);
  ansi2( "md", 0, 0 );
  printf("%3d%%", per);
  ansi2( "me", 0, 0 );
  printf("     %4d\n", cal);

  MUST_LEAVE:

  printf("\n%s\n%s ", PD65_MSG, PD66_MSG);
  ansi2( "md", 0, 0 );
  printf("200%%");
  ansi2( "me", 0, 0 );
  printf(" %s\n", PD67_MSG);
}
