/* ix/MBox (misc.c) by Volker Schuermann, 28.08.1994

   This C source code contains the following functions:

   #SC scanner()           switching from one newsgroup to another
   #SN schreiben()         write news articles 
   #PF prf()               is the uploaded file a text or a binaries?
   #PR pruefe()            contains an article the BINFILE key?

   Contact <volkers@unnet.wupper.de> for help! */

  





#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>


#include "mbox.h"


extern UNSIGNED char headinfo[STRING];


int lastpoint( name )
UNSIGNED char name[];
{
  int a = 0, b = 0;

  while(name[a] != '\0'){
	if(name[a] == '.') b = a;
	a++;
  }
  if(b == 0) return a;

  return (int) b;
}



/* #SC - Changing the current newsgroup.

   [mode]  ->    >  255 = all boards (ignore date)
                 >  500 = next AREA
		 > 1000 = no idea (next hiearchy, maybe)
                 +      = next board
                 -      = previous board */

void scanner(mode)
int mode;
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char prevg[STRING];
  UNSIGNED char prevf[STRING];
  int ok = 0, a;
  int line = 0, l = 0;
  int locmod = 0;
  int max = 0;
  int widerange = 0;


  if (mode >= 1000) {
	widerange = 1000;
	mode -= 1000;
  }

  if (mode >= 500) {
	locmod = 500;
	mode -= 500;
  }

  if (mode >= 255) {
	locmod = 255;
	mode -= 255;
  }

  KEIN_ZUGRIFF:

  if (locmod == 255) {
	maybe_locked(SGROUPS, "r");
	fp = fopen(SGROUPS, "r");
	if (fp == NULL) {
		nerror("misc.c", 26, "scanner", "Can't read", NGROUPS);
	}
  }
  else {
	maybe_locked(UGROUPS, "r");
	fp = fopen(UGROUPS, "r");
	if (fp == NULL) {
		nerror("misc.c", 34, "scanner", "Can't read", UGROUPS);
	}
  }

  f[0] = '\0';
  ok = 0;
  strcpy(prevg, "L.I.S.A.");

  while ((ok == 0) && (fscanf(fp, "%s %d %d %s", s, &a, &a, t) > 0)) {
	l++;
	if (strcomp(NG, s) == 0) {
		ok = 1;
	}
	else {
		strcpy(f, (UNSIGNED char *) s);
	
		if(strcomp(prevg, s) != 0){
			if(widerange == 0){
		  		a = lastpoint( s );
				strcpy(prevg, (UNSIGNED char *) s);
				strcpy(prevf, (UNSIGNED char *) s);
				prevg[a] = '\0';
			}
			else{
				strcpy(prevg, (UNSIGNED char *) s); prevg[3] = '\0';
				strcpy(prevf, (UNSIGNED char *) s);
			}
		}
	}
  }

  if (locmod == 500) {
	if (mode == '+') {
		ok = 0;
		
		if(widerange == 0){
			a = lastpoint( NG );
			strcpy(prevg, (UNSIGNED char *) NG);
			prevg[a] = '\0';
		}
		else{
			strcpy(prevg, (UNSIGNED char *) NG);
			prevg[3] = '\0';
		}

		while ((ok == 0) && (fscanf(fp, "%s %d %d %s", s, &a, &a, t) > 0)) {
			l++;
			if (strcomp(prevg, s) != 0) {
				ok = 1;
				strcpy(f, (UNSIGNED char *) s);
			}
		}
		if(ok == 0) line = -1;
	}
	if (mode == '-') {
		strcpy(f, (UNSIGNED char *) prevf);
	}
  }
  else{
	  if (mode == '+') {
		if (fscanf(fp, "%s %d %d %s", f, &a, &a, t) < 1) {
			if (ok == 0) {
				rewind(fp);
				fscanf(fp, "%s %d %d %s", f, &a, &a, t);
			}
		  	else {
				line = -1;
			}
		}
	  }
	  if (mode == '-') {
		if (f[0] == '\0') {
			rewind(fp);
			while (fscanf(fp, "%s %d %d %s", f, &a, &a, t) > 0);
		}
	  }
  }	
  fclose(fp);

  if (max == 40) {
	ansi2( "md", 0, 0 );
	printf("\n\n%s", MIS00_MSG);
	ansi2( "me", 0, 0 );
  }

  if ((line == -1) || (f[0] == '\0')) {
	strcpy(BRETT, (UNSIGNED char *) "PM");
	printf("\n");
	sprintf(NG, "%s.PM", USER.name);
	sprintf(INHALT, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
	return;
  }
  if (l == 0) {
	ansi2("md", 0, 0);
	printf(" %s\n", MIS01_MSG);
	ansi2("me", 0, 0);
	return;
  }
 
  if ((chk_newsgrp(f) != 0) || (is_subscribed(f) != 1) || (chk_area(f) != 1)) {
	sprintf(NG, "%s", f);
	max++;
	goto KEIN_ZUGRIFF;
  }

  if(strcomp(ADULTNG, f) == 0){
	sprintf(NG, "%s", f);
	max++;
	goto KEIN_ZUGRIFF;
  }

  brett(f);
}






/* #SN - Write an article for the news system.

   [arg] seems to be a dummy ... don't comment on this! */

void schreiben(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;
  FILE *fl;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char cmdl[STRING];
  UNSIGNED char rep[STRING];
  UNSIGNED char subj[STRING];
  UNSIGNED char keyw[STRING];
  UNSIGNED char summ[STRING];
  UNSIGNED char from[STRING];
  UNSIGNED char msid[STRING];
  UNSIGNED char refs[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char ng[STRING];
  UNSIGNED char reply[STRING];
  UNSIGNED char group[STRING];
  UNSIGNED char newsgroups[STRING];
  UNSIGNED char distribution[STRING];
  UNSIGNED char followup[STRING];
  UNSIGNED char expires[STRING];
  UNSIGNED char ctrl[STRING];
  UNSIGNED char sender[STRING];
  UNSIGNED char approved[STRING];
  UNSIGNED char content[STRING];
  UNSIGNED char iam[STRING];
  UNSIGNED char username[STRING];

  int i, j, a, b, ok;
  int app, endless;
  int lines;

  UNSIGNED char protokoll = 0;
  UNSIGNED char c;
  UNSIGNED char lf;

  int BINFILE;

  struct stat fst;

  UNSIGNED char pubdir[STRING];
  long tdummy;
  long tn, ts;

  if (strcomp(BRETT, "PM") == 0) {
	brief( arg );
	return;
  }
  BINFILE = 0;

  if (moderated( NG ) == 1) return;

  i = 0;				/* Vorname.Name */
  strcpy(ng, USER.name);
  while (ng[i] != '\0') {
	if (ng[i] == ' ') ng[i] = '.';
	i++;
  }
  strcpy(username, ng);
  strcpy(group, NG);


  umask(0000);

  if (arg[0] == '\0') {

	subj[0]  = '\0';
	keyw[0]  = '\0';
	from[0]  = '\0';
	msid[0]  = '\0';
	summ[0]  = '\0';
	refs[0]  = '\0';
	reply[0] = '\0';

	sprintf(rep, "%s/%dRep", TMP, getpid());


	fp = fopen(rep, "r");
	if (fp != NULL) {		/* REPLY */

		strcpy(VAR_NAME, (UNSIGNED char *) fetch_reciepy( rep ));

		while ((fgets(s, STRING, fp) != NULL) && (strlen(s) > 2)) {
			if (strcomp("Subject:", s)   == 0) {
				strcat(subj, strcopy(s, 8, 79));
				strcpy(subj,  (UNSIGNED char *) stripped(subj));				
			}
			if (strcomp("From:", s)      == 0) {
				from[0] = '\0';
				strcat(from, strcopy(s, 6, 79));
				strcpy(from,  (UNSIGNED char *) stripped(from));
			}
			if (strcomp("Reply-To:", s)  == 0) {
				from[0] = '\0';
				strcat(from, strcopy(s, 10, 79));
				strcpy(from,  (UNSIGNED char *) stripped(from));
			}
			if (strcomp("Keywords:", s)  == 0) {
				strcat(keyw, strcopy(s, 10, 79));
				strcpy(keyw,  (UNSIGNED char *) stripped(keyw));
			}
			if (strcomp("Summary:", s)   == 0) {
				strcat(summ, strcopy(s, 9, 79));
				strcpy(summ,  (UNSIGNED char *) stripped(summ));
			}
			if (strcomp("Message-ID:", s) == 0) {
				strcat(msid, strcopy(s, 11, 79));
				strcpy(msid,  (UNSIGNED char *) stripped(msid));
			}
			if (strcomp("Content-Type:", s) == 0) {
				strcat(content, strcopy(s, 14, 79));
				strcpy(content,  (UNSIGNED char *) stripped(content));
			}
			if (strcomp("Article-I.D.:", s) == 0) {
				strcat(msid, strcopy(s, 13, 79));
				strcpy(msid,  (UNSIGNED char *) stripped(msid));
			}
			if (strcomp("References:", s) == 0) {
				strcat(refs, strcopy(s, 12, 79));
				strcpy(refs,  (UNSIGNED char *) stripped(refs));
			} 
			if (strcomp("Followup-To:", s) == 0) {
				strcpy(group, strcopy(s, 13, 79));
				strcpy(group, (UNSIGNED char *) stripped(group));
			}

			/* THE FOLLOWING IS A LOUSY TRICK, EATING HEADER INFORMATION! */

			while(strlen(s) == (STRING - 1)){ 
				fgets(s, STRING, fp);
			}
		}
		
		if(strcomp("Poster", group) == 0){
			printf(" <- %s\n", MIS02aMSG);
			return;
		}


		sprintf(t, "%s/A%d", TMP, getpid());
		ff = fopen(t, "w");

		a = 0;
		b = 0;
		i = 0;
		while (from[i] != '\0') {
			if (from[i] == '(') a = i + 1;
			if (from[i] == ')') b = i - 1;
			i++;
		}
		if (a < b) {
			strcpy(s, (UNSIGNED char *) strcopy(from, a, b));
			strcpy(from, (UNSIGNED char *) s);
		}
		sprintf(ex, "In article %s,\n            %s just mentioned:\n\n", msid, from);
		fputs(ex, ff);

		a = 0; printf(" %-4.4d", a );
		i = 0;

		while (fgets(s, STRING, fp) != NULL) {
	
		a++; 
		printf("%c%c%c%c%-4.4d", BS, BS, BS, BS, a );

		if((s[0] != '\n') && (i == 0)){
		
			if(s[0] != '>'){
				if(s[2] != '>'){
					fputs(">     ", ff);
				}
			}
			else{
				if(strcomp(">  ", s) == 0){
					s[1] = '>';
				}
				else fputs(">", ff);
			}
		}

		if((s[0] != '>') && (s[2] != '>')){

			if(i >= 65){	
				fputs("\n>     ", ff);
				i = 0;
			}

			endless = 0;

			BETTER_TWICE:

			if((strlen(s) + i) > 65){
				j = 65 - i;
				i = 0;
				ok = 0;
				while((ok == 0) && (j > 0)){
					if(s[j] == ' '){
						fputs((UNSIGNED char *) iso_line( (UNSIGNED char *) strcopy(s, 0, (j-1))), ff);
						fputs("\n>     ", ff);
						strcpy(f, (UNSIGNED char *) stripped( strcopy(s, (j+1), strlen(s))));
						strcpy(s, (UNSIGNED char *) f);
						i = strlen(s) -1;
						if((s[i] == ' ') || (s[i] == '-'))
							s[i] = '\0';
						else
							strcat(s, (UNSIGNED char *) " ");
						i = strlen(s);
						ok++;
					}
					j--;
				}
				if((j == 0) && (ok == 0)){
					fputs("\n>     ", ff);
					endless++;
					if(endless == 1) goto BETTER_TWICE;
				}
			}
			else{
				i = 0;
			}
		}

		fputs((UNSIGNED char *) iso_line(s), ff);
		}
		fclose(fp);
		fclose(ff);

		if(G94ACTIVE == 0){
			printf("\n\n");
			security_ed( t );
		}
		else{
			g94_nrep( t );			
		}
		if (strcomp("Re:", subj) != 0) {
			sprintf(f, "Re: %s", stripped(subj));
			strcpy(subj, (UNSIGNED char *) f);
		}
		unlink(rep);
	}
	else {		/* Interactive Articles */

		printf("\n\n%c", CR);

		if(ROT13_MODUS){
			printf("%s ", MIS02bMSG);
			ansi2("md", 0, 0);
			printf("ROT13");
			ansi2("me", 0, 0);
			printf(" %s\n\n", MIS02cMSG);
		}

		ansi2("mr", 0, 0);
		printf("%s", MIS03_MSG);
		ansi2("me", 0, 0);
		printf(" %s (%s)\n%c", USER.name, USER.nick, CR);
		ansi2("mr", 0, 0);
		printf("%s", MIS04_MSG);
		ansi2("me", 0, 0);
		printf(" %s\n%c", NG, CR);
		ansi2("mr", 0, 0);
		printf("%s", MIS05_MSG);
		ansi2("me", 0, 0);
		printf(" ");
		strcpy(subj, (UNSIGNED char *) getline(57, -11, '.', ""));
		if(subj[0] == '\0'){
			strcpy(subj, (UNSIGNED char *) "Yet another article ...");
			printf("%s                                  ", subj);
		}	

		printf("\n");
		ansi2("mr", 0, 0);
		printf("%s", MIS06_MSG);
		ansi2("me", 0, 0);
		printf(" ");
		strcpy(keyw, (UNSIGNED char *) getline(57, -11, '.', ""));
		printf("\n");
		ansi2("mr", 0, 0);
		printf("%s", MIS07_MSG);
		ansi2("me", 0, 0);
		printf(" ");
		strcpy(summ, (UNSIGNED char *) getline(57, -11, '.', ""));

		printf("\n\n");
		ansi2("mr", 0, 0);
		printf("[%s] %s ? > ", NG, MIS08_MSG);
		ansi2("me", 0, 0);
		printf("%c%c", MIS09_MSG, BS);

		do {
			c = getint();
			if (c >= 97) c -= 32;
			if (c == '?') {
				clearline();
				ansi2("mr", 0, 0);
				printf("%c%s > ", CR, MIS12_MSG);
				ansi2("me", 0, 0);
			}
			if (c == ENTER) c = MIS09_MSG;
			if ((c != MIS09_MSG) && (c != MIS10_MSG) && (c != MIS11_MSG)) c = 0;
		} while (c == 0);

		printf("%c", c);

		if (c == MIS11_MSG) {	/* REJECT / VERWERFEN */
			printf("\n");
			unlink(t);
			return;
		}
		if (c == MIS10_MSG) {	/* UPLOAD */
			printf("%c                                                                       ", CR);
			ansi2("mr", 0, 0);
			printf("%c%s, ? > ", CR, MIS13_MSG);
			ansi2("me", 0, 0);

			do {
				protokoll = getint();
				if (protokoll >= 97) protokoll -= 32;
				if (protokoll == '?') {
					clearline();
					ansi2("mr", 0, 0);
					printf("%c%s > ", CR, MIS14_MSG);
					ansi2("me", 0, 0); 
				}
				if ((protokoll != MIS15_MSG) && (protokoll != MIS15_MSG) &&
				    (protokoll != MIS18_MSG) && (protokoll != MIS17_MSG ))
					protokoll = 0;
			} while (protokoll == 0);

			printf("%c", protokoll);

		}
		sprintf(tmp, "%s/A%d", TMP, getpid());
		sprintf(pubdir, "%s/dir%d", TMP, getpid());
		strcpy(cmdl, (UNSIGNED char *) tmp);

		if (c == MIS09_MSG) {	/* SEND / SCHREIBEN */
			strcpy(cmdl, (UNSIGNED char *) tmp);
			security_ed( cmdl );
			protokoll = '*';
		}
		else {	/* UPLOAD */

			noctrlx();

			printf("\n\n");
			ansi2("md", 0, 0);
			printf("%s", MIS19_MSG);
			ansi2("me", 0, 0);

			switch (protokoll) {
			    case MIS15_MSG:
					fp = fopen(tmp, "w");
					if (fp == NULL) {
						nerror("misc.c", 310, "schreiben", "Can't write to", tmp);
					}
					c = 0;
					lf = CR;
					fputc(LF, fp);

					/*
					while ((c != CTRL_X) && (c != CTRL_D)) {
					*/
					while ((c != CTRL_E) && (c != CTRL_D)) {
						c = getint();
						if ((c == CR) && (lf == CR))
							fputc(LF, fp);
						if (c == CR) lf = CR;
						if (c == LF) lf = LF;
						/*
						if ((c != CTRL_X) && (c != CTRL_D) && (c != CR)) {
							fputc(c, fp);
						}
						*/
						if ((c != CTRL_E) && (c != CTRL_D) && (c != CR)) {
							fputc(c, fp);
						}
					}
					fclose(fp);
					break;
			    case MIS16_MSG:
					printf("\n");
					sprintf(s, "exec %s -c TimeTravelAgency 2> /dev/null", RX);
					break;
			    case MIS17_MSG:
					printf("\n");
					sprintf(s, "exec %s 2> /dev/null", RB);
					break;
			    case MIS18_MSG:
					printf("\n");
					sprintf(s, "exec %s 2> /dev/null", RZ);
					break;
			}
			if (protokoll != MIS15_MSG){
				mkdir( pubdir, 0777 );
				chdir( pubdir );

				time(&ts);
				system( s );
				time(&tn); tn = tn - ts;
				tn -= 10;  /* 10 = "Toleranz" */
	
				chdir( HOME );
				sprintf(s, "mv %s/* %s", pubdir, tmp);
				system( s );
				sprintf(s, "rm -r %s", pubdir);
				system( s );
			}
			sync();
			ctrlx();
			stat(tmp, &fst);
			if (fst.st_size < 3L) {
				printf("\n\n%s\n", MIS20_MSG);
				control(MIS21_MSG, 3);
				unlink(tmp);
				return;
			}
			if (prf(tmp) == 1) {
				if (strcomp(PDNG, NG) == 0) {
					USER.upratio += ((long) fst.st_size / 1024);
				}
				BINFILE++;
				sprintf(s, MIS22_MSG);
			}
			else{
				mkix(tmp);
				sprintf(s, MIS23_MSG);
			}
			ansi2( "md", 0, 0 );
			printf("\n\n%ld %s %s %s.\n", fst.st_size, MIS24_MSG, s, MIS25_MSG);
			ansi2( "me", 0, 0 );
			if(tn < 1) tn = 1L;
			printf("%s %d cps (ca. %d bps).", MIS26_MSG,
				(fst.st_size / tn), ((fst.st_size / tn) * 11));				
		}
	}

	sprintf(iam, "%s <%s@%s>", USER.name, username, UUCPID);
	/*
	sprintf(reply, "%s@%s (%s)", username, UUCPID, USER.name);
	*/
	strcpy(newsgroups, group);
	if (USER.level < WRITE_EX_LEV) {
		strcpy(distribution, "local");
	}
	else {
		/*
		strcpy(ng, NG);
		i = 0;
		while ((ng[i] != '.') && (ng[i] != '\0')) i++;
		ng[i] = '\0';
		strcpy(distribution, ng);
		*/
		strcpy(distribution, "world");
	}
	if(refs[0] != '\0') strcat(refs, " ");
	strcat(refs, msid);	
	followup[0] = '\0';
	sender[0] = '\0';
	ctrl[0] = '\0';
	expires[0] = '\0';
	approved[0] = '\0';
	app = 0;
	content[0] = '\0';	
	reply[0] = '\0';

#if defined(_MULTIMEDIA) && defined(_UMLAUT)
	strcpy(content, (UNSIGNED char *) "text/plain; charset=iso-8859-1");
#endif

	if(G94ACTIVE == 1) goto G94JUMP;

	ONCE_MORE:

	printf("\n\n");
	ansi2("mr", 0, 0);
	if(BINFILE == 0){
		printf("[%s] %s, ? > ", NG, MIS27_MSG);
	}
	else{
		printf("[%s] %s, ? > ", NG, MIS28_MSG);
	}
	ansi2("me", 0, 0);
	printf("%c%c", MIS29_MSG, BS);

	sprintf(cmdl, "%s/A%d", TMP, getpid());

	do {
		c = getint();
		if (c >= 97) c -= 32;
		if (c == '?') {
			clearline();
			ansi2("mr", 0, 0);
			if(BINFILE == 0){
				printf("%c%s > ", CR, MIS32_MSG);
			}
			else{
				printf("%c%s > ", CR, MIS33_MSG);
			}
			ansi2("me", 0, 0);
		}
		if (c == ENTER) c = MIS29_MSG;
		if ((c != MIS29_MSG) && (c != MIS30_MSG) && (c != MIS31_MSG) && (c != MIS31aMSG)) c = 0;
	} while (c == 0);

	printf("%c", c);
	if (c == MIS30_MSG) {	/* REJECT / VERWERFEN */
		unlink(f);
		unlink(s);
		unlink(t);
		unlink(tmp); /* ??? */
		unlink(rep);
		printf("\n");
		return;
	}
	if ((c == MIS31_MSG) && (BINFILE == 0)) {	/* REEDIT / WEITERSCHREIBEN */
		security_ed( cmdl );
		goto ONCE_MORE;
	}
	if (c == MIS31aMSG) { /* HEADER */
		headline( MIS38aMSG );
		printf("\n");
		time(&tdummy);

		ansi2( "md", 0, 0 );
		printf("From: ");
		ansi2( "me", 0, 0 );
		if(USER.level > ADMIN_LEV){
			strcpy(s, (UNSIGNED char *) getline(80, -1001, 32, iam));
			if(strcomp(s, iam) != 0) app++;			
			if(s[0] != '\0') strcpy(iam, s);
			printf("\n");
		}
		else printf("%s\n", iam);

		ansi2( "md", 0, 0 );
		printf("Reply-To: ");
		ansi2( "me", 0, 0 );
		if(USER.level > GUEST_LEV){
			strcpy(reply, (UNSIGNED char *) getline(80, -1001, 32, reply));
			printf("\n");
		}
		else printf("%s\n", reply);

		ansi2( "md", 0, 0 );
		printf("Sender: ");
		ansi2( "me", 0, 0 );
		if(USER.level >= ADMIN_LEV){
			strcpy(sender, (UNSIGNED char *) getline(80, -1001, 32, sender));
			printf("\n");
		}
		else printf("%s\n", sender);	
		
		ansi2( "md", 0, 0 );
		printf("Control: ");
		ansi2( "me", 0, 0 );
		if(USER.level >= ADMIN_LEV){
			strcpy(ctrl, (UNSIGNED char *) getline(80, -1001, 32, ctrl));
			printf("\n");
		}
		else printf("%s\n", ctrl);	
		
		ansi2( "md", 0, 0 );
		printf("Approved: ");
		ansi2( "me", 0, 0 );
		if(app != 0) sprintf(approved, "%s <%s@%s>", USER.name, username, UUCPID);
		if(USER.level >= EXE_LEV){
			strcpy(approved, (UNSIGNED char *) getline(80, -1001, 32, approved));
			printf("\n");
		}
		else printf("%s\n", approved);	
	
		ansi2( "md", 0, 0 );
		printf("Newsgroups: ");
		ansi2( "me", 0, 0 );
		if(USER.level >= WRITE_EX_LEV){
			strcpy(newsgroups, (UNSIGNED char *) getline(80, -1001, 32, newsgroups));
			printf("\n");
			i = 0;
			while(newsgroups[i] != '\0'){
				if(newsgroups[i] == ' '){
					strcpy(s, (UNSIGNED char *) newsgroups);
					newsgroups[i] = '\0';
					strcat(newsgroups, (UNSIGNED char *) strcopy(s, (i+1), 80));
					i--;
				}
				i++;
			}			
		}
		else printf("%s\n", newsgroups);	
		
		ansi2( "md", 0, 0 );
		printf("Distribution: ");
		ansi2( "me", 0, 0 );
		if(USER.level >= WRITE_INTERNAT){
			strcpy(distribution, (UNSIGNED char *) getline(80, -1001, 32, distribution));
			printf("\n");
		}
		else printf("%s\n", distribution);	
		
		ansi2( "md", 0, 0 );
		printf("Followup-To: ");
		ansi2( "me", 0, 0 );
		if(USER.level >= WRITE_EX_LEV){
			strcpy(followup, (UNSIGNED char *) getline(80, -1001, 32, followup));
			printf("\n");
		}
		else printf("%s\n", followup);	
		
		ansi2( "md", 0, 0 );
		printf("Subject: ");
		ansi2( "me", 0, 0 );
		strcpy(subj, (UNSIGNED char *) getline(80, -1001, 32, subj));

		ansi2( "md", 0, 0 );
		printf("\nKeywords: ");
		ansi2( "me", 0, 0 );
		strcpy(keyw, (UNSIGNED char *) getline(80, -1001, 32, keyw));
			
		ansi2( "md", 0, 0 );
		printf("\nSummary: ");
		ansi2( "me", 0, 0 );
		strcpy(summ, (UNSIGNED char *) getline(80, -1001, 32, summ));

#ifdef _MULTIMEDIA

		if(USER.level >= WRITE_INTERNAT){
			if(content[0] == '\0')
				strcpy(content, (UNSIGNED char *) "text/plain; charset=us-ascii");
			ansi2( "md", 0, 0 ); 
			printf("\nContent-Type: ");
			ansi2( "me", 0, 0 );
			strcpy(content, (UNSIGNED char *) getline(80, -1001, 32, content));
		}
#endif

		ansi2( "md", 0, 0 );
		printf("\nX-News-Reader: ");
		ansi2( "me", 0, 0 );
	        printf("%s %s %s\n", VERSION, PATCHLEVEL, AUTOR);

		ansi2( "md", 0, 0 );
		printf("References: ");
		ansi2( "me", 0, 0 );
		printf("%s\n", refs);
		
		ansi2( "md", 0, 0 );
		printf("Message-ID: ");
		ansi2( "me", 0, 0 );
		printf("<%x.%d@%s>\n", tdummy, USER.id, UUCPID);
		
		ansi2( "md", 0, 0 );
		printf("Expires: ");
		ansi2( "me", 0, 0 );
		if(USER.level >= WRITE_INTERNAT){
			strcpy(expires, (UNSIGNED char *) getline(80, -1001, 32, expires));
			printf("\n");
		}
		else printf("%s\n", expires);	

		goto ONCE_MORE;		
	}

	ansi2( "md", 0, 0 );
	printf("\n\n%s\n", MIS34_MSG);
	ansi2( "me", 0, 0 );

	G94JUMP:

	sprintf(f, "%s/A%d", TMP, getpid());
	sprintf(t, "%s/B%d", TMP, getpid());

	fp = fopen(f, "r");
	if (fp == NULL) {
		printf("\n");
		ansi2("md", 0, 0);
		printf("%s ...\n", MIS35_MSG);
		ansi2("me", 0, 0);
		control(MIS36_MSG, 3);
		unlink(rep);
		return;
	}

#ifdef _CNEWS
	lines = 0;
	while(fgets(s, STRING, fp) != 0) lines++;
	rewind(fp);
#endif

	ff = fopen(t, "w");

	time(&tdummy);

	fprintf(ff, "From: %s\n", iam);
	if(reply[0] != '\0')
		fprintf(ff, "Reply-To: %s\n", reply);
	if(sender[0] != '\0')
		fprintf(ff, "Sender: %s\n", sender);
	if(approved[0] != '\0')
		fprintf(ff, "Approved: %s\n", approved);
	if(newsgroups[0] != '\0')
		fprintf(ff, "Newsgroups: %s\n", newsgroups);
	if(distribution[0] != '\0')
		fprintf(ff, "Distribution: %s\n", distribution);
	if(ctrl[0] != '\0')
		fprintf(ff, "Control: %s\n", ctrl);
	if(followup[0] != '\0')
		fprintf(ff, "Followup-To: %s\n", followup);
	if(subj[0] != '\0')
		fprintf(ff, "Subject: %s\n", subj);
	if(keyw[0] != '\0')
		fprintf(ff, "Keywords: %s\n", keyw);
	if(summ[0] != '\0')
		fprintf(ff, "Summary: %s\n", summ);
	if(content[0] != '\0'){
		fprintf(ff, "MIME-Version: %s\n", MIME_VERSION);		
		fprintf(ff, "Content-Type: %s\n", content);
#ifdef _UMLAUT
		fprintf(ff, "Content-Transfer-Encoding: 8bit\n");
#endif
	}
	fprintf(ff, "X-News-Reader: %s %s %s\n", VERSION, PATCHLEVEL, AUTOR);
	fprintf(ff, "Message-ID: <%x.%d@%s>\n", tdummy, USER.id, UUCPID);
	if(expires[0] != '\0')
		fprintf(ff, "Expires: %s\n", expires);
	if(refs[0] != '\0')
		fprintf(ff, "References: %s\n", refs);	
#ifdef _CNEWS
	fprintf(ff, "Lines: %d\n", lines);	
#endif
	fputs("\n", ff);	
	
	if (BINFILE == 0) {
		UMLAUT_MODUS = 1;
		i = 0;
		while (fgets(s, STRING, fp) != 0) {
			if(ROT13_MODUS) strcpy(s, (UNSIGNED char *) rot13( s ));
			fputs((UNSIGNED char *) iso_line(s), ff);
			i++;
		}
		fclose(fp);
		unlink(f);
	}
	else {
#ifdef _CHECK_PD_1ST
		time(&tdummy);
		fputs("BINFILE\n", ff);
		sprintf(s, "%s/PD.%d", BRETT, tdummy);
		fputs(s, ff);
		sprintf(f, "cp %s %s &", tmp, s);
		system(f);
		sprintf(s, "\n/public/pd/%s\n", subj);
		fputs(s, ff);
		fl = fopen( PDSCRIPT, "a" );
		fprintf(fl, "mv %s/PD.%d /public/pd/%s\n", BRETT, tdummy, subj);
		fclose(fl);
#else
		fp = fopen( "./etc/list.destinations", "r" );
		if(fp == NULL){
			nerror("misc.c", 966, "schreiben", "Can't read", "./etc/list.destinations");
		}
		while((fgets(s, STRING, fp) != 0) && (s[0] != '='));
		f[0] = '\0';
		while(fscanf(fp, "%s %s", &s, &ex) > 0){
			if(strcomp(NG, s) == 0) strcpy(f, (UNSIGNED char *) stripped(ex));
		}
		fclose(fp);
		if(f[0] == '\0'){
			strcpy(f, (UNSIGNED char *) "/tmp");	
		}
		i = 0;
		while(subj[i] != '\0'){
			if((subj[i] < 48) && (subj[i] != 45)) subj[i] = '.';
			if((subj[i] > 57) && (subj[i]  < 65)) subj[i] = '-';
			if((subj[i] > 90) && (subj[i]  < 97)) subj[i] = '-';
			if((subj[i] > 122)) subj[i] = '-';
			i++;
		}
		sprintf(s, "cp %s %s/%s &", tmp, f, subj ); 
		system( s );
		fputs("BINFILE\n", ff);
		fprintf(ff, "%s/%s", f, subj);
				
		sprintf(s, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);
		fp = fopen(s, "w");
		fprintf(fp, "UPLOAD: %s/%s\n\n", f, subj);
		fprintf(fp, "        %s\n", keyw);	
		fclose(fp);

		sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
		fp = fopen(s, "w");
		fprintf(fp, ">- UPLOAD -> %s", NG);
		fclose(fp);

		sprintf(s, "%s?", POSTMASTER );
		brief( s );
  
#endif	/* _CHECK_PD_1ST */
	}

	unlink(rep);

	if ((USER.level > WRITE_IN_LEV) && (BINFILE == 0)) {
		sprintf(s, "%s/usr/%c/%d/.signature", HOME, USER.name[0], USER.id);
		fp = fopen(s, "r");
		if (fp != NULL) {
			while (fgets(s, STRING, fp) != 0) {
				if(ROT13_MODUS) strcpy(s, (UNSIGNED char *) rot13( s ));
				fputs((UNSIGNED char *) iso_line(s), ff);
			}
			fclose(fp);
		}
	}
	fclose(ff);

	UMLAUT_MODUS = USER.schluessel[2];

	sprintf(ex, "/bin/sh ./etc/inews.sh %s %s", NG, t);
	system(ex);

	unlink(t);

	sprintf(s, "%s \"%s\" %s", MIS37_MSG, NG, MIS38_MSG);
	control(s, 3);

	
	if(BINFILE != 0){
		maybe_locked(NGROUPS, "r");
		fp = fopen(NGROUPS, "r");
		if (fp == NULL) {
			nerror("misc.c", 895, "schreiben", "Can't read", NGROUPS);
		}

		ok = 0;

	        while ((ok == 0) && (fscanf(fp, "%s %d %d %s", s, &a, &b, f) > 0)) {
			if(strcomp(NG, s) == 0){
				i = a;
				ok = 1;
			}
	 	}
		fclose(fp);

		fl = fopen( PDSCRIPT, "a" );
		fprintf(fl, "%s %s/%d\n", FAVORITE_EDITOR, BRETT, i); 
		fprintf(fl, "#%s   %s\n\n", NG, USER.name);
		fclose(fl);
	}

	printf("%s", MIS39_MSG);

#ifndef _SYS7
	sleep(10);	/* On SVR4, INEWS seems to be running in background mode */
#endif

	sprintf(s, "%s %s", MB_DAEMON, group);
	system(s);
	unlink(tmp);
	printf("\n");
  }
  else {
	ansi2("md", 0, 0);
	printf(" %s\n\n", MIS40_MSG);
	ansi2("me", 0, 0);
  }
  umask(0007);

  sprintf(tmp, "%s/%d.dis", TMP, getpid());
  sprintf(f, "%s/usr/%c/%d/.dis", HOME, USER.name[0], USER.id);

  fp = fopen( tmp, "w" );

  ff = fopen( f, "r" );
  if(ff != NULL){
	i = 0;
	while((fgets(s, STRING, ff) != 0) && (i < 100)){
		fputs(s, fp);	
		i++;
	}
	fclose(ff);
  }
  fclose(fp);

  ff = fopen(INHALT, "r");
  fgets(s, STRING, ff);
  fgets(s, STRING, ff);
  fgets(s, STRING, ff);
  fclose(ff);
  a = atoi(s);

  fp = fopen( f, "w" );
  strcpy(s, (UNSIGNED char *) NG); 
  sprintf(f, " (%d)", a); strcat(s, (UNSIGNED char *) f); s[29] = '\0';
  strcpy(t, (UNSIGNED char *) subj); t[25] = '\0';
  fprintf(fp, "%-29.29s %-25.25s ", s, t);
  sprintf(s, "<%x.%d>", tdummy, USER.id); s[14] = '\0';
  fprintf(fp, "%-14.14s %s\n", s, mydate( 1 ));   

  ff = fopen( tmp, "r" );
  while(fgets(s, STRING, ff) != 0){
	fputs(s, fp);
  }
  fclose(ff);
  fclose(fp);

  unlink( tmp );
}






/* #PR - Finds out whether a file is a text or binary.

   [arg] is the name/path of the file to check.   

   This function returns 0 if the file includes a text or an 1 if
   it's binary. */

int prf(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  UNSIGNED char ex[LONGSTRING];
  int i, a;

#ifdef _PROFILE
  profile( "prf()" );
#endif

  fp = fopen(arg, "r");
  if (fp == NULL) return -1;
  while ((fgets(ex, LONGSTRING, fp) != NULL) && (strlen(ex) < 30));
  fclose(fp);

  i = 0;
  a = 0;
  while (ex[i] != '\0') {
	if ((ex[i] < 32) || (ex[i] > 127)) {
		if ((ex[i] != LF) && (ex[i] != CR)) a++;
	}
	i++;
  }
  if (a > 3) return 1;		/* BINFILE */

  return 0;			/* TEXTFILE */
}






/* #PF - Checks if an article includes the key BINFILE. If so, the 
   function "pd()" is called to handle it.

   [arg] gives the number (NOT path) of an article.

   This function returns 0 if the article includes a text and 1 if it
   is a binary file. */

int pruefe(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char s[STRING];
  UNSIGNED char entry[STRING];
  UNSIGNED char keywds[STRING];
  UNSIGNED char subject[STRING];
 
  int i;


#ifdef _PROFILE
  profile( "pruefe()" );
#endif

  if ((arg[0] == '\0') || (arg[0] == '*')) return -1;

  ROBINROUND:

  if (strcomp(BRETT, "PM") != 0) {
	sprintf(entry, "%s/%s", BRETT, arg);
  }
  else {
	sprintf(entry, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, arg);
  }

  keywds[0] = '\0';

  fp = fopen(entry, "r");
  if (fp == NULL) return -1;

  while ((fgets(ex, LONGSTRING, fp) != NULL) && (ex[0] > 32)){
	if(strcomp("Keywords: ", ex) == 0){
		ex[80] = '\0';
		strcpy(keywds, strcopy(ex, 10, 80));
	}
	if(strcomp("Subject: ", ex) == 0){
		ex[80] = '\0';
		strcpy(subject, ex);
	}
  }

  while ((fgets(ex, LONGSTRING, fp) != NULL) && (ex[0] < 32));

  if (strcomp("Content-", ex) == 0) 
      	fgets(ex, LONGSTRING, fp);

  if (strcomp("BINFILE", ex) == 0) {
	fgets(s, STRING, fp);
	fclose(fp);
	if(USER.level == 45){
		i = atoi(arg) + 1;
		sprintf(arg, "%d", i);
		printf("\n(%4d) %s", (i-1), subject);
		if(keywds[0] == '\0') newhead_rq( entry );
		goto ROBINROUND; 
	}
	pd(s, keywds);
	return 1;
  }
  fclose(fp);

  return 0;
}
