/* ix/MBox (makro.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #MK makro()           handling users macro definitions
   #SM set_makros        edit macros
   #GM get_makros        put macro definitions in a structure
   #AM add_makros        expands macro definitions file
   #MD makro_definiton   scans input lines for macro defintions

   Contact <volkers@unnet.wupper.de> for help! */






#include <stdio.h>

#include "mbox.h"


void get_makros();



/* #MK - Swapping macros in an input line [s] with their substitutes.

   The function returns the input line with the substitutes. */

UNSIGNED char *makro( s )
UNSIGNED char s[];
{
  static UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  int a = 0, b = 0, i = 0;
  int m = 0, ok = 0;
  int subcom = 0;

  t[0] = '\0';

  strcat(s, " ");

  while(s[0] == ' ') *s++; /* GCCs warning concerning this *IS* wrong!!! */

  while(s[i] != '\0'){

	if(s[i] == ' '){
		b = i -1;
		f[0] = '\0';
		strcat(f, strcopy(s, a, b));
		a = i +1;
		ok = 0; 
		m = 0;

		if(f[0] == '$'){ /* Variable */
			if(strcomp("$NA", f) == 0){
				strcpy(f, (UNSIGNED char *) VAR_NAME);
			}
			if(strcomp("$ME", f) == 0){
				strcpy(f, (UNSIGNED char *) VAR_ME);
			}
		}

		while(MAK[m].makname[0] != '\0'){
			if((strcomp(f, MAK[m].makname) == 0) && (strcomp(MAK[m].makname, f) == 0) && (subcom == 0)){
				ok = 1; 
				strcat(t, MAK[m].makwert);
			}
			m++;
		}
		if(ok == 0) strcat(t, stripped(f));
		strcat(t, " ");
	
		subcom++;
	}
	i++;
  }
  return (UNSIGNED char *) t;
}





/* #SM - Displays the macro file. It could be changed. */

void set_makros()
{
  UNSIGNED char c;
  int b;


  printf("\n\n%s\n\n", MAK01_MSG);

  ansi2("md", 0, 0);
  b = 0;
  while(MAK[b].makname[0] != '\0'){
	printf("%s%c=%c%s\n", MAK[b].makname, TAB, TAB, MAK[b].makwert);
	b++;
  }  
  printf("\n");  
  ansi2("mr", 0, 0);
  printf("%c%s [%c, %c] > ", CR, MAK02_MSG, GBL06_MSG, GBL07_MSG);
  ansi2("me", 0, 0);

  c = yesno();

  if (c == GBL06_MSG) {
	security_ed( MAKRO );
  }

  get_makros();

  printf("\n");
}






/* #GM - Make up a structure out of the macro file. */

void get_makros()
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int b = 0, i = 0;

  fp = fopen(MAKRO, "r");
  if (fp == NULL) {
	MAK[0].makname[0] = '\0';
	return;
  }

  while(fgets(s, STRING, fp) != NULL){

	MAK[b].makname[0] = '\0';
	MAK[b].makwert[0] = '\0';
	
	i = 0;

	while((s[i] != '=') && (s[i] != '\0')) i++;

	t[0] = '\0'; strcat(t, strcopy(s, 0, (i-1)));
	strcat(MAK[b].makname, stripped(t));

	t[0] = '\0'; strcat(t, strcopy(s, (i+1), strlen(s)));
 	strcat(MAK[b].makwert, stripped(t));

	b++;
	if (b >= (MAX_MAK -1)) {
		nerror("makro.c", 108, "get_makro", "Definition MAX_MAK", "to small");
	}
  }
  MAK[b].makname[0] = '\0';

  fclose(fp);

}



/* #AM - Adds a new macro defintion [s] to the macro file. */

void add_makro( s )
UNSIGNED char s[];
{
  FILE *fp;

  fp = fopen( MAKRO, "a" );
  if(fp == NULL){
	nerror("makro.c", 189, "add_makro", "Can't append to", MAKRO);
  }
  fputs((UNSIGNED char *) stripped(s), fp);
  fputs("\n", fp);
  fclose(fp);

  get_makros();

  printf("\n\n%s\n", MAK03_MSG);
  
}



/* #MD - Checks whether an input line [s] includes macro defintions.

   The functions returns 1, if a defintion is found and 0 otherwise. */

int makro_definition( s )
UNSIGNED char s[];
{
  int i = 1; /* 1, !0 ;-) */
  int ok = 0;

  if(USER.level < 1) return 0;

  while(s[i] != '\0'){
	if(s[i] == '=') ok++;
	i++;
  }

  if(ok == 1){
	add_makro( s );
  }
  if(ok > 1){
	ansi2("md", 0, 0);
	printf(" %s\n", MAK04_MSG);
	ansi2("me", 0, 0);
  }
  return ok;
}


