/* ix/MBox (dis.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #DS dis()              sort of a threaded news reader
   #IS infsys()		  offer some vital info to users
   #SC selected_calls()	  show a selected list of call(er)s 

   Contact <volkers@unnet.wupper.de> for help! */





  


#include <stdio.h>

#include "mbox.h"


/* #DS - Handle news articles as threads. 

   If [argument] is empty, only new threads are display. A '*' will
   give a list of all thread in the current group.

   All other figures will be interpreted as article numbers and will
   start the reading process. */

void dis( argument )
UNSIGNED char argument[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  
  if(argument[0] == '\0'){
	headblock( DIS00_MSG, DIS00aMSG );
	strcpy(t, (UNSIGNED char *) NG);

	if(strlen(t) > 14){
#ifndef _LONGNAMES
		strcpy(t, (UNSIGNED char *) shortname(t));
#endif
	}

	sprintf(s, "%s/.thread/%s", LIB, t);
	if (show(s, 9999, USER.more + 100) == -1) {
	        ansi2( "md", 0, 0);
	        printf("%s\n", DIS03_MSG);
	        ansi2( "me", 0, 0 );
	        printf("%s\n", DIS04_MSG);
		intuition( 490 );
	}
	return;
  }


  if(argument[0] == '*'){
	headblock( DIS01_MSG, DIS02_MSG );

	sprintf(s, "%s/usr/%c/%d/.dis", HOME, USER.name[0], USER.id);
	if (show(s, 9999, USER.more + 100) == -1) {
	        ansi2( "md", 0, 0);
	        printf("%s.\n", DIS03_MSG);
	        ansi2( "me", 0, 0 );
	        printf("%s\n", DIS04_MSG);
	}
	return;
  }


  DISKUSSION = 1;

  if (strcomp(BRETT, "PM") != 0) {
	sprintf(s, "%s/%s", BRETT, argument); 
  }
  else {
	sprintf(s, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, argument);
  }

  fp = fopen(s, "r");
  if(fp != NULL){
	while(fgets(s, STRING, fp) != 0){
		if(strcomp("Subject:", s) == 0){
			strcpy(DIS_subject, (UNSIGNED char *) strcopy(s, 9, STRING));
		}
	}
	fclose(fp);

	lesen( argument );
  }

  DISKUSSION = 0;
}


/* #IS - Offer some vital info to users */

void infsys()
{
  UNSIGNED char s[STRING];
  UNSIGNED char h[STRING];
  UNSIGNED char l[STRING];
  int i = 1;
  int ok = 1;
  int c; 

  FILE *fp;

  sprintf(l, ".%s.", LANGUAGE); 
  sprintf(s, "./etc/info%s%d", l, i);
  fp = fopen( s, "r" );
  if(fp != NULL){
	fclose(fp);
  }
  else strcpy(l, (UNSIGNED char *) ".");

  while(1){

	  sprintf(h, " %s [%s] ", DIS07_MSG, SYSTEM );
	  headline( h );

	  i = 1; ok = 1;
 
	  do{ 
  		sprintf(s, "./etc/info%s%d", l, i);
		fp = fopen( s, "r" );
	        if(fp != NULL){
			fgets(s, STRING, fp);
			fclose(fp);
			printf("\n  %c - %s\n", (i + 64) , (UNSIGNED char *) stripped( s ));
			i++;
	        }
		else{
			ok = 0;
		}	     
	  }while((i < 11) && (ok == 1)); 

	  i--;

	  ansi2( "md", 0, 0 );
	  printf("\n\n[INFO] (A-%c)? > ", (i + 64));
	  ansi2( "me", 0, 0 );

	  c = getch();

	  if(c >= 'a') c -= 32;

	  if((c < 'A') || (c > (i + 64))){ /* Up, up and away ... */
		printf("\n\n");
		return;
	  }

	  headline( h );
  	  sprintf(s, "./etc/info%s%d", l, (c - 64));
	  show( s, 9999, USER.more );
	  more();
  } 
}


/* #SC - Show a selected list of calls & callers */

void selected_calls( arg )
UNSIGNED char arg[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];
  int i = 0;

  strcpy(t, (UNSIGNED char *) GREP);
  while(t[i] != '\0'){	
	if(t[i] == ' ') t[i] = '\0';
	i++;
  }
 
  sprintf(tmp, "%s/sc.%d", TMP, getpid());
  sprintf(s, "%s \"%s\" %s > %s", t, arg, CALLS, tmp);
  system( s );

  show(tmp, 9999, USER.more + 100);

  unlink( tmp );
}
