/* ix/MBox (ctrlx.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #CX ctrlx()            set QUIT (SIGQIUT) to CTRL-X (24)
   #NX noctrlx()          restore QUIT

   Contact <volkers@unnet.wupper.de> for help! */








#ifdef _SYS7	/* UNIX System 7  (MINIX, COHERENT, ...) */

#include  <sgtty.h>
static struct tchars newtc, oldtc;

#else		/* UNIX System V  (UNIX, XENIX, ESIX, ...) */

#ifdef _LINUX
#include  <termio.h>
#else
#include  <sys/termio.h> 
#endif

struct termio newtc, oldtc;

#endif



/* #CX - If user sends CTRL-X, UNIX receives SIGQUIT. */

void ctrlx()
{

#ifdef _SYS7

  ioctl(0, TIOCGETC, (struct sgttyb *) &oldtc);
  newtc = oldtc;
  newtc.t_quitc = 24;
  ioctl(0, TIOCSETC, (struct sgttyb *) &newtc);

#else

  ioctl(0, TCGETA, (struct termio *) &oldtc);
  newtc = oldtc;
  newtc.c_cc[VQUIT] = 24; 
  ioctl(0, TCSETA, (struct termio *) &newtc);
 
#endif

}




/* #NX - Restore SIGQUIT. */

void noctrlx()
{

#ifdef _SYS7

  ioctl(0, TIOCSETC, (struct sgttyb *) &oldtc);

#else

  ioctl(0, TCSETA, (struct termio *) &oldtc);

#endif

}
