/* ix/MBox/WENDY (rtf.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #MR make_rtf()         convert screen line to RTF
   #RC rtf_convert()      convert RTF line to screen line

   Contact <volkers@unnet.wupper.de> for help! */









#include "wendy.h"



/* #MR - Convert a screen line to RFF */

unsigned char *make_rtf( t, a )
unsigned char t[], a[];
{
  unsigned char s[LONGSTRING];
  unsigned char q[LONGSTRING];
  int olda = '0';
  int i = 0;
  int l = 0;

  unsigned char line[1024];



  strcpy(q, (unsigned char *) t);  strcpy(s, (unsigned char *) right_stripped(q));

  if((strlen(q) > LONGSTRING) || (strlen(s) > LONGSTRING)){
	printf("\nMemory fault - Shit!\n");
  }  

  strcat(s, (unsigned char *) "`");
  strcat(a, (unsigned char *) "0");

  if(s[0] == '~'){
	line[0] = '~';
	l++;
	i++;
  }

  if(strcomp("        ", s) == 0){ 	/* TAB for Makefiles ;-) */
	line[l] = TAB;
	l++;
	i += 8;
  }

  while((s[i] != '\0') && (l < LINELENGTH)){
	if(s[i] == BLANK) s[i] = ' ';
	if(a[i] != olda){
		line[l] = '\0';
		if(olda == '0'){
			switch(a[i]){
				case 'b' : strcat(line, (unsigned char *) "<Bold>");
					   break;	
				case 'i' : strcat(line, (unsigned char *) "<Italic>");
					   break;
				case 'f' : strcat(line, (unsigned char *) "<Flash>");
					   break;
				case 'u' : strcat(line, (unsigned char *) "<Underline>");
					   break;
			}
		}
		else{
			switch(olda){
				case 'b' : strcat(line, (unsigned char *) "</Bold>");
					   break;	
				case 'i' : strcat(line, (unsigned char *) "</Italic>");
					   break;
								case 'f' : strcat(line, (unsigned char *) "</Flash>");
					   break;
				case 'u' : strcat(line, (unsigned char *) "</Underline>");
					   break;
			}
		}
		olda = a[i];
		l = strlen(line);
	}
	if(s[i] != '`'){
		line[l] = s[i];
		l++;		
	}
	i++;
  }

  line[l] = ' '; line[l+1] = '\0'; /* !!!? */


  return (unsigned char *) line;
}



/* #RC - Convert RTF line to screen line */

rtf_convert( line, scrpos, tpos )
unsigned char line[];
int scrpos;
int tpos;
{
  unsigned char s[LINELENGTH];

  unsigned char screen[1024];
  unsigned char attrib[1024];
  unsigned char scr2[1024];
  unsigned char att2[1024];

  int i = 0;
  int l = 0;
  int j = 0;
  int c = 0;

  int rtf = 0;
  int RTF_local = '0';


  screen[0] = '\0';
  attrib[0] = '\0';

  while(line[i] != '\0'){
	rtf = 0;
	if(line[i] > 127){
		if(strcomp("iso", umlaut) == 0){
			switch(line[i]){
				case 142 : line[i] = 196; 
					   break;
				case 153 : line[i] = 214; 
					   break;
				case 154 : line[i] = 220; 
					   break;
				case 225 : line[i] = 223; 
					   break;
				case 132 : line[i] = 228; 
					   break;
				case 148 : line[i] = 246;
					   break;
				case 129 : line[i] = 252; 
					   break;
			}
		}
		if(strcomp("ibm", umlaut) == 0){
			switch(line[i]){
				case 196 : line[i] = 142; 
					   break;
				case 214 : line[i] = 153; 
					   break;
				case 220 : line[i] = 154; 
					   break;
				case 223 : line[i] = 225; 
					   break;
				case 228 : line[i] = 132; 
					   break;
				case 246 : line[i] = 148;
					   break;
				case 252 : line[i] = 129; 
					   break;
			}
		}
	}
	if(line[i] == ' ') line[i] = BLANK;
	if(line[i] == '<'){
		if(line[(i+1)] == '/'){
			rtf++;
		}
		else{
			strcpy(s, (unsigned char *) bigcopy(line, (i+1), strlen(line)));
			if((strcomp("Bold",        s) == 0) ||
			   (strcomp("Italic",      s) == 0) ||
			   (strcomp("Fixed",       s) == 0) ||
			   (strcomp("Flash",       s) == 0) || /* Un.Net ;-) */
			   (strcomp("Smaller",     s) == 0) ||
			   (strcomp("Bigger",      s) == 0) ||
			   (strcomp("Underline",   s) == 0) ||
			   (strcomp("Center",      s) == 0) ||
			   (strcomp("Flush",       s) == 0) ||
			   (strcomp("Indent",      s) == 0) ||
		 	   (strcomp("Outdent",     s) == 0) ||
			   (strcomp("Samepage",    s) == 0) ||
		           (strcomp("Subscript",   s) == 0) ||
			   (strcomp("Superscript", s) == 0) ||
			   (strcomp("Heading",     s) == 0) ||
			   (strcomp("Footing",     s) == 0) ||
			   (strcomp("ISO-8859-",   s) == 0) ||
			   (strcomp("US-ASCII",    s) == 0) ||
			   (strcomp("Excerpt",     s) == 0) ||
			   (strcomp("Paragraph",   s) == 0) ||
			   (strcomp("Signature",   s) == 0) ||
		           (strcomp("Comment",     s) == 0) ||
			   (strcomp("nl",          s) == 0) ||
			   (strcomp("np",          s) == 0) ||
			   (strcomp("lt",          s) == 0) ||
			   (strcomp("No-op",       s) == 0)) rtf++;
		}
        }

	if(rtf == 0){
		if(line[i] == TAB){
			j = (((int)(l+8)/8) * 8) - l;
			strcpy(s, "            "); s[j] = '\0';						
			screen[l] = '\0'; strcat(screen, (unsigned char *) s);
			strcpy(s, "000000000000"); s[j] = '\0';
			attrib[l] = '\0'; strcat(attrib, (unsigned char *) s);
			l += (j -1);
		}
		else{
			if(line[i] > 31){
				screen[l] = line[i];
				attrib[l] = RTF_local;
			}
		}
		l++;
	}		
	else{
		j = i + 1;
		while((line[i] != '>') && (line[i] != '\0')){
			i++;
		}

		strcpy(s, (unsigned char *) bigcopy(line, j, (i-1)));

		if(s[0] == '/'){
			RTF_local = '0';
		}		
		else{
			if(strcomp("nl", s) != 0){
				c = s[0]; if(c < 97) c += 32;
				if((c == 'b') || (c == 'i') || (c == 'f') || (c == 'u')){
					RTF_local = c;
				}
				if(c == 'c'){
					FLAG[(ypos + scrpos -1)] |= is_centered;
				}
				if(strcomp("lt", s) == 0){
					screen[l] = '<';
					attrib[l] = RTF_local;
					l++;
				}
			}
		}
	}
	i++;
  }
  l--;

  while(l < MAXX){
	screen[l] = ' ';
	attrib[l] = '0';
	l++;
  }
  screen[l] = '\0';
  attrib[l] = '\0';
 
  sprintf(SCREEN[scrpos], "%-*.*s", MAXX, MAXX, (unsigned char *) screen);
  sprintf(ATTRIB[scrpos], "%-*.*s", MAXX, MAXX, (unsigned char *) attrib);

  if(l > MAXX){
	strcpy(screen, (unsigned char *) strcopy(screen, (MAXX-1), l));
	strcpy(attrib, (unsigned char *) strcopy(attrib, (MAXX-1), l));
	
	screen[0] = '~';
	attrib[0] = '0';

	for(i = lastline; i > tpos; i--){
		strcpy(TEXT[(i+1)], (unsigned char *) TEXT[i]);
		FLAG[(i+1)] = FLAG[i];
	}
	lastline++;	
	tpos++;
	strcpy(TEXT[tpos], (unsigned char *) make_rtf( screen, attrib ));
  }  

  if(((FLAG[tpos] & is_centered) == is_centered) && (SCREEN[scrpos][0] != ' ')){
	strcpy(screen, (unsigned char *) SCREEN[scrpos]);
	strcpy(attrib, (unsigned char *) ATTRIB[scrpos]);
	strcpy(s, (unsigned char *) SCREEN[scrpos]); i = strlen((unsigned char *) right_stripped(s));
	j = (MAXX - i) / 2;
	strcpy(SCREEN[scrpos], (unsigned char *) "                                                                              ");           		
	strcpy(ATTRIB[scrpos], (unsigned char *) "000000000000000000000000000000000000000000000000000000000000000000000000000000");
	SCREEN[scrpos][j] = '\0';
	ATTRIB[scrpos][j] = '\0';
        screen[i] = '\0';
	strcat(SCREEN[scrpos], (unsigned char *) screen);
	attrib[i] = '\0';
	strcat(ATTRIB[scrpos], (unsigned char *) attrib);
  }

}
