#ifndef _BBS_TYPESH_INCLUDED
#define _BBS_TYPESH_INCLUDED

#ifndef PID_T
#define PID_T pid_t		/* process id */
#endif

#ifndef UID_T
#define UID_T uid_t		/* user id */
#endif

#ifndef GID_T
#define GID_T gid_t		/* group id */
#endif

#ifndef MODE_T
#define MODE_T mode_t		/* file type */
#endif

#ifndef TIME_T
#define TIME_T time_t		/* counter of secounts */
#endif

#ifndef OFF_T
#define OFF_T off_t		/* file offset */
#endif

#ifndef SIZE_T
#define SIZE_T size_t		/* size of objects (unsigned) */
#endif

#ifndef SSIZE_T
#define SSIZE_T ssize_t		/* signed size of objects */
#endif

#ifndef U_CHAR
#define U_CHAR u_char           /* unsigned char */
#endif

#ifndef FD_SET_T
#define FD_SET_T fd_set		/* file descriptor set */
#endif

#ifndef FD_SETPTR_CAST          /* cast for ptr to fd_set */
#define FD_SETPTR_CAST (FD_SET_T *)
#endif

#ifndef CADDR_T
#define CADDR_T caddr_t		/* core address */
#endif

#ifndef SIG_ATOMIC_T
#define SIG_ATOMIC_T sig_atomic_t	/* atomically accessed type */
#endif

#ifndef SIGSET_T
#define SIGSET_T sigset_t	/* signal set */
#endif

#ifndef SUN_LEN
# ifdef SCM_RIGHTS
#  define SUN_LEN(unp) sizeof((unp)->sun_len)+sizeof((unp)->sun_family)+strlen((unp)->sun_path)+1
# else
#  define SUN_LEN(unp) sizeof((unp)->sun_family) + strlen((unp)->sun_path)
# endif
#endif

#ifndef PATH_MAX
# ifdef MAXPATHLEN
#  define PATH_MAX MAXPATHLEN
# endif
#endif

#ifndef NAME_MAX
# ifdef _MAXNAMLEN
#  define NAME_MAX _MAXNAMLEN
# endif
#endif

#ifndef TGETENTBUF
#define TGETENTBUF 8192
#endif

#ifndef PASS_MAX
# ifdef _PASSWORD_LEN
#  define PASS_MAX _PASSWORD_LEN
# else
#  define PASS_MAX 8
# endif
#endif

#ifndef PASSCRYPTED_LEN
# define PASSCRYPTED_LEN 20
#endif

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
typedef int boolean;

#define STRLEN 1024
#define S_STRLEN 80
#define TTYNAMELEN 20
#define TALKSOCKNAMELEN 40
#define BUFSIZE 1024
#define ASCTIMESTRLEN 26
#define LOG_NEVER -1
#define LOG_FILE 0
#define LOG_CONSOLE 1
#define SOCKCONTRIES 3
#define MAXSESSIONS 100

#define BEFSTRLEN 4
#define DO_LOG 1
#define DO_GETSESSIONS 2
#define DO_ADDSESSION 3
#define DO_REMOVESESSION 4
#define DO_GETUSERRECORD 5
#define DO_SAVEUSERRECORD 6
#define DO_TALKINIT 7
#define DO_TALKABORT 8
#define DO_TALKREMOTE 9
#define DO_SENDSTATUS 10

#define BBS_IDLE 0
#define BBS_BUSY 1

#define E_SYSLOG 1
#define E_LOGFILE 2
#define E_CONSOLE 4
#define E_USER 8

#define PERM_R 1
#define PERM_W 2
#define PERM_X 4

typedef struct {
  char name[S_STRLEN+1];
  char passwd[PASSCRYPTED_LEN+1];
  int loglevel;
  int seclevel;
  int kermitok;
  int protokoll;
  boolean autozmodem;
  boolean fullist_on_cd;
  char home[PATH_MAX+1];
  char uploaddir[PATH_MAX+1];
  char shell[PATH_MAX+1];
  char path[PATH_MAX+1];
  int lang;
  char term[S_STRLEN+1];
  int lines;
  int columns;
} userrecordtyp;

#define KERMITPROTO 0
#define ZMODEMPROTO 1
#define HIGHSECURITY 0
#define MEDIUMSECURITY 1
#define LOWSECURITY 2
#define NOUSER "nouser"

#define GERMAN 0
#define ENGLISH 1

typedef struct {
  userrecordtyp userrecord;
  int idletimeout;
  int logintimeout;
  int maxversuche;
  char bbsdpath[PATH_MAX+1];
  int bbsdwatchtime;
  char bbsduid[STRLEN+1];
  char usersfile[PATH_MAX+1];
  char logfile[PATH_MAX+1];
  char vardir[PATH_MAX+1];
  char helpdir[PATH_MAX+1];
  char scratchdir[PATH_MAX+1];
  char sysop[STRLEN+1];
  int lang;
  char authkey[STRLEN+1];
  boolean curses_on;
  char rootdir[PATH_MAX+1];
  char sockpath[PATH_MAX+1];
  char lockpath[PATH_MAX+1];
  char bbsdpidpath[PATH_MAX+1];
  char bbsdkpidpath[PATH_MAX+1];
  char kermrcpath[PATH_MAX+1];
} confrecordtyp;

typedef struct {
  PID_T pid;
  int status;
  char tty[TTYNAMELEN+1];
  char user[S_STRLEN+1];
  PID_T talking_to;
} sessionrecordtyp;

typedef struct {
  char key;
  char *dec[2];
  char *cmd;
} menuetyp;

typedef struct tlistetyp {
  char **tp;
  int nr;
  struct tlistetyp *prec;
  struct tlistetyp *next;
} tlistetyp;

#define TL_BLOCKLEN 8

#define MAXMEN 26

typedef enum {TTY_RESET, TTY_RAW, TTY_CBREAK} ttystateenum;
typedef enum {SIGMASK_SET, SIGMASK_UNSET} sigmaskstatusenum;

#endif
